{
   This file, included from congfx.pp, enables use of the Code Page #437 box
   drawing characters in the MSDOS and Win32-console platforms.

   It is seperated so that it can be easily replaced by a patch to enable
   boxdrawing on other platforms.

   If a flag NEEDSHIFTS is defined here, congfx.pp will bracket usage of
   the boxdrawing characters with calls to procedures ShiftAltCharset and
   ShiftNormalCharset.  Those procedures don't exist in vanilla gearhead
   or the FPC libraries, but the calls provide a hook useful in
   implementing boxdrawing on VT110-like terminals. (eg: Linux console and
   Xterm)
}

Const

{$IFDEF PATCH_I18N}
{$ELSE PATCH_I18N}
{$IFDEF go32v2}
{$DEFINE use_cp437}
{$ELSE go32v2}
{$IFDEF Windows}
{$DEFINE use_cp437}
{$ENDIF Windows}
{$ENDIF go32v2}
{$ENDIF PATCH_I18N}

{$IFDEF use_cp437}
  {$IFDEF GUIMSWINMODE}
	BoxUpperLeft  = #$d5;
	BoxUpperRight = #$b8;
	BoxLowerLeft  = #$d4;
	BoxLowerRight = #$be;
	BoxHorizontal = #$cd;
	BoxVertical   = #$b3;
	BoxSeperator  = '~';
	GLYPH_FRAME_LM = #$11;
	GLYPH_FRAME_RM = #$10;
	GLYPH_FRAME_TM = #$1e;
	GLYPH_FRAME_BM = #$1f;
  {$ELSE GUIMSWINMODE}
	BoxUpperLeft = #218;
	BoxUpperRight = #191;
	BoxLowerLeft = #192;
	BoxLowerRight = #217;
	BoxHorizontal = #196;
	BoxVertical = #179;
	BoxSeperator = #196;
  {$ENDIF GUIMSWINMODE}
{$ELSE}
	BoxUpperLeft  = '+';
	BoxUpperRight = '+';
	BoxLowerLeft  = '+';
	BoxLowerRight = '+';
	BoxHorizontal = '-';
	BoxVertical   = '|';
	BoxSeperator = '~';
	GLYPH_FRAME_LM = '+';
	GLYPH_FRAME_RM = '+';
	GLYPH_FRAME_TM = '+';
	GLYPH_FRAME_BM = '+';
{$ENDIF}
