#!/bin/sh --
#
#	Bourne shell script, to build arena.
#
#
#	How to Use This Script?
#	% sh ./build.sh help
#
#
#	How to Compile for Unix-like OS:
#
#		I18N ASCII mode
#	% export PC='path-to-FreePascal/fpc'
#	% sh ./build.sh ascii build clean
#
#		I18N SDL mode
#	% export PC='path-to-FreePascal/fpc'
#	% sh ./build.sh sdl build clean
#
#		I18N SDL mode, for Developper
#	% export PC='path-to-FreePascal/fpc'
#	% sh ./build.sh sdl build clean definedebug
#
#
#
#	How to Compile with LIBICONV instead of GCONV(alternative library) on GNU/Linux:
#
#		I18N ASCII mode
#	% export PC='path-to-FreePascal/fpc'
#	% sh ./build.sh ascii build nolibc_iconv nolibiconv_plug
#
#	If you want a static linked binary,
#	% ld -b elf32-i386 -m elf_i386 -dynamic-linker=/lib/ld-linux.so.2 -L. -o ../GearHead-1100.I18N/arena.ascii arena.res
#	You must write a arena.res by manually. '-st' option for fpc is usable for write it.
#
#		I18N SDL mode
#	% export PC='path-to-FreePascal/fpc'
#	% sh ./build.sh sdl build nolibc_iconv nolibiconv_plug
#
#	If you want a static linked binary,
#	% ld -b elf32-i386 -m elf_i386 -dynamic-linker=/lib/ld-linux.so.2 -L. -o ../GearHead-1100.I18N/arena.sdl arena.res
#	You must write a arena.res by manually. '-st' option for fpc is usable for write it.
#
#
#
#	How to Compile for MS-Windows:
#
#		I18N ASCII mode
#	% C:\FPC\2.2.2\bin\i386-win32\fpc.exe -g -Ci -Co -CR -Cr -Ct -O3 -Op2 -dENABLE_ADDRESSBOOK -dPATCH_GH -dPATCH_GH_PARANOID_SAFER -dPATCH_JPSSDL -dPATCH_l0ugh -dPATCH -dPATCH_I18N -dPATCH_CHEAT -dPATCH_BACKPORT -dWITH_TENC -dICONV arena.pas
#	% C:\FPC\2.2.2\bin\i386-win32\strip.exe arena.exe
#
#		I18N ASCII mode with WideChar Function
#	% C:\FPC\2.2.2\bin\i386-win32\fpc.exe -g -Ci -Co -CR -Cr -Ct -O3 -Op2 -dENABLE_ADDRESSBOOK -dPATCH_GH -dPATCH_GH_PARANOID_SAFER -dPATCH_JPSSDL -dPATCH_l0ugh -dPATCH -dPATCH_I18N -dPATCH_CHEAT -dPATCH_BACKPORT -dWITH_TENC -dICONV -dWITH_WIDECHAR -dCONV_UNICODE arena.pas
#	% C:\FPC\2.2.2\bin\i386-win32\strip.exe arena.exe
#
#		I18N GDI mode
#	% C:\FPC\2.2.2\bin\i386-win32\fpc.exe -g -Ci -Co -CR -Cr -Ct -O3 -Op2 -dENABLE_ADDRESSBOOK -dPATCH_GH -dPATCH_GH_PARANOID_SAFER -dPATCH_JPSSDL -dPATCH_l0ugh -dPATCH -dPATCH_I18N -dPATCH_CHEAT -dPATCH_BACKPORT -dGUIMSWINMODE -dWITH_TENC -dICONV -dHAVE_NO_TERMINAL arena.pas
#	% C:\FPC\2.2.2\bin\i386-win32\strip.exe arena.exe
#
#		I18N SDL mode
#	% C:\FPC\2.2.2\bin\i386-win32\fpc.exe -g -Ci -Co -CR -Cr -Ct -O1 -Op2 -dENABLE_ADDRESSBOOK -dPATCH_GH -dPATCH_GH_PARANOID_SAFER -dPATCH_JPSSDL -dPATCH_l0ugh -dPATCH -dPATCH_I18N -dPATCH_CHEAT -dPATCH_BACKPORT -dSDLMODE -dWITH_TENC -dCONV_UNICODE -dICONV -dHAVE_NO_TERMINAL -dWITHOUT_SDLIM -FiJEDI-SDLv1.0_extract -FuJEDI-SDLv1.0_extract arena.pas
#	% C:\FPC\2.2.2\bin\i386-win32\strip.exe arena.exe
#
#
#
#	Compiler Options:
#
#		-dSDLMODE
#			Select SDL mode. If not, ASCII mode. If you use SDLMODE with PATH_I18N, need with -dCONV_UNICODE.
#		-dMINI
#			Select Minimize SDL mode. Need with -dSDLMODE.
#		-dGUIMSWINMODE
#			Select ASCII simulation mode using GDI for MS-Windows, made by l0ugh and updated by G-HAL.
#			Need with -dPATCH_I18N and -dHAVE_NO_TERMINAL and -dWITH_TENC.
#			NOTE: Only for MS-Windows.
#		-dPATCH_I18N
#			Enable I18N support.
#		-dENABLE_ADDRESSBOOK
#			Enable additional function, addressbook, made by l0ugh.
#		-dPATCH_GH
#			Enable additional function, made by G-HAL.
#		-dPATCH_GH_PARANOID_SAFER
#			Enable additional function to detect illigal memory access, made by G-HAL.
#		-dPATCH_JPSSDL
#			Enable additional function, made by jp-SDL version on the JaPanese Spoiler site.
#		-dPATCH_l0ugh
#			Enable additional function, made by l0ugh.
#		-dPATCH
#			Enable additional function, made by unknown, perhaps l0ugh or jp-SDL.
#		-dPATCH_CHEAT
#			Enable cheat function, made by JP-SDL version on the Japanese Spoiler Site and G-HAL.
#		-dPATCH_BACKPORT
#			Enable backported function.
#		-dWITH_TENC
#			Enable dynamically chaging of terminal-encoding. (ASCII and SDL)
#			NOTE: If you use this option, you can set any source-code and data encoding that differs from the locale.
#		-dWITH_WIDECHAR
#			Select WideChar/WideString for Write() in ASCII mode. Need with -dCONV_UNICODE. Exclusive with -dSDLMODE.
#		-dPASCAL_WRITE_BUG_HACK
#			Enable a hack to avoid a bug of Free-Pascal's write while printing I18N string.
#			At fpc-2.2.2, this bug was treated (?).
#
#		-dCONV_UNICODE
#			Enable additional function, handling Unicode.
#			NOTE: In UNIX like OS, Need with -dICONV.
#		-dICONV
#			Select iconv to handle Unicode.(MS-Windows only)
#			NOTE: Other OSs require it defining.
#		-dLIBC_ICONV
#			Select using iconv in libc, offered by GNU/Linux and Solaris.
#		-dLIBICONV_PLUG
#			Select using iconv offered by GNU/Linux and Solaris.
#
#		-dHAVE_NO_TERMINAL
#			Compiling for "Window-mode Application" on MS-Windows. MS-Windows only.
#			NOTE: Applications using SDL on MS-Windows can not use terminal without creating a console window.
#			NOTE: If you set this option, the program create a console window.
#		-dWITHOUT_SDLIM
#			Select IMM insted of SDL to handle IME. MS-Windows only.
#			ATTENTION: If you use it, you must do nooptimize. If you use it and optimize(-O2 or -O3), it cause crash when open a input-dialog.
#			NOTE: Only in SDLMODE.
#			NOTE: If you setlect setting any source-code and data encoding that differs from the locale, need with -dWITH_TENC.
#
#		-dENCODING_SINGLEBYTE
#		-dENCODING_EUCJP
#		-dENCODING_EUCKR
#		-dENCODING_EUCCN
#		-dENCODING_EUCTW
#		-dENCODING_UTF8
#		-dENCODING_SJIS
#		-dENCODING_CP932
#			Fixating source-code and data encoding as it.
#			If you do not set it, a value 'SYSTEM_ENCODING' in GameData/I18N_messages.txt is used.
#			NOTE: ISO2022-* is not supported.
#
#		-dUNIX
#			Enable compiling for UNIX like OS. Need with -dICONV, Exclusive with -dWindows.
#		-dLINUX
#			Enable compiling for UNIX like OS (JEDI-SDL). Need with -dUNIX.
#			ATTENTION: Not only GNU/Linux but also *BSD require it defining.
#		-dWindows
#			Enable compiling for MS-Windows. Exclusive with -dUNIX.
#

check_exec()
{
  _check_file="$1"
  if [ -x ${_check_file} -a ! -d ${_check_file} ]; then
    return 0
  fi
  return 1
}

search_exec()
{
  _env_name="$1"
  _search_file="$2"
  _default_file="$3"
  if [ "x${_default_file}" = "x" ]; then
    if check_exec /bin/${_search_file}; then
      _ret=/bin/${_search_file}
      return 0
    elif check_exec /usr/bin/${_search_file}; then
      _ret=/usr/bin/${_search_file}
      return 0
    elif check_exec /usr/local/bin/${_search_file}; then
      _ret=/usr/local/bin/${_search_file}
      return 0
    else
      echo "${_search_file} not found."
      echo "Please set environment ${_env_name} where ${_search_file} is."
      return 1
    fi
  elif check_exec ${_default_file}; then
    _ret=${_default_file}
    return 0
  else
    echo "${_default_file} not found."
    echo "Please set environment ${_env_name} where ${_search_file} is."
    return 1
  fi
}

# Parse argments
#
# Default Settings
MODE_SHOW=
MODE_CLEAN=
MODE_BUILD=
MODE_CROSS=
MODE_OPTIMIZE=
MODE_DEBUG=yes
MODE_PARANOID_SAFER=yes
MODE_DEFINE_DEBUG=
MODE_STATIC=
MODE_ASCII=
MODE_SDL=yes
MODE_SDLMINI=
MODE_MSWINGDI=
MODE_I18N=yes
MODE_ABOOK=yes
MODE_PATCH=yes
MODE_PATCHl0ugh=yes
MODE_PATCHJPSSDL=yes
MODE_PATCHGH=yes
MODE_PATCH_CHEAT=yes
MODE_PATCH_BACKPORT=yes
MODE_TENC=yes
MODE_WIDECHAR=
MODE_PASCAL_WRITE_BUG_HACK=
MODE_UNIX=
MODE_ENCODING_SINGLEBYTE=
MODE_ENCODING_EUCJP=
MODE_ENCODING_EUCKR=
MODE_ENCODING_EUCCN=
MODE_ENCODING_EUCTW=
MODE_ENCODING_UTF8=
MODE_ENCODING_SJIS=
MODE_ENCODING_CP932=
MODE_CONV_UNICODE=
MODE_ICONV=yes
MODE_LIBC_ICONV=auto
MODE_LIBICONV_PLUG=auto
MODE_32EMU=
OPTIONS="${OPTIONS}"
PCMODE="-Mfpc"
#PCMODE="-Mobjfpc"
LDFLAGS=
LD_RES=
#
for FOO in $*
do
  MODE_=yes
  MODEnot_=
  case $FOO in
  no*)
    MODE_=
    MODEnot_=yes
    ;;
  esac
  case $FOO in
  show|noshow)
    MODE_SHOW=${MODE_}
    ;;
  clean|noclean)
    MODE_CLEAN=${MODE_}
    ;;
  build|nobuild)
    MODE_BUILD=${MODE_}
    ;;

  cross*|nocross)
    case $FOO in
    cross|nocross)
      MODE_CROSS=
      ;;
    crossemx)
      MODE_CROSS=EMX
      ;;
    crossdarwin)
      MODE_CROSS=Darwin
      ;;
    crossfreebsd)
      MODE_CROSS=FreeBSD
      ;;
    crossgo32v2)
      MODE_CROSS=GO32v2
      ;;
    crosslinux)
      MODE_CROSS=Linux
      ;;
    crossnetbsd)
      MODE_CROSS=NetBSD
      ;;
    crossnetware)
      MODE_CROSS=NetWare
      ;;
    crossopenbsd)
      MODE_CROSS=OpenBSD
      ;;
    crossos2)
      MODE_CROSS=OS2
      ;;
    crosssolaris)
      MODE_CROSS=Solaris
      ;;
    crosswatcom)
      MODE_CROSS=Watcom
      ;;
    crosswdosx)
      MODE_CROSS=WDosX
      ;;
    crosswin32)
      MODE_CROSS=Win32
      ;;
    *)
      echo "Cross-platform option '"$FOO"' is unknown."
      exit 0
      ;;
    esac
    ;;

  optimize|nooptimize)
    MODE_OPTIMIZE=${MODE_}
    ;;
  debug|nodebug)
    MODE_DEBUG=${MODE_}
    ;;
  paranoid_safer|noparanoid_safer)
    MODE_PARANOID_SAFER=${MODE_}
    ;;
  definedebug|nodefinedebug)
    MODE_DEFINE_DEBUG=${MODE_}
    ;;
  static|nostatic)
    MODE_STATIC=${MODE_}
    ;;

  ascii)
    MODE_SDL=${MODEnot_}
    MODE_SDLMINI=${MODEnot_}
    MODE_ASCII=${MODE_}
    MODE_MSWINGDI=${MODEnot_}
    ;;
  sdl)
    MODE_SDL=${MODE_}
    MODE_SDLMINI=
    MODE_ASCII=${MODEnot_}
    MODE_MSWINGDI=${MODEnot_}
    ;;
  sdlmini)
    MODE_SDL=${MODE_}
    MODE_SDLMINI=${MODE_}
    MODE_ASCII=${MODEnot_}
    MODE_MSWINGDI=${MODEnot_}
    ;;
  mswingdi)
    MODE_SDL=${MODEnot_}
    MODE_SDLMINI=
    MODE_ASCII=${MODEnot_}
    MODE_MSWINGDI=${MODE_}
    ;;

  i18n|noi18n)
    MODE_I18N=${MODE_}
    ;;

  addressbook|noaddressbook)
    MODE_ABOOK=${MODE_}
    ;;
  patchl0ugh|nopatchl0ugh)
    MODE_PATCHl0ugh=${MODE_}
    ;;
  patchjpssdl|nopatchjpssdl)
    MODE_PATCHJPSSDL=${MODE_}
    ;;
  patchgh|nopatchgh)
    MODE_PATCHGH=${MODE_}
    ;;
  patch|nopatch)
    MODE_PATCH=${MODE_}
    ;;
  jpcheat|nojpcheat|cheat|nocheat)
    MODE_PATCH_CHEAT=${MODE_}
    ;;
  backport|nobackport)
    MODE_PATCH_BACKPORT=${MODE_}
    ;;

  tenc|notenc)
    MODE_TENC=${MODE_}
    ;;
  widechar|nowidechar)
    MODE_WIDECHAR=${MODE_}
    ;;
  pascal_write_bug_hack|nopascal_write_bug_hack)
    MODE_PASCAL_WRITE_BUG_HACK=${MODE_}
    ;;

  unix|nounix)
    MODE_UNIX=${MODE_}
    ;;

  noencoding)
    MODE_ENCODING_SINGLEBYTE=
    MODE_ENCODING_EUCJP=
    MODE_ENCODING_EUCKR=
    MODE_ENCODING_EUCCN=
    MODE_ENCODING_EUCTW=
    MODE_ENCODING_UTF8=
    MODE_ENCODING_SJIS=
    MODE_ENCODING_CP932=
    ;;
  encoding_singlebyte)
    MODE_ENCODING_SINGLEBYTE=yes
    MODE_ENCODING_EUCJP=
    MODE_ENCODING_EUCKR=
    MODE_ENCODING_EUCCN=
    MODE_ENCODING_EUCTW=
    MODE_ENCODING_UTF8=
    MODE_ENCODING_SJIS=
    MODE_ENCODING_CP932=
    ;;
  encoding_eucjp)
    MODE_ENCODING_SINGLEBYTE=
    MODE_ENCODING_EUCJP=yes
    MODE_ENCODING_EUCKR=
    MODE_ENCODING_EUCCN=
    MODE_ENCODING_EUCTW=
    MODE_ENCODING_UTF8=
    MODE_ENCODING_SJIS=
    MODE_ENCODING_CP932=
    ;;
  encoding_euckr)
    MODE_ENCODING_SINGLEBYTE=
    MODE_ENCODING_EUCJP=
    MODE_ENCODING_EUCKR=yes
    MODE_ENCODING_EUCCN=
    MODE_ENCODING_EUCTW=
    MODE_ENCODING_UTF8=
    MODE_ENCODING_SJIS=
    MODE_ENCODING_CP932=
    ;;
  encoding_euccn)
    MODE_ENCODING_SINGLEBYTE=
    MODE_ENCODING_EUCJP=
    MODE_ENCODING_EUCKR=
    MODE_ENCODING_EUCCN=yes
    MODE_ENCODING_EUCTW=
    MODE_ENCODING_UTF8=
    MODE_ENCODING_SJIS=
    MODE_ENCODING_CP932=
    ;;
  encoding_euctw)
    MODE_ENCODING_SINGLEBYTE=
    MODE_ENCODING_EUCJP=
    MODE_ENCODING_EUCKR=
    MODE_ENCODING_EUCCN=
    MODE_ENCODING_EUCTW=yes
    MODE_ENCODING_UTF8=
    MODE_ENCODING_SJIS=
    MODE_ENCODING_CP932=
    ;;
  encoding_utf8)
    MODE_ENCODING_SINGLEBYTE=
    MODE_ENCODING_EUCJP=
    MODE_ENCODING_EUCKR=
    MODE_ENCODING_EUCCN=
    MODE_ENCODING_EUCTW=
    MODE_ENCODING_UTF8=yes
    MODE_ENCODING_SJIS=
    MODE_ENCODING_CP932=
    ;;
  encoding_sjis)
    MODE_ENCODING_SINGLEBYTE=
    MODE_ENCODING_EUCJP=
    MODE_ENCODING_EUCKR=
    MODE_ENCODING_EUCCN=
    MODE_ENCODING_EUCTW=
    MODE_ENCODING_UTF8=
    MODE_ENCODING_SJIS=yes
    MODE_ENCODING_CP932=
    ;;
  encoding_cp932)
    MODE_ENCODING_SINGLEBYTE=
    MODE_ENCODING_EUCJP=
    MODE_ENCODING_EUCKR=
    MODE_ENCODING_EUCCN=
    MODE_ENCODING_EUCTW=
    MODE_ENCODING_UTF8=
    MODE_ENCODING_SJIS=
    MODE_ENCODING_CP932=yes
    ;;

  iconv|noiconv)
    MODE_ICONV=${MODE_}
    ;;
  libc_iconv|nolibc_iconv)
    MODE_LIBC_ICONV=${MODE_}
    ;;
  autolibc_iconv)
    MODE_LIBC_ICONV=auto
    ;;
  libiconv_plug|nolibiconv_plug)
    MODE_LIBICONV_PLUG=${MODE_}
    ;;
  autolibiconv_plug)
    MODE_LIBICONV_PLUG=auto
    ;;

  *|help|h)
    echo "build.sh , It is a script, to build GearHead."
    echo ""
    echo "Argments:"
    echo "	help		Show these messages."
    echo "	"
    echo "	(no)show	Show only. Not execute.(default no)"
    echo "	(no)clean	Erase all object files, such as *.o and *.ppu .(default no)"
    echo "	(no)build	Build arena.(default no)"
    echo "	(no)cross(darwin|freebsd|linux|netbsd|openbsd|os2|solaris|win32)	Cross Compile.(default no)"
    echo "	"
    echo "	(no)optimize	Build with optimization.(default no)"
    echo "	(no)debug	Build with debugger informations.(default yes)"
    echo "	(no)paranoid_safer	Build with define PATCH_GH_PARANOID_SAFER.(default yes)"
    echo "	(no)definedebug	Build with define DEBUG.(default no)"
    echo "	"
    echo "	ascii		Build for ASCII-mode.(default no)"
    echo "	sdl		Build for Fullsize SDL-mode.(default yes)"
    echo "	sdlmini		Build for Minimize SDL-mode.(default no)"
    echo "	mswingdi	Build for GDI-mode.(MS-Windows only)(default no)"
    echo "	"
    echo "	(no)i18n	Enable I18N support.(default yes)"
    echo "	"
    echo "	(no)addressbook	Enable address-book.(default yes)"
    echo "	(no)cheat	Enable cheat function.(default yes)"
    echo "	(no)backport	Enable backported function.(default yes)"
    echo "	(no)tenc	Enable dynamically chaging of terminal-encoding.(default yes)"
    echo "	(no)widechar	Enable WideChar/WideString for Write().(default no)"
    echo "	"
    echo "	(no)unix	Build for unixlike os.(default autodetect)"
    echo "	"
    echo "		Select Data Charactorset Encoding.(default noencoding)"
    echo "	noencoding		Encoding is dynamic changable, and determine at a run time."
    echo "	encoding_singlebyte	Fixating SingleByteCharacter as source-code and data encoding."
    echo "	encoding_eucjp		Fixating EUC-JP as source-code and data encoding."
    echo "	encoding_euckr		Fixating EUC-KR as source-code and data encoding."
    echo "	encoding_euccn		Fixating EUC-CN as source-code and data encoding."
    echo "	encoding_euctw		Fixating EUC-TW as source-code and data encoding."
    echo "	encoding_utf8		Fixating UTF8 as source-code and data encoding."
    echo "	encoding_sjis		Fixating ShiftJIS as source-code and data encoding."
    echo "	encoding_cp932		Fixating CP932 as source-code and data encoding."
    echo "	"
    echo "	(no)iconv	Build with iconv.(MS-Windows only)(default yes)"
    echo "	(no|auto)libc_iconv	Select using iconv in libc (default auto)"
    echo "	(no|auto)libiconv_plug	Select to define LIBICONV_PLUG (default auto)"
    echo "	"
    echo "Enviroments:"
    echo "	UNAME		Command for 'uname' with fullpath."
    echo "	RM		Command for 'rm' with fullpath."
    echo "	MKDIR		Command for 'mkdir' with fullpath."
    echo "	PC		Command for 'fpc' with fullpath."
    echo "	LD		Command for 'ld' with fullpath."
    echo "	INCLUDE		Additional directory for include."
    echo "	UNIT		Additional directory for unit."
    echo "	OPTIONS		Additional options for compiler."
    echo "	DEFINE		Additional define the symbols for compiler."
    echo "	SRC		Source file.(default arena.pas)"
    echo ""
    exit 0
    ;;
  esac
done
#
# Check Conflict
if [ x$MODE_ASCII = xyes -a x$MODE_SDL = xyes ]; then
  echo "Don't use 'ascii' and 'sdl' at the same time."
  exit 1
fi
if [ x$MODE_SDL = xyes -a x$MODE_WIDECHAR = xyes ]; then
  echo "Don't use 'sdl' and 'widechar' at the same time."
  exit 1
fi
#

#
search_exec UNAME uname ${UNAME} || exit 1
UNAME=${_ret}
search_exec RM rm ${RM} || exit 1
RM=${_ret}
search_exec MKDIR mkdir ${MKDIR} || exit 1
MKDIR=${_ret}
search_exec PC fpc ${PC} || exit 1
PC=${_ret}
search_exec LD ld ${LD} || exit 1
LD=${_ret}
#
if [ x$MODE_ABOOK = xyes ]; then
  DEFINE="${DEFINE} -dENABLE_ADDRESSBOOK"
fi
if [ x$MODE_PATCHGH = xyes ]; then
  DEFINE="${DEFINE} -dPATCH_GH"
fi
if [ x$MODE_PATCHJPSSDL = xyes ]; then
  DEFINE="${DEFINE} -dPATCH_JPSSDL"
fi
if [ x$MODE_PATCHl0ugh = xyes ]; then
  DEFINE="${DEFINE} -dPATCH_l0ugh"
fi
if [ x$MODE_PATCH = xyes ]; then
  DEFINE="${DEFINE} -dPATCH"
fi
if [ x$MODE_I18N = xyes ]; then
  DEFINE="${DEFINE} -dPATCH_I18N"
fi
if [ x$MODE_PATCH_CHEAT = xyes ]; then
  DEFINE="${DEFINE} -dPATCH_CHEAT"
fi
if [ x$MODE_PATCH_BACKPORT = xyes ]; then
  DEFINE="${DEFINE} -dPATCH_BACKPORT"
fi
#
if [ x$MODE_ENCODING_SINGLEBYTE = xyes ]; then
  DEFINE="${DEFINE} -dENCODING_SINGLEBYTE"
elif [ x$MODE_ENCODING_EUCJP = xyes ]; then
  DEFINE="${DEFINE} -dENCODING_EUCJP"
elif [ x$MODE_ENCODING_EUCKR = xyes ]; then
  DEFINE="${DEFINE} -dENCODING_EUCKR"
elif [ x$MODE_ENCODING_EUCCN = xyes ]; then
  DEFINE="${DEFINE} -dENCODING_EUCCN"
elif [ x$MODE_ENCODING_EUCTW = xyes ]; then
  DEFINE="${DEFINE} -dENCODING_EUCTW"
elif [ x$MODE_ENCODING_UTF8 = xyes ]; then
  DEFINE="${DEFINE} -dENCODING_UTF8"
elif [ x$MODE_ENCODING_SJIS = xyes ]; then
  DEFINE="${DEFINE} -dENCODING_SJIS"
elif [ x$MODE_ENCODING_CP932 = xyes ]; then
  DEFINE="${DEFINE} -dENCODING_CP932"
fi
#
if [ x$MODE_CROSS = x ]; then
  OS_IDENT=`${UNAME} -s`
else
  OPTIONS="${OPTIONS} -T${MODE_CROSS}"
  OS_IDENT="${MODE_CROSS}"
fi
case ${OS_IDENT} in
FreeBSD|NetBSD|OpenBSD|*BSD|Darwin)
  MODE_UNIX=yes
#  if [ x`${UNAME} -m` = xamd64 ]; then
#    if [ ! -f fpc.cfg ]; then
#      echo "'fpc.cfg' not found."
#      exit 1;
#    fi
#    LDFLAGS="-m elf_i386_fbsd"
#    MODE_32EMU=yes
#  fi
  ;;
Linux|linux)
  MODE_UNIX=yes
  if [ x$MODE_LIBC_ICONV = xauto ]; then
    MODE_LIBC_ICONV=yes
  fi
  if [ x$MODE_LIBICONV_PLUG = xauto ]; then
    MODE_LIBICONV_PLUG=yes
  fi
  LDFLAGS="-b elf32-i386 -m elf_i386 -dynamic-linker=/lib/ld-linux.so.2"
  ;;
*Solaris*|*solaris*)
  MODE_UNIX=yes
  if [ x$MODE_LIBC_ICONV = xauto ]; then
    MODE_LIBC_ICONV=yes
  fi
  if [ x$MODE_LIBICONV_PLUG = xauto ]; then
    MODE_LIBICONV_PLUG=yes
  fi
  ;;
*Win32*|*win32*|*Windows*|*CYGWIN*|*MINGW*)
  MODE_UNIX=
  if [ x$MODE_MSWINGDI = xyes ]; then
    DEFINE="${DEFINE} -dHAVE_NO_TERMINAL"
  elif [ x$MODE_SDL = xyes ]; then
    MODE_OPTIMIZE=
    DEFINE="${DEFINE} -dHAVE_NO_TERMINAL -dWITHOUT_SDLIM"
  fi
  if [ x$MODE_ENCODING_SJIS = x -a x$MODE_ENCODING_CP932 = x ]; then
    MODE_TENC=yes
  fi
  ;;
*)
  ;;
esac
if [ -f /usr/local/lib/X11/fonts/TrueType/sazanami-gothic.ttf ]; then
  DEFINE="${DEFINE} -dFONTFILE_USR_LOCAL"
elif [ -f /usr/X11R6/lib/X11/fonts/TrueType/sazanami-gothic.ttf ]; then
  DEFINE="${DEFINE} -dFONTFILE_USR_X11R6"
elif [ -f /usr/share/fonts/truetype/sazanami/sazanami-gothic.ttf ]; then
  DEFINE="${DEFINE} -dFONTFILE_USR_SHARE"
fi
#
if [ x$MODE_SDL = xyes ]; then
  if [ x$MODE_UNIX = xyes -a x$MODE_I18N = xyes ]; then
    MODE_ICONV=yes
  fi
  if [ x$MODE_ICONV = xyes -a x$MODE_I18N = xyes ]; then
    MODE_CONV_UNICODE=yes
  fi
  DEFINE="${DEFINE} -dSDLMODE"
  MODE_STRING="sdl"
  if [ x$MODE_SDLMINI = xyes ]; then
    DEFINE="${DEFINE} -dMINI"
  fi
  if [ x$MODE_32EMU = xyes ]; then
    LD_RES="build.link.sdlmode.32.static.res"
  else
    LD_RES="build.link.sdlmode.static.res"
  fi
fi
if [ x$MODE_MSWINGDI = xyes ]; then
  DEFINE="${DEFINE} -dGUIMSWINMODE"
  MODE_STRING="ascii_mswingdi"
fi
if [ x$MODE_ASCII = xyes ]; then
  MODE_STRING="ascii"
fi
#
if [ x$MODE_TENC = xyes ]; then
  DEFINE="${DEFINE} -dWITH_TENC"
  MODE_ICONV=yes
fi
if [ x$MODE_WIDECHAR = xyes ]; then
  DEFINE="${DEFINE} -dWITH_WIDECHAR"
  MODE_CONV_UNICODE=yes
fi
if [ x$MODE_PASCAL_WRITE_BUG_HACK = xyes ]; then
  DEFINE="${DEFINE} -dPASCAL_WRITE_BUG_HACK"
fi
if [ x$MODE_CONV_UNICODE = xyes ]; then
  DEFINE="${DEFINE} -dCONV_UNICODE"
fi
if [ x$MODE_ICONV = xyes ]; then
  DEFINE="${DEFINE} -dICONV"
fi
if [ x$MODE_LIBC_ICONV = xyes ]; then
  DEFINE="${DEFINE} -dLIBC_ICONV"
fi
if [ x$MODE_LIBICONV_PLUG = xyes ]; then
  DEFINE="${DEFINE} -dLIBICONV_PLUG"
fi
#
if [ x$MODE_DEBUG = xyes ]; then
  OPTIONS="${OPTIONS} -g -Ci -Co -CR -Cr -Ct"
fi
if [ x$MODE_PARANOID_SAFER = xyes ]; then
  DEFINE="${DEFINE} -dPATCH_GH_PARANOID_SAFER"
fi
if [ x$MODE_DEFINE_DEBUG = xyes ]; then
  DEFINE="${DEFINE} -dDEBUG"
fi
if [ x$MODE_OPTIMIZE = xyes ]; then
  OPTIONS="${OPTIONS} -O3 -Op2"
else
  OPTIONS="${OPTIONS}"
fi
if [ x$MODE_STATIC = xyes -a x$MODE_ASCII = xyes ]; then
  OPTIONS="${OPTIONS} -Xt"
fi
if [ x$MODE_UNIX = xyes ]; then
  DEFINE="${DEFINE} -dUNIX -dLINUX"
fi
#
if [ x$PATH_TO_OBJECTS_ADD = x ]; then
  PATH_TO_OBJECTS="build.${MODE_STRING}.${OS_IDENT}"
else
  PATH_TO_OBJECTS="build.${MODE_STRING}.${OS_IDENT}.${PATH_TO_OBJECTS_ADD}"
fi
if [ ! -d ${PATH_TO_OBJECTS} ]; then
  ${MKDIR} ${PATH_TO_OBJECTS}
fi
OPTIONS="${OPTIONS} -FU${PATH_TO_OBJECTS} -FE${PATH_TO_OBJECTS}"
#
PCFLAGS="${OPTIONS} ${DEFINE} ${INCLUDE} ${UNIT}"
SRC=${SRC:-"arena.pas"}
#

#
if [ x$MODE_CLEAN = xyes ]; then
  if [ x$MODE_SHOW = x ]; then
    ${RM} *.o *.ppu
  else
    echo "${RM} *.o *.ppu"
  fi
fi
#
if [ x$MODE_BUILD = xyes ]; then
  if [ x$MODE_SHOW = x ]; then
    ${PC} ${PCMODE} ${PCFLAGS} ${SRC}
  else
    echo "${PC} ${PCMODE} ${PCFLAGS} ${SRC}"
  fi
fi
if [ x$MODE_STATIC = xyes -a x$MODE_SDL = xyes ]; then
  if [ x$MODE_SHOW = x ]; then
    ${LD} ${LDFLAGS} -L. -o arena.static ${LD_RES}
  else
    echo "${LD} ${LDFLAGS} -L. -o arena.static ${LD_RES}"
  fi
fi
#

# [ End of File ]
