unit ConGfx;
{
	GearHead: Arena, a roguelike mecha CRPG
	Copyright (C) 2005 Joseph Hewitt

	This library is free software; you can redistribute it and/or modify it
	under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation; either version 2.1 of the License, or (at
	your option) any later version.

	The full text of the LGPL can be found in license.txt.

	This library is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
	General Public License for more details. 

	You should have received a copy of the GNU Lesser General Public License
	along with this library; if not, write to the Free Software Foundation,
	Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
}

interface

{$IFDEF GUIMSWINMODE}
uses w32crt;
{$ELSE GUIMSWINMODE}
uses crt;
{$ENDIF GUIMSWINMODE}

const

{ For the purpose of making things easy on me, the }
{ screen is divided into several zones. }
{$IFDEF PATCH_GH}
	NumZones = 31;
{$ELSE PATCH_GH}
	NumZones = 30;
{$ENDIF PATCH_GH}
	ZONE_Map = 1;
	ZONE_Clock = 2;
	ZONE_Info = 3;
	ZONE_Menu = 4;
	ZONE_Menu1 = 5;
	ZONE_Menu2 = 6;
	ZONE_Dialog = 7;
	ZONE_HQPilots = 8;
	ZONE_HQMecha = 9;
	ZONE_CharGenMenu = 10;
	ZONE_CharGenDesc = 11;
	ZONE_InteractStatus = 12;
	ZONE_InteractMenu = 13;
	ZONE_InteractMsg = 14;
	ZONE_InteractTotal = 15;

	ZONE_TextInput = 16;
	ZONE_EqpMenu = 17;
	ZONE_InvMenu = 18;
	ZONE_CharGenPrompt = 19;
	ZONE_Biography = 20;

	ZONE_SkillGenMenu = 21;
	ZONE_SkillGenDesc = 22;
	ZONE_SubInfo = 23;
	ZONE_Factory_Caption = 24;
	ZONE_Factory_Parts = 25;

	ZONE_YesNoTotal = 26;
	ZONE_YesNoPrompt = 27;
	ZONE_YesNoMenu = 28;
	ZONE_UsagePrompt = 29;
	ZONE_UsageMenu = 30;

{$IFDEF PATCH_GH}
	ZONE_MoreText = 31;
{$ELSE PATCH_GH}
{$ENDIF PATCH_GH}

	ZONE_MemoText = 27;
	ZONE_MemoMenu = 28;

	ScreenZone: Array [1..NumZones , 1..4] of Integer = (
	(   2 ,   2  ,  -32 , -6 ),
	(  -30 , -5  ,  -1 , -5 ),
	(  -30 ,   1  ,  -1 , 10 ),
	(  -30 ,  11  ,  -1 , -6 ),
{$IFDEF PATCH_I18N}
	(  -30 ,  11  ,  -1 , 14 ),

	(  -30 ,  15  ,  -1 , -6 ),
{$ELSE PATCH_I18N}
	(  -30 ,  11  ,  -1 , 13 ),

	(  -30 ,  14  ,  -1 , -6 ),
{$ENDIF PATCH_I18N}
	(   1 , -4  ,  -1 , 0 ),
	(   3 ,   3  ,   -62 , -6 ),
	(  -60 ,   3  ,  -32 , -6 ),
	(  -29 ,   4  ,  -2 , 0 ),

	(   2 , -4  ,  -32 , 0 ),
	(   2 ,   2  ,   46 ,  5 ),
	(   2 ,  13  ,  46 , 19 ),
	(   2 ,  6  ,  46 , 12 ),
	(   1 ,   1  ,  47 , 20 ),

	(   -71 ,  -15  ,  -40 , -12 ),
	(   4 ,   3  ,  44 , 7 ),
	(   4 ,  9  ,  44 , 18 ),
	(  -28 ,   2  ,  -3 , 2 ),
	(   4 ,   -10  , -34 , -6 ),

	(  -29 ,   -21  ,  -2 , -10 ),
	(  -28 ,   -7  ,  -3 , -2 ),
	(  -29 ,   2  ,  -2 , 9 ),
	(   2 ,   2  ,  -32 , -20 ),
	(   2 ,   -18 ,  -32 , -6 ),

	(   -69 ,   -21  ,  -37 , -9 ),
	(   -68 ,   -20  ,  -38 , -13 ),
	(   -68 ,   -11  ,  -38 , -10 ),
	(   -68 ,   -20  ,  -38 , -17 ),
{$IFDEF PATCH_GH}
	(   -68 ,   -15  ,  -38 , -10 ),
	(   1 ,   1  ,  -1 , -1 )
{$ELSE PATCH_GH}
	(   -68 ,   -15  ,  -38 , -10 )
{$ENDIF PATCH_GH}

	);

{$IFDEF PATCH_GH}
	GOTOXY_MIN = 1;
	GOTOXY_MAX = 255;
{$ELSE PATCH_GH}
  {$IFDEF PATCH_I18N}
	GOTOXY_MIN = 1;
	GOTOXY_MAX = 255;
  {$ENDIF PATCH_I18N}
{$ENDIF PATCH_GH}

{ *** STANDARD COLORS *** }
	StdBlack: Byte = Black;
	StdWhite: Byte = White;
	MenuItem: Byte = Cyan;
	MenuSelect: Byte = LightCyan;
	TerrainGreen: Byte = Green;
	PlayerBlue: Byte = LightBlue;
	AllyPurple: Byte = LightMagenta;
	EnemyRed: Byte = Red;
	NeutralGrey: Byte = LightGray;
	InfoGreen: Byte = Green;
	InfoHiLight: Byte = LightGreen;
	TextboxGrey: Byte = DarkGray;
	AttackColor: Byte = LightRed;
	NeutralBrown: Byte = Yellow;
	BorderBlue: Byte = Blue;


Procedure ClipZone( ZoneNumber: Integer );
Procedure MaxClipZone;
Procedure ClrZone( ZoneNumber: Integer );
Procedure ClrScreen;
Procedure DrawZoneBorder( X1, Y1, X2, Y2, Color: Byte );
Procedure DrawZoneBorder( Z: Integer; C: Byte );
Procedure DrawExtBorder( Z: Integer; C: Byte );
Procedure DrawMapBorder( N,E,S,W: Boolean );

Procedure DrawBPBorder;
Procedure DrawCharGenBorder;
Procedure SetupCombatDisplay;
{$IFDEF PATCH_GH}
	{ SetupHQDisplay was moved into context.pp. }
{$ELSE PATCH_GH}
Procedure SetupHQDisplay;
{$ENDIF PATCH_GH}
Procedure SetupFactoryDisplay;
Procedure SetupYesNoDisplay;
Procedure SetupMemoDisplay;
Procedure SetupInteractDisplay( TeamColor: Byte );

implementation

uses
{$IFDEF DEBUG}
	errmsg,
{$ENDIF DEBUG}
{$IFDEF GUIMSWINMODE}
	w32,conoutput,
{$ENDIF GUIMSWINMODE}
	ui4gh;

{$I boxdraw.inc}

Procedure ClipZone( ZoneNumber: Integer );
	{ Set the clipping bounds to this defined zone. }
begin
{$IFDEF GUIMSWINMODE}
	w32crt.Window( ScreenZone[ZoneNumber,1] , ScreenZone[ZoneNumber,2] , ScreenZone[ZoneNumber,3] , ScreenZone[ZoneNumber,4] );
{$ELSE GUIMSWINMODE}
	Window( ScreenZone[ZoneNumber,1] , ScreenZone[ZoneNumber,2] , ScreenZone[ZoneNumber,3] , ScreenZone[ZoneNumber,4] );
{$ENDIF GUIMSWINMODE}
end;

Procedure MaxClipZone;
	{ Restore the clip area to the maximum possible area. }
begin
{$IFDEF GUIMSWINMODE}
	w32crt.Window( 1 , 1 , ScreenColumns , ScreenRows );
{$ELSE GUIMSWINMODE}
	Window( 1 , 1 , ScreenColumns , ScreenRows );
{$ENDIF GUIMSWINMODE}
end;

Procedure ClrZone( ZoneNumber: Integer );
	{ Clear the specified screen zone. }
begin
	ClipZone( ZoneNumber );
{$IFDEF GUIMSWINMODE}
	w32crt.TextBackground( Black );
	w32crt.ClrScr;
{$ELSE GUIMSWINMODE}
	TextBackground( Black );
	ClrScr;
{$ENDIF GUIMSWINMODE}
	MaxClipZone;
end;

Procedure ClrScreen;
	{ Clear the entire screen. }
begin
{$IFDEF GUIMSWINMODE}
	w32crt.TextBackground( Black );
{$ELSE GUIMSWINMODE}
	TextBackground( Black );
{$ENDIF GUIMSWINMODE}
	MaxClipZone;
{$IFDEF GUIMSWINMODE}
	w32crt.ClrScr;
{$ELSE GUIMSWINMODE}
	ClrScr;
{$ENDIF GUIMSWINMODE}
end;

Procedure DrawZoneBorder( X1, Y1, X2, Y2, Color: Byte );
	{ Do a lovely box in the specified color around the specified zone. }
var
	t: integer;		{a counter, of the house of CBM.}
begin
	{Set the color for the box.}
{$IFDEF GUIMSWINMODE}
	w32crt.TextColor(Color);
	w32crt.TextBackground( Black );
{$ELSE GUIMSWINMODE}
	TextColor(Color);
	TextBackground( Black );
{$ENDIF GUIMSWINMODE}

{$IFDEF NeedShifts}
	ShiftAltCharset;
{$ENDIF}

	{Print the four corners.}
{$IFDEF GUIMSWINMODE}
	w32crt.GotoXY(X1,Y1);
	conoutput.ConWrite(BoxUpperLeft);
	w32crt.GotoXY(X2,Y1);
	conoutput.ConWrite(BoxUpperRight);
	w32crt.GotoXY(X1,Y2);
	conoutput.ConWrite(BoxLowerLeft);
	w32crt.GotoXY(X2,Y2);
	conoutput.ConWrite(BoxLowerRight);
{$ELSE GUIMSWINMODE}
	GotoXY(X1,Y1);
	write(BoxUpperLeft);
	GotoXY(X2,Y1);
	write(BoxUpperRight);
	GotoXY(X1,Y2);
	write(BoxLowerLeft);
	GotoXY(X2,Y2);
	write(BoxLowerRight);
{$ENDIF GUIMSWINMODE}

	{Print the two horizontal edges.}
	for t := X1+1 to X2-1 do begin
{$IFDEF GUIMSWINMODE}
		w32crt.GotoXY(t,Y1);
		conoutput.ConWrite(BoxHorizontal);
		w32crt.GotoXY(t,Y2);
		conoutput.ConWrite(BoxHorizontal);
{$ELSE GUIMSWINMODE}
		GotoXY(t,Y1);
		write(BoxHorizontal);
		GotoXY(t,Y2);
		write(BoxHorizontal);
{$ENDIF GUIMSWINMODE}
	end;

	{Print the two vertical edges.}
	for t := Y1+1 to Y2-1 do begin
{$IFDEF GUIMSWINMODE}
		w32crt.GotoXY(X1,t);
		conoutput.Conwrite(BoxVertical);
		w32crt.GotoXY(X2,t);
		conoutput.ConWrite(BoxVertical);
{$ELSE GUIMSWINMODE}
		GotoXY(X1,t);
		write(BoxVertical);
		GotoXY(X2,t);
		write(BoxVertical);
{$ENDIF GUIMSWINMODE}
	end;

{$IFDEF NeedShifts}
	ShiftNormalCharset;
{$ENDIF}

end;

Procedure DrawZoneBorder( Z: Integer; C: Byte );
	{ Do a box around this zone. }
begin
	DrawZoneBorder( ScreenZone[Z,1], ScreenZone[Z,2], ScreenZone[Z,3], ScreenZone[Z,4], C );
end;

Procedure DrawExtBorder( Z: Integer; C: Byte );
	{ Do a box around this zone. }
begin
	DrawZoneBorder( ScreenZone[Z,1] - 1, ScreenZone[Z,2] - 1, ScreenZone[Z,3] + 1, ScreenZone[Z,4] + 1, C );
end;

Procedure DrawMapBorder( N,E,S,W: Boolean );
	{ Draw a box one character outside of the map zone. }
	{ If any of the directions are set to TRUE, print a "MORE" }
	{ prompt along that side. }
var
	T: Integer;
begin
	{ Start by drawing the border itself. }
	DrawZoneBorder( ScreenZone[ ZONE_Map , 1 ] - 1 , ScreenZone[ ZONE_Map , 2 ] - 1 , ScreenZone[ ZONE_Map , 3 ] + 1 , ScreenZone[ ZONE_Map , 4 ] + 1 , Cyan );

	{ Draw "MORE"s as appropriate. }
	If N then begin
{$IFDEF GUIMSWINMODE}
		w32crt.GotoXY( ( ScreenZone[ ZONE_Map , 1 ] + ScreenZone[ ZONE_Map , 3 ] ) div 2 - 2 , ScreenZone[ ZONE_Map , 2 ] - 1 );
		conoutput.ConWrite( StringOfChar(GLYPH_FRAME_TM, 5) );
{$ELSE GUIMSWINMODE}
		GotoXY( ( ScreenZone[ ZONE_Map , 1 ] + ScreenZone[ ZONE_Map , 3 ] ) div 2 - 2 , ScreenZone[ ZONE_Map , 2 ] - 1 );
		Write( '+++++' );
{$ENDIF GUIMSWINMODE}
	end;
	If S then begin
{$IFDEF GUIMSWINMODE}
		w32crt.GotoXY( ( ScreenZone[ ZONE_Map , 1 ] + ScreenZone[ ZONE_Map , 3 ] ) div 2 - 2 , ScreenZone[ ZONE_Map , 4 ] + 1 );
		conoutput.ConWrite( StringOfChar(GLYPH_FRAME_BM, 5) );
{$ELSE GUIMSWINMODE}
		GotoXY( ( ScreenZone[ ZONE_Map , 1 ] + ScreenZone[ ZONE_Map , 3 ] ) div 2 - 2 , ScreenZone[ ZONE_Map , 4 ] + 1 );
		Write( '+++++' );
{$ENDIF GUIMSWINMODE}
	end;
	If W then begin
		for t := 1 to 4 do begin
{$IFDEF GUIMSWINMODE}
			w32crt.GotoXY( ScreenZone[ ZONE_Map , 1 ] - 1 , ( ScreenZone[ ZONE_Map , 2 ] + ScreenZone[ ZONE_Map , 4 ] ) div 2 - 2 + T );
			conoutput.ConWrite( GLYPH_FRAME_LM );
{$ELSE GUIMSWINMODE}
			GotoXY( ScreenZone[ ZONE_Map , 1 ] - 1 , ( ScreenZone[ ZONE_Map , 2 ] + ScreenZone[ ZONE_Map , 4 ] ) div 2 - 2 + T );
			Write( '+' );
{$ENDIF GUIMSWINMODE}
		end;
	end;
	If E then begin
		for t := 1 to 4 do begin
{$IFDEF GUIMSWINMODE}
			w32crt.GotoXY( ScreenZone[ ZONE_Map , 3 ] + 1 , ( ScreenZone[ ZONE_Map , 2 ] + ScreenZone[ ZONE_Map , 4 ] ) div 2 - 2 + T );
			conoutput.ConWrite( GLYPH_FRAME_RM );
{$ELSE GUIMSWINMODE}
			GotoXY( ScreenZone[ ZONE_Map , 3 ] + 1 , ( ScreenZone[ ZONE_Map , 2 ] + ScreenZone[ ZONE_Map , 4 ] ) div 2 - 2 + T );
			Write( '+' );
{$ENDIF GUIMSWINMODE}
		end;
	end;
end;

Procedure DrawBPBorder;
	{ Do the border for the BackPack routines. }
var
	T: Integer;
begin
{$IFDEF PATCH_GH}
	DrawZoneBorder( ScreenZone[ ZONE_EqpMenu , 1 ] - 1 , ScreenZone[ ZONE_EqpMenu , 2 ] - 1 , ScreenZone[ ZONE_EqpMenu , 3 ] + 1 , ScreenZone[ ZONE_EqpMenu , 4 ] + 1 , White );
	DrawZoneBorder( ScreenZone[ ZONE_InvMenu , 1 ] - 1 , ScreenZone[ ZONE_InvMenu , 2 ] - 1 , ScreenZone[ ZONE_InvMenu , 3 ] + 1 , ScreenZone[ ZONE_InvMenu , 4 ] + 1 , White );
{$ELSE PATCH_GH}
	DrawZoneBorder( ScreenZone[ ZONE_EqpMenu , 1 ] - 1 , ScreenZone[ ZONE_EqpMenu , 2 ] - 1 , ScreenZone[ ZONE_InvMenu , 3 ] + 1 , ScreenZone[ ZONE_InvMenu , 4 ] + 1 , White );
{$IFDEF GUIMSWINMODE}
	w32crt.GotoXY( ScreenZone[ ZONE_EqpMenu , 1 ] , ScreenZone[ ZONE_EqpMenu , 4 ] + 1 );
{$ELSE GUIMSWINMODE}
	GotoXY( ScreenZone[ ZONE_EqpMenu , 1 ] , ScreenZone[ ZONE_EqpMenu , 4 ] + 1 );
{$ENDIF GUIMSWINMODE}
{$IFDEF NeedShifts}
	ShiftAltCharset;
{$ENDIF}
	for t := 1 to (ScreenZone[ ZONE_EqpMenu , 3 ] - ScreenZone[ ZONE_EqpMenu , 1 ] + 1 ) do
{$IFDEF GUIMSWINMODE}
		conoutput.ConWrite(BoxSeperator);
{$ELSE GUIMSWINMODE}
		write(BoxSeperator);
{$ENDIF GUIMSWINMODE}
{$IFDEF NeedShifts}
	ShiftNormalCharset;
{$ENDIF}
{$ENDIF PATCH_GH}

end;

Procedure DrawCharGenBorder;
	{ Do the border for the character generator routines. }
begin
	DrawZoneBorder( ScreenZone[ ZONE_Map , 1 ] - 1 , ScreenZone[ ZONE_Map , 2 ] - 1 , ScreenZone[ ZONE_Map , 3 ] + 1 , ScreenZone[ ZONE_Map , 4 ] + 1 , PlayerBlue );
	DrawZoneBorder( ScreenZone[ ZONE_CharGenPrompt , 1 ] - 1 , ScreenZone[ ZONE_CharGenPrompt , 2 ] - 1 , ScreenZone[ ZONE_CharGenPrompt , 3 ] + 1 , ScreenZone[ ZONE_CharGenPrompt , 4 ] + 1 , Blue );
end;


Procedure SetupCombatDisplay;
	{ Clear the screen & draw boxes. }
begin
{$IFDEF GUIMSWINMODE}
	w32crt.ClrScr;
{$ELSE GUIMSWINMODE}
	ClrScr;
{$ENDIF GUIMSWINMODE}
end;

{$IFDEF PATCH_GH}
{$ELSE PATCH_GH}
Procedure SetupHQDisplay;
	{ CLear the screen & draw boxes. }
begin
  {$IFDEF GUIMSWINMODE}
	w32crt.ClrScr;
  {$ELSE GUIMSWINMODE}
	ClrScr;
  {$ENDIF GUIMSWINMODE}
end;
{$ENDIF PATCH_GH}


Procedure SetupFactoryDisplay;
	{ CLear the screen & draw boxes. }
begin
{$IFDEF GUIMSWINMODE}
	w32crt.ClrScr;
{$ELSE GUIMSWINMODE}
	ClrScr;
{$ENDIF GUIMSWINMODE}
	DrawExtBorder( ZONE_Factory_Parts , LightGray );
	DrawExtBorder( ZONE_Factory_Caption , White );
end;

Procedure SetupYesNoDisplay;
	{ Set up the display for the YesNo box. }
var
	T: Integer;
begin
	ClrZone( ZONE_YesNoTotal );
	DrawZoneBorder( ZONE_YesNoTotal  , LightBlue );
{$IFDEF GUIMSWINMODE}
	w32crt.GotoXY( ScreenZone[ ZONE_YesNoMenu , 1 ] , ScreenZone[ ZONE_YesNoMenu , 2 ] - 1 );
{$ELSE GUIMSWINMODE}
	GotoXY( ScreenZone[ ZONE_YesNoMenu , 1 ] , ScreenZone[ ZONE_YesNoMenu , 2 ] - 1 );
{$ENDIF GUIMSWINMODE}
{$IFDEF NeedShifts}
	ShiftAltCharset;
{$ENDIF}
	for t := 1 to (ScreenZone[ ZONE_YesNoMenu , 3 ] - ScreenZone[ ZONE_YesNoMenu , 1 ] + 1 ) do
{$IFDEF GUIMSWINMODE}
		conoutput.ConWrite(BoxSeperator);
{$ELSE GUIMSWINMODE}
		write(BoxSeperator);
{$ENDIF GUIMSWINMODE}
{$IFDEF NeedShifts}
	ShiftNormalCharset;
{$ENDIF}
end;

Procedure SetupMemoDisplay;
	{ Draw a nice border and some instructions for the memo display. }
var
	T: Integer;
begin
	ClrZone( ZONE_YesNoTotal );
	DrawZoneBorder( ZONE_YesNoTotal  , LightMagenta );
{$IFDEF GUIMSWINMODE}
	w32crt.GotoXY( ScreenZone[ ZONE_YesNoMenu , 1 ] , ScreenZone[ ZONE_YesNoMenu , 2 ] - 1 );
{$ELSE GUIMSWINMODE}
	GotoXY( ScreenZone[ ZONE_YesNoMenu , 1 ] , ScreenZone[ ZONE_YesNoMenu , 2 ] - 1 );
{$ENDIF GUIMSWINMODE}
{$IFDEF NeedShifts}
	ShiftAltCharset;
{$ENDIF}
	for t := 1 to (ScreenZone[ ZONE_YesNoMenu , 3 ] - ScreenZone[ ZONE_YesNoMenu , 1 ] + 1 ) do
{$IFDEF GUIMSWINMODE}
		conoutput.ConWrite(BoxSeperator);
{$ELSE GUIMSWINMODE}
		write(BoxSeperator);
{$ENDIF GUIMSWINMODE}
{$IFDEF NeedShifts}
	ShiftNormalCharset;
{$ENDIF}
end;

Procedure SetupInteractDisplay( TeamColor: Byte );
	{ Draw the display for the interaction interface. }
begin
	ClrZone( ZONE_InteractTotal );
	DrawZoneBorder( ZONE_InteractTotal , TeamColor );
end;


Procedure AnchorEdge(var value: Integer; limit: Integer);
begin
      if value < 1 then value := limit + value;
end;

Procedure CheckDimensions;
	{ If the screen dimensions have been redefined, we'll need to alter }
	{ the dimensions of the screen zones. }
var
	t, uRows, uCols, iRowOff, iColOff: Integer;
begin

{$IFDEF PATCH_GH}
	if (0 < ScreenSize_Width) and (ScreenSize_Width < ScreenColumns) then begin
		ScreenColumns := ScreenSize_Width;
	end;
	if (0 < ScreenSize_Height) and (ScreenSize_Height < ScreenRows) then begin
		ScreenRows := ScreenSize_Height;
	end;
{$ENDIF PATCH_GH}
	if ScreenRows > 57 then uRows := 57 else uRows := ScreenRows;
	if ScreenColumns > 83 then uCols := 83 else uCols := ScreenColumns;

	iRowOff := (uRows - 25) div 2;
	iColOff := (uCols - 78) div 2;

	for t := 1 to NumZones do begin
	    case t of
	      ZONE_InteractStatus, ZONE_InteractMenu, 
	      ZONE_InteractMsg, ZONE_InteractTotal,
	      ZONE_InvMenu, ZONE_EqpMenu:
		  begin
		      { Center the interaction and inventory windows within
			the map window }
		      ScreenZone[t,1] := ScreenZone[t,1] + iColOff;
		      ScreenZone[t,2] := ScreenZone[t,2] + iRowOff;
		      ScreenZone[t,3] := ScreenZone[t,3] + iColOff;
		      ScreenZone[t,4] := ScreenZone[t,4] + iRowOff;
		  end;
	      ZONE_Dialog:
		  begin 
		      { The dialog window recieves any slop lines at the
			bottom of the screen }
		      AnchorEdge(ScreenZone[t,1],uCols);
		      AnchorEdge(ScreenZone[t,2],uRows);
		      AnchorEdge(ScreenZone[t,3],uCols);
		      ScreenZone[t,4] := ScreenRows;
		  end;
	      else 
		  begin
		      { Normal zone anchoring. Most zone corners are 
			specified relative to edges of an screen area
			which ranges from 80x25 to 83x57 depending on the 
			underlying terminal support.} 
		      AnchorEdge(ScreenZone[t,1],uCols);
		      AnchorEdge(ScreenZone[t,2],uRows);
		      AnchorEdge(ScreenZone[t,3],uCols);
		      AnchorEdge(ScreenZone[t,4],uRows);
		  end;
	      end;
	end;

{$IFDEF PATCH_GH}
	if (0 < ScreenSize_Width) or (0 < ScreenSize_Height) then begin
		for t := 1 to NumZones do begin
		    case t of
		      ZONE_Map:
		       begin
			if ScreenColumns < ScreenSize_Width then begin
				ScreenZone[t,3] := ScreenZone[t,3] * ScreenSize_Width  div uCols;
			end;
			if ScreenRows < ScreenSize_Height then begin
				ScreenZone[t,4] := ScreenZone[t,4] * ScreenSize_Height div uRows;
			end;
		       end;
		      else
		       begin
			if ScreenColumns < ScreenSize_Width then begin
				if 2 < ScreenZone[t,1] then begin
					ScreenZone[t,1] := ScreenZone[t,1] * ScreenSize_Width  div uCols;
				end;
				ScreenZone[t,3] := ScreenZone[t,3] * ScreenSize_Width  div uCols;
			end;
			if ScreenRows < ScreenSize_Height then begin
				if 2 < ScreenZone[t,2] then begin
					ScreenZone[t,2] := ScreenZone[t,2] * ScreenSize_Height div uRows;
				end;
				ScreenZone[t,4] := ScreenZone[t,4] * ScreenSize_Height div uRows;
			end;
		       end;
		    end;
		end;
		if 49 < (ScreenZone[ZONE_Map,3] - ScreenZone[ZONE_Map,1]) then begin
			ScreenZone[ZONE_Map,3] := ScreenZone[ZONE_Map,1] + 49;
		end;
		if 49 < (ScreenZone[ZONE_Map,4] - ScreenZone[ZONE_Map,2]) then begin
			ScreenZone[ZONE_Map,4] := ScreenZone[ZONE_Map,2] + 49;
		end;
		ScreenColumns := ScreenSize_Width;
		ScreenRows    := ScreenSize_Height;
	end;
{$ENDIF PATCH_GH}
{$IFDEF GUIMSWINMODE}
	MSWINGUI_Width  := ScreenColumns;
	MSWINGUI_Height := ScreenRows;
{$ENDIF GUIMSWINMODE}
end;



initialization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: congfx.pp');
{$ENDIF DEBUG}
{$IFDEF GUIMSWINMODE}
	CheckDimensions;
	w32crt.W32CrtInit;
	w32crt.CursorOff;
	w32crt.ClrScr;
{$ELSE GUIMSWINMODE}
	CursorOff; {LINUX ALERT... Maybe also doesn't work on Win2000}
	ClrScr;
	CheckDimensions;
{$ENDIF GUIMSWINMODE}
end;

finalization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: congfx.pp(finalization)');
{$ENDIF DEBUG}
{$IFDEF GUIMSWINMODE}
	w32crt.NormVideo;
	w32crt.ClrScr;
	w32crt.CursorOn;
	w32crt.DisposeWindow;
{$ELSE GUIMSWINMODE}
  {$IFDEF DEBUG}
  {$ELSE DEBUG}
	NormVideo;
	ClrScr;
  {$ENDIF}
	CursorOn;
{$ENDIF GUIMSWINMODE}
end;

end.
