{$IFDEF PATCH_GH}
unit errmsg;
{ Display the Error Message(s) to appropriate device. }

interface


Procedure ErrorMessage_fork( const msg: String );
Procedure ErrorMessage( const msg: String );



implementation

{$IFDEF HAVE_NO_TERMINAL}
  {$IFDEF Windows}
    {$DEFINE WIN_USE_DEBUGGEROUTPUT}
    {$DEFINE WIN_MUST_CREATE_CONSOLEWINDOW}
    {$IFDEF WIN_USE_WRITECONSOLE}
    {$ELSE WIN_USE_WRITECONSOLE}
      {$DEFINE HAVE_TERMINAL}
    {$ENDIF WIN_USE_WRITECONSOLE}
  {$ENDIF Windows}
{$ENDIF HAVE_NO_TERMINAL}

{ "sysutils" has to come before others. }
uses sysutils,
{$IFDEF WIN_MUST_CREATE_CONSOLEWINDOW}
	windows
  {$IFDEF SDLMODE}
	,w32
  {$ENDIF SDLMODE}
	;
{$ELSE WIN_MUST_CREATE_CONSOLEWINDOW}
	dos;
  {$DEFINE HAVE_TERMINAL}
{$ENDIF WIN_MUST_CREATE_CONSOLEWINDOW}


const
	LOGFILE = 'debug.log';


var
	FP: Text;
	FP_ready: Boolean = False;
{$IFDEF WIN_MUST_CREATE_CONSOLEWINDOW}
	Console_stderr: Handle;
	Console_HWND: Windows.HWND;
{$ENDIF WIN_MUST_CREATE_CONSOLEWINDOW}


{$IFDEF WIN_MUST_CREATE_CONSOLEWINDOW}
Function InitializeConsole(): Boolean;
const
	title = 'GearHead ErrorMessages'#0;
	cmsgLen = 255;
var
	cmsg: Array[0..cmsgLen] of Char;
begin
	if Windows.AllocConsole() then begin
		Windows.SetConsoleTitle( title );
		Windows.GetConsoleTitle( cmsg, cmsgLen-1 );	cmsg[cmsgLen] := #0;

		{ Connect handles to the console window. }
		Console_stderr := Windows.GetStdHandle( Windows.STD_ERROR_HANDLE );
  {$IFDEF FPC}
		System.IsConsole := True;
		System.SysInitStdIO();
  {$ENDIF FPC}

		{ Wait, until open the console window. }
		repeat
			Windows.sleep(0);
			{ In MS-Windows, the order of sleep is mili-second, not second. }
			Console_HWND := Windows.FindWindow( NIL, cmsg );
		until Console_HWND <> 0;
	end;
	InitializeConsole := True;
end;
{$ENDIF WIN_MUST_CREATE_CONSOLEWINDOW}


Procedure ErrorMessage_fork( const msg: String );
{$IFDEF Windows}
var
	cmsg: Array[0..255] of Char;
  {$IFDEF WIN_USE_WRITECONSOLE}
	dw: LongWord;
  {$ENDIF WIN_USE_WRITECONSOLE}
{$ENDIF Windows}
begin
{$IFDEF WIN_USE_DEBUGGEROUTPUT}
	StrPCopy( cmsg, msg );
	Windows.OutputDebugString( cmsg );
{$ENDIF WIN_USE_DEBUGGEROUTPUT}

{$IFDEF DEBUG}
	if FP_ready then begin
		WriteLn( FP, msg );
		Flush( FP );
	end else begin
		WriteLn( stderr, msg );
		Flush( stderr );
	end;
{$ELSE DEBUG}
  {$IFDEF WIN_MUST_CREATE_CONSOLEWINDOW}
	InitializeConsole();
  {$ENDIF WIN_MUST_CREATE_CONSOLEWINDOW}
  {$IFDEF HAVE_TERMINAL}
	WriteLn( stderr, msg );
  {$ENDIF HAVE_TERMINAL}
  {$IFDEF WIN_USE_WRITECONSOLE}
	StrPCopy( cmsg, msg + #$0a );
	Windows.WriteConsole( Console_stderr, @cmsg,Length(msg)+1, dw, NIL );
  {$ENDIF WIN_USE_WRITECONSOLE}
{$ENDIF DEBUG}
end;


Procedure ErrorMessage( const msg: String );
{$IFDEF Windows}
var
	cmsg: Array[0..255] of Char;
  {$IFDEF WIN_USE_WRITECONSOLE}
	dw: LongWord;
  {$ENDIF WIN_USE_WRITECONSOLE}
  {$IFDEF WIN_MUST_CREATE_CONSOLEWINDOW}
	pwnd: Windows.HWND;
  {$ENDIF WIN_MUST_CREATE_CONSOLEWINDOW}
{$ENDIF Windows}
begin
{$IFDEF WIN_USE_DEBUGGEROUTPUT}
	StrPCopy( cmsg, msg );
	Windows.OutputDebugString( cmsg );
{$ENDIF WIN_USE_DEBUGGEROUTPUT}

{$IFDEF DEBUG}
	if FP_ready then begin
		WriteLn( FP, msg );
		Flush( FP );
	end else begin
		WriteLn( stderr, msg );
		Flush( stderr );
	end;
{$ELSE DEBUG}
  {$IFDEF WIN_MUST_CREATE_CONSOLEWINDOW}
	InitializeConsole();
  {$ENDIF WIN_MUST_CREATE_CONSOLEWINDOW}
  {$IFDEF HAVE_TERMINAL}
	WriteLn( stderr, msg );
  {$ENDIF HAVE_TERMINAL}
  {$IFDEF WIN_USE_WRITECONSOLE}
	StrPCopy( cmsg, msg + #$0a );
	Windows.WriteConsole( Console_stderr, @cmsg,Length(msg)+1, dw, NIL );
  {$ENDIF WIN_USE_WRITECONSOLE}
{$ENDIF DEBUG}

{$IFDEF WIN_MUST_CREATE_CONSOLEWINDOW}
	StrPCopy( cmsg, msg );
{$IFDEF SDLMODE}
	pwnd := w32.GetSDLHWND();
{$ELSE SDLMODE}
	pwnd := 0;
{$ENDIF SDLMODE}
	Windows.MessageBox( pwnd, cmsg, 'ERROR'#0, MB_OK );
{$ENDIF WIN_MUST_CREATE_CONSOLEWINDOW}
end;



initialization
begin
{$IFDEF DEBUG}
	Assign( FP, LOGFILE );
	{$i-}
	Append( FP );
	{$i+}
	if 0 <> IoResult then begin
		Rewrite( FP );
	end;
	FP_ready := True;
	ErrorMessage_fork('DEBUG: errmsg.pp');
{$ENDIF DEBUG}
end;

finalization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: errmsg.pp(finalization)');
	FP_ready := False;
	Close( FP );
{$ENDIF DEBUG}
end;

end.
{$ENDIF PATCH_GH}
