{$IFDEF PATCH_GH}
unit gears_base;
	{The building block from which everything in this game}
	{is constructed is called a GEAR. Just seemed a good}
	{thing to name the record, given the name of the game.}
{
	GearHead: Arena, a roguelike mecha CRPG
	Copyright (C) 2005 Joseph Hewitt

	This library is free software; you can redistribute it and/or modify it
	under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation; either version 2.1 of the License, or (at
	your option) any later version.

	The full text of the LGPL can be found in license.txt.

	This library is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
	General Public License for more details. 

	You should have received a copy of the GNU Lesser General Public License
	along with this library; if not, write to the Free Software Foundation,
	Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
}

interface

Const
	{ ******************************* }
	{ ***  FILE  NAME  CONSTANTS  *** }
	{ ******************************* }

	OS_Dir_Separator = DirectorySeparator;
	OS_Search_Separator = PathSeparator;
	OS_Current_Directory = '.';

	{ All of the following file names have been checked for }
	{ correct capitalization. Hopefully, everything should run }
	{ fine. }
	GZ_Archive_BufLen = 16384;
	GZ_Archive_Suffix = '.gz';
	Default_File_Ending = '.txt';
	Default_Search_Pattern = '*.txt';
	Archive_Search_Pattern = '*.txt.gz';
	Save_Game_DirName = 'SaveGame';
	Save_Game_Directory = Save_Game_DirName + OS_Dir_Separator;
	Save_Character_Base = Save_Game_Directory + 'CHA';
	Save_Unit_Base = Save_Game_Directory + 'GHU';
	Save_Campaign_Base = Save_Game_Directory + 'RPG';
	Design_DirName = 'Design';
	Design_Directory = Design_DirName + OS_Dir_Separator;
	PC_Equipment_File = Design_Directory + 'PC_Equipment.txt';
	Mek_Equipment_File = Design_Directory + 'Mek_Equipment.txt';
	Series_DirName = 'Series';
	Series_Directory = Series_DirName + OS_Dir_Separator;
	Archetypes_File = Series_Directory + 'ANPCdefault.txt';
	Adventure_File_Base = Series_Directory + 'ADV_';
	STC_Item_File = Series_Directory + 'STCdefault.txt';
	Plot_Seacrh_Pattern = Series_Directory + 'PLOT' + Default_Search_Pattern;
	Jobs_File = Series_Directory + 'RCJobs.txt';
	Monsters_File = Series_Directory + 'WMONdefault.txt';
	Data_DirName = 'GameData';
	Data_Directory = Data_DirName + OS_Dir_Separator;
	MetaTerrain_File_Base = Data_Directory + 'meta';
	Trait_Chatter_Base = Data_Directory + 'TC_';
	Standard_Message_File = Data_Directory + 'messages.txt';
	Damage_Strings_File = Data_Directory + 'damage.txt';
	Ability_Message_File = Data_Directory + 'ability.txt';
	Standard_Nouns_File = Data_Directory + 'nouns.txt';
	Standard_Phrases_File = Data_Directory + 'phrases.txt';
	Standard_Adjectives_File = Data_Directory + 'adjectives.txt';
	Standard_Rumors_File = Data_Directory + 'rumors.txt';
	Standard_Chatter_File = Data_Directory + 'chat_msg.txt';
	Standard_Threats_File = Data_Directory + 'threats.txt';
	Parser_Macro_File = Data_Directory + 'ghpmacro.txt';
	Script_Macro_File = Data_Directory + 'aslmacro.txt';
	Value_Macro_File = Data_Directory + 'asvmacro.txt';
	Effects_Message_File = Data_Directory + 'effects.txt';
	RandMaps_Param_File = Data_Directory + 'randmaps.txt';
	NPC_Chatter_File = Data_Directory + 'taunts.txt';

{$IFDEF PATCH_I18N}
	I18N_Settings_File         = Data_Directory + 'I18N_settings.txt';
	I18N_Name_File             = Data_Directory + 'I18N_name.txt';
	I18N_Messages_File         = Data_Directory + 'I18N_messages.txt';
	I18N_Help_Keymap_Name_File = Data_Directory + 'i18n_keymap_name.txt';
	I18N_Help_Keymap_Desc_File = Data_Directory + 'i18n_keymap_desc.txt';
{$ENDIF PATCH_I18N}

{$IFDEF PATCH_I18N}
	I18N_NPC_GenderTraits_File1 = Data_Directory + 'i18n_pgt_t_m1.txt';
	I18N_NPC_GenderTraits_File2 = Data_Directory + 'i18n_pgt_t_f1.txt';
	I18N_NPC_FirstPerson_File1  = Data_Directory + 'i18n_pgt_fp_m.txt';
	I18N_NPC_FirstPerson_File2  = Data_Directory + 'i18n_pgt_fp_f.txt';
	I18N_NPC_SecondPerson_File1 = Data_Directory + 'i18n_pgt_sp_m.txt';
	I18N_NPC_SecondPerson_File2 = Data_Directory + 'i18n_pgt_sp_f.txt';
	I18N_Standard_Modifier_File = Data_Directory + 'i18n_modifier.txt';
{$ENDIF PATCH_I18N}

	Doc_DirName = 'doc';
	Doc_Directory = Doc_DirName + OS_Dir_Separator;
{$IFDEF PATCH_I18N}
	Mecha_Help_File = Doc_Directory + 'i18n_man_umek.txt';
	FieldHQ_Help_File = Doc_Directory + 'i18n_man_mecha.txt';
	Chara_Help_File = Doc_Directory + 'i18n_man_chara.txt';
{$ELSE PATCH_I18N}
	Mecha_Help_File = Doc_Directory + 'man_umek.txt';
	FieldHQ_Help_File = Doc_Directory + 'man_mecha.txt';
	Chara_Help_File = Doc_Directory + 'man_chara.txt';
{$ENDIF PATCH_I18N}

	Config_File = 'arena.cfg';

{$IFDEF PATCH_CHEAT}
	Graphics_DirName = 'Image';
	Graphics_Directory = Graphics_Dirname + OS_Dir_Separator;
{$ELSE PATCH_CHEAT}
  {$IFDEF SDLMODE}
	Graphics_DirName = 'Image';
	Graphics_Directory = Graphics_Dirname + OS_Dir_Separator;
  {$ENDIF}
{$ENDIF PATCH_CHEAT}

{$IFDEF ENABLE_ADDRESSBOOK}
	Save_Campaign_AddressBook_Base = Save_Game_Directory + 'PHONE';
{$ENDIF}

	Startup_OK: Boolean = True;


Type
	SAttPtr = ^SAtt;
	SAtt = Record		{*** STRING ATTRIBUTE ***}
		info: String;
		next: SAttPtr;
	end;

	NAttPtr = ^NAtt;
	NAtt = Record		{*** NUMERICAL ATTRIBUTE ***}
		G,S: Integer;		{General, Specific, Value}
		V: LongInt;
		next: NAttPtr;
	end;


Function RetrieveAString(const S: String): String;

{$IFDEF PATCH_GH}
Procedure DisposeSAtt( var LList_arg: SAttPtr );
{$ELSE PATCH_GH}
Procedure DisposeSAtt(var LList: SAttPtr);
{$ENDIF PATCH_GH}
Function CreateSAtt(var LList: SAttPtr): SAttPtr;
Function StoreSAtt(var LList: SAttPtr; const Info: String): SAttPtr;
Function FindSAtt(LList: SAttPtr; const Code_In: String): SAttPtr;
Function SAttValue(LList: SAttPtr; const Code: String): String;
Function LoadStringList( const FName_In: String ): SAttPtr;



implementation

{ "sysutils" has to come before "dos" }
uses sysutils,dos
{$IFDEF PATCH_GH}
	,errmsg
{$ELSE PATCH_GH}
  {$IFDEF DEBUG}
	,errmsg
  {$ENDIF DEBUG}
{$ENDIF PATCH_GH}
{$IFDEF PATCH_GH}
	,pseudosmartpointer
{$ENDIF PATCH_GH}
	;

Function RetrieveAString(const S: String): String;
	{Retrieve an Alligator String from S.}
	{Alligator Strings are defined as the part of the string}
	{that both alligarors want to eat, i.e. between < and >.}
var
	A1,A2: Integer;
begin
	{Locate the position of the two alligators.}
	A1 := Pos('<',S);
	A2 := Pos('>',S);

	{If the string has not been declared with <, return}
	{an empty string.}
	if A1 = 0 then Exit('');

	{If the string has not been closed with >, return the}
	{entire remaining length of the string.}
	if A2 = 0 then A2 := Length(S)+1;

	RetrieveAString := Copy(S,A1+1,A2-A1-1);
end;

{$IFDEF PATCH_GH}
Procedure DisposeSAtt( var LList_arg: SAttPtr );
	{Dispose of the list, freeing all associated system resources.}
var
	LList: SAttPtr;
	LTemp: SAttPtr;
begin
	LList := LList_arg;
	LList_arg := NIL;
	while LList <> Nil do begin
		LTemp := LList^.Next;
  {$IFDEF DEBUG}
		Trace_MemoryLeak('DisposeSAtt() Dispose',LList);
  {$ENDIF DEBUG}
		CheckAndNIL_Pointer('DisposeSAtt() Dispose',LList,True);
  {$IFDEF PATCH_GH_PARANOID_SAFER}
		LList^.info := '@';
		LList^.Next := SAttPtr(-1);
  {$ENDIF PATCH_GH_PARANOID_SAFER}
		Dispose(LList);
		LList := LTemp;
	end;
end;
{$ELSE PATCH_GH}
Procedure DisposeSAtt(var LList: SAttPtr);
	{Dispose of the list, freeing all associated system resources.}
var
	LTemp: SAttPtr;
begin
	while LList <> Nil do begin
		LTemp := LList^.Next;
		Dispose(LList);
		LList := LTemp;
	end;
end;
{$ENDIF PATCH_GH}

Function LastSAtt( LList: SAttPtr ): SAttPtr;
	{ Find the last SAtt in this particular list. }
begin
	if LList <> Nil then while LList^.Next <> Nil do LList := LList^.Next;

	LastSAtt := LList;
end;

Function CreateSAtt(var LList: SAttPtr): SAttPtr;
	{Add a new element to the tail of LList.}
var
	it: SAttPtr;
begin
	{Allocate memory for our new element.}
	New(it);
{$IFDEF DEBUG}
	Trace_MemoryLeak('CreateSAtt() New',it);
	CheckAndNIL_Pointer('CreateSAtt() New', it, True );
{$ENDIF DEBUG}
	if it = Nil then exit( Nil );
	it^.Next := Nil;

	{Attach IT to the list.}
	if LList = Nil then begin
		LList := it;
	end else begin
		LastSAtt( LList )^.Next := it;
	end;

	{Return a pointer to the new element.}
	CreateSAtt := it;
end;

Function StoreSAtt(var LList: SAttPtr; const Info: String): SAttPtr;
	{ Add string attribute Info to the list. This procedure }
	{ doesn't check to make sure this attribute isn't duplicated. }
var
	it: SAttPtr;
begin
	it := CreateSAtt(LList);
	it^.info := Info;

	{Return a pointer to the new attribute.}
	StoreSAtt := it;
end;

Function LabelsMatch( const info,code: String ): Boolean;
	{ Return TRUE if UpCase( CODE ) matches UpCase( INFO ) all the }
	{ way to the first '<', ignoring spaces and tabs. }
var
	i_pos,c_pos: Integer;
begin
	{ error check... }
	if ( info = '' ) or ( code = '' ) then Exit( False );
	i_pos := 0;
	c_pos := 0;
	repeat
		inc( i_pos );
		inc( c_pos );
		while (i_pos <= Length(info)) and ((info[i_pos] = ' ') or (info[i_pos] = #9)) do begin
			Inc(i_pos);
		end;
		while (c_pos <= Length(code)) and ((code[c_pos] = ' ') or (code[c_pos] = #9)) do begin
			Inc(c_pos);
		end;
	until ( i_pos > Length( info ) ) or ( c_pos > Length( code ) ) or ( UpCase( info[i_pos] ) <> UpCase( code[c_pos] ) );

	LabelsMatch := ( c_pos > Length( code ) ) and ( i_pos <= Length( info ) ) and ( info[i_pos] = '<' );
end;

Function FindSAtt(LList: SAttPtr; const Code_In: String): SAttPtr;
	{Search through the list looking for a String Attribute}
	{whose code matches CODE and return its address.}
	{Return Nil if no such SAtt can be found.}
var
	it: SAttPtr;
	Code: String;
begin
	{Initialize IT to Nil.}
	it := Nil;

	Code := UpCase(Code_In);

	{Check through all the SAtts looking for the SATT in question.}
	while ( LList <> Nil ) and ( it = Nil ) do begin
		if LabelsMatch( LList^.info , Code ) then it := LList;
		LList := LList^.Next;
	end;

	FindSAtt := it;
end;

Function SAttValue(LList: SAttPtr; const Code: String): String;
	{Find a String Attribute which corresponds to Code, then}
	{return its embedded alligator string.}
var
	it: SAttPtr;
begin
	it := FindSAtt(LList,Code);

	if it = Nil then Exit('');

	SAttValue := RetrieveAString(it^.info);
end;

Function LoadStringList( const FName_In: String ): SAttPtr;
	{ Load a list of string attributes from the listed file, }
	{ if it can be found. }
var
	SList: SAttPtr;
	F: Text;
	S: String;
        FName: String;
begin
	SList := Nil;
	FName := FSearch( FName_In , '.' );
	if FName <> '' then begin
		Assign( F , FName );
		Reset( F );

		{ Get rid of the opening comment }
		ReadLn( F , S );

		while not EOF( F ) do begin
			ReadLn( F , S );
			if S <> '' then StoreSAtt( SList , S );
		end;

		Close( F );
	end;
	LoadStringList := SList;
end;


{$IFDEF PATCH_GH}
Procedure ExceptionErrorMessage_CanNotMakeDir( Obj: TObject; Addr: Pointer; FrameCount: LongInt; Frame: PPointer );
begin
	ErrorMessage('Can not make a directory.');
	halt(1);
end;
{$ENDIF PATCH_GH}

Procedure CheckDirectoryPresent;
	{ Make sure that the default save directory exists. If not, }
	{ create it. }
var
	S: String;
{$IFDEF PATCH_GH}
	OrgExceptProc: TExceptProc;
{$ENDIF PATCH_GH}
begin
{$IFDEF PATCH_GH}
	{ Check to make sure all the other directories can be found. }
	if not DirectoryExists( Design_DirName ) then begin
		ErrorMessage('Directory "'+Design_DirName+'" is not found.');
		Startup_OK := False;
	end;
	if not DirectoryExists( Series_DirName ) then begin
		ErrorMessage('Directory "'+Series_DirName+'" is not found.');
		Startup_OK := False;
	end;
	if not DirectoryExists( Data_DirName ) then begin
		ErrorMessage('Directory "'+Data_DirName+'" is not found.');
		Startup_OK := False;
	end;
  {$IFDEF SDLMODE}
	if not DirectoryExists( Graphics_DirName ) then begin
		ErrorMessage('Directory "'+Graphics_DirName+'" is not found.');
		Startup_OK := False;
	end;
  {$ENDIF}

	if not DirectoryExists( Save_Game_DirName ) then begin
		ErrorMessage('Directory "'+Save_Game_DirName+'" is not found.');
		ErrorMessage('Making a directory "'+Save_Game_DirName+'" ...');
		OrgExceptProc := ExceptProc;
		ExceptProc := @ExceptionErrorMessage_CanNotMakeDir;
		MkDir( Save_Game_DirName );
		ExceptProc := OrgExceptProc;
	end;

	if False = Startup_OK then begin
		halt(1);
	end;
{$ELSE PATCH_GH}
	if not DirectoryExists( Save_Game_DirName ) then begin
		MkDir( Save_Game_DirName );
	end;

	{ Check to make sure all the other directories can be found. }
	Startup_OK := Startup_OK and DirectoryExists( Design_DirName );
	Startup_OK := Startup_OK and DirectoryExists( Series_DirName );
	Startup_OK := Startup_OK and DirectoryExists( Data_DirName );
  {$IFDEF SDLMODE}
	Startup_OK := Startup_OK and DirectoryExists( Graphics_DirName );
  {$ENDIF}
{$ENDIF PATCH_GH}
end;



initialization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: gears_base.pp');
{$ENDIF DEBUG}
	{ Make sure we have the required data directories. }
{$IFNDEF go32v2}
	CheckDirectoryPresent;
{$ENDIF}
end;

finalization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: gears_base.pp(finalization)');
{$ENDIF DEBUG}
end;

end.
{$ENDIF PATCH_GH}
