unit gflooker;
	{ This is the map cursor browser tool thingie. }
{
	GearHead: Arena, a roguelike mecha CRPG
	Copyright (C) 2005 Joseph Hewitt

	This library is free software; you can redistribute it and/or modify it
	under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation; either version 2.1 of the License, or (at
	your option) any later version.

	The full text of the LGPL can be found in license.txt.

	This library is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
	General Public License for more details. 

	You should have received a copy of the GNU Lesser General Public License
	along with this library; if not, write to the Free Software Foundation,
	Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
}

	{ SDL rendering strategy: }
	{ - Call GFLRedraw first }
	{ - Place needed messages & menus on the screen }
	{ - Indicate the origin and target tiles last; this will also do a flip }

interface

uses
{$IFDEF PATCH_GH}
	gears_base,
{$ENDIF PATCH_GH}
	gears,locale;

const
	LOOKER_AutoSelect: Boolean = True;	{ Auto select new target if no current target. }

var
	LOOKER_X,LOOKER_Y: Integer;	{ Last X , Y position accessed. }
	LOOKER_Gear: GearPtr;		{ Last mecha accessed. }
{$IFDEF PATCH_GH}
{$ELSE PATCH_GH}
	LOOKER_LastGearSelected: GearPtr;	{ Last enemy selected with select next enemy key. }
{$ENDIF PATCH_GH}

Function WeaponBVSetting( Weapon: GearPtr ): Integer;

Function LookAround( GB: GameBoardPtr; Mek: GearPtr ): Boolean;
Function SelectTarget( GB: GameBoardPtr; Mek: GearPtr; var Wpn: GearPtr; var CallShot: boolean; var RapidFire: Integer ): Boolean;

implementation

uses
{$IFDEF DEBUG}
	errmsg,
{$ENDIF DEBUG}
{$IFDEF PATCH_GH}
	pseudosmartpointer,
{$ENDIF PATCH_GH}
{$IFDEF PATCH_I18N}
	i18nmsg,
{$ENDIF PATCH_I18N}
{$IFDEF PATCH_GH}
	ui4gh,
	ability,damage,gearutil,ghweapon,menugear,texutil,
{$ELSE PATCH_GH}
	ability,damage,gearutil,ghweapon,menugear,texutil,ui4gh,
{$ENDIF PATCH_GH}
{$IFDEF PATCH_CHEAT}
	backpack,
{$ENDIF PATCH_CHEAT}
{$IFDEF SDLMODE}
	sdlgfx,sdlinfo,sdlmap,sdlmenus
{$ELSE}
	congfx,coninfo,conmap,conmenus,context
{$ENDIF}
	;

var
{$IFDEF PATCH_GH}
	LOOKER_LastGearSelected: GearPtr;	{ Last enemy selected with select next enemy key. }
{$ELSE PATCH_GH}
{$ENDIF PATCH_GH}
	LOOKER_Origin,LOOKER_Weapon: GearPtr;
	LOOKER_CallShot: Boolean;
	LOOKER_RapidFire: Integer;
{$IFDEF SDLMODE}
	LOOKER_GB: GameBoardPtr;
	LOOKER_Desc: String;
{$ENDIF}

Function WeaponBVSetting( Weapon: GearPtr ): Integer;
	{ Return the BV Setting used by this weapon. It should be }
	{ one of either Off, 1/2, 1/4, or Max. }
var
	BV: Integer;
begin
{$IFDEF PATCH_GH}
	if (NIL = Weapon) or (Weapon^.G <= GG_DisposeGear) then Exit(BV_Off);
{$ELSE PATCH_GH}
	if Weapon = Nil then Exit( BV_Off );
{$ENDIF PATCH_GH}

	BV := NAttValue( Weapon^.NA , NAG_Prefrences , NAS_DefAtOp );
	if BV = 0 then begin
		if Weapon^.G <> GG_Weapon then begin
			BV := BV_Off;
		end else if ( Weapon^.S = GS_Ballistic ) then begin
			BV := DefBallisticBV;
		end else if Weapon^.S = GS_BeamGun then begin
			BV := DefBeamGunBV;
		end else if Weapon^.S = GS_Missile then begin
			BV := DefMissileBV;
		end else begin
			BV := BV_Off;
		end;
	end;

	WeaponBVSetting := BV;
end;

Procedure DoSwitchBV;
	{ Switch the burst value used for LOOKER_Weapon, then store the }
	{ new burst value as the weapon's default. }
var
	BV: Integer;
begin
{$IFDEF PATCH_GH}
	if (NIL = LOOKER_Weapon) or (LOOKER_Weapon^.G <= GG_DisposeGear) then Exit;
{$ELSE PATCH_GH}
	if LOOKER_Weapon = Nil then Exit;
{$ENDIF PATCH_GH}

	{ Determine the current BV; this will tell us what to do next. }
	BV := WeaponBVSetting( LOOKER_Weapon );
	if LOOKER_Weapon^.G = GG_Weapon then begin
		if LOOKER_Weapon^.S = GS_Missile then begin
			BV := BV + 1;
			if BV > 4 then BV := 1;
			SetNAtt( LOOKER_Weapon^.NA , NAG_Prefrences , NAS_DefAtOp , BV );
		end else if ( LOOKER_Weapon^.S = GS_Ballistic ) or ( LOOKER_Weapon^.S = GS_BeamGun ) then begin
			BV := 5 - BV;
			SetNAtt( LOOKER_Weapon^.NA , NAG_Prefrences , NAS_DefAtOp , BV );
		end;
	end;
end;

Procedure WeaponDisplay;
	{ Show the weapon display, and the instructions/options. }
var
	msg: String;
begin
	{ Generate instructions. }
{$IFDEF PATCH_I18N}
	msg := ReplaceHash( I18N_MsgString('WeaponDisplay_KeyMap','SwitchWeapon'), KeyMap[ KMC_SwitchWeapon ].KCode );
	msg := msg + #13 + ' ' + ReplaceHash( I18N_MsgString('WeaponDisplay_KeyMap','CalledShot'), KeyMap[ KMC_CalledShot ].KCode );
	if LOOKER_CallShot then msg := msg + I18N_MsgString('WeaponDisplay_KeyMap','CalledShot_On')
	else msg := msg + I18N_MsgString('WeaponDisplay_KeyMap','CalledShot_Off');
	msg := msg + #13 + ' ' + ReplaceHash( I18N_MsgString('WeaponDisplay_KeyMap','SwitchBV'), KeyMap[ KMC_SwitchBV ].KCode );
	msg := msg + BVTypeName[ WeaponBVSetting( LOOKER_Weapon ) ];
	msg := msg + #13 + ' ' + ReplaceHash( I18N_MsgString('WeaponDisplay_KeyMap','SwitchTarget'), KeyMap[ KMC_SwitchTarget ].KCode );
{$ELSE PATCH_I18N}
	msg := '[' + KeyMap[ KMC_SwitchWeapon ].KCode + '] Change Weapon' + #13;
	msg := msg + ' [' + KeyMap[ KMC_CalledShot ].KCode + '] Called Shot: ';
	if LOOKER_CallShot then msg := msg + 'On'
	else msg := msg + 'Off';
	msg := msg + #13 + ' [' + KeyMap[ KMC_SwitchBV ].KCode + '] Burst Value: ';
	msg := msg + BVTypeName[ WeaponBVSetting( LOOKER_Weapon ) ];
	msg := msg + #13 + ' [' + KeyMap[ KMC_SwitchTarget ].KCode + '] Switch Target';
{$ENDIF PATCH_I18N}

	{ Print instructions. }
{$IFDEF SDLMODE}
	NFGameMSG( msg , ZONE_Menu2 , NeutralGrey );
{$ELSE}
	GameMSG( msg , ZONE_Menu2 , NeutralGrey );
{$ENDIF}

	QuickWeaponInfo( LOOKER_Weapon );
end;

{$IFDEF SDLMODE}
Procedure GFLRedraw;
	{ menu redrawer for this unit. }
begin
	if LOOKER_GB <> Nil then BasicCombatDisplay( LOOKER_GB );
{$IFDEF PATCH_GH}
	if (NIL <> Looker_Weapon) and (GG_DisposeGear < Looker_Weapon^.G) then begin
		WeaponDisplay;
	end;
{$ELSE PATCH_GH}
	if LOOKER_Weapon <> Nil then WeaponDisplay;
{$ENDIF PATCH_GH}
	NFCMessage( LOOKER_Desc , ZONE_Clock , InfoHilight );
end;
{$ENDIF}


Function CreateTileMechaMenu( GB: GameBoardPtr; X,Y: Integer; ShowAll: Boolean ): RPGMenuPtr;
	{ Make a menu listing each of the mecha at spot X , Y. }
var
	TMM: RPGMenuPtr;
	N,T: Integer;
	Mek: GearPtr;
	msg,PName: String;
begin
	TMM := CreateRPGMenu( menuitem , menuselect , ZONE_Info );

	N := NumVisibleGears( GB , X , Y );

	for t := 1 to N do begin
		{ We need to list both the name of the mecha and the name of }
		{ the pilot. }
		Mek := FindVisibleGear( GB , X , Y , T );
		msg := GearName( Mek );
		PName := PilotName( Mek );
		if PName <> msg then msg := msg + ' - ' + PName;
		if not GearOperational( Mek ) then begin

{$IFDEF PATCH_I18N}
		    if NAttValue( Mek^.NA , NAG_EpisodeData , NAS_Gutted) = 1 then begin
			if NAttValue( Mek^.NA , NAG_EpisodeData , NAS_Flayed) = 1 then begin
			    msg := msg + I18N_MsgString('CreateTileMechaMenu', 'stripped');
			end else begin
			    msg := msg + I18N_MsgString('CreateTileMechaMenu', 'gutted');
			end;
		    end else begin
			if NAttValue( Mek^.NA , NAG_EpisodeData , NAS_Flayed) = 1 then begin
			    msg := msg + I18N_MsgString('CreateTileMechaMenu', 'flayed');
			end else begin
			    msg := msg + I18N_MsgString('CreateTileMechaMenu', 'X');
			end;
		    end;
		    if NAttValue( Mek^.NA , NAG_EpisodeData , NAS_Ransacked) = 1 then begin
			msg := msg + I18N_MsgString('CreateTileMechaMenu', 'looted');
		    end else begin
			msg := msg + I18N_MsgString('CreateTileMechaMenu', '');
		    end;
{$ELSE PATCH_I18N}
		    if NAttValue( Mek^.NA , NAG_EpisodeData , NAS_Gutted) = 1
		    then begin
			if NAttValue( Mek^.NA , NAG_EpisodeData , NAS_Flayed) = 1
			then
			    msg := msg + ' (stripped'
			else
			    msg := msg + ' (gutted';
			end
		    else begin
			if NAttValue( Mek^.NA , NAG_EpisodeData , NAS_Flayed) = 1
			then
			    msg := msg + ' (flayed'
			else
			    msg := msg + ' (X';
			end;
			
		    if NAttValue( Mek^.NA , NAG_EpisodeData , NAS_Ransacked) = 1
		    then
			msg := msg + ', looted)'
		    else
			msg := msg + ')';
{$ENDIF PATCH_I18N}
		end;
		if ShowAll or GearOperational( Mek ) then begin
			AddRPGMenuItem( TMM , msg , T );
		end;
	end;

	CreateTileMechaMenu := TMM;
end;

Procedure DisplayTileInfo( GB: GameBoardPtr; X,Y: Integer);
	{ Display info on the contents of location X,Y. }
	{ If the tile is empty, give a description of the terrain. }
	{ Otherwise provide a sumamry for whatever gears are there. }
var
	N: Integer;	{ The number of gears present in the tile. }
	Mek: GearPtr;
	TMM: RPGMenuPtr;
	msg: String;
begin
	{ Display info for target square. }
	N := NumVisibleGears( GB , X , Y );
	if not OnTheMap( X , Y ) then begin
{$IFDEF PATCH_I18N}
		GameMSG( I18N_MsgString('DisplayTileInfo','Off The Map') , ZONE_Info , StdWhite );
{$ELSE PATCH_I18N}
		GameMSG( 'Off The Map' , ZONE_Info , StdWhite );
{$ENDIF PATCH_I18N}
		LOOKER_Gear := Nil;

	end else if N = 0 then begin
		if GB^.Map[X,Y].Visible then begin
			msg := '';
{$IFDEF PATCH_GH}
			if (NIL <> GB^.Scene) and (GG_DisposeGear < GB^.Scene^.G) then begin
				msg := SAttValue( GB^.Scene^.SA , 'LOOKER' + BStr( X ) + '%' + BStr( Y ) );
			end;
{$ELSE PATCH_GH}
			if GB^.Scene <> Nil then msg := SAttValue( GB^.Scene^.SA , 'LOOKER' + BStr( X ) + '%' + BStr( Y ) );
{$ENDIF PATCH_GH}
{$IFDEF PATCH_I18N}
			if msg = '' then msg := I18N_Name('TerrMan',TerrMan[GB^.map[X,Y].Terr].Name);
{$ELSE PATCH_I18N}
			if msg = '' then msg := TerrMan[GB^.map[X,Y].Terr].Name;
{$ENDIF PATCH_I18N}
{$IFDEF SDLMODE}
			NFCMessage( msg , ZONE_Info , TerrainGreen );
{$ELSE}
			CMessage( msg , ZONE_Info , TerrainGreen );
{$ENDIF}
		end else begin
{$IFDEF SDLMODE}
{$IFDEF PATCH_I18N}
			NFCMessage( I18N_MsgString('DisplayTileInfo','UNKNOWN') , ZONE_Info , TerrainGreen );
{$ELSE PATCH_I18N}
			NFCMessage( 'UNKNOWN' , ZONE_Info , TerrainGreen );
{$ENDIF PATCH_I18N}
{$ELSE}
{$IFDEF PATCH_I18N}
			CMessage( I18N_MsgString('DisplayTileInfo','UNKNOWN') , ZONE_Info , TerrainGreen );
{$ELSE PATCH_I18N}
			CMessage( 'UNKNOWN' , ZONE_Info , TerrainGreen );
{$ENDIF PATCH_I18N}
{$ENDIF}
		end;

		LOOKER_Gear := Nil;

	end else if N = 1 then begin
		Mek := FindVisibleGear( GB , X , Y , 1 );
		DisplayGearInfo( Mek , gb );
		LOOKER_Gear := Mek;

	end else if N > 1 then begin
		TMM := CreateTileMechaMenu( GB , X , Y , True );
{$IFDEF SDLMODE}
		DisplayMenu( TMM , @GFLRedraw );
{$ELSE}
		DisplayMenu( TMM );
{$ENDIF}
		DisposeRPGMenu( TMM );
		LOOKER_Gear := Nil;

	end;

end;

Function CoverDesc( C: Integer ): String;
	{ Return a string telling how much cover the target has. }
begin
	if C < 0 then begin
		CoverDesc := 'X';
	end else begin
		CoverDesc := BStr( C );
	end;
end;

Function FindNextTarget( GB: GameBoardPtr; Origin: GearPtr ): GearPtr;
	{ ORIGIN is looking for a new target. Return the next visible enemy found. }
var
	M,NextTarget,FirstTarget: GearPtr;
	PickNext: Boolean;
begin
	{ If we've already selected an enemy, find the next one from that point. }
{$IFDEF PATCH_GH}
	if (NIL = LOOKER_LastGearSelected) or (LOOKER_LastGearSelected^.G <= GG_DisposeGear) then begin
		if (NIL <> LOOKER_Gear) and (GG_DisposeGear < LOOKER_Gear^.G) then begin
			LOOKER_LastGearSelected := LOOKER_Gear;
		end else begin
			LOOKER_LastGearSelected := NIL;
		end;
	end;
	if (NIL = Origin) or (Origin^.G <= GG_DisposeGear) then Exit(NIL);
{$ELSE PATCH_GH}
	if ( LOOKER_LastGearSelected = Nil ) and ( LOOKER_Gear <> Nil ) then LOOKER_LastGearSelected := LOOKER_Gear;
{$ENDIF PATCH_GH}

	{ Cycle through all the models on the map looking for a visible, operational enemy. }
	M := GB^.Meks;
	NextTarget := Nil;
	PickNext := False;
	FirstTarget := Nil;
	while M <> Nil do begin
{$IFDEF PATCH_GH}
		if (GG_DisposeGear < M^.G) then begin
{$ENDIF PATCH_GH}
		{ If M fits our target criteria, check it to see what's going on. }
		if OnTheMap( M ) and AreEnemies( GB , Origin , M ) and GearOperational( M ) and MekCanSeeTarget( GB , Origin , M ) then begin
			{ If M is the target we started with, set the flag to pick the next }
			{ target encountered. }
			if M = LOOKER_LastGearSelected then begin
				PickNext := True;
			end else if PickNext then begin
				NextTarget := M;
				PickNext := False;
			end;
			if FirstTarget = Nil then FirstTarget := M;
		end;
{$IFDEF PATCH_GH}
		end;
{$ENDIF PATCH_GH}

		M := M^.Next;
	end;
	{ If NextTarget = Nil, either we started with no target or the target we had }
	{ was the last target in the list. So, go with the first target found. }
	if NextTarget = Nil then NextTarget := FirstTarget;
	LOOKER_LastGearSelected := NextTarget;
	FindNextTarget := NextTarget;
end;

Function TrueLooker( GB: GameBoardPtr; X , Y: Integer ): Boolean;
	{ Scan the map, starting at location X,Y. }
	{ Return TRUE if this procedure is exited with the space bar, }
	{ FALSE if it is exited with the ESC key. }
	{ If Mek <> Nil, do range calculations from that spot. }
	{ If WPN <> Nil, allow weapon selection. }
var
{$IFDEF PATCH_GH}
	N: Integer;
	MekNum: LongInt;
{$ELSE PATCH_GH}
	N,MekNum: Integer;
{$ENDIF PATCH_GH}
	TMM: RPGMenuPtr;
	A: Char;
	P: Point;
{$IFDEF PATCH_GH}
  {$IFDEF SDLMODE}
	Target_X,Target_Y: Integer;
	flag_mouse: Boolean;
  {$ENDIF SDLMODE}
{$ENDIF PATCH_GH}
	Procedure RepositionCursor( D: Integer );
	begin
		RedrawTile( gb, X , Y );
		if OnTheMap( X + AngDir[ D , 1 ] , Y + AngDir[ D , 2 ] ) then begin
			X := X + AngDir[ D , 1 ];
			Y := Y + AngDir[ D , 2 ];
{$IFDEF PATCH_GH}
  {$IFDEF SDLMODE}
			RedrawTile( GB , Target_X , Target_Y );
			Target_X := X;
			Target_Y := Y;
			flag_mouse := False;
  {$ENDIF SDLMODE}
{$ENDIF PATCH_GH}
		end;
	end;
{$IFDEF PATCH_GH}
  {$IFDEF SDLMODE}
var
	M: Point;
  {$ENDIF SDLMODE}
{$ENDIF PATCH_GH}
begin
	{ Error check- make sure the start point is on the screen. }
	if not OnTheMap(X,Y) then begin
{$IFDEF PATCH_GH}
		LOOKER_Gear := FindNextTarget( GB , LOOKER_Origin );
		if ( NIL <> LOOKER_Gear ) then begin
			X := NAttValue( LOOKER_Gear^.NA , NAG_Location , NAS_X );
			Y := NAttValue( LOOKER_Gear^.NA , NAG_Location , NAS_Y );
		end;
		if ( not OnTheMap(X,Y) ) and ( NIL <> LOOKER_Origin ) then begin
			X := NAttValue( LOOKER_Origin^.NA , NAG_Location , NAS_X );
			Y := NAttValue( LOOKER_Origin^.NA , NAG_Location , NAS_Y );
		end;
		if not OnTheMap(X,Y) then begin
			X := 1;
			Y := 1;
		end;
{$ELSE PATCH_GH}
		X := 1;
		Y := 1;
{$ENDIF PATCH_GH}
	end;

{$IFDEF PATCH_GH}
  {$IFDEF SDLMODE}
	Target_X := X;
	Target_Y := Y;
	flag_mouse := False;
	MouseAtTile( GB , Target_X , Target_Y );
	RedrawTile( GB , Target_X , Target_Y );
  {$ENDIF SDLMODE}
{$ENDIF PATCH_GH}

	LOOKER_LastGearSelected := Nil;

{$IFDEF PATCH_GH}
	if (NIL <> LOOKER_Origin) and (GG_DisposeGear < LOOKER_Origin^.G) then begin
		P := GearCurrentLocation( LOOKER_Origin );
	end else begin
		LOOKER_Origin := NIL;
	end;
	if (NIL <> LOOKER_Gear) and (GG_DisposeGear < LOOKER_Gear^.G) then begin
	end else begin
		LOOKER_Gear := NIL;
	end;
	if (NIL <> LOOKER_Weapon) and (GG_DisposeGear < LOOKER_Weapon^.G) then begin
	end else begin
		LOOKER_Weapon := NIL;
	end;
{$ELSE PATCH_GH}
	if LOOKER_Origin <> Nil then P := GearCurrentLocation( LOOKER_Origin );
{$ENDIF PATCH_GH}

	{ Start going here. }
	repeat
{$IFDEF SDLMODE}
		LOOKER_GB := GB;
  {$IFDEF PATCH_CHEAT}
		if Cheat_Display_SW then begin
		end else begin
			GFLRedraw;
		end;
  {$ELSE PATCH_CHEAT}
		GFLRedraw;
  {$ENDIF PATCH_CHEAT}
{$ENDIF}
		{ Display info on the selected tile. }
{$IFDEF PATCH_GH}
  {$IFDEF SDLMODE}
		DisplayTileInfo( GB , Target_X , Target_Y );
		if flag_mouse then begin
			if ( Target_X <> X ) or ( Target_Y <> Y ) then begin
				MouseAtTile( GB , Target_X , Target_Y );
			end;
		end else begin
			MouseAtTile( GB , -1 , -1 );
		end;
  {$ELSE SDLMODE}
		DisplayTileInfo( GB , X , Y );
  {$ENDIF SDLMODE}
{$ELSE PATCH_GH}
		DisplayTileInfo( GB , X , Y );
{$ENDIF PATCH_GH}

		if ( LOOKER_Origin <> Nil ) and OnTheMap( LOOKER_Origin ) then begin
			if LOOKER_Gear = Nil then begin
{$IFDEF SDLMODE}
				NFCMessage( 'Range: ' + BStr( ScaleRange( Range(LOOKER_Origin,X,Y) , GB^.Scale ) ) + '   Cover: '+CoverDesc( CalcObscurement( LOOKER_Origin , X , Y , gb )) , ZONE_Clock , InfoGreen );
{$ELSE}
				CMessage( 'Range: ' + BStr( ScaleRange( Range(LOOKER_Origin,X,Y) , GB^.Scale ) ) + '   Cover: '+CoverDesc( CalcObscurement( LOOKER_Origin , X , Y , gb )) , ZONE_Clock , InfoGreen );
{$ENDIF}
			end else begin
{$IFDEF SDLMODE}
  {$IFDEF PATCH_CHEAT}
				if Cheat_Range_Colored and not MekCanSeeTarget( GB , FindRoot( LOOKER_Gear ) , LOOKER_Origin ) then begin
					NFCMessage( 'Range* ' + BStr( ScaleRange( Range(gb,LOOKER_Origin,LOOKER_Gear) , GB^.Scale )) + '   Cover* '+CoverDesc( CalcObscurement( LOOKER_Origin , LOOKER_Gear , gb )) , ZONE_Clock , InfoHiLight );
				end else begin
					NFCMessage( 'Range: ' + BStr( ScaleRange( Range(gb,LOOKER_Origin,LOOKER_Gear) , GB^.Scale )) + '   Cover: '+CoverDesc( CalcObscurement( LOOKER_Origin , LOOKER_Gear , gb )) , ZONE_Clock , InfoGreen );
				end;
  {$ELSE PATCH_CHEAT}
				NFCMessage( 'Range: ' + BStr( ScaleRange( Range(gb,LOOKER_Origin,LOOKER_Gear) , GB^.Scale )) + '   Cover: '+CoverDesc( CalcObscurement( LOOKER_Origin , LOOKER_Gear , gb )) , ZONE_Clock , InfoGreen );
  {$ENDIF PATCH_CHEAT}
{$ELSE}
  {$IFDEF PATCH_CHEAT}
				if Cheat_Range_Colored and not MekCanSeeTarget( GB , FindRoot( LOOKER_Gear ) , LOOKER_Origin ) then begin
					CMessage( 'Range* ' + BStr( ScaleRange( Range(gb,LOOKER_Origin,LOOKER_Gear) , GB^.Scale )) + '   Cover* '+CoverDesc( CalcObscurement( LOOKER_Origin , LOOKER_Gear , gb )) , ZONE_Clock , InfoHiLight );
				end else begin
					CMessage( 'Range: ' + BStr( ScaleRange( Range(gb,LOOKER_Origin,LOOKER_Gear) , GB^.Scale )) + '   Cover: '+CoverDesc( CalcObscurement( LOOKER_Origin , LOOKER_Gear , gb )) , ZONE_Clock , InfoGreen );
				end;
  {$ELSE PATCH_CHEAT}
				CMessage( 'Range: ' + BStr( ScaleRange( Range(gb,LOOKER_Origin,LOOKER_Gear) , GB^.Scale )) + '   Cover: '+CoverDesc( CalcObscurement( LOOKER_Origin , LOOKER_Gear , gb )) , ZONE_Clock , InfoGreen );
  {$ENDIF PATCH_CHEAT}
{$ENDIF}
			end;
		end;

		{ Display info on the selected weapon. }
		if LOOKER_Weapon <> Nil then WeaponDisplay;

		{ Indicate origin and target squares. }
{$IFDEF SDLMODE}
		if ( LOOKER_Origin <> Nil ) then IndicateTile( GB , LOOKER_Origin , False );
		IndicateTile( GB , X , Y , TerrMan[ GB^.Map[ X , Y ].terr ].Altitude , True );
{$ELSE}
		if ( LOOKER_Origin <> Nil ) and ( not NeedsRecentering( P.X , P.Y ) ) then IndicateTile( GB , LOOKER_Origin );
		IndicateTile( GB , X , Y );
{$ENDIF}

		A := RPGKey;

		if A = KeyMap[ KMC_North ].KCode then begin
			RepositionCursor( 6 );

		end else if A = KeyMap[ KMC_South ].KCode then begin
			RepositionCursor( 2 );

		end else if A = KeyMap[ KMC_West ].KCode then begin
			RepositionCursor( 4 );

		end else if A = KeyMap[ KMC_East ].KCode then begin
			RepositionCursor( 0 );

		end else if A = KeyMap[ KMC_NorthEast ].KCode then begin
			RepositionCursor( 7 );

		end else if A = KeyMap[ KMC_SouthWest ].KCode then begin
			RepositionCursor( 3 );

		end else if A = KeyMap[ KMC_NorthWest ].KCode then begin
			RepositionCursor( 5 );

		end else if A = KeyMap[ KMC_SouthEast ].KCode then begin
			RepositionCursor( 1 );

		end else if ( A = KeyMap[ KMC_SwitchWeapon ].KCode ) and ( LOOKER_Weapon <> Nil ) and ( LOOKER_Origin <> Nil ) then begin
			LOOKER_Weapon := FindNextWeapon( GB , LOOKER_Origin , LOOKER_Weapon , Range( LOOKER_Origin , X , Y ) );

		end else if ( A = KeyMap[ KMC_SwitchTarget ].KCode ) and ( LOOKER_Weapon <> Nil ) and ( LOOKER_Origin <> Nil ) then begin
			RedrawTile( gb, X , Y );
			LOOKER_Gear := FindNextTarget( GB , LOOKER_Origin );
			if LOOKER_Gear <> Nil then begin
				X := NATtValue( LOOKER_Gear^.NA , NAG_Location , NAS_X );
				Y := NATtValue( LOOKER_Gear^.NA , NAG_Location , NAS_Y );
			end;
{$IFDEF PATCH_GH}
  {$IFDEF SDLMODE}
			if OnTheMap( X , Y ) then begin
				RedrawTile( GB , Target_X , Target_Y );
				Target_X := X;
				Target_Y := Y;
			end;
			flag_mouse := False;
  {$ENDIF SDLMODE}
{$ENDIF PATCH_GH}

		end else if ( A = KeyMap[ KMC_SwitchBV ].KCode ) and ( LOOKER_Weapon <> Nil ) and ( LOOKER_Origin <> Nil ) then begin
			DoSwitchBV;

		end else if ( A = KeyMap[ KMC_CalledShot ].KCode ) and ( LOOKER_Weapon <> Nil ) and ( LOOKER_Origin <> Nil ) then begin
			LOOKER_CallShot := not LOOKER_CallShot;

		end else if A = KeyMap[ KMC_ExamineMap ].KCode then begin
			A := #27;

		end else if A = KeyMap[ KMC_Attack ].KCode then begin
			A := ' ';

{$IFDEF SDLMODE}
		end else if A = #8 then begin
			A := #27;
{$IFDEF PATCH_GH}
		end else if A = #13 then begin
			A := ' ';
		end else if A = #10 then begin
			A := ' ';
{$ENDIF PATCH_GH}
{$ENDIF}
{$IFDEF PATCH_CHEAT}
		end else if Cheat_NPC_Edit and (A = KeyMap[ KMC_SelectPortrait ].KCode) then begin
			if (LOOKER_Gear <> Nil) and (LOOKER_Gear^.G = GG_Character) then begin
				SelectPortrait( LOOKER_Gear );
				ClrZone(ZONE_Menu);
			end;
		end else if Cheat_NPC_Edit and (A = KeyMap[ KMC_RenameMecha ].KCode) then begin
			if (LOOKER_Gear <> Nil) then Rename_Mecha( GB , LOOKER_Gear );
		end else if Cheat_NPC_Edit and Cheat_MenuOrder_Edit and (A = KeyMap[ KMC_EditMenuOrder ].KCode) then begin
			if (LOOKER_Gear <> Nil) then begin
  {$IFDEF SDLMODE}
				MechaPartBrowser( LOOKER_Gear , @GFLRedraw )
  {$ELSE SDLMODE}
				MechaPartBrowser( LOOKER_Gear )
  {$ENDIF SDLMODE}
			end else begin
				LOOKER_Gear := NewGear(Nil);
				LOOKER_Gear^.G := GG_Scene;
				LOOKER_Gear^.InvCom := GB^.meks;
  {$IFDEF SDLMODE}
				MechaPartBrowser( LOOKER_Gear , @GFLRedraw );
  {$ELSE SDLMODE}
				MechaPartBrowser( LOOKER_Gear );
  {$ENDIF SDLMODE}
				GB^.meks := LOOKER_Gear^.InvCom;
				LOOKER_Gear^.InvCom := Nil;
				DisposeGear(LOOKER_Gear);
			end;
			ClrZone(ZONE_Menu);
{$ENDIF PATCH_CHEAT}
{$IFDEF PATCH_GH}
  {$IFDEF SDLMODE}
		end else if ( RPK_MouseButton = A ) then begin
			if IsMouseOnMap and ( not IsMenuActive ) then begin
				flag_mouse := True;
				RedrawTile( GB , X , Y );
				M := MouseMapPos;
				if OnTheMap( M.X , M.Y ) then begin
					X := M.X;
					Y := M.Y;
					Target_X := M.X;
					Target_Y := M.Y;
				end;
			end;

		end else if ( RPK_RightButton = A ) then begin
			A := #27;

		end else if ( RPK_MouseMotion = A ) then begin
			if IsMouseOnMap and ( not IsMenuActive ) then begin
				flag_mouse := True;
				RedrawTile( GB , Target_X , Target_Y );
				M := MouseMapPos;
				if OnTheMap( M.X , M.Y ) then begin
					Target_X := M.X;
					Target_Y := M.Y;
				end;
			end;
  {$ENDIF SDLMODE}
{$ENDIF PATCH_GH}

		end;

	until (A = ' ') or (A = #27) or (A = #10);

	{ Restore the display. }
	RedrawTile( gb, X , Y );
{$IFDEF PATCH_GH}
  {$IFDEF SDLMODE}
	RedrawTile( GB, Target_X , Target_Y );
  {$ENDIF SDLMODE}
{$ENDIF PATCH_GH}
	if LOOKER_Origin <> Nil then RedrawTile( gb, LOOKER_Origin );
	UpdateCombatDisplay( GB );

	{ Store the values in the global variables. }
	LOOKER_X := X;
	LOOKER_Y := Y;

	N := NumVisibleGears( GB , X , Y );
	if N = 1 then begin
		LOOKER_Gear := FindVisibleGear( GB , X , Y , 1 );

{$IFDEF PATCH}
	end else if (N > 1) and (A = ' ') then begin
{$ELSE}
	end else if N > 1 then begin
{$ENDIF}
		TMM := CreateTileMechaMenu( GB , X , Y , Looker_Weapon = Nil );
		if TMM^.NumItem > 1 then begin
{$IFDEF PATCH_CHEAT}
			if Cheat_LookInfo and not(LOOKER_CallShot and Cheat_CallShot and Cheat_CallShot_OmitLookInfo) then begin
				repeat
  {$IFDEF SDLMODE}
					MekNum := SelectMenu( TMM , @GFLRedraw );
  {$ELSE SDLMODE}
					MekNum := SelectMenu( TMM );
  {$ENDIF SDLMODE}
					if MekNum <> -1 then begin
						DisplayGearInfo( FindVisibleGear( GB , X , Y , MekNum ) , GB , ZONE_Info );
  {$IFDEF SDLMODE}
						GHFlip;
    {$IFDEF PATCH_GH}
						repeat
							A := RPGKey;
						until ( ( RPK_TimeEvent <> A ) and ( RPK_MouseMotion <> A ) );

						if A = #13 then begin
							A := ' ';
						end else if A = #10 then begin
							A := ' ';
						end;
    {$ELSE PATCH_GH}
						repeat
							A := RPGKey;
						until A <> RPK_TimeEvent;
    {$ENDIF PATCH_GH}
  {$ELSE SDLMODE}
						A := RPGKey;
  {$ENDIF SDLMODE}
						if (A = KeyMap[ KMC_ExamineMap ].KCode) or (A = #8) then A := #27
						else if A = KeyMap[ KMC_Attack ].KCode then A := ' ';

						if (A = #27) then A := 'A';
					end;
				until (MekNum = -1) or (A = ' ') or (A = #27) or (A = #10);
				if MekNum = -1 then A := #27;
			end else begin
  {$IFDEF SDLMODE}
				MekNum := SelectMenu( TMM , @GFLRedraw );
  {$ELSE SDLMODE}
				MekNum := SelectMenu( TMM );
  {$ENDIF SDLMODE}
  {$IFDEF PATCH_GH}
				if MekNum = -1 then A := #27;
  {$ENDIF PATCH_GH}
			end;
{$ELSE PATCH_CHEAT}
  {$IFDEF SDLMODE}
			MekNum := SelectMenu( TMM , @GFLRedraw );
  {$ELSE SDLMODE}
			MekNum := SelectMenu( TMM );
  {$ENDIF SDLMODE}
  {$IFDEF PATCH_GH}
			if MekNum = -1 then A := #27;
  {$ENDIF PATCH_GH}
{$ENDIF PATCH_CHEAT}
		end else if TMM^.NumItem > 0 then begin
			MekNum := TMM^.FirstItem^.Value;
		end else begin
			MekNum := -1;
		end;
		DisposeRPGMenu( TMM );

		if MekNum <> -1 then LOOKER_Gear := FindVisibleGear( GB , X , Y , MekNum )
		else LOOKER_Gear := Nil;

	end else begin
		LOOKER_Gear := Nil;
	end;

	{ Return TRUE if a space was pressed, FALSE otherwise. }
	TrueLooker := ( A = ' ' ) or ( A = #10 );
end;

Function LookAround( GB: GameBoardPtr; Mek: GearPtr ): Boolean;
	{ This function just calls the above one with the location of }
	{ the specified mek. }
var
	X,Y: Integer;
begin
{$IFDEF PATCH_GH}
	if (NIL = Mek) or (Mek^.G <= GG_DisposeGear) then begin
		Mek := NIL;
	end;
{$ENDIF PATCH_GH}

	LOOKER_Origin := Mek;
	LOOKER_Weapon := Nil;

	if Mek <> Nil then begin
		X := NAttValue( Mek^.NA , NAG_Location, NAS_X );
		Y := NAttValue( Mek^.NA , NAG_Location, NAS_Y );
	end else begin
		X := 1;
		Y := 1;
	end;

	LookAround := TrueLooker( GB , X , Y );
end;

Function SelectTarget( GB: GameBoardPtr; Mek: GearPtr; var Wpn: GearPtr; var CallShot: boolean; var RapidFire: Integer ): Boolean;
	{ This function just calls LookAround with the location of }
	{ the specified mek and its current target. }
	{ Record the target selected as this mecha's target. }
var
	T: GearPtr;		{ The Target }
	X,Y: Integer;
	FunResult: Boolean;	{ Function Result }
begin
{$IFDEF PATCH_GH}
	if (NIL = Mek) or (Mek^.G <= GG_DisposeGear) then Exit(False);
	if (NIL = Wpn) or (Wpn^.G <= GG_DisposeGear) then Exit(False);
{$ENDIF PATCH_GH}

	LOOKER_Origin := Mek;
	LOOKER_Weapon := Wpn;
	LOOKER_CallShot := CallShot;
	LOOKER_RapidFire := RapidFire;

	{ Get the default values from this mek. }
	T := LocateMekByUID( GB , NAttValue( Mek^.NA , NAG_EpisodeData , NAS_Target ) );

	{ If this mek has a target, start out the targeting cursor in the }
	{ target's square. If it has no target, start the targeting cursor }
	{ in the mek's own square. }
	if ( T <> Nil ) and MekCanSeeTarget( gb , Mek , T ) and GearOperational( T ) then begin
		X := NAttValue( T^.NA , NAG_Location, NAS_X );
		Y := NAttValue( T^.NA , NAG_Location, NAS_Y );
	end else if LOOKER_AutoSelect then begin
		T := SeekTarget( GB , Mek );
		if T <> Nil then begin
			X := NAttValue( T^.NA , NAG_Location, NAS_X );
			Y := NAttValue( T^.NA , NAG_Location, NAS_Y );
		end else begin
			X := NAttValue( Mek^.NA , NAG_Location , NAS_X );
			Y := NAttValue( Mek^.NA , NAG_Location , NAS_Y );
		end;
	end else begin
		X := NAttValue( Mek^.NA , NAG_Location , NAS_X );
		Y := NAttValue( Mek^.NA , NAG_Location , NAS_Y );
	end;

	{ Call the look around procedure. }
	FunResult := TrueLooker( GB , X , Y );

	{ If the targeting wasn't cancelled, record the target. }
	if FunResult and ( LOOKER_Gear <> Nil ) and ( FindRoot( LOOKER_Gear ) <> Mek ) then begin
		SetNAtt( Mek^.NA , NAG_EpisodeData , NAS_Target , NAttValue( LOOKER_Gear^.NA , NAG_EpisodeData , NAS_UID ) );
	end;

	{ Set the values of the VAR parameters. }
	Wpn := LOOKER_Weapon;
	CallShot := LOOKER_CallShot;
	RapidFire := LOOKER_RapidFire;

	{ Return the value. }
	SelectTarget := FunResult;
end;



initialization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: gflooker.pp');
{$ENDIF DEBUG}
{$IFDEF PATCH_GH}
	LOOKER_Gear := NIL;
	LOOKER_LastGearSelected := NIL;
	LOOKER_Origin := NIL;
	LOOKER_Weapon := NIL;
	Attach_SmartPointer( 'LOOKER_Gear: GearPtr', @LOOKER_Gear );
	Attach_SmartPointer( 'LOOKER_LastGearSelected: GearPtr', @LOOKER_LastGearSelected );
	Attach_SmartPointer( 'LOOKER_Origin: GearPtr', @LOOKER_Origin );
	Attach_SmartPointer( 'LOOKER_Weapon: GearPtr', @LOOKER_Weapon );
  {$IFDEF SDLMODE}
	LOOKER_GB := NIL;
	Attach_SmartPointer( 'LOOKER_GB: GameBoardPtr', @LOOKER_GB );
  {$ENDIF SDLMODE}
{$ENDIF PATCH_GH}
end;

finalization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: gflooker.pp(finalization)');
{$ENDIF DEBUG}
end;

end.
