unit libiconv;
{*******************************}
{	iconv wrapper		}
{	Wed,27 Feb,2008		}
{*******************************}
{example:
uses unixtype,libiconv;
Function NewConvUni( const pmsg: PChar ): PWord;
const
	WCLen = 512;
var
	src_len, dst_len: size_t;
	pdst: PChar;
	psrc_tmp, pdst_tmp: PChar;
	iconv_enc2utf16: iconv_t;
	iconv_result: size_t;
begin
	pdst := StrAlloc( WCLen );
	src_len := Length(pmsg);
	dst_len := WCLen - 2;
	psrc_tmp := pmsg;
	pdst_tmp := pdst;
	iconv_enc2tenc := libiconv.iconv_open( "EUCJP", "UTF-8" );
	iconv_result := libiconv.iconv( iconv_enc2utf16,
				@psrc_tmp, @src_len, @pdst_tmp, @dst_len );
	iconv_result := libiconv.iconv( iconv_enc2utf16,
				NIL, NIL, @pdst_tmp, @dst_len );
	pdst_tmp[0] := #0; pdst_tmp[1] := #0;
	NewConvUni := PWord(pdst);
	libiconv.iconv_close( iconv_enc2utf16 );
end;
}
{*******************************}

{$MODE FPC}

interface

{$IFDEF Windows}
uses windows, JwaWinType;
{$ENDIF Windows}
{$IFDEF UNIX}
uses pthreads, baseunix, unix, unixtype;
{$ENDIF UNIX}


type
{$IFDEF ICONV}
{{$IFDEF WIN32}}
{	Psize_t = ^size_t;}
{	size_t = LongWord;}
{{$ENDIF WIN32}}
{{$IFDEF WIN64}}
{	Psize_t = ^size_t;}
{	size_t = QWord;}
{{$ENDIF WIN64}}
	Piconv_t = ^iconv_t;
	iconv_t = pointer;
{$ENDIF ICONV}


const
{$IFDEF ICONV}
  {$IFDEF UNIX}
    {$IFDEF LIBC_ICONV}
	libiconvname='c';
	{$DEFINE _LIBICONVNAME_}
    {$ELSE LIBC_ICONV}
	libiconvname='iconv';
	{$DEFINE _LIBICONVNAME_}
    {$ENDIF LIBC_ICONV}
  {$ENDIF UNIX}
  {$IFDEF Windows}
	libiconvname='iconv.dll';
	{$DEFINE _LIBICONVNAME_}
  {$ENDIF Windows}
  {$IFNDEF _LIBICONVNAME_}
	libiconvname='iconv';
  {$ENDIF _LIBICONVNAME_}
  {$IFDEF LIBICONV_PLUG}
	libiconv_functionname_iconv_open	= 'iconv_open';
	libiconv_functionname_iconv		= 'iconv';
	libiconv_functionname_iconv_close	= 'iconv_close';
  {$ELSE LIBICONV_PLUG}
	libiconv_functionname_iconv_open	= 'libiconv_open';
	libiconv_functionname_iconv		= 'libiconv';
	libiconv_functionname_iconv_close	= 'libiconv_close';
  {$ENDIF LIBICONV_PLUG}
{$ENDIF ICONV}



{$IFDEF ICONV}
function iconv_open( __tocode: Pchar; __fromcode: Pchar ): iconv_t;
cdecl; external libiconvname name libiconv_functionname_iconv_open;

function iconv( __cd: iconv_t; __inbuf: PPchar; __inbytesleft: Psize_t; __outbuf: PPchar; __outbytesleft: Psize_t ): size_t;
cdecl; external libiconvname name libiconv_functionname_iconv;

function iconv_close( __cd: iconv_t ): longint;
cdecl; external libiconvname name libiconv_functionname_iconv_close;
{$ENDIF ICONV}



implementation

end.
