unit menugear;
	{ This is the RPGMenus / Gear Tree utilities unit. }
{
	GearHead: Arena, a roguelike mecha CRPG
	Copyright (C) 2005 Joseph Hewitt

	This library is free software; you can redistribute it and/or modify it
	under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation; either version 2.1 of the License, or (at
	your option) any later version.

	The full text of the LGPL can be found in license.txt.

	This library is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
	General Public License for more details. 

	You should have received a copy of the GNU Lesser General Public License
	along with this library; if not, write to the Free Software Foundation,
	Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
}

interface

uses
{$IFDEF PATCH_GH}
	gears_base,
{$ENDIF PATCH_GH}
	gears,locale,
{$IFDEF SDLMODE}
	sdlmenus
{$ELSE}
	conmenus
{$ENDIF}
	;

Procedure BuildGearMenu( RPM: RPGMenuPtr; Master: GearPtr; G: Integer );
{$IFDEF PATCH_GH}
  {$IFDEF DEBUG}
Function BuildGearMenu( RPM: RPGMenuPtr; Master: GearPtr; DebugMode: Boolean ): LongInt;
  {$ELSE DEBUG}
Procedure BuildGearMenu( RPM: RPGMenuPtr; Master: GearPtr; DebugMode: Boolean );
  {$ENDIF DEBUG}
{$ENDIF PATCH_GH}
{$IFDEF DEBUG}
Function BuildGearMenu( RPM: RPGMenuPtr; Master: GearPtr ): LongInt;
{$ELSE DEBUG}
Procedure BuildGearMenu( RPM: RPGMenuPtr; Master: GearPtr );
{$ENDIF DEBUG}

{$IFDEF DEBUG}
Function BuildEquipmentMenu( RPM: RPGMenuPtr; Master: GearPtr ): LongInt;
{$ELSE DEBUG}
Procedure BuildEquipmentMenu( RPM: RPGMenuPtr; Master: GearPtr );
{$ENDIF DEBUG}
{$IFDEF PATCH_CHEAT}
  {$IFDEF DEBUG}
Function BuildInventoryMenu( RPM: RPGMenuPtr; Master: GearPtr; const ShowSub: Boolean ): LongInt;
  {$ELSE DEBUG}
Procedure BuildInventoryMenu( RPM: RPGMenuPtr; Master: GearPtr; const ShowSub: Boolean );
  {$ENDIF DEBUG}
{$ENDIF PATCH_CHEAT}
{$IFDEF DEBUG}
Function BuildInventoryMenu( RPM: RPGMenuPtr; Master: GearPtr ): LongInt;
{$ELSE DEBUG}
Procedure BuildInventoryMenu( RPM: RPGMenuPtr; Master: GearPtr );
{$ENDIF DEBUG}
{$IFDEF DEBUG}
Function BuildSlotMenu( RPM: RPGMenuPtr; Master,Item: GearPtr ): LongInt;
{$ELSE DEBUG}
Procedure BuildSlotMenu( RPM: RPGMenuPtr; Master,Item: GearPtr );
{$ENDIF DEBUG}
{$IFDEF PATCH_CHEAT}
  {$IFDEF DEBUG}
Function BuildSubMenu( RPM: RPGMenuPtr; Master,Item: GearPtr; DoMultiplicityCheck: Boolean; const ShowSub: Boolean ): LongInt;
  {$ELSE DEBUG}
Procedure BuildSubMenu( RPM: RPGMenuPtr; Master,Item: GearPtr; DoMultiplicityCheck: Boolean; const ShowSub: Boolean );
  {$ENDIF DEBUG}
{$ENDIF PATCH_CHEAT}
{$IFDEF DEBUG}
Function BuildSubMenu( RPM: RPGMenuPtr; Master,Item: GearPtr; DoMultiplicityCheck: Boolean ): LongInt;
{$ELSE DEBUG}
Procedure BuildSubMenu( RPM: RPGMenuPtr; Master,Item: GearPtr; DoMultiplicityCheck: Boolean );
{$ENDIF DEBUG}

{$IFDEF DEBUG}
Function LocateGearByNumber( Master: GearPtr; Num: LongInt; DebugMode: Boolean; MaxNum: LongInt; DebugMsg: String ): GearPtr;
{$ELSE DEBUG}
  {$IFDEF PATCH_GH}
Function LocateGearByNumber( Master: GearPtr; Num: LongInt; DebugMode: Boolean ): GearPtr;
Function LocateGearByNumber( Master: GearPtr; Num: LongInt ): GearPtr;
  {$ELSE PATCH_GH}
Function LocateGearByNumber( Master: GearPtr; Num: Integer ): GearPtr;
  {$ENDIF PATCH_GH}
{$ENDIF DEBUG}
Function FindNextWeapon( GB: GameBoardPtr; Master,Weapon: GearPtr; MinRange: Integer ): GearPtr;
{$IFDEF PATCH_GH}
Function FindGearIndex( Master , FindThis: GearPtr ): LongInt;
{$ELSE PATCH_GH}
Function FindGearIndex( Master , FindThis: GearPtr ): Integer;
{$ENDIF PATCH_GH}
{$IFDEF DEBUG}
Function CountGearIndex( Master: GearPtr; DebugMode: Boolean; DebugMsg: String ): LongInt;
{$ENDIF DEBUG}

Procedure AlphaKeyMenu( RPM: RPGMenuPtr );

implementation

uses
{$IFDEF DEBUG}
	sysutils,
	errmsg,
{$ELSE DEBUG}
  {$IFDEF PATCH_GH}
	sysutils,
  {$ENDIF PATCH_GH}
{$ENDIF DEBUG}
{$IFDEF PATCH_I18N}
	i18nmsg,
{$ENDIF PATCH_I18N}
{$IFDEF PATCH_CHEAT}
	ui4gh,
{$ENDIF PATCH_CHEAT}
	damage,effects,gearutil,ghswag,ghweapon,texutil
{$IFDEF DEBUG}
  {$IFDEF SDLMODE}
	,sdlgfx
  {$ELSE SDLMODE}
	,context
  {$ENDIF SDLMODE}
{$ENDIF DEBUG}
	;

Procedure BuildGearMenu( RPM: RPGMenuPtr; Master: GearPtr; G: Integer );
	{ Search through MASTER, adding to menu RPM any part which }
	{ corresponds to descriptor G. Add each matching part to the }
	{ menu, along with its locator number. }
var
{$IFDEF PATCH_GH}
	N: LongInt;
{$ELSE PATCH_GH}
	N: Integer;
{$ENDIF PATCH_GH}
{ PROCEDURES BLOCK }
	Procedure CheckAlongPath( Part: GearPtr; AddToMenu: Boolean );
		{ CHeck along the path specified. }
	begin
		while Part <> Nil do begin
{$IFDEF PATCH_GH}
			if (GG_DisposeGear < Part^.G) then begin
{$ENDIF PATCH_GH}
			Inc(N);
  {$IFDEF DEBUG}
			if ( Part^.G = G ) and AddToMenu then begin
				AddRPGMenuItem( RPM , BStr(N) + ':' + GearName( Part ) , N );
			end;
  {$ELSE DEBUG}
			if ( Part^.G = G ) and AddToMenu then AddRPGMenuItem( RPM , GearName( Part ) , N );
  {$ENDIF DEBUG}
			if Part^.G = GG_Cockpit then begin
				{ Don't add parts beyond the cockpit barrier. }
				CheckAlongPath( Part^.InvCom , False );
				CheckAlongPath( Part^.SubCom , False );
			end else begin
				CheckAlongPath( Part^.InvCom , AddToMenu );
				CheckAlongPath( Part^.SubCom , AddToMenu );
			end;
{$IFDEF PATCH_GH}
			end;
{$ENDIF PATCH_GH}
			Part := Part^.Next;
		end;
	end;
begin
{$IFDEF PATCH_GH}
	if (NIL = Master) or (Master^.G <= GG_DisposeGear) then Exit;
{$ENDIF PATCH_GH}
	N := 0;
	if Master^.G = G then AddRPGMenuItem( RPM , GearName( Master ) , 0 );
	CheckAlongPath( Master^.InvCom , True );
	CheckAlongPath( Master^.SubCom , True );
end; { BuildGearMenu }

{$IFDEF PATCH_GH}
  {$IFDEF DEBUG}
Function BuildGearMenu( RPM: RPGMenuPtr; Master: GearPtr ): LongInt;
begin
	BuildGearMenu := BuildGearMenu( RPM, Master, False );
end;
  {$ELSE DEBUG}
Procedure BuildGearMenu( RPM: RPGMenuPtr; Master: GearPtr );
begin
	BuildGearMenu( RPM, Master, False );
end;
  {$ENDIF DEBUG}
{$ENDIF PATCH_GH}

{$IFDEF PATCH_GH}
  {$IFDEF DEBUG}
Function BuildGearMenu( RPM: RPGMenuPtr; Master: GearPtr; DebugMode: Boolean ): LongInt;
  {$ELSE DEBUG}
Procedure BuildGearMenu( RPM: RPGMenuPtr; Master: GearPtr; DebugMode: Boolean );
  {$ENDIF DEBUG}
{$ELSE PATCH_GH}
  {$IFDEF DEBUG}
Function BuildGearMenu( RPM: RPGMenuPtr; Master: GearPtr ): LongInt;
  {$ELSE DEBUG}
Procedure BuildGearMenu( RPM: RPGMenuPtr; Master: GearPtr );
  {$ENDIF DEBUG}
{$ENDIF PATCH_GH}
	{ Search through MASTER, adding to menu all parts. }
const
	InvStr = '+';
	SubStr = '>';
var
{$IFDEF PATCH_GH}
	N: LongInt;
	N_clean: LongInt;
{$ELSE PATCH_GH}
	N: Integer;
{$ENDIF PATCH_GH}
{ PROCEDURES BLOCK }
{$IFDEF PATCH_GH}
	Function MakeGearName( Part: GearPtr; TabPos,Prefix: String ): String;
	var
		Msg: String;
	begin
		Msg := TabPos;
		if DebugMode then begin
			case Part^.G of
			GG_AbsolutelyNothing:	Msg := Msg + 'A';
			GG_DisposeGear:		Msg := Msg + 'D';
			-32768:			Msg := Msg + '*';
			else			Msg := Msg + ' ';
			end;
		end;
{$IFDEF PATCH_CHEAT}
		if Cheat_EqpMenu_ShowFullGearName then begin
			MakeGearName := Msg + Prefix + FullGearName( Part, DebugMode );
		end else begin
			MakeGearName := Msg + Prefix + GearName( Part, DebugMode );
		end;
{$ELSE PATCH_CHEAT}
		MakeGearName := Msg + Prefix + GearName( Part, DebugMode );
{$ENDIF PATCH_CHEAT}
	end;

	Procedure CheckAlongPath( Part: GearPtr; TabPos,Prefix: String; WithNext: Boolean; Show: Boolean );
		{ CHeck along the path specified. }
	begin
		while Part <> Nil do begin
			if DebugMode or (GG_DisposeGear < Part^.G) then begin
				if Show then begin
					if DebugMode then begin
						AddRPGMenuItem( RPM, BStr(N_clean) + ':' + BStr(N) + ':' + MakeGearName( Part, TabPos,Prefix ), N );
					end else if (GG_AbsolutelyNothing <> Part^.G) then begin
						AddRPGMenuItem( RPM, MakeGearName( Part, TabPos,Prefix ), N );
					end;
				end;
				Inc(N);
				if (GG_DisposeGear < Part^.G) then begin
					Inc(N_clean);
				end;
{$IFDEF PATCH_CHEAT}
				if Cheat_EnableCockpitBarrier and ( GG_Cockpit = Part^.G ) then begin
					{ Don't add parts beyond the cockpit barrier. }
					CheckAlongPath( Part^.InvCom, TabPos + '   ', InvStr, True, Show );
					CheckAlongPath( Part^.SubCom, TabPos + '   ', SubStr, True, False );
				end else begin
{$ENDIF PATCH_CHEAT}
					CheckAlongPath( Part^.InvCom, TabPos + '   ', InvStr, True, Show );
					CheckAlongPath( Part^.SubCom, TabPos + '   ', SubStr, True, Show );
{$IFDEF PATCH_CHEAT}
				end;
{$ENDIF PATCH_CHEAT}
			end;
			if not(WithNext) then begin
				break;
			end;
			Part := Part^.Next;
		end;
	end;{CheckAlongPath}
{$ELSE PATCH_GH}
	Procedure CheckAlongPath( Part: GearPtr; TabPos,Prefix: String );
		{ CHeck along the path specified. }
	begin
		while Part <> Nil do begin
			Inc(N);
			if Part^.G <> GG_AbsolutelyNothing then AddRPGMenuItem( RPM , TabPos + Prefix + GearName( Part ) , N );
			CheckAlongPath( Part^.InvCom , TabPos + '   ' , InvStr );
			CheckAlongPath( Part^.SubCom , TabPos + '   ' , SubStr );
			Part := Part^.Next;
		end;
	end;{CheckAlongPath}
{$ENDIF PATCH_GH}
begin
{$IFDEF PATCH_GH}
	N := 0;
	N_clean := 0;
	CheckAlongPath( Master, '', '', DebugMode, True );
{$ELSE PATCH_GH}
	N := 0;
	AddRPGMenuItem( RPM , GearName( Master ) , 0 );
	CheckAlongPath( Master^.InvCom , '   ' , '+' );
	CheckAlongPath( Master^.SubCom , '   ' , '>' );
{$ENDIF PATCH_GH}
{$IFDEF DEBUG}
	BuildGearMenu := (N - 1);
{$ENDIF DEBUG}
end; { BuildGearMenu }

{$IFDEF DEBUG}
Function BuildEquipmentMenu( RPM: RPGMenuPtr; Master: GearPtr ): LongInt;
{$ELSE DEBUG}
Procedure BuildEquipmentMenu( RPM: RPGMenuPtr; Master: GearPtr );
{$ENDIF DEBUG}
	{ Create a menu for this master's equipment. Equipment is defined as }
	{ an InvCom of any part other than the master itself. }
{$IFDEF PATCH_CHEAT}
const
	InvStr = '+';
	SubStr = '>';
{$ENDIF PATCH_CHEAT}
var
{$IFDEF PATCH_GH}
	N: LongInt;
{$ELSE PATCH_GH}
	N: Integer;
{$ENDIF PATCH_GH}
	Procedure CheckAlongPath( Part: GearPtr; IsInv: Boolean );
		{ CHeck along the path specified. }
	var
		msg: String;
	begin
		while Part <> Nil do begin
{$IFDEF PATCH_GH}
			if (GG_DisposeGear < Part^.G) then begin
{$ENDIF PATCH_GH}
			Inc(N);
			if ( Part^.G <> GG_AbsolutelyNothing ) and IsInv then begin
				{ Creating a message line for this equipment is made tricky by the }
				{ fact that a pilot riding in a mecha has a separate inventory from }
				{ the mecha itself. }
				if IsMasterGear( Part^.Parent ) then begin
{$IFDEF PATCH_CHEAT}
					if Cheat_EqpMenu_ShowFullGearName then begin
						msg := '[' + GearName( Part^.Parent ) + '] ' + FullGearName( Part );
					end else begin
						msg := '[' + GearName( Part^.Parent ) + '] ' + GearName( Part );
					end;
{$ELSE PATCH_CHEAT}
					msg := '[' + GearName( Part^.Parent ) + '] ' + GearName( Part );
{$ENDIF PATCH_CHEAT}
				end else begin
{$IFDEF PATCH_CHEAT}
					if Cheat_EqpMenu_ShowFullGearName then begin
						msg := FullGearName( Part ) + ' [';
					end else begin
						msg := GearName( Part ) + ' [';
					end;
{$ELSE PATCH_CHEAT}
					msg := GearName( Part ) + ' [';
{$ENDIF PATCH_CHEAT}
					if FindMaster(Part)^.Parent <> Nil then msg := msg + GearName( FindMaster( Part ) ) + ':';
					msg := msg + GearName( Part^.Parent ) + ']';
				end;
{$IFDEF PATCH_I18N}
				AddRPGMenuItem( RPM, msg, N, FormatDescString(Part) );
{$ELSE PATCH_I18N}
				AddRPGMenuItem( RPM , msg , N , SAttValue( Part^.SA , 'DESC' ) );
{$ENDIF PATCH_I18N}
			end;
			CheckAlongPath( Part^.InvCom , True );
			CheckAlongPath( Part^.SubCom , False );
{$IFDEF PATCH_GH}
			end;
{$ENDIF PATCH_GH}
			Part := Part^.Next;
		end;
	end;{CheckAlongPath}
{$IFDEF PATCH_CHEAT}
	Procedure CheckAlongPath( Part: GearPtr; const IsInv,IsInvSub: Boolean; const TabPos,Prefix: String; Show: Boolean );
	var
		msg: String;
	begin
		while Part <> Nil do begin
{$IFDEF PATCH_GH}
			if (GG_DisposeGear < Part^.G) then begin
{$ENDIF PATCH_GH}
			Inc(N);
			if ( Part^.G <> GG_AbsolutelyNothing ) and Show then begin
				if IsInv then begin
					if IsMasterGear( Part^.Parent ) then begin
{$IFDEF PATCH_CHEAT}
						if Cheat_EqpMenu_ShowFullGearName then begin
							msg := '[' + GearName( Part^.Parent ) + '] ' + FullGearName( Part );
						end else begin
							msg := '[' + GearName( Part^.Parent ) + '] ' + GearName( Part );
						end;
{$ELSE PATCH_CHEAT}
						msg := '[' + GearName( Part^.Parent ) + '] ' + GearName( Part );
{$ENDIF PATCH_CHEAT}
					end else begin
{$IFDEF PATCH_CHEAT}
						if Cheat_EqpMenu_ShowFullGearName then begin
							msg := FullGearName( Part ) + ' [';
						end else begin
							msg := GearName( Part ) + ' [';
						end;
{$ELSE PATCH_CHEAT}
						msg := GearName( Part ) + ' [';
{$ENDIF PATCH_CHEAT}
						if FindMaster(Part)^.Parent <> Nil then msg := msg + GearName( FindMaster( Part ) ) + ':';
						msg := msg + GearName( Part^.Parent ) + ']';
					end;
{$IFDEF PATCH_I18N}
					AddRPGMenuItem( RPM, msg, N, FormatDescString(Part) );
{$ELSE PATCH_I18N}
					AddRPGMenuItem( RPM , msg , N , SAttValue( Part^.SA , 'DESC' ) );
{$ENDIF PATCH_I18N}
				end else if IsInvSub then begin
{$IFDEF PATCH_I18N}
					AddRPGMenuItem( RPM, TabPos + Prefix + GearName(Part), N, FormatDescString(Part) );
{$ELSE PATCH_I18N}
					AddRPGMenuItem( RPM, TabPos + Prefix + GearName(Part), N, SAttValue(Part^.SA , 'DESC') );
{$ENDIF PATCH_I18N}
				end;
			end;
{$IFDEF PATCH_CHEAT}
			if Cheat_EnableCockpitBarrier and ( GG_Cockpit = Part^.G ) then begin
				{ Don't add parts beyond the cockpit barrier. }
				CheckAlongPath( Part^.InvCom, True, True,     '',             InvStr, Show );
				CheckAlongPath( Part^.SubCom, False,IsInvSub, TabPos + '   ', SubStr, False );
			end else begin
{$ENDIF PATCH_CHEAT}
				CheckAlongPath( Part^.InvCom, True, True,     '',             InvStr, Show );
				CheckAlongPath( Part^.SubCom, False,IsInvSub, TabPos + '   ', SubStr, Show );
{$IFDEF PATCH_CHEAT}
			end;
{$ENDIF PATCH_CHEAT}
{$IFDEF PATCH_GH}
			end;
{$ENDIF PATCH_GH}
			Part := Part^.Next;
		end;
	end;
{$ENDIF PATCH_CHEAT}
begin
{$IFDEF PATCH_GH}
	if (NIL = Master) or (Master^.G <= GG_DisposeGear) then Exit;
{$ENDIF PATCH_GH}
	N := 0;
{$IFDEF PATCH_CHEAT}
	if Cheat_EqpMenu_ShowSubItem then begin
		CheckAlongPath( Master^.InvCom , False,False, '', InvStr, True );
		CheckAlongPath( Master^.SubCom , False,False, '', SubStr, True );
	end else begin
		CheckAlongPath( Master^.InvCom , False );
		CheckAlongPath( Master^.SubCom , False );
	end;
{$ELSE PATCH_CHEAT}
	CheckAlongPath( Master^.InvCom , False );
	CheckAlongPath( Master^.SubCom , False );
{$ENDIF PATCH_CHEAT}
{$IFDEF DEBUG}
	BuildEquipmentMenu := N;
{$ENDIF DEBUG}
end; {BuildEquipmentMenu}

{$IFDEF PATCH_CHEAT}
  {$IFDEF DEBUG}
Function BuildInventoryMenu( RPM: RPGMenuPtr; Master: GearPtr ): LongInt;
begin
	BuildInventoryMenu := BuildInventoryMenu( RPM, Master, False );
end;
  {$ELSE DEBUG}
Procedure BuildInventoryMenu( RPM: RPGMenuPtr; Master: GearPtr );
begin
	BuildInventoryMenu( RPM, Master, False );
end;
  {$ENDIF DEBUG}

  {$IFDEF DEBUG}
Function BuildInventoryMenu( RPM: RPGMenuPtr; Master: GearPtr; const ShowSub: Boolean ): LongInt;
  {$ELSE DEBUG}
Procedure BuildInventoryMenu( RPM: RPGMenuPtr; Master: GearPtr; const ShowSub: Boolean );
  {$ENDIF DEBUG}
{$ELSE PATCH_CHEAT}
  {$IFDEF DEBUG}
Function BuildInventoryMenu( RPM: RPGMenuPtr; Master: GearPtr ): LongInt;
  {$ELSE DEBUG}
Procedure BuildInventoryMenu( RPM: RPGMenuPtr; Master: GearPtr );
  {$ENDIF DEBUG}
{$ENDIF PATCH_CHEAT}
	{ Create a menu for this master's inventory. Inventory is defined as }
	{ any InvCom of the master. }
{$IFDEF PATCH_CHEAT}
const
	InvStr = '+';
	SubStr = '>';
{$ENDIF PATCH_CHEAT}
var
	N: Integer;
	Part: GearPtr;
	Procedure CountTheKids( P: GearPtr );
		{ This procedure ignores the sub/inv components of things }
		{ in the general inventory, but they have to be counted so }
		{ the locator numbers will work properly. }
	begin
		While P <> Nil do begin
{$IFDEF PATCH_GH}
			if (GG_DisposeGear < Part^.G) then begin
{$ENDIF PATCH_GH}
			Inc( N );
			if P^.InvCom <> Nil then CountTheKids( P^.InvCom );
			if P^.SubCom <> Nil then CountTheKids( P^.SubCom );
{$IFDEF PATCH_GH}
			end;
{$ENDIF PATCH_GH}
			P := P^.Next;
		end;
	end;
	Function IMString( P: GearPtr ): String;
		{ Given part P, return a string to use in the menu. }
	var
		msg: String;
		ShotsUsed: Integer;
	begin
{$IFDEF PATCH_GH}
		if (NIL = P) or (P^.G <= GG_DisposeGear) then Exit('');
{$ENDIF PATCH_GH}
		msg := FullGearName( P );

		{ Add extra information, depending upon item type. }
		if P^.G = GG_Weapon then begin
			msg := msg + '  (DC:' + BStr( ScaleDC( P^.V , P^.Scale ) ) + ')';
		end else if ( P^.G = GG_ExArmor ) or ( P^.G = GG_Shield ) then begin
			msg := msg + '  [AC:' + BStr( GearMaxArmor( P ) ) + ']';
		end else if P^.G = GG_Ammo then begin
			ShotsUsed := NAttValue( P^.NA , NAG_WeaponModifier , NAS_AmmoSpent );
			msg := msg + '  (' + BStr( P^.STat[ STAT_AmmoPresent ] - ShotsUSed ) + '/' + BStr( P^.Stat[ STAT_AmmoPresent ] ) + 'a)';
		end else if P^.G = GG_Consumable then begin
			msg := msg + '  (' + BStr( P^.STat[ STAT_FoodQuantity ] ) + ')';
		end;

{$IFDEF PATCH_GH}
		if DisallowSelling( P ) then begin
{$IFDEF PATCH_I18N}
			msg := msg + I18N_MsgString( 'BuildInventoryMenu' , 'CannotBeSold' );
{$ELSE PATCH_I18N}
			msg := msg + ' [Unsellable]';
{$ENDIF PATCH_I18N}
		end;
		if DisallowDropping( P ) then begin
{$IFDEF PATCH_I18N}
			msg := msg + I18N_MsgString( 'BuildInventoryMenu' , 'CannotBeDropped' );
{$ELSE PATCH_I18N}
			msg := msg + ' [NoDrop]';
{$ENDIF PATCH_I18N}
		end;
		if DisallowTransfering( P ) then begin
{$IFDEF PATCH_I18N}
			msg := msg + I18N_MsgString( 'BuildInventoryMenu' , 'CannotBeTransfered' );
{$ELSE PATCH_I18N}
			msg := msg + ' [NoTransfer]';
{$ENDIF PATCH_I18N}
		end;
{$ENDIF PATCH_GH}

		IMString := Msg;
	end;
{$IFDEF PATCH_CHEAT}
	Procedure CheckAlongPath( Part: GearPtr; const TabPos,Prefix: String );
	begin
		while Part <> Nil do begin
{$IFDEF PATCH_GH}
			if (GG_DisposeGear < Part^.G) then begin
{$ENDIF PATCH_GH}
			Inc(N);
{$IFDEF PATCH_I18N}
			if Part^.G <> GG_AbsolutelyNothing then begin
				AddRPGMenuItem( RPM, #$0 + TabPos + Prefix + IMString(Part), N, FormatDescString(Part) );
			end;
{$ELSE PATCH_I18N}
			if Part^.G <> GG_AbsolutelyNothing then AddRPGMenuItem( RPM, #$0 + TabPos + Prefix + IMString(Part), N, SAttValue(Part^.SA , 'DESC') );
{$ENDIF PATCH_I18N}
			CheckAlongPath( Part^.InvCom , TabPos + '   ' , InvStr );
			CheckAlongPath( Part^.SubCom , TabPos + '   ' , SubStr );
{$IFDEF PATCH_GH}
			end;
{$ENDIF PATCH_GH}
			Part := Part^.Next;
		end;
	end;
{$ENDIF PATCH_CHEAT}
begin
{$IFDEF PATCH_GH}
	if (NIL = Master) or (Master^.G <= GG_DisposeGear) then Exit;
{$ENDIF PATCH_GH}
	N := 0;
	Part := Master^.InvCom;

	while Part <> Nil do begin
{$IFDEF PATCH_GH}
		if (GG_DisposeGear < Part^.G) then begin
{$ENDIF PATCH_GH}
		Inc( N );
{$IFDEF PATCH_I18N}
		AddRPGMenuItem( RPM, IMString(Part), N, FormatDescString(Part) );
{$ELSE PATCH_I18N}
		AddRPGMenuItem( RPM , IMString( Part ) , N , SAttValue( Part^.SA , 'DESC' ) );
{$ENDIF PATCH_I18N}
{$IFDEF PATCH_CHEAT}
		if ShowSub then begin
			CheckAlongPath( Part^.InvCom, '   ', InvStr );
			CheckAlongPath( Part^.SubCom, '   ', SubStr );
		end else begin
			CountTheKids( Part^.InvCom );
			CountTheKids( Part^.SubCom );
		end;
{$ELSE PATCH_CHEAT}
		if Part^.InvCom <> Nil then CountTheKids( Part^.InvCom );
		if Part^.SubCom <> Nil then CountTheKids( Part^.SubCom );
{$ENDIF PATCH_CHEAT}
{$IFDEF PATCH_GH}
		end;
{$ENDIF PATCH_GH}
		Part := Part^.Next;
	end;

{$IFDEF DEBUG}
	BuildInventoryMenu := CountGearIndex( Master, False, '' );
{$ENDIF DEBUG}
end;

{$IFDEF DEBUG}
Function BuildSlotMenu( RPM: RPGMenuPtr; Master,Item: GearPtr ): LongInt;
{$ELSE DEBUG}
Procedure BuildSlotMenu( RPM: RPGMenuPtr; Master,Item: GearPtr );
{$ENDIF DEBUG}
	{ Search through MASTER, adding to menu all parts which can }
	{ equip ITEM. }
{$IFDEF PATCH_CHEAT}
const
	InvStr = '+';
	SubStr = '>';
{$ENDIF PATCH_CHEAT}
var
{$IFDEF PATCH_GH}
	N: LongInt;
{$ELSE PATCH_GH}
	N: Integer;
{$ENDIF PATCH_GH}
{ PROCEDURES BLOCK }
{$IFDEF PATCH_CHEAT}
	Function IMString_addParent( const Part: GearPtr; const basemsg: String ): String;
	var
		msg: String;
	begin
{$IFDEF PATCH_GH}
		if (NIL = Part) or (Part^.G <= GG_DisposeGear) then Exit('');
{$ENDIF PATCH_GH}
		if IsMasterGear( Part^.Parent ) then begin
			msg := '[' + GearName( Part^.Parent ) + '] ' + basemsg;
		end else begin
			msg := basemsg + ' [';
			if FindMaster(Part)^.Parent <> Nil then msg := msg + GearName( FindMaster( Part ) ) + ':';
			msg := msg + GearName( Part^.Parent ) + ']';
		end;
		IMString_addParent := msg;
	end;
	Function IMString( const P: GearPtr ): String;
	var
		msg: String;
		ShotsUsed: Integer;
	begin
{$IFDEF PATCH_GH}
		if (NIL = P) or (P^.G <= GG_DisposeGear) then Exit('');
{$ENDIF PATCH_GH}
		msg := FullGearName( P );
		if P^.G = GG_Weapon then begin
			msg := msg + '  (DC:' + BStr( ScaleDC( P^.V , P^.Scale ) ) + ')';
		end else if ( P^.G = GG_ExArmor ) or ( P^.G = GG_Shield ) then begin
			msg := msg + '  [AC:' + BStr( GearMaxArmor( P ) ) + ']';
		end else if P^.G = GG_Ammo then begin
			ShotsUsed := NAttValue( P^.NA , NAG_WeaponModifier , NAS_AmmoSpent );
			msg := msg + '  (' + BStr( P^.STat[ STAT_AmmoPresent ] - ShotsUsed ) + '/' + BStr( P^.Stat[ STAT_AmmoPresent ] ) + 'a)';
		end else if P^.G = GG_Consumable then begin
			msg := msg + '  (' + BStr( P^.STat[ STAT_FoodQuantity ] ) + ')';
		end;
		IMString := Msg;
	end;
	Procedure CheckAlongPath( Part: GearPtr; const LastN: LongInt; const IsHitSub: Boolean; const TabPos,Prefix: String );
	var
		Hit: Boolean;
		NewN: LongInt;
		NewTabPos: String;
		msg: String;
	begin
		while Part <> Nil do begin
	{$IFDEF PATCH_GH}
			if (GG_DisposeGear < Part^.G) then begin
				Hit := False;
				NewN := -2;
				NewTabPos := '';
				Inc(N);
				if IsLegalSlot( Part , Item ) and PartActive( Part ) then begin
					msg := '';
					if Cheat_EquipItem_ShowInvStr then begin
						msg := Prefix;
					end;
					if Cheat_EquipItem_ShowParentItem then begin
						msg := msg + IMString_addParent( Part, GearName(Part) );
					end else begin
						msg := msg + GearName( Part );
					end;
					AddRPGMenuItem( RPM, msg, N );
					Hit := True;
					NewN := N;
					NewTabPos := '   ';
				end else begin
					if Cheat_EquipItem_ShowSubItem and IsHitSub then begin
						AddRPGMenuItem( RPM, TabPos + Prefix + IMString(Part), LastN );
						Hit := True;
						NewTabPos := TabPos + '   ';
					end;
				end;
				CheckAlongPath( Part^.InvCom, NewN, Hit, NewTabPos, InvStr );
				CheckAlongPath( Part^.SubCom, NewN, Hit, NewTabPos, SubStr );
			end;
	{$ELSE PATCH_GH}
			Hit := False;
			NewN := -2;
			NewTabPos := '';
			Inc(N);
			if IsLegalSlot( Part , Item ) and PartActive( Part ) then begin
				msg := '';
				if Cheat_EquipItem_ShowInvStr then begin
					msg := Prefix;
				end;
				if Cheat_EquipItem_ShowParentItem then begin
					msg := msg + IMString_addParent( Part, GearName(Part) );
				end else begin
					msg := msg + GearName( Part );
				end;
				AddRPGMenuItem( RPM, msg, N );
				Hit := True;
				NewN := N;
				NewTabPos := '   ';
			end else begin
				if Cheat_EquipItem_ShowSubItem and IsHitSub then begin
					AddRPGMenuItem( RPM, TabPos + Prefix + IMString(Part), LastN );
					Hit := True;
					NewTabPos := TabPos + '   ';
				end;
			end;
			CheckAlongPath( Part^.InvCom, NewN, Hit, NewTabPos, InvStr );
			CheckAlongPath( Part^.SubCom, NewN, Hit, NewTabPos, SubStr );
	{$ENDIF PATCH_GH}
			Part := Part^.Next;
		end;
	end;{CheckAlongPath}
{$ELSE PATCH_CHEAT}
	Procedure CheckAlongPath( Part: GearPtr );
		{ CHeck along the path specified. }
	begin
		while Part <> Nil do begin
	{$IFDEF PATCH_GH}
			if (GG_DisposeGear < Part^.G) then begin
				Inc(N);
				if IsLegalSlot( Part , Item ) and PartActive( Part ) then AddRPGMenuItem( RPM , GearName( Part ) , N );
				CheckAlongPath( Part^.InvCom );
				CheckAlongPath( Part^.SubCom );
			end;
	{$ELSE PATCH_GH}
			Inc(N);
			if IsLegalSlot( Part , Item ) and PartActive( Part ) then AddRPGMenuItem( RPM , GearName( Part ) , N );
			CheckAlongPath( Part^.InvCom );
			CheckAlongPath( Part^.SubCom );
	{$ENDIF PATCH_GH}
			Part := Part^.Next;
		end;
	end;{CheckAlongPath}
{$ENDIF PATCH_CHEAT}
begin
{$IFDEF PATCH_GH}
	if (NIL = Master) or (Master^.G <= GG_DisposeGear) then Exit;
{$ENDIF PATCH_GH}
	N := 0;
{$IFDEF PATCH_CHEAT}
	CheckAlongPath( Master^.InvCom, -2, False, '', InvStr );
	CheckAlongPath( Master^.SubCom, -2, False, '', SubStr );
{$ELSE PATCH_CHEAT}
	CheckAlongPath( Master^.InvCom );
	CheckAlongPath( Master^.SubCom );
{$ENDIF PATCH_CHEAT}
{$IFDEF DEBUG}
	BuildSlotMenu := N;
{$ENDIF DEBUG}
end; { BuildSlotMenu }

{$IFDEF PATCH_CHEAT}
  {$IFDEF DEBUG}
Function BuildSubMenu( RPM: RPGMenuPtr; Master,Item: GearPtr; DoMultiplicityCheck: Boolean ): LongInt;
begin
	BuildSubMenu := BuildSubMenu( RPM, Master, Item, DoMultiplicityCheck, False );
end;
  {$ELSE DEBUG}
Procedure BuildSubMenu( RPM: RPGMenuPtr; Master,Item: GearPtr; DoMultiplicityCheck: Boolean );
begin
	BuildSubMenu( RPM, Master, Item, DoMultiplicityCheck, False );
end;
  {$ENDIF DEBUG}

  {$IFDEF DEBUG}
Function BuildSubMenu( RPM: RPGMenuPtr; Master,Item: GearPtr; DoMultiplicityCheck: Boolean; const ShowSub: Boolean ): LongInt;
  {$ELSE DEBUG}
Procedure BuildSubMenu( RPM: RPGMenuPtr; Master,Item: GearPtr; DoMultiplicityCheck: Boolean; const ShowSub: Boolean );
  {$ENDIF DEBUG}
{$ELSE PATCH_CHEAT}
  {$IFDEF DEBUG}
Function BuildSubMenu( RPM: RPGMenuPtr; Master,Item: GearPtr; DoMultiplicityCheck: Boolean ): LongInt;
  {$ELSE DEBUG}
Procedure BuildSubMenu( RPM: RPGMenuPtr; Master,Item: GearPtr; DoMultiplicityCheck: Boolean );
  {$ENDIF DEBUG}
{$ENDIF PATCH_CHEAT}
	{ Search through MASTER, adding to menu all parts which can }
	{ take ITEM as a subcomponent. }
{$IFDEF PATCH_CHEAT}
const
	InvStr = '+';
	SubStr = '>';
{$ENDIF PATCH_CHEAT}
var
{$IFDEF PATCH_GH}
	N: LongInt;
{$ELSE PATCH_GH}
	N: Integer;
{$ENDIF PATCH_GH}
{$IFDEF PATCH_CHEAT}
	Hit: Boolean;
	NewN: LongInt;
	NewTabPos: String;
{$ENDIF PATCH_CHEAT}
{ PROCEDURES BLOCK }
	Function MenuMsg( Part: GearPtr ): String;
	begin
{$IFDEF PATCH_GH}
		if (NIL = Part) or (Part^.G <= GG_DisposeGear) then Exit('');
{$ENDIF PATCH_GH}
		MenuMsg := GearName( Part ) + ' (' + BStr( SubComComplexity( Part ) ) + '/' + BStr( ComponentComplexity( Part ) ) + ')';
	end;
{$IFDEF PATCH_CHEAT}
	Function IMString_addParent( const Part: GearPtr; const basemsg: String ): String;
	var
		msg: String;
	begin
{$IFDEF PATCH_GH}
		if (NIL = Part) or (Part^.G <= GG_DisposeGear) then Exit('');
{$ENDIF PATCH_GH}
		if IsMasterGear( Part^.Parent ) then begin
			msg := '[' + GearName( Part^.Parent ) + '] ' + basemsg;
		end else begin
			msg := basemsg + ' [';
			if FindMaster(Part)^.Parent <> Nil then msg := msg + GearName( FindMaster( Part ) ) + ':';
			msg := msg + GearName( Part^.Parent ) + ']';
		end;
		IMString_addParent := msg;
	end;
	Function IMString( const P: GearPtr ): String;
	var
		msg: String;
		ShotsUsed: Integer;
	begin
{$IFDEF PATCH_GH}
		if (NIL = P) or (P^.G <= GG_DisposeGear) then Exit('');
{$ENDIF PATCH_GH}
		msg := FullGearName( P );
		if P^.G = GG_Weapon then begin
			msg := msg + '  (DC:' + BStr( ScaleDC( P^.V , P^.Scale ) ) + ')';
		end else if ( P^.G = GG_ExArmor ) or ( P^.G = GG_Shield ) then begin
			msg := msg + '  [AC:' + BStr( GearMaxArmor( P ) ) + ']';
		end else if P^.G = GG_Ammo then begin
			ShotsUsed := NAttValue( P^.NA , NAG_WeaponModifier , NAS_AmmoSpent );
			msg := msg + '  (' + BStr( P^.STat[ STAT_AmmoPresent ] - ShotsUsed ) + '/' + BStr( P^.Stat[ STAT_AmmoPresent ] ) + 'a)';
		end else if P^.G = GG_Consumable then begin
			msg := msg + '  (' + BStr( P^.STat[ STAT_FoodQuantity ] ) + ')';
		end;
		IMString := Msg;
	end;
	Function CheckThisBit( const Part: GearPtr; const Prefix: String ): Boolean;
	var
		msg, basemsg: String;
	begin
{$IFDEF PATCH_GH}
		if (NIL = Part) or (Part^.G <= GG_DisposeGear) then Exit(False);
{$ENDIF PATCH_GH}
		msg := '';
		if Cheat_InstallMisc_ShowInvStr then begin
			msg := Prefix;
		end;
		if DoMultiplicityCheck then begin
			if CanBeInstalled( Part , Item ) then begin
				basemsg := MenuMsg( Part );
				if Cheat_InstallMisc_ShowParentItem then begin
					msg := msg + IMString_addParent( Part, basemsg );
				end else begin
					msg := msg + basemsg;
				end;
				AddRPGMenuItem( RPM, msg, N );
				Exit( True );
			end;
		end else begin
			if IsLegalSubCom( Part , Item ) then begin
				basemsg := GearName( Part );
				if Cheat_InstallMisc_ShowParentItem then begin
					msg := msg + IMString_addParent( Part, basemsg );
				end else begin
					msg := msg + basemsg;
				end;
				AddRPGMenuItem( RPM, msg, N );
				Exit( True );
			end;
		end;
		Exit( False );
	end;
	Procedure CheckAlongPath( Part: GearPtr; const LastN: LongInt; const IsHitSub: Boolean; const TabPos,Prefix: String );
	var
		Hit: Boolean;
		NewN: LongInt;
		NewTabPos: String;
	begin
		while Part <> Nil do begin
	{$IFDEF PATCH_GH}
			if (GG_DisposeGear < Part^.G) then begin
				Inc(N);
				Hit := CheckThisBit( Part, Prefix );
				NewN := -2;
				NewTabPos := '';
				If Hit then begin
					NewN := N;
					NewTabPos := '   ';
				end else begin
					if ShowSub and IsHitSub then begin
						AddRPGMenuItem( RPM, TabPos + Prefix + IMString(Part), LastN );
						Hit := True;
						NewTabPos := TabPos + '   ';
					end;
				end;
				CheckAlongPath( Part^.InvCom, NewN, Hit, NewTabPos, InvStr );
				CheckAlongPath( Part^.SubCom, NewN, Hit, NewTabPos, SubStr );
			end;
	{$ELSE PATCH_GH}
			Inc(N);
			Hit := CheckThisBit( Part, Prefix );
			NewN := -2;
			NewTabPos := '';
			If Hit then begin
				NewN := N;
				NewTabPos := '   ';
			end else begin
				if ShowSub and IsHitSub then begin
					AddRPGMenuItem( RPM, TabPos + Prefix + IMString(Part), LastN );
					Hit := True;
					NewTabPos := TabPos + '   ';
				end;
			end;
			CheckAlongPath( Part^.InvCom, NewN, Hit, NewTabPos, InvStr );
			CheckAlongPath( Part^.SubCom, NewN, Hit, NewTabPos, SubStr );
	{$ENDIF PATCH_GH}
			Part := Part^.Next;
		end;
	end;
{$ELSE PATCH_CHEAT}
	Procedure CheckThisBit( Part: GearPtr );
		{ Check this bit, and maybe add it to the menu. }
	begin
{$IFDEF PATCH_GH}
		if (NIL = Part) or (Part^.G <= GG_DisposeGear) then Exit;
{$ENDIF PATCH_GH}
		if DoMultiplicityCheck then begin
			if CanBeInstalled( Part , Item ) then AddRPGMenuItem( RPM , MenuMsg( Part ) , N );
		end else begin
			if IsLegalSubCom( Part , Item ) then AddRPGMenuItem( RPM , GearName( Part ) , N );
		end;
	end;
	Procedure CheckAlongPath( Part: GearPtr );
		{ CHeck along the path specified. }
	begin
		while Part <> Nil do begin
	{$IFDEF PATCH_GH}
			if (GG_DisposeGear < Part^.G) then begin
				Inc(N);
				CheckThisBit( Part );
				CheckAlongPath( Part^.InvCom );
				CheckAlongPath( Part^.SubCom );
			end;
	{$ELSE PATCH_GH}
			Inc(N);
			CheckThisBit( Part );
			CheckAlongPath( Part^.InvCom );
			CheckAlongPath( Part^.SubCom );
	{$ENDIF PATCH_GH}
			Part := Part^.Next;
		end;
	end;{CheckAlongPath}
{$ENDIF PATCH_CHEAT}
begin
{$IFDEF PATCH_GH}
	if (NIL = Master) or (Master^.G <= GG_DisposeGear) then Exit;
{$ENDIF PATCH_GH}
	N := 0;
{$IFDEF PATCH_CHEAT}
	Hit := CheckThisBit( Master, '' );
	NewN := -2;
	NewTabPos := '';
	if Hit then begin
		NewN := N;
		NewTabPos := '   ';
	end;
	CheckAlongPath( Master^.InvCom, NewN, Hit, NewTabPos, InvStr );
	CheckAlongPath( Master^.SubCom, NewN, Hit, NewTabPos, SubStr );
{$ELSE PATCH_CHEAT}
	CheckThisBit( Master );
	CheckAlongPath( Master^.InvCom );
	CheckAlongPath( Master^.SubCom );
{$ENDIF PATCH_CHEAT}
{$IFDEF DEBUG}
	BuildSubMenu := N;
{$ENDIF DEBUG}
end; { BuildSubMenu }


{$IFDEF DEBUG}
{$ELSE DEBUG}
  {$IFDEF PATCH_GH}
Function LocateGearByNumber( Master: GearPtr; Num: LongInt ): GearPtr;
begin
	LocateGearByNumber := LocateGearByNumber( Master, Num, False );
end;
  {$ENDIF PATCH_GH}
{$ENDIF DEBUG}

{$IFDEF DEBUG}
Function LocateGearByNumber( Master: GearPtr; Num: LongInt; DebugMode: Boolean; MaxNum: LongInt; DebugMsg: String ): GearPtr;
{$ELSE DEBUG}
  {$IFDEF PATCH_GH}
Function LocateGearByNumber( Master: GearPtr; Num: LongInt; DebugMode: Boolean ): GearPtr;
  {$ELSE PATCH_GH}
Function LocateGearByNumber( Master: GearPtr; Num: Integer ): GearPtr;
  {$ENDIF PATCH_GH}
{$ENDIF DEBUG}
	{ Locate the Nth part in the tree. }
var
{$IFDEF PATCH_GH}
	N: LongInt;
{$ELSE PATCH_GH}
	N: Integer;
{$ENDIF PATCH_GH}
	TheGearWeWant: GearPtr;
{ PROCEDURES BLOCK. }
	Procedure CheckAlongPath( Part: GearPtr );
		{ CHeck along the path specified. }
	begin
	{$IFDEF DEBUG}
		while (NIL <> Part) do begin
			if DebugMode or (GG_DisposeGear < Part^.G) then begin
				Inc(N);
				if N = Num then TheGearWeWant := Part;
				CheckAlongPath( Part^.InvCom );
				CheckAlongPath( Part^.SubCom );
			end;
			Part := Part^.Next;
		end;
	{$ELSE DEBUG}
		while ( Part <> Nil ) and ( TheGearWeWant = Nil ) do begin
	  {$IFDEF PATCH_GH}
			if DebugMode or (GG_DisposeGear < Part^.G) then begin
				Inc(N);
				if N = Num then TheGearWeWant := Part;
				if TheGearWeWant = Nil then CheckAlongPath( Part^.InvCom );
				if TheGearWeWant = Nil then CheckAlongPath( Part^.SubCom );
			end;
	  {$ELSE PATCH_GH}
			Inc(N);
			if N = Num then TheGearWeWant := Part;
			if TheGearWeWant = Nil then CheckAlongPath( Part^.InvCom );
			if TheGearWeWant = Nil then CheckAlongPath( Part^.SubCom );
	  {$ENDIF PATCH_GH}
			Part := Part^.Next;
		end;
	{$ENDIF DEBUG}
	end;
begin
{$IFDEF PATCH_GH}
	if (NIL = Master) or (not(DebugMode) and (Master^.G <= GG_DisposeGear)) then begin
  {$IFDEF DEBUG}
		ErrorMessage('ERROR: ' + DebugMsg + ': LocateGearByNumber(): GG_DisposeGear');
		DialogMsg('ERROR: ' + DebugMsg + ': LocateGearByNumber(): GG_DisposeGear');
  {$ENDIF DEBUG}
		Exit(NIL);
	end;
{$ENDIF PATCH_GH}

	TheGearWeWant := Nil;
	N := 0;

	{ Part 0 is the master gear itself. }
{$IFDEF DEBUG}
	if Num < 1 then begin
		TheGearWeWant := Master;
	end;

	CheckAlongPath( Master^.InvCom );
	CheckAlongPath( Master^.SubCom );

	if (NIL = TheGearWeWant) then begin
		ErrorMessage('ERROR: ' + DebugMsg + ': LocateGearByNumber(): NotFound: ' + BStr(Num) );
		DialogMsg('ERROR: ' + DebugMsg + ': LocateGearByNumber(): NotFound: ' + BStr(Num) );
	end else begin
		if (0 < Length(DebugMsg)) then begin
			if (NIL <> TheGearWeWant^.SA) then begin
				ErrorMessage_fork( 'TRACE: LocateGearByNumber(): ' + BStr(Num) + ':' + TheGearWeWant^.SA^.info );
				DialogMsg( 'TRACE: LocateGearByNumber(): ' + BStr(Num) + ':' + TheGearWeWant^.SA^.info );
			end else begin
				ErrorMessage_fork( 'TRACE: LocateGearByNumber(): ' + BStr(Num) + ':NIL' );
				DialogMsg( 'TRACE: LocateGearByNumber(): ' + BStr(Num) + ':NIL' );
			end;
		end;
	end;
	if (0 < Length(DebugMsg)) and (MaxNum <> N) then begin
		ErrorMessage('ERROR: ' + DebugMsg + ': MaxNum is mismatch, arg:' + BStr(MaxNum) + ', Now:' + IntToStr(N) + '.');
		DialogMsg('ERROR: ' + DebugMsg + ': MaxNum is mismatch, arg:' + BStr(MaxNum) + ', Now:' + IntToStr(N) + '.');
	end;
{$ELSE DEBUG}
	if Num < 1 then Exit( Master );

	CheckAlongPath( Master^.InvCom );
	if TheGearWeWant = Nil then CheckAlongPath( Master^.SubCom );
{$ENDIF DEBUG}
	LocateGearByNumber := TheGearWeWant;
end; { LocateGearByNumber }

Function FindNextWeapon( GB: GameBoardPtr; Master,Weapon: GearPtr; MinRange: Integer ): GearPtr;
	{ This procedure will check recursively through MASTER looking }
	{ for the first weapon (ready to fire) in standard order following PART. }
	{ If MinRange > 0, the weapon's range or throwing range must exceed MinRange. }
	{ If no further weapons are found, it will return the first }
	{ weapon. }
var
	FirstWep,NextWep: GearPtr;
	FoundStart: Boolean;
{ PROCEDURES BLOCK }
	Function WeaponIsOkay( W: GearPtr ): Boolean;
		{ Return TRUE if W is ready to fire and meets our other criteria, or }
		{ FALSE otherwise. }
	begin
{$IFDEF PATCH_GH}
		if (NIL = W) or (W^.G <= GG_DisposeGear) then Exit(False);
{$ENDIF PATCH_GH}
		if MinRange = 0 then begin
			WeaponIsOkay := ReadyToFire( GB , Master , W );
		end else begin
			WeaponIsOkay := ReadyToFire( GB , Master , W ) and ( ( WeaponRange( GB , W ) >= MinRange ) or ( ThrowingRange( GB , Master , W ) >= MinRange ) );
		end;
	end;
	Procedure CheckAlongPath( Part: GearPtr );
		{ CHeck along the path specified. }
	begin
		while Part <> Nil do begin
	{$IFDEF PATCH_GH}
			if (GG_DisposeGear < Part^.G) then begin
				if WeaponIsOkay( Part ) then begin
					if FirstWep = Nil then FirstWep := Part;
					if FoundStart and ( NextWep = Nil ) then NextWep := Part;
				end;
				if Part = Weapon then FoundStart := True;
				CheckAlongPath( Part^.InvCom );
				CheckAlongPath( Part^.SubCom );
			end;
	{$ELSE PATCH_GH}
			if WeaponIsOkay( Part ) then begin
				if FirstWep = Nil then FirstWep := Part;
				if FoundStart and ( NextWep = Nil ) then NextWep := Part;
			end;

			if Part = Weapon then FoundStart := True;
			CheckAlongPath( Part^.InvCom );
			CheckAlongPath( Part^.SubCom );
	{$ENDIF PATCH_GH}

			Part := Part^.Next;
		end;
	end;
begin
{$IFDEF PATCH_GH}
	if (NIL = Master) or (Master^.G <= GG_DisposeGear) then Exit(NIL);
	if (NIL = Weapon) or (Weapon^.G <= GG_DisposeGear) then begin
		Weapon := NIL;
	end;
{$ENDIF PATCH_GH}

	FirstWep := Nil;
	NextWep := Nil;

	if Weapon = Nil then FoundStart := True
	else FoundStart := False;

	CheckAlongPath( Master^.InvCom );
	CheckAlongPath( Master^.SubCom );

	{ Return either the next weapon or the first weapon, }
	{ depending upon what we found. }
{$IFDEF PATCH_CHEAT}
	if NextWep = Nil then FindNextWeapon := FirstWep
	else FindNextWeapon := NextWep;
	if Cheat_FindNextWeapon then begin
		if FindNextWeapon = Nil then FindNextWeapon := Weapon;
	end;
{$ELSE PATCH_CHEAT}
	if NextWep = Nil then FindNextWeapon := Weapon
	else FindNextWeapon := NextWep;
{$ENDIF PATCH_CHEAT}
end; { FindNextWeapon }

{$IFDEF PATCH_GH}
Function FindGearIndex( Master , FindThis: GearPtr ): LongInt;
{$ELSE PATCH_GH}
Function FindGearIndex( Master , FindThis: GearPtr ): Integer;
{$ENDIF PATCH_GH}
	{ Search through master looking for FINDTHIS. }
	{ Once found, return its index number. Return -1 if it }
	{ cannot be found. }
var
{$IFDEF PATCH_GH}
	N,it: LongInt;
{$ELSE PATCH_GH}
	N,it: Integer;
{$ENDIF PATCH_GH}
{ PROCEDURES BLOCK }
	Procedure CheckAlongPath( Part: GearPtr );
		{ CHeck along the path specified. }
	begin
		while ( Part <> Nil ) and ( it = -1 ) do begin
	{$IFDEF PATCH_GH}
			if (GG_DisposeGear < Part^.G) then begin
				Inc(N);
				if ( Part = FindThis ) then it := N;
				CheckAlongPath( Part^.InvCom );
				CheckAlongPath( Part^.SubCom );
			end;
	{$ELSE PATCH_GH}
			Inc(N);
			if ( Part = FindThis ) then it := N;
			CheckAlongPath( Part^.InvCom );
			CheckAlongPath( Part^.SubCom );
	{$ENDIF PATCH_GH}
			Part := Part^.Next;
		end;
	end;
begin
{$IFDEF PATCH_GH}
	if (NIL = Master) or (Master^.G <= GG_DisposeGear) then Exit(-1);
	if (NIL = FindThis) or (FindThis^.G <= GG_DisposeGear) then Exit(-1);
{$ENDIF PATCH_GH}
	N := 0;
	it := -1;
	if Master = FindThis then it := 0;
	CheckAlongPath( Master^.InvCom );
	CheckAlongPath( Master^.SubCom );
	FindGearIndex := it;
end; { FindGearIndex }

{$IFDEF DEBUG}
Function CountGearIndex( Master: GearPtr; DebugMode: Boolean; DebugMsg: String ): LongInt;
var
	N: LongInt;
	Procedure CheckAlongPath( Part: GearPtr );
	begin
		while (NIL <> Part) do begin
			if DebugMode or (GG_DisposeGear < Part^.G) then begin
				Inc(N);
				CheckAlongPath( Part^.InvCom );
				CheckAlongPath( Part^.SubCom );
			end;
			Part := Part^.Next;
		end;
	end;
begin
	if (NIL = Master) or (Master^.G <= GG_DisposeGear) then begin
		N := -1;
	end else begin
		N := 0;
		CheckAlongPath( Master^.InvCom );
		CheckAlongPath( Master^.SubCom );
	end;

	if 0 < Length(DebugMsg) then begin
		ErrorMessage_fork('TRACE: ' + DebugMsg + ': MaxNum is ' + IntToStr(N) + '.');
		DialogMsg('TRACE: ' + DebugMsg + ': MaxNum is ' + IntToStr(N) + '.');
	end;

	CountGearIndex := N;
end; { CountGearIndex }
{$ENDIF DEBUG}

Procedure AlphaKeyMenu( RPM: RPGMenuPtr );
	{ Alter this menu so that each item in it has a letter key }
	{ hotlinked. }
	{ This procedure has nothing to do with gears, but it's easier }
	{ to stick it here than keep two copies in the conmenus and }
	{ sdlmenus units. What I really need is a separate menu-utility }
	{ unit, I guess. }
{$IFDEF PATCH_GH}
const
	MENUKEY_TABLE_MAX = 20;
	MenuKey_Table: Array [1..MENUKEY_TABLE_MAX] of Integer = (
			KMC_Up,
			KMC_Down,
			KMC_Left,
			KMC_Right,
			KMC_UpRight,
			KMC_DownRight,
			KMC_UpLeft,
			KMC_DownLeft,
			KMC_MenuUp,
			KMC_MenuDown,
			KMC_MenuLeft,
			KMC_MenuRight,
			KMC_PageUp,
			KMC_PageDown,
			KMC_ScrollUp,
			KMC_ScrollDown,
			KMC_ButtonWUp,
			KMC_ButtonWDown,
			KMC_ButtonWLeft,
			KMC_ButtonWRight
		);
{$ENDIF PATCH_GH}
var
	Key: Char;
	MI: RPGMenuItemPtr;
{$IFDEF PATCH_GH}
	i: Integer;
{$ENDIF PATCH_GH}
{$IFDEF PATCH_GH}
label
	NextKey;
{$ENDIF PATCH_GH}
begin
	{ The hotkeys start with 'a'. }
	Key := 'a';

	MI := RPM^.firstitem;
	while MI <> Nil do begin
{$IFDEF PATCH_CHEAT}
		if #$0 = MI^.msg[1] then begin
			MI^.msg := '   ' + Copy( MI^.msg, 2, Length(MI^.msg) -1 );
		end else begin
			{ Alter the message. }
			MI^.msg := Key + ') ' + MI^.msg;

  {$IFDEF PATCH_GH}
			{ Add the key. }
			if ('*' <> Key) then begin
				AddRPGMenuKey( RPM , Key , MI^.value );
			end;

			{ Move to the next letter in the series. }
			{ note that only 52 letters can be assigned. }
			while ('*' <> Key) do begin
			NextKey:
				if ('z' = Key) then Key := 'A'
				else if ('Z' = Key) or ('*' = Key) then Key := '*'
				else inc( Key );
    {$IFDEF PATCH_l0ugh}
				if KeyBind_RogueMove then begin
					if (Key = 'b') then Key := 'c' {skip b}
					else if (Key = 'h') then Key := 'i' {skip h}
					else if (Key = 'j') then Key := 'm' {skip j,k,l}
					else if (Key = 'k') then Key := 'm' {skip k,l}
					else if (Key = 'l') then Key := 'm' {skip l}
					else if (Key = 'n') then Key := 'o' {skip n}
					else if (Key = 'u') then Key := 'v' {skip u}
					else if (Key = 'y') then Key := 'z' {skip y}
				end;
    {$ENDIF PATCH_l0ugh}
				if ('*' <> Key) then begin
					for i := 1 to MENUKEY_TABLE_MAX do begin
						if (KeyMap[ MenuKey_Table[i] ].KCode = Key) then begin
							goto NextKey;
						end;
					end;
				end;
				break;
			end;
  {$ELSE PATCH_GH}
			{ Add the key. }
			AddRPGMenuKey( RPM , Key , MI^.value );

			{ Move to the next letter in the series. }
			{ note that only 52 letters can be assigned. }
			if key = 'z' then key := 'A'
    {$IFDEF PATCH_l0ugh}
			else if KeyBind_RogueMove and (key = 'a') then key := 'c' {skip b}
			else if KeyBind_RogueMove and (key = 'g') then key := 'i' {skip h}
			else if KeyBind_RogueMove and (key = 'i') then key := 'm' {skip j,k,l}
			else if KeyBind_RogueMove and (key = 'j') then key := 'm' {skip k,l}
			else if KeyBind_RogueMove and (key = 'k') then key := 'm' {skip l}
			else if KeyBind_RogueMove and (key = 'm') then key := 'o' {skip n}
			else if KeyBind_RogueMove and (key = 't') then key := 'v' {skip u}
			else if KeyBind_RogueMove and (key = 'x') then key := 'z' {skip y}
    {$ENDIF PATCH_l0ugh}
    {$IFDEF PATCH_GH}
			else if ('Z' = key) or ('*' = key) then key := '*'
    {$ENDIF PATCH_GH}
			else inc( key );
  {$ENDIF PATCH_GH}
		end;
{$ELSE PATCH_CHEAT}
		{ Alter the message. }
		MI^.msg := Key + ') ' + MI^.msg;

		{ Add the key. }
  {$IFDEF PATCH_GH}
		{ Add the key. }
		if ('*' <> Key) then begin
			AddRPGMenuKey( RPM , Key , MI^.value );
		end;

		{ Move to the next letter in the series. }
		{ note that only 52 letters can be assigned. }
		while ('*' <> Key) do begin
		NextKey:
			if ('z' = Key) then Key := 'A'
			else if ('Z' = Key) or ('*' = Key) then Key := '*'
			else inc( Key );
    {$IFDEF PATCH_l0ugh}
			if KeyBind_RogueMove then begin
				if (Key = 'b') then Key := 'c' {skip b}
				else if (Key = 'h') then Key := 'i' {skip h}
				else if (Key = 'j') then Key := 'm' {skip j,k,l}
				else if (Key = 'k') then Key := 'm' {skip k,l}
				else if (Key = 'l') then Key := 'm' {skip l}
				else if (Key = 'n') then Key := 'o' {skip n}
				else if (Key = 'u') then Key := 'v' {skip u}
				else if (Key = 'y') then Key := 'z' {skip y}
			end;
    {$ENDIF PATCH_l0ugh}
			if ('*' <> Key) then begin
				for i := 1 to MENUKEY_TABLE_MAX do begin
					if (KeyMap[ MenuKey_Table[i] ].KCode = Key) then begin
						goto NextKey;
					end;
				end;
			end;
			break;
		end;
  {$ELSE PATCH_GH}
		AddRPGMenuKey( RPM , Key , MI^.value );

		{ Move to the next letter in the series. }
		{ note that only 52 letters can be assigned. }
		if key = 'z' then key := 'A'
    {$IFDEF PATCH_l0ugh}
		else if KeyBind_RogueMove and (key = 'a') then key := 'c' {skip b}
		else if KeyBind_RogueMove and (key = 'g') then key := 'i' {skip h}
		else if KeyBind_RogueMove and (key = 'i') then key := 'm' {skip j,k,l}
		else if KeyBind_RogueMove and (key = 'j') then key := 'm' {skip k,l}
		else if KeyBind_RogueMove and (key = 'k') then key := 'm' {skip l}
		else if KeyBind_RogueMove and (key = 'm') then key := 'o' {skip n}
		else if KeyBind_RogueMove and (key = 't') then key := 'v' {skip u}
		else if KeyBind_RogueMove and (key = 'x') then key := 'z' {skip y}
    {$ENDIF PATCH_l0ugh}
		else inc( key );
  {$ENDIF PATCH_GH}
{$ENDIF PATCH_CHEAT}

		MI := MI^.Next;
	end;
end;



initialization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: menugear.pp');
{$ENDIF DEBUG}
end;

finalization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: menugear.pp(finalization)');
{$ENDIF DEBUG}
end;

end.
