{$IFDEF PATCH_GH}
unit pseudosmartpointer;
{ Pseudo Smart Pointer }
{ This unit is only for single threading programs. }

interface

type
	PointerPtr = ^Pointer;

{$IFDEF DEBUG}
var
	DEBUG_MemoryLeak : Boolean = True;
{$ENDIF DEBUG}

Procedure Trace_MemoryLeak( Msg: String; P: Pointer );
Procedure Attach_SmartPointer( const Msg: String; const it: PointerPtr );
Function CheckAndNIL_Pointer( const Msg: String; const it: Pointer; const ErrorMode: Boolean ): Boolean;



implementation

uses sysutils, errmsg;

type
	PseudoSmartPointerListPtr = ^PseudoSmartPointerList;
	PseudoSmartPointerList = Record
		P: PointerPtr;
		Msg: String;
		next: PseudoSmartPointerListPtr;
	end;

var
	Top : PseudoSmartPointerListPtr;



Procedure Trace_MemoryLeak( Msg: String; P: Pointer );
begin
{$IFDEF DEBUG}
	if DEBUG_MemoryLeak then begin
		ErrorMessage_fork( 'MEMORY_TRACE: ' + Msg + ' :' + IntToHex(Int64(P), 16) );
	end;
{$ENDIF DEBUG}
end;



Procedure Attach_SmartPointer( const Msg: String; const it: PointerPtr );
var
	next: PseudoSmartPointerListPtr;
begin
	New( next );
	Trace_MemoryLeak('Attach_SmartPointer() New',next);
	next^.P    := it;
	next^.Msg  := Msg;
	next^.next := Top;
	Top := next;
end;



Function CheckAndNIL_Pointer( const Msg: String; const it: Pointer; const ErrorMode: Boolean ): Boolean;
var
	hit: Boolean = False;
	checkptr: PseudoSmartPointerListPtr;
begin
	checkptr := Top;
	while NIL <> checkptr do begin
		if it = checkptr^.P^ then begin
			if '' <> Msg then begin
				if ErrorMode then begin
					ErrorMessage_fork('ERROR: ' + Msg + ' (' + checkptr^.Msg + ') is purged. :' + IntToHex(Int64(it), 16) );
				end else begin
{$IFDEF DEBUG}
					ErrorMessage_fork('WARNING: ' + Msg + ' (' + checkptr^.Msg + ') is purged. :' + IntToHex(Int64(it), 16) );
{$ENDIF DEBUG}
				end;
			end;
			checkptr^.P^ := NIL;
			hit := True;
		end;
		checkptr := checkptr^.next;
	end;
	CheckAndNIL_Pointer := hit;
end;



Procedure Purge();
var
	n2: PseudoSmartPointerListPtr;
begin
	while NIL <> Top do begin
		n2 := Top^.next;
		Trace_MemoryLeak('Purge() Dispose',Top);
		Dispose( Top );
		Top := n2;
	end;
	Top := NIL;
end;



initialization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: pseudosmartpointer.pp');
{$ENDIF DEBUG}
	Top := NIL;
end;

finalization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: pseudosmartpointer.pp(finalization)');
{$ENDIF DEBUG}
	Purge();
end;

end.
{$ENDIF PATCH_GH}
