unit ui4gh;
	{ User Interface for GearHead. }
	{ This unit exists to keep me from copying changes back and forth between }
	{ the SDL mode units and the CRT mode units... }
{
	GearHead: Arena, a roguelike mecha CRPG
	Copyright (C) 2005 Joseph Hewitt

	This library is free software; you can redistribute it and/or modify it
	under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation; either version 2.1 of the License, or (at
	your option) any later version.

	The full text of the LGPL can be found in license.txt.

	This library is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
	General Public License for more details. 

	You should have received a copy of the GNU Lesser General Public License
	along with this library; if not, write to the Free Software Foundation,
	Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
}


interface

{$IFDEF PATCH_GH}
  {$IFDEF SDLMODE}
uses	SDL;
  {$ENDIF SDLMODE}
{$ENDIF PATCH_GH}

type
	KeyMapDesc = Record
		CmdName,CmdDesc: String;
		KCode: Char;
	end;

{$IFDEF PATCH_GH}
	KeyMapAliasDesc = Record
		CmdAlias: String;
		CmdName: String;
	end;
{$ENDIF PATCH_GH}

{$IFDEF PATCH_I18N}
	FontSearchNameDesc = Record
		FontFile: String;
		FontFace: Integer;
		FontSize: Integer;
	end;
	PFontSearchNameDesc = ^FontSearchNameDesc;
{$ENDIF PATCH_I18N}

const
{$IFDEF SDLMODE}
	RPK_UpRight = #$89;
	RPK_Up = #$88;
	RPK_UpLeft = #$87;
	RPK_Left = #$84;
	RPK_Right = #$86;
	RPK_DownRight = #$81;
	RPK_Down = #$82;
	RPK_DownLeft = #$83;
	RPK_MouseButton = #$90;
	RPK_TimeEvent = #$91;
	RPK_RightButton = #$92;
  {$IFDEF PATCH_GH}
	RPK_MouseButtonRelease = #$93;
	RPK_MouseMotion = #$94;
  {$ENDIF PATCH_GH}

	FrameDelay: Integer = 50;
{$ELSE}
	RPK_UpRight = '9';
	RPK_Up = '8';
	RPK_UpLeft = '7';
	RPK_Left = '4';
	RPK_Right = '6';
	RPK_DownRight = '3';
	RPK_Down = '2';
	RPK_DownLeft = '1';

	FrameDelay: Integer = 100;
{$ENDIF}

	MenuBasedInput = 0;
	RLBasedInput = 1;
	ControlMethod: Byte = MenuBasedInput;
	CharacterMethod: Byte = RLBasedInput;
	WorldMapMethod: Byte = RLBasedInput;
	{ PATCH_I18N: Converted by Load_I18N_Default }
	ControlTypeName: Array [0..1] of string = ('Menu','Roguelike');

	DoFullScreen: Boolean = False;
	Mouse_Active: Boolean = True;

	Always_Save_Character: Boolean = False;
	No_Combat_Taunts: Boolean = False;
	Pillage_On: Boolean = True;

	TacticsRoundLength: Integer = 60;

	PC_SHOULD_RUN: Boolean = False;

	BV_Off = 1;
	BV_Quarter = 2;
	BV_Half = 3;
	BV_Max = 4;
	DefMissileBV: Byte = BV_Quarter;
	DefBallisticBV: Byte = BV_Max;
	DefBeamgunBV: Byte = BV_Max;
	{ PATCH_I18N: Converted by Load_I18N_Default }
	BVTypeName: Array [1..4] of string = ('Off','1/4','1/2','Max');

	DoAutoSave: Boolean = True;

	Use_Alpha_Blending: Boolean = True;
	Alpha_Level: Byte = 135;

	Names_Above_Heads: Boolean = False;

	Max_Plots_Per_Adventure: Byte = 50;
	Load_Plots_At_Start: Boolean = False;

	Display_Mini_Map: Boolean = False;

	UseTacticsMode: Boolean = False;

	UseAdvancedColoring: Boolean = False;

	{ *** SCREEN DIMENSIONS *** }
	ScreenRows: Byte = 25;
	ScreenColumns: Byte = 80;

{$IFDEF PATCH_GH}
	Direct_Skill_Learning: Boolean = False;
{$ENDIF PATCH_GH}


{$IFDEF ENABLE_ADDRESSBOOK}
	NumMappedKeys_ADDRESSBOOK = 1;
{$ELSE ENABLE_ADDRESSBOOK}
	NumMappedKeys_ADDRESSBOOK = 0;
{$ENDIF ENABLE_ADDRESSBOOK}
{$IFDEF PATCH_JPSSDL}
	NumMappedKeys_JPSSDL = 1;
{$ELSE PATCH_JPSSDL}
	NumMappedKeys_JPSSDL = 0;
{$ENDIF PATCH_JPSSDL}
{$IFDEF PATCH_GH}
	NumMappedKeys_GH = 17;
{$ELSE PATCH_GH}
	NumMappedKeys_GH = 0;
{$ENDIF PATCH_GH}
{$IFDEF PATCH_CHEAT}
	NumMappedKeys_CHEAT = 5;
{$ELSE PATCH_CHEAT}
	NumMappedKeys_CHEAT = 0;
{$ENDIF PATCH_CHEAT}
{$IFDEF DEBUG}
	NumMappedKeys_DEBUG = 1;
{$ELSE DEBUG}
	NumMappedKeys_DEBUG = 0;
{$ENDIF DEBUG}
	NumMappedKeys = 47 + NumMappedKeys_ADDRESSBOOK + NumMappedKeys_JPSSDL + NumMappedKeys_GH + NumMappedKeys_CHEAT + NumMappedKeys_DEBUG;
	KeyMap: Array [1..NumMappedKeys] of KeyMapDesc = (
	(	CmdName: 'NormSpeed';
		CmdDesc: 'Travel foreword at normal speed.';
		KCode: '=';	),
	(	CmdName: 'FullSpeed';
		CmdDesc: 'Travel foreword at maximum speed';
		KCode: '+';	),
	(	CmdName: 'TurnLeft';
		CmdDesc: 'Turn to the left.';
		KCode: '[';	),
	(	CmdName: 'TurnRight';
		CmdDesc: 'Turn to the right.';
		KCode: ']';	),
	(	CmdName: 'Stop';
		CmdDesc: 'Stop moving, wait in place.';
		KCode: '5';	),

{$IFDEF SDLMODE}
{ In SDL Mode, the direction keys for movement need to be shifted }
{ in order to match the isometric display. }
	(	CmdName: 'Dir-SouthWest';
		CmdDesc: 'Move southwest.';
		KCode: RPK_Left;	),
	(	CmdName: 'Dir-South';
		CmdDesc: 'Move south.';
		KCode: RPK_DownLeft;	),
	(	CmdName: 'Dir-SouthEast';
		CmdDesc: 'Move southeast.';
		KCode: RPK_Down;	),
	(	CmdName: 'Dir-West';
		CmdDesc: 'Move west.';
		KCode: RPK_UpLeft;	),
	(	CmdName: 'Dir-East';
		CmdDesc: 'Move east.';
		KCode: RPK_DownRight;	),

	(	CmdName: 'Dir-NorthWest';
		CmdDesc: 'Move northwest.';
		KCode: RPK_Up;	),
	(	CmdName: 'Dir-North';
		CmdDesc: 'Move north.';
		KCode: RPK_UpRight;	),
	(	CmdName: 'Dir-NorthEast';
		CmdDesc: 'Move northeast.';
		KCode: RPK_Right;	),
{$ELSE SDLMODE}
	(	CmdName: 'Dir-SouthWest';
		CmdDesc: 'Move southwest.';
		KCode: RPK_DownLeft;	),
	(	CmdName: 'Dir-South';
		CmdDesc: 'Move south.';
		KCode: RPK_Down;	),
	(	CmdName: 'Dir-SouthEast';
		CmdDesc: 'Move southeast.';
		KCode: RPK_DownRight;	),
	(	CmdName: 'Dir-West';
		CmdDesc: 'Move west.';
		KCode: RPK_Left;	),
	(	CmdName: 'Dir-East';
		CmdDesc: 'Move east.';
		KCode: RPK_Right;	),

	(	CmdName: 'Dir-NorthWest';
		CmdDesc: 'Move northwest.';
		KCode: RPK_UpLeft;	),
	(	CmdName: 'Dir-North';
		CmdDesc: 'Move north.';
		KCode: RPK_Up;	),
	(	CmdName: 'Dir-NorthEast';
		CmdDesc: 'Move northeast.';
		KCode: RPK_UpRight;	),
{$ENDIF SDLMODE}

	(	CmdName: 'ShiftGears';
		CmdDesc: 'Change movement mode.';
		KCode: '.';	),
	(	CmdName: 'Look';
		CmdDesc: 'Look around the map.';
		KCode: 'l';	),

	(	CmdName: 'AttackMenu';
		CmdDesc: 'Access the attack menu.';
		KCode: 'A';	),
	(	CmdName: 'QuitGame';
		CmdDesc: 'Exit the game.';
		KCode: 'Q';	),
	(	CmdName: 'Talk';
		CmdDesc: 'Initiate conversation with a NPC.';
		KCode: 't';	),
	(	CmdName: 'Help';
		CmdDesc: 'View these helpful messages.';
		KCode: 'h';	),
	(	CmdName: 'SwitchWeapon';
		CmdDesc: 'Change the active weapon while selecting a target.';
		KCode: '.';	),

	(	CmdName: 'CalledShot';
		CmdDesc: 'Toggle the Called Shot option while selecting a target.';
		KCode: '/';	),
	(	CmdName: 'Recenter';
		CmdDesc: 'Recenter the display on the currently active character.';
		KCode: 'R';	),
	(	CmdName: 'Get';
		CmdDesc: 'Pick up an item lying on the ground.';
		KCode: ',';	),
	(	CmdName: 'Inventory';
		CmdDesc: 'Access all carried items.';
		KCode: 'i';	),
	(	CmdName: 'Equipment';
		CmdDesc: 'Access all equipped items.';
		KCode: 'e';	),

	{ Commands 26 - 30 }
	(	CmdName: 'Enter';
		CmdDesc: 'Use a stairway or portal.';
		KCode: '>';	),
	(	CmdName: 'PartBrowser';
		CmdDesc: 'Examine the individual components of your PC.';
		KCode: 'B';	),
	(	CmdName: 'LearnSkills';
		CmdDesc: 'Spend accumulated experience points.';
		KCode: 'L';	),
	(	CmdName: 'Attack';
		CmdDesc: 'Perform an attack.';
		KCode: 'a';	),
	(	CmdName: 'SelectMecha';
		CmdDesc: 'Choose the mecha that will be used by this PC in combat.';
		KCode: 'M';	),

	{ Commands 31 - 35 }
	(	CmdName: 'UseScenery';
		CmdDesc: 'Activate a stationary item, such as a door or a computer.';
		KCode: 'u';	),
	(	CmdName: 'Messages';
		CmdDesc: 'Review all current adventure memos, email, and news.';
		KCode: 'm';	),
	(	CmdName: 'SaveGame';
		CmdDesc: 'Write the game data to disk, so you can come back and waste time later.';
		KCode: 'X';	),
	(	CmdName: 'Enter2';
		CmdDesc: 'Use a stairway or portal.';
		KCode: '<';	),
	(	CmdName: 'CharInfo';
		CmdDesc: 'View detailed information about your character, access option menus.';
		KCode: 'C';	),

	{ Commands 36 - 40 }
	(	CmdName: 'FirstAid';
		CmdDesc: 'Use the first aid skill to restore health points.';
		KCode: 'F';	),
	(	CmdName: 'ApplySkill';
		CmdDesc: 'Select and use a skill that the PC knows.';
		KCode: 's';	),
	(	CmdName: 'Eject';
		CmdDesc: 'Eject from your mecha and abandon it on the field.';
		KCode: 'E';	),
	(	CmdName: 'Rest';
		CmdDesc: 'Take a break for one hour of game time.';
		KCode: 'Z';	),
	(	CmdName: 'History';
		CmdDesc: 'Display past messages.';
		KCode: 'V';	),

	{ Commands 41 - 45 }
	(	CmdName: 'FieldHQ';
		CmdDesc: 'Examine and edit your personal wargear.';
		KCode: 'H';	),
	(	CmdName: 'Search';
		CmdDesc: 'Check the area for enemies and secrets.';
		KCode: 'S';	),
	(	CmdName: 'Telephone';
		CmdDesc: 'Place a telephone call to a local NPC.';
		KCode: 'T';	),
	(	CmdName: 'SwitchBV';
		CmdDesc: 'Switch the Burst Fire option while selecting a target.';
		KCode: '>';	),
	(	CmdName: 'Reverse';
		CmdDesc: 'Travel backward at normal speed.';
		KCode: '-';	),

	{ Commands 46 - 50 }
	(	CmdName: 'SwitchTarget';
		CmdDesc: 'Switch to next visible enemy when selecting a target.';
		KCode: ';';	),
	(	CmdName: 'RunToggle';
		CmdDesc: 'Toggle running on or off.';
		KCode: 'r';	)

{$IFDEF ENABLE_ADDRESSBOOK}
	,
	(	CmdName: 'AddressBook';
		CmdDesc: 'Use AddressBook.';
		KCode:	'b'; )
{$ENDIF ENABLE_ADDRESSBOOK}
{$IFDEF PATCH_JPSSDL}
	,
	(	CmdName: 'ToggleDrawWall';
		CmdDesc: 'Toggle Draw Wall.';
		KCode:	'0'; )
{$ENDIF PATCH_JPSSDL}
{$IFDEF PATCH_GH}
	,
	(	CmdName: 'ForcePlot';
		CmdDesc: '';
		KCode:	'P'; )
	,
	(	CmdName: 'MechaPartBrowser';
		CmdDesc: '';
		KCode:	'!'; )
	,
	(	CmdName: 'ShowRep';
		CmdDesc: '';
		KCode:	'@'; )
	,
	(	CmdName: 'DirectScript';
		CmdDesc: '';
		KCode:	'#'; )
	,
	(	CmdName: 'WheelClick';
		CmdDesc: 'Do the key event when a mouse wheel is clicked.';
		KCode:	'5'; )
	,
	(	CmdName: 'WheelUp';
		CmdDesc: 'Do the key event when a mouse wheel is rolled to up.';
		KCode:	'['; )
	,
	(	CmdName: 'WheelDown';
		CmdDesc: 'Do the key event when a mouse wheel is rolled to down.';
		KCode:	']'; )
	,
	(	CmdName: 'WheelLeft';
		CmdDesc: 'Do the key event when a mouse wheel is rolled to left.';
		KCode:	'-'; )
	,
	(	CmdName: 'WheelRight';
		CmdDesc: 'Do the key event when a mouse wheel is rolled to right.';
		KCode:	'='; )
	,
	(	CmdName: 'Menu-Up';
		CmdDesc: 'Move up.';
		KCode: RPK_Up;	),
	(	CmdName: 'Menu-Down';
		CmdDesc: 'Move down.';
		KCode: RPK_Down;	),
	(	CmdName: 'Menu-Left';
		CmdDesc: 'Move left.';
		KCode: RPK_Left;	),
	(	CmdName: 'Menu-Right';
		CmdDesc: 'Move right.';
		KCode: RPK_Right;	),
	(	CmdName: 'Menu-PageUp';
		CmdDesc: 'Page up.';
		KCode: RPK_UpRight;	),
	(	CmdName: 'Menu-PageDown';
		CmdDesc: 'Page down.';
		KCode: RPK_DownRight;	),
	(	CmdName: 'Menu-ScrollUp';
		CmdDesc: 'Scroll Up.';
		KCode: RPK_UpLeft;	),
	(	CmdName: 'Menu-ScrollDown';
		CmdDesc: 'Scroll down.';
		KCode: RPK_DownLeft;	)
{$ENDIF PATCH_GH}
{$IFDEF PATCH_CHEAT}
	,
	(	CmdName: 'SelectPortrait';
		CmdDesc: '';
		KCode:	'/'; )
	,
	(	CmdName: 'RenameMecha';
		CmdDesc: '';
		KCode:	'@'; )
	,
	(	CmdName: 'EditMenuOrder';
		CmdDesc: '';
		KCode:	'\'; )
	,
	(	CmdName: 'Transformation';
		CmdDesc: 'Change form mode.';
		KCode: '*';	)
	,
	(	CmdName: 'PurgeParts';
		CmdDesc: 'Purge parts form mecha.';
		KCode: '*';	)
{$ENDIF PATCH_CHEAT}
{$IFDEF DEBUG}
	,
	(	CmdName: 'CanSeeAll';
		CmdDesc: '';
		KCode:	'~'; )
{$ENDIF DEBUG}
	);

{$IFDEF PATCH_GH}
	KeyMapAliasMax = 9;

	KeyMapAlias: Array [1..KeyMapAliasMax] of KeyMapAliasDesc = (
  {$IFDEF SDLMODE}
	(	CmdAlias: 'Dir-UpLeft';		CmdName:  'Dir-West'; ),
	(	CmdAlias: 'Dir-Up';		CmdName:  'Dir-NorthWest'; ),
	(	CmdAlias: 'Dir-UpRight';	CmdName:  'Dir-North'; ),
	(	CmdAlias: 'Dir-Left';		CmdName:  'Dir-SouthWest'; ),
	(	CmdAlias: 'Dir-Right';		CmdName:  'Dir-NorthEast'; ),
	(	CmdAlias: 'Dir-DownLeft';	CmdName:  'Dir-South'; ),
	(	CmdAlias: 'Dir-Down';		CmdName:  'Dir-SouthEast'; ),
	(	CmdAlias: 'Dir-DownRight';	CmdName:  'Dir-East'; ),
  {$ELSE SDLMODE}
	(	CmdAlias: 'Dir-UpLeft';		CmdName:  'Dir-NorthWest'; ),
	(	CmdAlias: 'Dir-Up';		CmdName:  'Dir-North'; ),
	(	CmdAlias: 'Dir-UpRight';	CmdName:  'Dir-NorthEast'; ),
	(	CmdAlias: 'Dir-Left';		CmdName:  'Dir-West'; ),
	(	CmdAlias: 'Dir-Right';		CmdName:  'Dir-East'; ),
	(	CmdAlias: 'Dir-DownLeft';	CmdName:  'Dir-SouthWest'; ),
	(	CmdAlias: 'Dir-Down';		CmdName:  'Dir-South'; ),
	(	CmdAlias: 'Dir-DownRight';	CmdName:  'Dir-SouthEast'; ),
  {$ENDIF SDLMODE}
	( CmdAlias: ''; CmdName:  ''; )
	);
{$ENDIF PATCH_GH}

	{ *** KEYMAP COMMAND NUMBERS *** }
	KMC_NormSpeed = 1;
	KMC_FullSpeed = 2;
	KMC_TurnLeft = 3;
	KMC_TurnRight = 4;
	KMC_Stop = 5;
	KMC_SouthWest = 6;
	KMC_South = 7;
	KMC_SouthEast = 8;
	KMC_West = 9;
	KMC_East = 10;
	KMC_NorthWest = 11;
	KMC_North = 12;
	KMC_NorthEast = 13;
{$IFDEF PATCH_GH}
  {$IFDEF SDLMODE}
	KMC_UpLeft = 9;
	KMC_Up = 11;
	KMC_UpRight = 12;
	KMC_Left = 6;
	KMC_Right = 13;
	KMC_DownLeft = 7;
	KMC_Down = 8;
	KMC_DownRight = 10;
  {$ELSE SDLMODE}
	KMC_UpLeft = 11;
	KMC_Up = 12;
	KMC_UpRight = 13;
	KMC_Left = 9;
	KMC_Right = 10;
	KMC_DownLeft = 6;
	KMC_Down = 7;
	KMC_DownRight = 8;
  {$ENDIF SDLMODE}
{$ENDIF PATCH_GH}
	KMC_ShiftGears = 14;
	KMC_ExamineMap = 15;
	KMC_AttackMenu = 16;
	KMC_QuitGame = 17;
	KMC_Talk = 18;
	KMC_Help = 19;
	KMC_SwitchWeapon = 20;
	KMC_CalledShot = 21;
	KMC_Recenter = 22;
	KMC_Get = 23;
	KMC_Inventory = 24;
	KMC_Equipment = 25;
	KMC_Enter = 26;
	KMC_PartBrowser = 27;
	KMC_LearnSkills = 28;
	KMC_Attack = 29;
	KMC_SelectMecha = 30;
	KMC_UseProp = 31;
	KMC_ViewMemo = 32;
	KMC_SaveGame = 33;
	KMC_Enter2 = 34;
	KMC_CharInfo = 35;
	KMC_FirstAid = 36;
	KMC_ApplySkill = 37;
	KMC_Eject = 38;
	KMC_Rest = 39;
	KMC_History = 40;
	KMC_FieldHQ = 41;
	KMC_Search = 42;
	KMC_Telephone = 43;
	KMC_SwitchBV = 44;
	KMC_Reverse = 45;
	KMC_SwitchTarget = 46;
	KMC_RunToggle = 47;
{$IFDEF ENABLE_ADDRESSBOOK}
	KMC_AddressBook = KMC_RunToggle + 1;
	KMC_AddressBook_NEXT = KMC_RunToggle + 2;
{$ELSE ENABLE_ADDRESSBOOK}
	KMC_AddressBook_NEXT = KMC_RunToggle + 1;
{$ENDIF ENABLE_ADDRESSBOOK}
{$IFDEF PATCH_JPSSDL}
	KMC_ToggleDrawWall = KMC_AddressBook_NEXT;
	KMC_ToggleDrawWall_NEXT = KMC_AddressBook_NEXT + 1;
{$ELSE PATCH_JPSSDL}
	KMC_ToggleDrawWall_NEXT = KMC_AddressBook_NEXT;
{$ENDIF PATCH_JPSSDL}
{$IFDEF PATCH_GH}
	KMC_ForcePlot        = KMC_ToggleDrawWall_NEXT;
	KMC_MechaPartBrowser = KMC_ToggleDrawWall_NEXT + 1;
	KMC_ShowRep          = KMC_ToggleDrawWall_NEXT + 2;
	KMC_DirectScript     = KMC_ToggleDrawWall_NEXT + 3;
	KMC_ButtonMiddle     = KMC_ToggleDrawWall_NEXT + 4;
	KMC_ButtonWUp        = KMC_ToggleDrawWall_NEXT + 5;
	KMC_ButtonWDown      = KMC_ToggleDrawWall_NEXT + 6;
	KMC_ButtonWLeft      = KMC_ToggleDrawWall_NEXT + 7;
	KMC_ButtonWRight     = KMC_ToggleDrawWall_NEXT + 8;
	KMC_MenuUp           = KMC_ToggleDrawWall_NEXT + 9;
	KMC_MenuDown         = KMC_ToggleDrawWall_NEXT + 10;
	KMC_MenuLeft         = KMC_ToggleDrawWall_NEXT + 11;
	KMC_MenuRight        = KMC_ToggleDrawWall_NEXT + 12;
	KMC_PageUp           = KMC_ToggleDrawWall_NEXT + 13;
	KMC_PageDown         = KMC_ToggleDrawWall_NEXT + 14;
	KMC_ScrollUp         = KMC_ToggleDrawWall_NEXT + 15;
	KMC_ScrollDown       = KMC_ToggleDrawWall_NEXT + 16;
	KMC_PATCH_GH_NEXT    = KMC_ToggleDrawWall_NEXT + 17;
{$ELSE PATCH_GH}
	KMC_PATCH_GH_NEXT = KMC_ToggleDrawWall_NEXT;
{$ENDIF PATCH_GH}
{$IFDEF PATCH_CHEAT}
	KMC_SelectPortrait = KMC_PATCH_GH_NEXT;
	KMC_RenameMecha    = KMC_PATCH_GH_NEXT + 1;
	KMC_EditMenuOrder  = KMC_PATCH_GH_NEXT + 2;
	KMC_Transformation = KMC_PATCH_GH_NEXT + 3;
	KMC_PurgeParts     = KMC_PATCH_GH_NEXT + 4;
	KMC_PATCH_CHEAT_NEXT = KMC_PATCH_GH_NEXT + 5;
{$ELSE PATCH_CHEAT}
	KMC_PATCH_CHEAT_NEXT = KMC_PATCH_GH_NEXT;
{$ENDIF PATCH_CHEAT}
{$IFDEF DEBUG}
	KMC_CanSeeAll  = KMC_PATCH_CHEAT_NEXT;
	KMC_DEBUG_NEXT = KMC_PATCH_CHEAT_NEXT + 1;
{$ELSE DEBUG}
	KMC_DEBUG_NEXT = KMC_PATCH_CHEAT_NEXT;
{$ENDIF DEBUG}

{$IFDEF PATCH_I18N}
  {$IFDEF UNIX}
	MaxFontSearchDirNum = 7;
	FontSearchDir: Array [1..MaxFontSearchDirNum] of String = (
		'',					{ Read from arena.cfg }
		'Image',				{ default directory }
		'',					{ current directory }
    {$IFDEF FONTFILE_USR_X11R6}
		'/usr/X11R6/lib/X11/fonts/TrueType',	{ FreeBSD 6.2 and before, some Distribution of GNU/Linux }
		{$DEFINE _FONTDIR_2}
    {$ENDIF}
    {$IFDEF FONTFILE_USR_LOCAL}
		'/usr/local/lib/X11/fonts/TrueType',	{ FreeBSD 6.3 and later }
		{$DEFINE _FONTDIR_2}
    {$ENDIF}
    {$IFDEF FONTFILE_USR_SHARE}
		'/usr/share/fonts/truetype/sazanami',	{ Debian GNU/Linux }
		{$DEFINE _FONTDIR_2}
    {$ENDIF}
    {$IFNDEF _FONTDIR_2}
		'',
    {$ENDIF _FONTDIR_2}
		'/usr/X11R6/lib/X11/fonts/TrueType',	{ FreeBSD 6.2 and before, some Distribution of GNU/Linux }
		'/usr/local/lib/X11/fonts/TrueType',	{ FreeBSD 6.3 and later }
		'/usr/share/fonts/truetype/sazanami'	{ Debian GNU/Linux }
	);
	MaxFontSearchNameNum = 11;
	FontSearchName_Big: Array [1..MaxFontSearchNameNum] of FontSearchNameDesc = (
		(	{ Read from arena.cfg }
			FontFile: '';
			FontFace: 0;
			FontSize: 14;
		), (	{ Read from GameData/I18N_messages.txt }
			FontFile: '';
			FontFace: 0;
			FontSize: 14;
		), (	{ Normal Font, 1 }
			FontFile: 'sazanami-gothic.ttf';
			FontFace: 0;
			FontSize: 14;
		), (	{ Normal Font, 2 }
			FontFile: 'sazanami-mincho.ttf';
			FontFace: 0;
			FontSize: 14;
		), (	{ Normal Font, 3 }
			FontFile: 'ipag.ttf';
			FontFace: 0;
			FontSize: 14;
		), (	{ Normal Font, 4 }
			FontFile: 'ipam.ttf';
			FontFace: 0;
			FontSize: 14;
		), (	{ Normal Font, 5 }
			FontFile: 'kochi-gothic-subst.ttf';
			FontFace: 0;
			FontSize: 14;
		), (	{ Normal Font, 6 }
			FontFile: 'kochi-mincho-subst.ttf';
			FontFace: 0;
			FontSize: 14;
		), (	{ Normal Font, 7 }
			FontFile: 'kochi-gothic.ttf';
			FontFace: 0;
			FontSize: 14;
		), (	{ Normal Font, 8 }
			FontFile: 'kochi-mincho.ttf';
			FontFace: 0;
			FontSize: 14;
		), (	{ Default font }
			FontFile: 'VeraBd.ttf';
			FontFace: 0;
			FontSize: 14;
		)
	);
	FontSearchName_Small: Array [1..MaxFontSearchNameNum] of FontSearchNameDesc = (
		(	{ Read from arena.cfg }
			FontFile: '';
			FontFace: 0;
			FontSize: 11;
		), (	{ Read from GameData/I18N_messages.txt }
			FontFile: '';
			FontFace: 0;
			FontSize: 11;
		), (	{ Normal Font, 1 }
			FontFile: 'sazanami-gothic.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Normal Font, 2 }
			FontFile: 'sazanami-mincho.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Normal Font, 3 }
			FontFile: 'ipag.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Normal Font, 4 }
			FontFile: 'ipam.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Normal Font, 5 }
			FontFile: 'kochi-gothic-subst.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Normal Font, 6 }
			FontFile: 'kochi-mincho-subst.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Normal Font, 7 }
			FontFile: 'kochi-gothic.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Normal Font, 8 }
			FontFile: 'kochi-mincho.ttf';
			FontFace: 0;
			FontSize: 12;
		), (	{ Default font }
			FontFile: 'VeraMoBd.ttf';
			FontFace: 0;
			FontSize: 11;
		)
	);
	{$DEFINE _FONTSEARCH_}
  {$ENDIF UNIX}
  {$IFDEF Windows}
	MaxFontSearchDirNum = 6;
	FontSearchDir: Array [1..MaxFontSearchDirNum] of String = (
		'',			{ Read from arena.cfg }
		'Image',		{ default directory }
		'',			{ current directory }
		'',			{ Read environment %windir% or %SystemRoot% }
		'C:\WINDOWS\Fonts',	{ MS-Windows XP }
		'C:\WINNT\Fonts'	{ MS-Windows 2000 }
	);
	MaxFontSearchNameNum = 6;
	FontSearchName_Big: Array [1..MaxFontSearchNameNum] of FontSearchNameDesc = (
		(	{ Read from arena.cfg }
			FontFile: '';
			FontFace: 0;
			FontSize: 15;
		), (	{ Read from GameData/I18N_messages.txt }
			FontFile: '';
			FontFace: 0;
			FontSize: 14;
		), (	{ Normal Font, 1 }
			FontFile: 'meiryo.ttc';
			FontFace: 0;
			FontSize: 15;
		), (	{ Normal Font, 2 }
			FontFile: 'msgothic.ttc';
			FontFace: 0;
			FontSize: 15;
		), (	{ Normal Font, 3 }
			FontFile: 'msmincho.ttc';
			FontFace: 0;
			FontSize: 15;
		), (	{ Default font }
			FontFile: 'VeraBd.ttf';
			FontFace: 0;
			FontSize: 14;
		)
	);
	FontSearchName_Small: Array [1..MaxFontSearchNameNum] of FontSearchNameDesc = (
		(	{ Read from arena.cfg }
			FontFile: '';
			FontFace: 0;
			FontSize: 13;
		), (	{ Read from GameData/I18N_messages.txt }
			FontFile: '';
			FontFace: 0;
			FontSize: 11;
		), (	{ Normal Font, 1 }
			FontFile: 'meiryo.ttc';
			FontFace: 0;
			FontSize: 13;
		), (	{ Normal Font, 2 }
			FontFile: 'msgothic.ttc';
			FontFace: 0;
			FontSize: 13;
		), (	{ Normal Font, 3 }
			FontFile: 'msmincho.ttc';
			FontFace: 0;
			FontSize: 13;
		), (	{ Default font }
			FontFile: 'VeraMoBd.ttf';
			FontFace: 0;
			FontSize: 11;
		)
	);
	{$DEFINE _FONTSEARCH_}
  {$ENDIF Windows}
  {$IFNDEF _FONTSEARCH_}
	MaxFontSearchDirNum = 3;
	FontSearchDir: Array [1..MaxFontSearchDirNum] of String = (
		'',			{ Read from arena.cfg }
		'Image',		{ default directory }
		''			{ current directory }
	);
	MaxFontSearchNameNum = 3;
	FontSearchName_Big: Array [1..MaxFontSearchNameNum] of FontSearchNameDesc = (
		(	{ Read from arena.cfg }
			FontFile: '';
			FontFace: 0;
			FontSize: 14;
		), (	{ Read from GameData/I18N_messages.txt }
			FontFile: '';
			FontFace: 0;
			FontSize: 14;
		), (	{ Default font }
			FontFile: 'VeraBd.ttf';
			FontFace: 0;
			FontSize: 14;
		)
	);
	FontSearchName_Small: Array [1..MaxFontSearchNameNum] of FontSearchNameDesc = (
		(	{ Read from arena.cfg }
			FontFile: '';
			FontFace: 0;
			FontSize: 11;
		), (	{ Read from GameData/I18N_messages.txt }
			FontFile: '';
			FontFace: 0;
			FontSize: 11;
		), (	{ Default font }
			FontFile: 'VeraMoBd.ttf';
			FontFace: 0;
			FontSize: 11;
		)
	);
	{$DEFINE _FONTSEARCH_}
  {$ENDIF _FONTSEARCH_}

	FontSize_Big: Integer = 0;
	FontSize_Small: Integer = 0;
	{ PATCH_I18N: Converted by Load_I18N_Default }
	ProhibitationHead  : String = '! ) , . > ? ] }';
	ProhibitationTrail : String = '( < [ {';
{$ENDIF PATCH_I18N}
{$IFDEF PATCH_I18N}
	I18N_UseNameORG : Boolean = False;
{$ENDIF PATCH_I18N}
{$IFDEF PATCH_JPSSDL}
	Pad_Left : Integer = 0;
	Pad_Top  : Integer = 0;
	SkipAnim : Boolean = False;
	DrawWallMode : Integer = 1;
{$ENDIF PATCH_JPSSDL}
{$IFDEF PATCH_GH}
	SDL_NoTimeEvent : Boolean = False;
	FrameSkip : Boolean = True;
	FrameInterval : Integer = 33;
	SleepGranularity : Integer = 0;
	KeysamplingInterval  : Integer = 11;
	SDL_Mini : Boolean = False;
	ScreenPos_X: Integer = -1;
	ScreenPos_Y: Integer = -1;
	ScreenSize_Width  : Integer = 0;
	ScreenSize_Height : Integer = 0;
{$ENDIF PATCH_GH}
{$IFDEF PATCH_I18N}
  {$IFDEF SDLMODE}
	SDL_AAFont        : Boolean = False;
	SDL_AAFont_Shaded : Boolean = False;
  {$ENDIF SDLMODE}
{$ENDIF PATCH_I18N}
{$IFDEF PATCH_GH}
  {$IFDEF SDLMODE}
	{ for Color Barrier Free }
	Avocado: TSDL_Color =		( r:136; g:141; b:101 );
	Bacardi: TSDL_Color =		( r:121; g:105; b:137 );
	Jade: TSDL_Color =		( r: 66; g:121; b:119 );
	BrightJade: TSDL_Color =	( r:100; g:200; b:180 );
	{}
	StdBlack: TSDL_Color =		( r:  0; g:  0; b:  0 );
	StdWhite: TSDL_Color =		( r:255; g:255; b:255 );
	MenuItem: TSDL_Color =		( r: 66; g:121; b:119 );
	MenuSelect: TSDL_Color =	( r:100; g:200; b:180 );
	TerrainGreen: TSDL_Color =	( r:100; g:210; b:  0 );
	PlayerBlue: TSDL_Color =	( r:  0; g:141; b:211 );
	AllyPurple: TSDL_Color =	( r:236; g:  0; b:211 );
	EnemyRed: TSDL_Color =		( r:230; g:  0; b:  0 );
	NeutralGrey: TSDL_Color =	( r:150; g:150; b:150 );
	DarkGrey: TSDL_Color =		( r:100; g:100; b:100 );
	InfoGreen: TSDL_Color =		( r:  0; g:141; b:  0 );
	InfoHiLight: TSDL_Color =	( r:  0; g:210; b:  0 );
	TextboxGrey: TSDL_Color =	( r:130; g:120; b:125 );
	NeutralBrown: TSDL_Color =	( r:240; g:201; b: 20 );
	BorderBlue: TSDL_Color =	( r:  0; g:101; b:151 );
	BrightYellow: TSDL_Color =	( r:255; g:201; b:  0 );
	{ sdlinfo.pp }
	StatusPerfect:TSDL_Color =	( r:  0; g:255; b: 65 );
	StatusOK:TSDL_Color =		( r: 30; g:190; b: 10 );
	StatusFair:TSDL_Color =		( r:220; g:190; b:  0 );
	StatusBad:TSDL_Color =		( r:220; g: 50; b:  0 );
	StatusCritical:TSDL_Color =	( r:150; g:  0; b:  0 );
	StatusKO:TSDL_Color =		( r: 75; g: 75; b: 75 );
  {$ENDIF SDLMODE}
	MaxSDLColors_Str = 64;
	SDL_colors_TeamColor_Character_DefPlayerTeam : Array [0..MaxSDLColors_Str] of Char = '66 121 179 255 212 195 205 25 0';
	SDL_colors_TeamColor_Character_Enemies       : Array [0..MaxSDLColors_Str] of Char = '180 10 120  255 212 195 170 205 75';
	SDL_colors_TeamColor_Character_Allies        : Array [0..MaxSDLColors_Str] of Char = '66 121 119 255 212 195 0 205 0';
	SDL_colors_TeamColor_Character_Others        : Array [0..MaxSDLColors_Str] of Char = '175 175 171 255 212 195 0 200 200';
	SDL_colors_TeamColor_Mecha_DefPlayerTeam     : Array [0..MaxSDLColors_Str] of Char = '66 121 179 210 215 80 205 25 0';
	SDL_colors_TeamColor_Mecha_Enemies           : Array [0..MaxSDLColors_Str] of Char = '180 10 120  125 125 125 170 205 75';
	SDL_colors_TeamColor_Mecha_Allies            : Array [0..MaxSDLColors_Str] of Char = '66 121 119 190 190 190 0 205 0';
	SDL_colors_TeamColor_Mecha_Others            : Array [0..MaxSDLColors_Str] of Char = '175 175 171 100 100 120 0 200 200';
	SDL_colors_RobotCreate : Array [0..MaxSDLColors_Str] of Char = '80 80 85 170 155 230 6 42 120';
	SDL_colors_CharacterCreate : Array [0..MaxSDLColors_Str] of Char = '49 91 161 252 212 195 150 112 89';
  {$IFDEF SDLMODE}
	Enable_ArenaMode : Boolean = False;
	Enable_EditMap   : Boolean = False;
  {$ELSE SDLMODE}
	Enable_ArenaMode : Boolean = True;
	Enable_EditMap   : Boolean = True;
  {$ENDIF SDLMODE}
	Enable_PointAnimation : Boolean = False;
{$ENDIF PATCH_GH}
{$IFDEF PATCH_l0ugh}
	KeyBind_RogueMove: Boolean = False;
{$ENDIF PATCH_l0ugh}
{$IFDEF PATCH_GH}
	SelectMenu_Scroll_by_Edge: Boolean = True;
	Show_MenuScrollbar : Boolean = False;
  {$IFDEF SDLMODE}
	SDL_Show_MenuScrollbar : Boolean = False;
	SDL_Scrollbar_Size : Integer = 12;
  {$ENDIF SDLMODE}
	Show_MenuPage : Boolean = False;
	SelectMenu_UpDown_by_MouseWheel_UD:         Boolean = False;
	SelectMenu_UpDown_by_MouseWheel_UD_Reverse: Boolean = False;
	SelectMenu_UpDown_by_MouseWheel_LR:         Boolean = False;
	SelectMenu_UpDown_by_MouseWheel_LR_Reverse: Boolean = False;
	SelectMenu_Scroll_by_MouseWheel_UD:         Boolean = True;
	SelectMenu_Scroll_by_MouseWheel_UD_Reverse: Boolean = False;
	SelectMenu_Scroll_by_MouseWheel_LR:         Boolean = False;
	SelectMenu_Scroll_by_MouseWheel_LR_Reverse: Boolean = False;
	SelectMenu_ScrollPage_by_MouseWheel_UD:         Boolean = False;
	SelectMenu_ScrollPage_by_MouseWheel_UD_Reverse: Boolean = False;
	SelectMenu_ScrollPage_by_MouseWheel_LR:         Boolean = True;
	SelectMenu_ScrollPage_by_MouseWheel_LR_Reverse: Boolean = False;
	Cheat_DisplayGearInfo : Boolean = False;
{$ENDIF PATCH_GH}
{$IFDEF PATCH_CHEAT}
	Cheat_Display : Boolean = False;
	Cheat_Display_SW : Boolean = False;
	Cheat_Display_DESIG : Boolean = False;
	Cheat_Display_OverLoad : Boolean = False;
	Cheat_Display_DamagePercent : Boolean = False;
	Cheat_Display_SpeedoMeter : Boolean = False;
	Cheat_Display_PV : Boolean = False;
	Cheat_Print_TimeString : Boolean = False;
	Cheat_Print_AttemptDefenses : Boolean = False;
	Cheat_Print_AmmoExplosion : Boolean = False;
	Cheat_Print_DoPillage : Boolean = False;
	Cheat_Autosave_Trace : Boolean = False;
	Cheat_Autosave_with_Timestamp : Boolean = False;
	Cheat_MainMenu_AddMenuKey : Boolean = False;
	Cheat_Restore_AddMenuKey : Boolean = False;
	Cheat_Chat : Boolean = False;
	Cheat_Chat_ReverseSort : Boolean = False;
	Cheat_CallShot : Boolean = False;
	Cheat_CallShot_Cancel : Boolean = False;
	Cheat_CallShot_OmitLookInfo : Boolean = False;
	Cheat_Range_Colored : Boolean = False;
	Cheat_FindNextWeapon : Boolean = True;
	Cheat_MenuOrder_Edit : Boolean = False;
	Cheat_MechaPartBrowser_Delete : Boolean = False;
	Cheat_RenameBackup : Boolean = False;
	Cheat_NPC_Edit : Boolean = False;
	Cheat_LookInfo : Boolean = False;
	Cheat_Enable_Limit_SellingPrice : Boolean = False;
	Cheat_BuyStuff_ShowSubItem : Boolean = False;
	Cheat_BuyStuff_Mecha_ShowSubItem : Boolean = False;
	Cheat_BuyStuff_Sort : Boolean = True;
	Cheat_SellStuff_ShowSubItem : Boolean = False;
	Cheat_SellStuff_Sort : Boolean = False;
	Cheat_SellStuff_KeepPosition : Boolean = False;
	Cheat_EqpMenu_AddMenuKey : Boolean = False;
	Cheat_EqpMenu_KeepPosition : Boolean = False;
	Cheat_EqpMenu_ShowSubItem : Boolean = False;
	Cheat_EqpMenu_ShowMassMeter : Boolean = False;
	Cheat_EqpMenu_ShowFullGearName : Boolean = False;
	Cheat_InvMenu_KeepPosition : Boolean = False;
	Cheat_InvMenu_ShowSubItem : Boolean = False;
	Cheat_InvMenu_NoSort : Boolean = False;
	Cheat_MechaDescription_ShowMassMeter : Boolean = False;
	Cheat_MechaPartEditor_AddMenuKey : Boolean = True;
	Cheat_MechaPartEditor_KeepPosition : Boolean = True;
	Cheat_PCVIEW_AddMenuKey : Boolean = False;
	Cheat_PCVIEW_KeepPosition : Boolean = False;
	Cheat_PCVIEW_Training_AddMenuKey : Boolean = False;
	Cheat_PCVIEW_Training_KeepPosition : Boolean = False;
	Cheat_FieldHQ_Mecha_NoSort : Boolean = False;
	Cheat_FieldHQ_Mecha_AddMenuKey : Boolean = False;
	Cheat_FieldHQ_Mecha_KeepPosition : Boolean = False;
	Cheat_FieldHQ_AddMenuKey : Boolean = False;
	Cheat_InstallMisc_ShowParentItem : Boolean = False;
	Cheat_EquipItem_ShowParentItem : Boolean = False;
	Cheat_InstallMisc_ShowInvStr : Boolean = False;
	Cheat_EquipItem_ShowInvStr : Boolean = False;
	Cheat_InstallAmmo_ShowSubItem : Boolean = False;
	Cheat_EquipItem_ShowSubItem : Boolean = False;
	Cheat_Install_ShowSubItem : Boolean = False;
	Cheat_InstallCyberware_ShowSubItem : Boolean = False;
	Cheat_ExtendedDescription_ShowHighOutput : Boolean = False;
	Cheat_GearName_AddScaleNumber : Boolean = False;
	Cheat_GearName_AddClassNumber_GGModule : Boolean = False;
	Cheat_GearName_AddClassNumber_GGMecha : Boolean = False;
	Cheat_GearName_AddClassNumber_GGHolder : Boolean = False;
	Cheat_GearName_AddClassNumber_GGSupport : Boolean = False;
	Cheat_GearName_AddClassNumber_GGConsumable : Boolean = False;
	Cheat_MechaCustomize_Limitless : Boolean = False;
	Cheat_MechaCustomize_FreeSupport : Boolean = False;
	Cheat_MechaCustomize_FreeCockpit : Boolean = False;
	Cheat_MechaCustomize_FreeMasterGear : Boolean = False;
	Cheat_MechaCustomize_FreeParent : Boolean = False;
	Cheat_MechaCustomize_FreeScale : Boolean = False;
	Cheat_MechaCustomize_FreeModifier : Boolean = False;
	Cheat_MechaCustomize_FreeBodyModule : Boolean = False;
	Cheat_Trade_NotSafeArea : Boolean = False;
	Cheat_Roguelike_Death : Boolean = False;
	Cheat_ArenaMode_MainMenu_AddMenuKey : Boolean = False;
	Cheat_ArenaMode_PilotsMenu_AddMenuKey : Boolean = False;
	Cheat_ArenaMode_MechaMenu_AddMenuKey : Boolean = False;
	Cheat_ArenaMode_PilotsHQ_AddMenuKey : Boolean = False;
	Cheat_ArenaMode_MechaHQ_AddMenuKey : Boolean = False;
	Cheat_ArenaMode_AllRecoveryInHQ : Boolean = False;
	Cheat_ArenaMode_InventoryInHQ : Boolean = False;
	Cheat_ArenaMode_FieldHQInHQ : Boolean = False;
	Cheat_ThisItemWasSelected_AddMenuKey : Boolean = False;
	Cheat_EnableCockpitBarrier : Boolean = True;
	Cheat_EnableCockpitBarrier_Hand : Boolean = True;
	Cheat_DoNotRunWhenMouseClicked : Boolean = True;
{$ENDIF PATCH_CHEAT}
{$IFDEF PATCH_BACKPORT}
	Backport_Caliber : Boolean = False;
	Backport_Caliber_GH1Compatible : Boolean = True;
{$ENDIF PATCH_BACKPORT}
{$IFDEF PATCH_GH}
  {$IFDEF DEBUG}
{	DEBUG_MemoryLeak : Boolean = True; }
	DEBUG_TraceMacro : Boolean = True;
	DEBUG_Grabbed_Gear : Boolean = True;
	DEBUG_SCRIPT_DynamicEncounter : Boolean = True;
{	DEBUG_DONOT_NIL_Grabbed_Gear_when_NewGear                    : Boolean = False; }
{	DEBUG_DONOT_NIL_Grabbed_Gear_when_DisposeGear                : Boolean = False; }
	DEBUG_DONOT_NIL_Grabbed_Gear_when_DelegeGG                   : Boolean = False;
	DEBUG_DONOT_NIL_Grabbed_Gear_when_EndStory                   : Boolean = False;
	DEBUG_DONOT_NIL_Grabbed_Gear_when_CleanupStoryPlots          : Boolean = False;
{	DEBUG_DONOT_NIL_Grabbed_Gear_when_Purge_GG_AbsolutelyNothing : Boolean = False; }
{	DEBUG_DONOT_NIL_Grabbed_Gear_when_Mark_GG_DisposeGear        : Boolean = False; }
{	DEBUG_DONOT_NIL_Grabbed_Gear_when_Purge_GG_DisposeGear       : Boolean = False; }
	DEBUG_DONOT_NIL_Grabbed_Gear_when_Change_Scene               : Boolean = False;
	DEBUG_DONOT_NIL_SCRIPT_DynamicEncounter                      : Boolean = False;
	DEBUG_FORCE_EXEC_MacroUPDATE_when_Restore      : Boolean = False;
	DEBUG_FORCE_EXEC_MacroSTART_when_Restore       : Boolean = False;
	DEBUG_STOP_MacroRESTORESTART_when_Restore      : Boolean = False;
	DEBUG_FORCE_RestockRandomMonsters_when_Restore : Boolean = False;
	DEBUG_MaxCID : Boolean = True;
	DEBUG_MaxNID : Boolean = True;
	DEBUG_CanSeeAll : Boolean = False;
  {$ENDIF DEBUG}
{$ENDIF PATCH_GH}


{$IFDEF PATCH_I18N}
Function I18N_Help_Keymap_Name_String( const MsgLabel: String ): String;
Function I18N_Help_Keymap_Desc_String( const MsgLabel: String ): String;
{$ENDIF PATCH_I18N}


implementation

uses
{$IFDEF PATCH_GH}
{ "sysutils" has to come before others. }
	sysutils,
{$ELSE PATCH_GH}
  {$IFDEF PATCH_I18N}
	sysutils,
  {$ENDIF PATCH_I18N}
{$ENDIF PATCH_GH}
	dos,
{$IFDEF PATCH_GH}
	errmsg,
{$ELSE PATCH_GH}
  {$IFDEF DEBUG}
	errmsg,
  {$ENDIF DEBUG}
{$ENDIF PATCH_GH}
{$IFDEF PATCH_GH}
	pseudosmartpointer,
{$ENDIF PATCH_GH}
{$IFDEF PATCH_I18N}
	i18nmsg,
{$ENDIF PATCH_I18N}
{$IFDEF PATCH_GH}
	gears_base,
	gears,
	texutil
{$ELSE PATCH_GH}
	ability,
	gears,
	texutil
{$ENDIF PATCH_GH}
{$IFDEF Windows}
	,w32
{$ENDIF Windows}
	;


{$IFDEF PATCH_GH}
  {$IFDEF SDLMODE}
type
	T_ColorTable = Record
		Name: String;
		DataPtr: PSDL_Color;
	end;
	T_SDLColorTable = Record
		Name: String;
		DataPtr: PChar;
	end;

const
	ColorTable_Num = 26;
	ColorTable: Array [1..ColorTable_Num] of T_ColorTable = (
	(	Name: 'Avocado';		DataPtr: @Avocado;	),
	(	Name: 'Bacardi';		DataPtr: @Bacardi;	),
	(	Name: 'Jade';			DataPtr: @Jade;		),
	(	Name: 'BrightJade';		DataPtr: @BrightJade;	),
	(	Name: 'StdBlack';		DataPtr: @StdBlack;	),
	(	Name: 'StdWhite';		DataPtr: @StdWhite;	),
	(	Name: 'MenuItem';		DataPtr: @MenuItem;	),
	(	Name: 'MenuSelect';		DataPtr: @MenuSelect;	),
	(	Name: 'TerrainGreen';		DataPtr: @TerrainGreen;	),
	(	Name: 'PlayerBlue';		DataPtr: @PlayerBlue;	),
	(	Name: 'AllyPurple';		DataPtr: @AllyPurple;	),
	(	Name: 'EnemyRed';		DataPtr: @EnemyRed;	),
	(	Name: 'NeutralGrey';		DataPtr: @NeutralGrey;	),
	(	Name: 'DarkGrey';		DataPtr: @DarkGrey;	),
	(	Name: 'InfoGreen';		DataPtr: @InfoGreen;	),
	(	Name: 'InfoHiLight';		DataPtr: @InfoHiLight;	),
	(	Name: 'TextboxGrey';		DataPtr: @TextboxGrey;	),
	(	Name: 'NeutralBrown';		DataPtr: @NeutralBrown;	),
	(	Name: 'BorderBlue';		DataPtr: @BorderBlue;	),
	(	Name: 'BrightYellow';		DataPtr: @BrightYellow;	),
	(	Name: 'StatusPerfect';		DataPtr: @StatusPerfect;	),
	(	Name: 'StatusOK';		DataPtr: @StatusOK;		),
	(	Name: 'StatusFair';		DataPtr: @StatusFair;		),
	(	Name: 'StatusBad';		DataPtr: @StatusBad;		),
	(	Name: 'StatusCritical';		DataPtr: @StatusCritical;	),
	(	Name: 'StatusKO';		DataPtr: @StatusKO;		)
	);

	SDLColorTable_Num = 10;
	SDLColorTable: Array [1..SDLColorTable_Num] of T_SDLColorTable = (
	(	Name: 'TeamColor_Character_DefPlayerTeam';	DataPtr: @SDL_colors_TeamColor_Character_DefPlayerTeam;		),
	(	Name: 'TeamColor_Character_Enemies';		DataPtr: @SDL_colors_TeamColor_Character_Enemies      ;		),
	(	Name: 'TeamColor_Character_Allies';		DataPtr: @SDL_colors_TeamColor_Character_Allies       ;		),
	(	Name: 'TeamColor_Character_Others';		DataPtr: @SDL_colors_TeamColor_Character_Others       ;		),
	(	Name: 'TeamColor_Mecha_DefPlayerTeam';		DataPtr: @SDL_colors_TeamColor_Mecha_DefPlayerTeam    ;		),
	(	Name: 'TeamColor_Mecha_Enemies';		DataPtr: @SDL_colors_TeamColor_Mecha_Enemies          ;		),
	(	Name: 'TeamColor_Mecha_Allies';			DataPtr: @SDL_colors_TeamColor_Mecha_Allies           ;		),
	(	Name: 'TeamColor_Mecha_Others';			DataPtr: @SDL_colors_TeamColor_Mecha_Others           ;		),
	(	Name: 'RobotCreate';		DataPtr: @SDL_colors_RobotCreate;		),
	(	Name: 'CharacterCreate';	DataPtr: @SDL_colors_CharacterCreate;		)
	);
  {$ENDIF SDLMODE}
{$ENDIF PATCH_GH}

{$IFDEF PATCH_I18N}
var
	I18N_Help_Keymap_Name: SAttPtr;
	I18N_Help_Keymap_Desc: SAttPtr;
{$ENDIF PATCH_I18N}


{$IFDEF PATCH_I18N}
Function I18N_Help_Keymap_Name_String( const MsgLabel: String ): String;
begin
	I18N_Help_Keymap_Name_String := SAttValue( I18N_Help_Keymap_Name, MsgLabel );
end;

Function I18N_Help_Keymap_Desc_String( const MsgLabel: String ): String;
begin
	I18N_Help_Keymap_Desc_String := SAttValue( I18N_Help_Keymap_Desc, MsgLabel );
end;

Procedure Load_I18N_Default;
begin
	ControlTypeName[0] := I18N_MsgString('ui4gh_ControlTypeName','Menu');
	ControlTypeName[1] := I18N_MsgString('ui4gh_ControlTypeName','Roguelike');
	BVTypeName[1]      := I18N_MsgString('ui4gh','BVTypeName1');
	BVTypeName[2]      := I18N_MsgString('ui4gh','BVTypeName2');
	BVTypeName[3]      := I18N_MsgString('ui4gh','BVTypeName3');
	BVTypeName[4]      := I18N_MsgString('ui4gh','BVTypeName4');
	ProhibitationHead                := I18N_Settings('ProhibitationHead',ProhibitationHead);
	ProhibitationTrail               := I18N_Settings('ProhibitationTrail',ProhibitationTrail);
	FontSearchName_Big[2].FontFile   := I18N_Settings('Default_FontFileBig',FontSearchName_Big[2].FontFile);
	FontSearchName_Big[2].FontFace   := StrToInt(I18N_Settings('Default_FontFaceBig',IntToStr(FontSearchName_Big[2].FontFace)));
	FontSearchName_Big[2].FontSize   := StrToInt(I18N_Settings('Default_FontSizeBig',IntToStr(FontSearchName_Big[2].FontSize)));
	FontSearchName_Small[2].FontFile := I18N_Settings('Default_FontFileSmall',FontSearchName_Small[2].FontFile);
	FontSearchName_Small[2].FontFace := StrToInt(I18N_Settings('Default_FontFaceSmall',IntToStr(FontSearchName_Small[2].FontFace)));
	FontSearchName_Small[2].FontSize := StrToInt(I18N_Settings('Default_FontSizeSmall',IntToStr(FontSearchName_Small[2].FontSize)));
  {$IFDEF Windows}
	MSWINGUI_FontName                := I18N_Settings('MSWIN_Default_FontNameOther',MSWINGUI_FontName);
	MSWINGUI_FontWeight              := StrToInt(I18N_Settings('MSWIN_Default_FontWeightOther',IntToStr(MSWINGUI_FontWeight)));
	MSWINGUI_FontSize                := StrToInt(I18N_Settings('MSWIN_Default_FontSizeOther',IntToStr(MSWINGUI_FontSize)));
  {$ENDIF Windows}
end;
{$ENDIF PATCH_I18N}


	Procedure LoadConfig;
		{ Open the configuration file and set the variables }
		{ as needed. }
	var
		F: Text;
		S,CMD,C: String;
		T: Integer;
{$IFDEF PATCH_I18N}
  {$IFDEF Windows}
		WinDir: String;
  {$ENDIF Windows}
{$ENDIF PATCH_I18N}
{$IFDEF PATCH_GH}
		Done: Boolean;
		KCode_tmp: Char;
		ColorNum: Integer;
{$ENDIF PATCH_GH}
	begin
{$IFDEF PATCH_I18N}
  {$IFDEF Windows}
		WinDir := '';
		if '' = WinDir then begin
			WinDir := GetEnvironmentVariable('SystemRoot');
		end;
		if '' = WinDir then begin
			WinDir := GetEnvironmentVariable('windir');
		end;
		if '' <> WinDir then begin
			FontSearchDir[4] := WinDir + DirectorySeparator + 'Fonts';
		end;
  {$ENDIF Windows}
{$ENDIF PATCH_I18N}
		{See whether or not there's a configuration file.}
		S := FSearch(Config_File,'.');
		if S <> '' then begin
			{ If we've found a configuration file, }
			{ open it up and start reading. }
			Assign(F,S);
			Reset(F);

			while not Eof(F) do begin
				ReadLn(F,S);
				cmd := ExtractWord(S);
				if (cmd <> '') then begin
{$IFDEF PATCH_GH}
					Done := False;
{$ENDIF PATCH_GH}
					{Check to see if CMD is one of the standard keys.}
					cmd := UpCase(cmd);
{$IFDEF PATCH_GH}
					for t := 1 to KeyMapAliasMax do begin
						if (UpCase(KeyMapAlias[t].CmdAlias) = cmd) then begin
							cmd := UpCase(KeyMapAlias[t].CmdName);
							break;
						end;
					end;
{$ENDIF PATCH_GH}
					for t := 1 to NumMappedKeys do begin
						if UpCase(KeyMap[t].CmdName) = cmd then
						begin
{$IFDEF PATCH_GH}
							Done := true;
{$ENDIF PATCH_GH}
							C := ExtractWord(S);
							if Length(C) = 1 then begin
								KeyMap[t].KCode := C[1];
{$IFDEF PATCH_GH}
							end else if ('#' = C[1]) and (2 <= Length(C)) then begin
								KCode_tmp := Char(StrToInt(Copy(C,2,Length(C)-1)));
								if #0 < KCode_tmp then begin
									KeyMap[t].KCode := KCode_tmp;
								end;
{$ENDIF PATCH_GH}
							end;
						end;
					end;

					{ Check to see if CMD is the animation speed throttle. }
					if cmd = 'ANIMSPEED' then begin
						T := ExtractValue( S );
						if T < 0 then T := 0;
						FrameDelay := T;
					end else if cmd = 'MECHACONTROL' then begin
						C := UpCase( ExtractWord( S ) );
						case C[1] of
							'M': ControlMethod := MenuBasedInput;
							'R': ControlMethod := RLBasedInput;
						end;
					end else if cmd = 'CHARACONTROL' then begin
						C := UpCase( ExtractWord( S ) );
						case C[1] of
							'M': CharacterMethod := MenuBasedInput;
							'R': CharacterMethod := RLBasedInput;
						end;
					end else if cmd = 'WORLDCONTROL' then begin
						C := UpCase( ExtractWord( S ) );
						case C[1] of
							'M': WorldMapMethod := MenuBasedInput;
							'R': WorldMapMethod := RLBasedInput;
						end;

					end else if cmd = 'MISSILEBV' then begin
						C := UpCase( ExtractWord( S ) );
						for t := 1 to 4 do begin
							if UpCase(BVTypeName[t]) = C then begin
								DefMissileBV := T;
							end;
						end;

					end else if cmd = 'BALLISTICBV' then begin
						C := UpCase( ExtractWord( S ) );
						for t := 1 to 4 do begin
							if UpCase(BVTypeName[t]) = C then begin
								DefBallisticBV := T;
							end;
						end;

					end else if cmd = 'BEAMGUNBV' then begin
						C := UpCase( ExtractWord( S ) );
						for t := 1 to 4 do begin
							if UpCase(BVTypeName[t]) = C then begin
								DefBeamGunBV := T;
							end;
						end;
					end else if cmd = 'DIRECTSKILLOK' then begin
						Direct_Skill_Learning := True;

					end else if cmd = 'NOAUTOSAVE' then begin
						DoAutoSave := False;

					end else if cmd = 'ALWAYSSAVECHARACTER' then begin
						ALWAYS_SAVE_CHARACTER := True;
					end else if cmd = 'NOCOMBATTAUNTS' then begin
						No_Combat_Taunts := True;

					end else if cmd = 'NOALPHA' then begin
						Use_Alpha_Blending := False;
					end else if cmd = 'ALPHALEVEL' then begin
						T := ExtractValue( S );
						if T > 255 then T := 255
						else if T < 0 then T := 0;
						Alpha_Level := T;

					end else if cmd = 'NUMPLOTS' then begin
						T := ExtractValue( S );
						if T > 255 then T := 255
						else if T < 0 then T := 0;
						Max_Plots_Per_Adventure := T;

					end else if cmd = 'LOADPLOTSATSTART' then begin
						Load_Plots_At_Start := True;

					end else if cmd = 'MINIMAPON' then begin
						Display_Mini_Map := True;

					end else if cmd = 'SCREENHEIGHT' then begin
						T := ExtractValue( S );
						if T > 255 then T := 255
						else if T < 24 then T := 24;
						ScreenRows := T;

					end else if cmd = 'SCREENWIDTH' then begin
						T := ExtractValue( S );
						if T > 255 then T := 255
						else if T < 80 then T := 80;
						ScreenColumns := T;

					end else if cmd = 'WINDOW' then begin
						DoFullScreen := False;
					end else if cmd = 'FULLSCREEN' then begin
						DoFullScreen := True;

					end else if cmd = 'NOMOUSE' then begin
						Mouse_Active := False;

					end else if cmd = 'NAMESON' then begin
						Names_Above_Heads := True;

					end else if cmd = 'NOPILLAGE' then begin
						Pillage_On := False;
					end else if cmd = 'USETACTICSMODE' then begin
						UseTacticsMode := True;

					end else if cmd = 'ADVANCEDCOLORS' then begin
						UseAdvancedColoring := True;

{$IFDEF PATCH_I18N}
					end else if cmd = 'I18N_USEORIGINALNAME' then begin
						if ExtractTF(S) then I18N_UseOriginalName := True else I18N_UseOriginalName := False;
					end else if cmd = 'I18N_USENAMEORG' then begin
						if ExtractTF(S) then I18N_UseNameORG := True else I18N_UseNameORG := False;
					end else if cmd = 'FONTFILEBIG' then begin
						FontSearchName_Big[1].FontFile   := ExtractWord( S );
						FontSearchName_Big[1].FontFace   := ExtractValue( S );
						if FontSearchName_Big[1].FontFace < 0 then begin FontSearchName_Big[1].FontFace := 0; end;
					end else if cmd = 'FONTFILESMALL' then begin
						FontSearchName_Small[1].FontFile := ExtractWord( S );
						FontSearchName_Small[1].FontFace := ExtractValue( S );
						if FontSearchName_Small[1].FontFace < 0 then begin FontSearchName_Small[1].FontFace := 0; end;
					end else if cmd = 'FONTSIZEBIG' then begin
						FontSize_Big := ExtractValue( S );
						if FontSize_Big < 1 then begin FontSize_Big := 1; end;
					end else if cmd = 'FONTSIZESMALL' then begin
						FontSize_Small := ExtractValue( S );
						if FontSize_Small < 1 then begin FontSize_Small := 1; end;
					end else if cmd = 'FONTNAMEOTHER' then begin
  {$IFDEF Windows}
						MSWINGUI_FontName := S;
  {$ENDIF Windows}
					end else if cmd = 'FONTWEIGHTOTHER' then begin
  {$IFDEF Windows}
						MSWINGUI_FontWeight := ExtractValue( S );
						if MSWINGUI_FontWeight < 0 then begin MSWINGUI_FontWeight := 0; end;
  {$ENDIF Windows}
					end else if cmd = 'FONTSIZEOTHER' then begin
  {$IFDEF Windows}
						MSWINGUI_FontSize := ExtractValue( S );
						if MSWINGUI_FontSize < 1 then begin MSWINGUI_FontSize := 1; end;
  {$ENDIF Windows}
					end else if cmd = 'PROHIBITATIONTRAIL' then begin
						ProhibitationTrail := S;
					end else if cmd = 'PROHIBITATIONHEAD' then begin
						ProhibitationHead := S;
{$ENDIF PATCH_I18N}
{$IFDEF PATCH_JPSSDL}
					end else if cmd = 'PADLEFT' then begin
						Pad_Left := ExtractValue( S );
					end else if cmd = 'PADTOP' then begin
						Pad_Top := ExtractValue( S );
					end else if cmd = 'SKIPANIM' then begin
						if ExtractTF(S) then SkipAnim := True else SkipAnim := False;
					end else if cmd = 'DRAWWALLMODE' then begin
						DrawWallMode := ExtractValue( S );
						if 4 < DrawWallMode then begin DrawWallMode := 4 end
						else if DrawWallMode < 0 then begin DrawWallMode := 0 end;
{$ENDIF PATCH_JPSSDL}
{$IFDEF PATCH_GH}
					end else if cmd = 'SDL_NOTIMEEVENT' then begin
						if ExtractTF(S) then SDL_NoTimeEvent := True else SDL_NoTimeEvent := False;
					end else if cmd = 'FRAMESKIP' then begin
						if ExtractTF(S) then FrameSkip := True else FrameSkip := False;
					end else if cmd = 'FRAMEINTERVAL' then begin
						FrameInterval := ExtractValue( S );
						if FrameInterval < 0 then begin FrameInterval := 0; end;
					end else if cmd = 'SLEEPGRANULARITY' then begin
						SleepGranularity := ExtractValue( S );
						if SleepGranularity < 0 then begin SleepGranularity := 0; end;
					end else if cmd = 'KEYSAMPLINGINTERVAL' then begin
						KeysamplingInterval := ExtractValue( S );
						if KeysamplingInterval < 0 then begin KeysamplingInterval := 0; end;
					end else if cmd = 'COLOR' then begin
						C := ExtractWord( S );
  {$IFDEF SDLMODE}
						for ColorNum := 1 to ColorTable_Num do begin
							if UpCase(ColorTable[ColorNum].Name) = UpCase(C) then begin
								ColorTable[ColorNum].DataPtr^.r := ExtractValue( S );
								ColorTable[ColorNum].DataPtr^.g := ExtractValue( S );
								ColorTable[ColorNum].DataPtr^.b := ExtractValue( S );
								if ColorTable[ColorNum].DataPtr^.r < 0 then begin ColorTable[ColorNum].DataPtr^.r := 0; end;
								if ColorTable[ColorNum].DataPtr^.g < 0 then begin ColorTable[ColorNum].DataPtr^.g := 0; end;
								if ColorTable[ColorNum].DataPtr^.b < 0 then begin ColorTable[ColorNum].DataPtr^.b := 0; end;
								if 255 < ColorTable[ColorNum].DataPtr^.r then begin ColorTable[ColorNum].DataPtr^.r := 255; end;
								if 255 < ColorTable[ColorNum].DataPtr^.g then begin ColorTable[ColorNum].DataPtr^.g := 255; end;
								if 255 < ColorTable[ColorNum].DataPtr^.b then begin ColorTable[ColorNum].DataPtr^.b := 255; end;
							end;
						end;
  {$ENDIF SDLMODE}
					end else if cmd = 'SDL_COLORS' then begin
						C := ExtractWord( S );
  {$IFDEF SDLMODE}
						for ColorNum := 1 to SDLColorTable_Num do begin
							if UpCase(SDLColorTable[ColorNum].Name) = UpCase(C) then begin
								StrPCopy( SDLColorTable[ColorNum].DataPtr, RetrieveAString(S) );
							end;
						end;
  {$ENDIF SDLMODE}
					end else if cmd = 'SDL_MINI' then begin
						if ExtractTF(S) then SDL_Mini := True else SDL_Mini := False;
					end else if cmd = 'CUI_SCREENSIZE' then begin
  {$IFDEF SDLMODE}
  {$ELSE SDLMODE}
						ScreenSize_Width  := ExtractValue( S );
						ScreenSize_Height := ExtractValue( S );
						if ScreenSize_Width < 3 then begin ScreenSize_Width := 3; end;
						if ScreenSize_Height < 3 then begin ScreenSize_Height := 3; end;
  {$ENDIF SDLMODE}
					end else if cmd = 'SDL_SCREENPOS' then begin
  {$IFDEF SDLMODE}
						ScreenPos_X := ExtractValue( S );
						ScreenPos_Y := ExtractValue( S );
  {$ENDIF SDLMODE}
					end else if cmd = 'SDL_SCREENSIZE' then begin
  {$IFDEF SDLMODE}
						ScreenSize_Width  := ExtractValue( S );
						ScreenSize_Height := ExtractValue( S );
						if ScreenSize_Width < 3 then begin ScreenSize_Width := 3; end;
						if ScreenSize_Height < 3 then begin ScreenSize_Height := 3; end;
  {$ENDIF SDLMODE}
{$ENDIF PATCH_GH}
{$IFDEF PATCH_I18N}
					end else if cmd = 'SDL_AAFONT' then begin
  {$IFDEF SDLMODE}
						if ExtractTF(S) then SDL_AAFont := True else SDL_AAFont := False;
  {$ENDIF SDLMODE}
					end else if cmd = 'SDL_AAFONT_SHADED' then begin
  {$IFDEF SDLMODE}
						if ExtractTF(S) then SDL_AAFont_Shaded := True else SDL_AAFont_Shaded := False;
  {$ENDIF SDLMODE}
{$ENDIF PATCH_I18N}
{$IFDEF PATCH_GH}
					end else if cmd = 'ENABLE_ARENAMODE' then begin
						if ExtractTF(S) then Enable_ArenaMode := True else Enable_ArenaMode := False;
					end else if cmd = 'ENABLE_EDITMAP' then begin
						if ExtractTF(S) then Enable_EditMap := True else Enable_EditMap := False;
					end else if cmd = 'ENABLE_POINTANIMATION' then begin
						if ExtractTF(S) then Enable_PointAnimation := True else Enable_PointAnimation := False;
{$ENDIF PATCH_GH}
{$IFDEF PATCH_l0ugh}
					end else if cmd = 'KEYBIND_ROGUEMOVE' then begin
						if ExtractTF(S) then KeyBind_RogueMove := True else KeyBind_RogueMove := False;
{$ENDIF PATCH_l0ugh}
{$IFDEF PATCH_GH}
					end else if cmd = 'SELECTMENU_SCROLL_BY_EDGE' then begin
						if ExtractTF(S) then SelectMenu_Scroll_by_Edge := True else SelectMenu_Scroll_by_Edge := False;
					end else if cmd = 'SHOW_MENUSCROLLBAR' then begin
						if ExtractTF(S) then Show_MenuScrollbar := True else Show_MenuScrollbar := False;
					end else if cmd = 'SDL_SHOW_MENUSCROLLBAR' then begin
  {$IFDEF SDLMODE}
						if ExtractTF(S) then SDL_Show_MenuScrollbar := True else SDL_Show_MenuScrollbar := False;
  {$ENDIF SDLMODE}
					end else if cmd = 'SDL_SCROLLBAR_SIZE' then begin
  {$IFDEF SDLMODE}
						SDL_Scrollbar_Size := ExtractValue( S );
						if SDL_Scrollbar_Size < 3 then begin SDL_Scrollbar_Size := 3; end;
  {$ENDIF SDLMODE}
					end else if cmd = 'SHOW_MENUPAGE' then begin
						if ExtractTF(S) then Show_MenuPage := True else Show_MenuPage := False;
					end else if cmd = 'SELECTMENU_UPDOWN_BY_MOUSEWHEEL_UD' then begin
						if ExtractTF(S) then SelectMenu_UpDown_by_MouseWheel_UD := True else SelectMenu_UpDown_by_MouseWheel_UD := False;
					end else if cmd = 'SELECTMENU_UPDOWN_BY_MOUSEWHEEL_UD_REVERSE' then begin
						if ExtractTF(S) then SelectMenu_UpDown_by_MouseWheel_UD_Reverse := True else SelectMenu_UpDown_by_MouseWheel_UD_Reverse := False;
					end else if cmd = 'SELECTMENU_UPDOWN_BY_MOUSEWHEEL_LR' then begin
						if ExtractTF(S) then SelectMenu_UpDown_by_MouseWheel_LR := True else SelectMenu_UpDown_by_MouseWheel_LR := False;
					end else if cmd = 'SELECTMENU_UPDOWN_BY_MOUSEWHEEL_LR_REVERSE' then begin
						if ExtractTF(S) then SelectMenu_UpDown_by_MouseWheel_LR_Reverse := True else SelectMenu_UpDown_by_MouseWheel_LR_Reverse := False;
					end else if cmd = 'SELECTMENU_SCROLL_BY_MOUSEWHEEL_UD' then begin
						if ExtractTF(S) then SelectMenu_Scroll_by_MouseWheel_UD := True else SelectMenu_Scroll_by_MouseWheel_UD := False;
					end else if cmd = 'SELECTMENU_SCROLL_BY_MOUSEWHEEL_UD_REVERSE' then begin
						if ExtractTF(S) then SelectMenu_Scroll_by_MouseWheel_UD_Reverse := True else SelectMenu_Scroll_by_MouseWheel_UD_Reverse := False;
					end else if cmd = 'SELECTMENU_SCROLL_BY_MOUSEWHEEL_LR' then begin
						if ExtractTF(S) then SelectMenu_Scroll_by_MouseWheel_LR := True else SelectMenu_Scroll_by_MouseWheel_LR := False;
					end else if cmd = 'SELECTMENU_SCROLL_BY_MOUSEWHEEL_LR_REVERSE' then begin
						if ExtractTF(S) then SelectMenu_Scroll_by_MouseWheel_LR_Reverse := True else SelectMenu_Scroll_by_MouseWheel_LR_Reverse := False;
					end else if cmd = 'SELECTMENU_SCROLLPAGE_BY_MOUSEWHEEL_UD' then begin
						if ExtractTF(S) then SelectMenu_ScrollPage_by_MouseWheel_UD := True else SelectMenu_ScrollPage_by_MouseWheel_UD := False;
					end else if cmd = 'SELECTMENU_SCROLLPAGE_BY_MOUSEWHEEL_UD_REVERSE' then begin
						if ExtractTF(S) then SelectMenu_ScrollPage_by_MouseWheel_UD_Reverse := True else SelectMenu_ScrollPage_by_MouseWheel_UD_Reverse := False;
					end else if cmd = 'SELECTMENU_SCROLLPAGE_BY_MOUSEWHEEL_LR' then begin
						if ExtractTF(S) then SelectMenu_ScrollPage_by_MouseWheel_LR := True else SelectMenu_ScrollPage_by_MouseWheel_LR := False;
					end else if cmd = 'SELECTMENU_SCROLLPAGE_BY_MOUSEWHEEL_LR_REVERSE' then begin
						if ExtractTF(S) then SelectMenu_ScrollPage_by_MouseWheel_LR_Reverse := True else SelectMenu_ScrollPage_by_MouseWheel_LR_Reverse := False;
					end else if cmd = 'CHEAT_DISPLAYGEARINFO' then begin
						if ExtractTF(S) then Cheat_DisplayGearInfo := True else Cheat_DisplayGearInfo := False;
{$ENDIF PATCH_GH}
{$IFDEF PATCH_CHEAT}
					end else if cmd = 'CHEAT_DISPLAY' then begin
						if ExtractTF(S) then Cheat_Display := True else Cheat_Display := False;
						Cheat_Display_SW := Cheat_Display;
					end else if cmd = 'CHEAT_DISPLAY_DESIG' then begin
						if ExtractTF(S) then Cheat_Display_DESIG := True else Cheat_Display_DESIG := False;
					end else if cmd = 'CHEAT_DISPLAY_OVERLOAD' then begin
						if ExtractTF(S) then Cheat_Display_OverLoad := True else Cheat_Display_OverLoad := False;
					end else if cmd = 'CHEAT_DISPLAY_DAMAGEPERCENT' then begin
						if ExtractTF(S) then Cheat_Display_DamagePercent := True else Cheat_Display_DamagePercent := False;
					end else if cmd = 'CHEAT_DISPLAY_SPEEDOMETER' then begin
						if ExtractTF(S) then Cheat_Display_SpeedoMeter := True else Cheat_Display_SpeedoMeter := False;
					end else if cmd = 'CHEAT_DISPLAY_PV' then begin
						if ExtractTF(S) then Cheat_Display_PV := True else Cheat_Display_PV := False;
					end else if cmd = 'CHEAT_PRINT_TIMESTRING' then begin
						if ExtractTF(S) then Cheat_Print_TimeString := True else Cheat_Print_TimeString := False;
					end else if cmd = 'CHEAT_PRINT_ATTEMPTDEFENSES' then begin
						if ExtractTF(S) then Cheat_Print_AttemptDefenses := True else Cheat_Print_AttemptDefenses := False;
					end else if cmd = 'CHEAT_PRINT_AMMOEXPLOSION' then begin
						if ExtractTF(S) then Cheat_Print_AmmoExplosion := True else Cheat_Print_AmmoExplosion := False;
					end else if cmd = 'CHEAT_PRINT_DOPILLAGE' then begin
						if ExtractTF(S) then Cheat_Print_DoPillage := True else Cheat_Print_DoPillage := False;
					end else if cmd = 'CHEAT_AUTOSAVE_TRACE' then begin
						if ExtractTF(S) then Cheat_Autosave_Trace := True else Cheat_Autosave_Trace := False;
					end else if cmd = 'CHEAT_AUTOSAVE_WITH_TIMESTAMP' then begin
						if ExtractTF(S) then Cheat_Autosave_with_Timestamp := True else Cheat_Autosave_with_Timestamp := False;
					end else if cmd = 'CHEAT_MAINMENU_ADDMENUKEY' then begin
						if ExtractTF(S) then Cheat_MainMenu_AddMenuKey := True else Cheat_MainMenu_AddMenuKey := False;
					end else if cmd = 'CHEAT_RESTORE_ADDMENUKEY' then begin
						if ExtractTF(S) then Cheat_Restore_AddMenuKey := True else Cheat_Restore_AddMenuKey := False;
					end else if cmd = 'CHEAT_CHAT' then begin
						if ExtractTF(S) then Cheat_Chat := True else Cheat_Chat := False;
					end else if cmd = 'CHEAT_CHAT_REVERSESORT' then begin
						if ExtractTF(S) then Cheat_Chat_ReverseSort := True else Cheat_Chat_ReverseSort := False;
					end else if cmd = 'CHEAT_CALLSHOT' then begin
						if ExtractTF(S) then Cheat_CallShot := True else Cheat_CallShot := False;
					end else if cmd = 'CHEAT_CALLSHOT_CANCEL' then begin
						if ExtractTF(S) then Cheat_CallShot_Cancel := True else Cheat_CallShot_Cancel := False;
					end else if cmd = 'CHEAT_CALLSHOT_OMITLOOKINFO' then begin
						if ExtractTF(S) then Cheat_CallShot_OmitLookInfo := True else Cheat_CallShot_OmitLookInfo := False;
					end else if cmd = 'CHEAT_RANGE_COLORED' then begin
						if ExtractTF(S) then Cheat_Range_Colored := True else Cheat_Range_Colored := False;
					end else if cmd = 'CHEAT_FINDNEXTWEAPON' then begin
						if ExtractTF(S) then Cheat_FindNextWeapon := True else Cheat_FindNextWeapon := False;
					end else if cmd = 'CHEAT_MENUORDER_EDIT' then begin
						if ExtractTF(S) then Cheat_MenuOrder_Edit := True else Cheat_MenuOrder_Edit := False;
					end else if cmd = 'CHEAT_MECHAPARTBROWSER_DELETE' then begin
						if ExtractTF(S) then Cheat_MechaPartBrowser_Delete := True else Cheat_MechaPartBrowser_Delete := False;
					end else if cmd = 'CHEAT_RENAMEBACKUP' then begin
						if ExtractTF(S) then Cheat_RenameBackup := True else Cheat_RenameBackup := False;
					end else if cmd = 'CHEAT_NPC_EDIT' then begin
						if ExtractTF(S) then Cheat_NPC_Edit := True else Cheat_NPC_Edit := False;
					end else if cmd = 'CHEAT_LOOKINFO' then begin
						if ExtractTF(S) then Cheat_LookInfo := True else Cheat_LookInfo := False;
					end else if cmd = 'CHEAT_ENABLE_LIMIT_SELLINGPRICE' then begin
						if ExtractTF(S) then Cheat_Enable_Limit_SellingPrice := True else Cheat_Enable_Limit_SellingPrice := False;
					end else if cmd = 'CHEAT_BUYSTUFF_SHOWSUBITEM' then begin
						if ExtractTF(S) then Cheat_BuyStuff_ShowSubItem := True else Cheat_BuyStuff_ShowSubItem := False;
					end else if cmd = 'CHEAT_BUYSTUFF_MECHA_SHOWSUBITEM' then begin
						if ExtractTF(S) then Cheat_BuyStuff_Mecha_ShowSubItem := True else Cheat_BuyStuff_Mecha_ShowSubItem := False;
					end else if cmd = 'CHEAT_BUYSTUFF_SORT' then begin
						if ExtractTF(S) then Cheat_BuyStuff_Sort := True else Cheat_BuyStuff_Sort := False;
					end else if cmd = 'CHEAT_SELLSTUFF_SHOWSUBITEM' then begin
						if ExtractTF(S) then Cheat_SellStuff_ShowSubItem := True else Cheat_SellStuff_ShowSubItem := False;
					end else if cmd = 'CHEAT_SELLSTUFF_SORT' then begin
						if ExtractTF(S) then Cheat_SellStuff_Sort := True else Cheat_SellStuff_Sort := False;
					end else if cmd = 'CHEAT_SELLSTUFF_KEEPPOSITION' then begin
						if ExtractTF(S) then Cheat_SellStuff_KeepPosition := True else Cheat_SellStuff_KeepPosition := False;
					end else if cmd = 'CHEAT_EQPMENU_ADDMENUKEY' then begin
						if ExtractTF(S) then Cheat_EqpMenu_AddMenuKey := True else Cheat_EqpMenu_AddMenuKey := False;
					end else if cmd = 'CHEAT_EQPMENU_KEEPPOSITION' then begin
						if ExtractTF(S) then Cheat_EqpMenu_KeepPosition := True else Cheat_EqpMenu_KeepPosition := False;
					end else if cmd = 'CHEAT_EQPMENU_SHOWSUBITEM' then begin
						if ExtractTF(S) then Cheat_EqpMenu_ShowSubItem := True else Cheat_EqpMenu_ShowSubItem := False;
					end else if cmd = 'CHEAT_EQPMENU_SHOWMASSMETER' then begin
						if ExtractTF(S) then Cheat_EqpMenu_ShowMassMeter := True else Cheat_EqpMenu_ShowMassMeter := False;
					end else if cmd = 'CHEAT_EQPMENU_SHOWFULLGEARNAME' then begin
						if ExtractTF(S) then Cheat_EqpMenu_ShowFullGearName := True else Cheat_EqpMenu_ShowFullGearName := False;
					end else if cmd = 'CHEAT_INVMENU_KEEPPOSITION' then begin
						if ExtractTF(S) then Cheat_InvMenu_KeepPosition := True else Cheat_InvMenu_KeepPosition := False;
					end else if cmd = 'CHEAT_INVMENU_SHOWSUBITEM' then begin
						if ExtractTF(S) then Cheat_InvMenu_ShowSubItem := True else Cheat_InvMenu_ShowSubItem := False;
					end else if cmd = 'CHEAT_INVMENU_NOSORT' then begin
						if ExtractTF(S) then Cheat_InvMenu_NoSort := True else Cheat_InvMenu_NoSort := False;
					end else if cmd = 'CHEAT_MECHADESCRIPTION_SHOWMASSMETER' then begin
						if ExtractTF(S) then Cheat_MechaDescription_ShowMassMeter := True else Cheat_MechaDescription_ShowMassMeter := False;
					end else if cmd = 'CHEAT_MECHAPARTEDITOR_ADDMENUKEY' then begin
						if ExtractTF(S) then Cheat_MechaPartEditor_AddMenuKey := True else Cheat_MechaPartEditor_AddMenuKey := False;
					end else if cmd = 'CHEAT_MECHAPARTEDITOR_KEEPPOSITION' then begin
						if ExtractTF(S) then Cheat_MechaPartEditor_KeepPosition := True else Cheat_MechaPartEditor_KeepPosition := False;
					end else if cmd = 'CHEAT_PCVIEW_ADDMENUKEY' then begin
						if ExtractTF(S) then Cheat_PCVIEW_AddMenuKey := True else Cheat_PCVIEW_AddMenuKey := False;
					end else if cmd = 'CHEAT_PCVIEW_KEEPPOSITION' then begin
						if ExtractTF(S) then Cheat_PCVIEW_KeepPosition := True else Cheat_PCVIEW_KeepPosition := False;
					end else if cmd = 'CHEAT_PCVIEW_TRAINING_ADDMENUKEY' then begin
						if ExtractTF(S) then Cheat_PCVIEW_Training_AddMenuKey := True else Cheat_PCVIEW_Training_AddMenuKey := False;
					end else if cmd = 'CHEAT_PCVIEW_TRAINING_KEEPPOSITION' then begin
						if ExtractTF(S) then Cheat_PCVIEW_Training_KeepPosition := True else Cheat_PCVIEW_Training_KeepPosition := False;
					end else if cmd = 'CHEAT_FIELDHQ_MECHA_NOSORT' then begin
						if ExtractTF(S) then Cheat_FieldHQ_Mecha_NoSort := True else Cheat_FieldHQ_Mecha_NoSort := False;
					end else if cmd = 'CHEAT_FIELDHQ_MECHA_ADDMENUKEY' then begin
						if ExtractTF(S) then Cheat_FieldHQ_Mecha_AddMenuKey := True else Cheat_FieldHQ_Mecha_AddMenuKey := False;
					end else if cmd = 'CHEAT_FIELDHQ_MECHA_KEEPPOSITION' then begin
						if ExtractTF(S) then Cheat_FieldHQ_Mecha_KeepPosition := True else Cheat_FieldHQ_Mecha_KeepPosition := False;
					end else if cmd = 'CHEAT_FIELDHQ_ADDMENUKEY' then begin
						if ExtractTF(S) then Cheat_FieldHQ_AddMenuKey := True else Cheat_FieldHQ_AddMenuKey := False;
					end else if cmd = 'CHEAT_INSTALLMISC_SHOWPARENTITEM' then begin
						if ExtractTF(S) then Cheat_InstallMisc_ShowParentItem := True else Cheat_InstallMisc_ShowParentItem := False;
					end else if cmd = 'CHEAT_EQUIPITEM_SHOWPARENTITEM' then begin
						if ExtractTF(S) then Cheat_EquipItem_ShowParentItem := True else Cheat_EquipItem_ShowParentItem := False;
					end else if cmd = 'CHEAT_INSTALLMISC_SHOWINVSTR' then begin
						if ExtractTF(S) then Cheat_InstallMisc_ShowInvStr := True else Cheat_InstallMisc_ShowInvStr := False;
					end else if cmd = 'CHEAT_EQUIPITEM_SHOWINVSTR' then begin
						if ExtractTF(S) then Cheat_EquipItem_ShowInvStr := True else Cheat_EquipItem_ShowInvStr := False;
					end else if cmd = 'CHEAT_INSTALLAMMO_SHOWSUBITEM' then begin
						if ExtractTF(S) then Cheat_InstallAmmo_ShowSubItem := True else Cheat_InstallAmmo_ShowSubItem := False;
					end else if cmd = 'CHEAT_EQUIPITEM_SHOWSUBITEM' then begin
						if ExtractTF(S) then Cheat_EquipItem_ShowSubItem := True else Cheat_EquipItem_ShowSubItem := False;
					end else if cmd = 'CHEAT_INSTALL_SHOWSUBITEM' then begin
						if ExtractTF(S) then Cheat_Install_ShowSubItem := True else Cheat_Install_ShowSubItem := False;
					end else if cmd = 'CHEAT_INSTALLCYBERWARE_SHOWSUBITEM' then begin
						if ExtractTF(S) then Cheat_InstallCyberware_ShowSubItem := True else Cheat_InstallCyberware_ShowSubItem := False;
					end else if cmd = 'CHEAT_EXTENDEDDESCRIPTION_SHOWHIGHOUTPUT' then begin
						if ExtractTF(S) then Cheat_ExtendedDescription_ShowHighOutput := True else Cheat_ExtendedDescription_ShowHighOutput := False;
					end else if cmd = 'CHEAT_GEARNAME_ADDSCALENUMBER' then begin
						if ExtractTF(S) then Cheat_GearName_AddScaleNumber := True else Cheat_GearName_AddScaleNumber := False;
					end else if cmd = 'CHEAT_GEARNAME_ADDCLASSNUMBER_GGMODULE' then begin
						if ExtractTF(S) then Cheat_GearName_AddClassNumber_GGModule := True else Cheat_GearName_AddClassNumber_GGModule := False;
					end else if cmd = 'CHEAT_GEARNAME_ADDCLASSNUMBER_GGMECHA' then begin
						if ExtractTF(S) then Cheat_GearName_AddClassNumber_GGMecha := True else Cheat_GearName_AddClassNumber_GGMecha := False;
					end else if cmd = 'CHEAT_GEARNAME_ADDCLASSNUMBER_GGHOLDER' then begin
						if ExtractTF(S) then Cheat_GearName_AddClassNumber_GGHolder := True else Cheat_GearName_AddClassNumber_GGHolder := False;
					end else if cmd = 'CHEAT_GEARNAME_ADDCLASSNUMBER_GGSUPPORT' then begin
						if ExtractTF(S) then Cheat_GearName_AddClassNumber_GGSupport := True else Cheat_GearName_AddClassNumber_GGSupport := False;
					end else if cmd = 'CHEAT_GEARNAME_ADDCLASSNUMBER_GGCONSUMABLE' then begin
						if ExtractTF(S) then Cheat_GearName_AddClassNumber_GGConsumable := True else Cheat_GearName_AddClassNumber_GGConsumable := False;
					end else if cmd = 'CHEAT_MECHACUSTOMIZE_LIMITLESS' then begin
						if ExtractTF(S) then Cheat_MechaCustomize_Limitless := True else Cheat_MechaCustomize_Limitless := False;
					end else if cmd = 'CHEAT_MECHACUSTOMIZE_FREESUPPORT' then begin
						if ExtractTF(S) then Cheat_MechaCustomize_FreeSupport := True else Cheat_MechaCustomize_FreeSupport := False;
					end else if cmd = 'CHEAT_MECHACUSTOMIZE_FREECOCKPIT' then begin
						if ExtractTF(S) then Cheat_MechaCustomize_FreeCockpit := True else Cheat_MechaCustomize_FreeCockpit := False;
					end else if cmd = 'CHEAT_MECHACUSTOMIZE_FREEMASTERGEAR' then begin
						if ExtractTF(S) then Cheat_MechaCustomize_FreeMasterGear := True else Cheat_MechaCustomize_FreeMasterGear := False;
					end else if cmd = 'CHEAT_MECHACUSTOMIZE_FREEPARENT' then begin
						if ExtractTF(S) then Cheat_MechaCustomize_FreeParent := True else Cheat_MechaCustomize_FreeParent := False;
					end else if cmd = 'CHEAT_MECHACUSTOMIZE_FREESCALE' then begin
						if ExtractTF(S) then Cheat_MechaCustomize_FreeScale := True else Cheat_MechaCustomize_FreeScale := False;
					end else if cmd = 'CHEAT_MECHACUSTOMIZE_FREEMODIFIER' then begin
						if ExtractTF(S) then Cheat_MechaCustomize_FreeModifier := True else Cheat_MechaCustomize_FreeModifier := False;
					end else if cmd = 'CHEAT_MECHACUSTOMIZE_FREEBODYMODULE' then begin
						if ExtractTF(S) then Cheat_MechaCustomize_FreeBodyModule := True else Cheat_MechaCustomize_FreeBodyModule := False;
					end else if cmd = 'CHEAT_TRADE_NOTSAFEAREA' then begin
						if ExtractTF(S) then Cheat_Trade_NotSafeArea := True else Cheat_Trade_NotSafeArea := False;
					end else if cmd = 'CHEAT_ROGUELIKE_DEATH' then begin
						if ExtractTF(S) then Cheat_Roguelike_Death := True else Cheat_Roguelike_Death := False;
					end else if cmd = 'CHEAT_ARENAMODE_MAINMENU_ADDMENUKEY' then begin
						if ExtractTF(S) then Cheat_ArenaMode_MainMenu_AddMenuKey := True else Cheat_ArenaMode_MainMenu_AddMenuKey := False;
					end else if cmd = 'CHEAT_ARENAMODE_PILOTSMENU_ADDMENUKEY' then begin
						if ExtractTF(S) then Cheat_ArenaMode_PilotsMenu_AddMenuKey := True else Cheat_ArenaMode_PilotsMenu_AddMenuKey := False;
					end else if cmd = 'CHEAT_ARENAMODE_MECHAMENU_ADDMENUKEY' then begin
						if ExtractTF(S) then Cheat_ArenaMode_MechaMenu_AddMenuKey := True else Cheat_ArenaMode_MechaMenu_AddMenuKey := False;
					end else if cmd = 'CHEAT_ARENAMODE_PILOTSHQ_ADDMENUKEY' then begin
						if ExtractTF(S) then Cheat_ArenaMode_PilotsHQ_AddMenuKey := True else Cheat_ArenaMode_PilotsHQ_AddMenuKey := False;
					end else if cmd = 'CHEAT_ARENAMODE_MECHAHQ_ADDMENUKEY' then begin
						if ExtractTF(S) then Cheat_ArenaMode_MechaHQ_AddMenuKey := True else Cheat_ArenaMode_MechaHQ_AddMenuKey := False;
					end else if cmd = 'CHEAT_ARENAMODE_ALLRECOVERYINHQ' then begin
						if ExtractTF(S) then Cheat_ArenaMode_AllRecoveryInHQ := True else Cheat_ArenaMode_AllRecoveryInHQ := False;
					end else if cmd = 'CHEAT_ARENAMODE_INVENTORYINHQ' then begin
						if ExtractTF(S) then Cheat_ArenaMode_InventoryInHQ := True else Cheat_ArenaMode_InventoryInHQ := False;
					end else if cmd = 'CHEAT_ARENAMODE_FIELDHQINHQ' then begin
						if ExtractTF(S) then Cheat_ArenaMode_FieldHQInHQ := True else Cheat_ArenaMode_FieldHQInHQ := False;
					end else if cmd = 'CHEAT_THISITEMWASSELECTED_ADDMENUKEY' then begin
						if ExtractTF(S) then Cheat_ThisItemWasSelected_AddMenuKey := True else Cheat_ThisItemWasSelected_AddMenuKey := False;
					end else if cmd = 'CHEAT_ENABLECOCKPITBARRIER' then begin
						if ExtractTF(S) then Cheat_EnableCockpitBarrier := True else Cheat_EnableCockpitBarrier := False;
					end else if cmd = 'CHEAT_ENABLECOCKPITBARRIER_HAND' then begin
						if ExtractTF(S) then Cheat_EnableCockpitBarrier_Hand := True else Cheat_EnableCockpitBarrier_Hand := False;
					end else if cmd = 'CHEAT_DONOTRUNWHENMOUSECLICKED' then begin
						if ExtractTF(S) then Cheat_DoNotRunWhenMouseClicked := True else Cheat_DoNotRunWhenMouseClicked := False;
{$ENDIF PATCH_CHEAT}
{$IFDEF PATCH_BACKPORT}
					end else if cmd = 'BACKPORT_CALIBER' then begin
						if ExtractTF(S) then Backport_Caliber := True else Backport_Caliber := False;
					end else if cmd = 'BACKPORT_CALIBER_GH1COMPATIBLE' then begin
						if ExtractTF(S) then Backport_Caliber_GH1Compatible := True else Backport_Caliber_GH1Compatible := False;
{$ENDIF PATCH_BACKPORT}
{$IFDEF PATCH_GH}
  {$IFDEF DEBUG}
					end else if cmd = 'DEBUG_MEMORYLEAK' then begin
						if ExtractTF(S) then DEBUG_MemoryLeak := True else DEBUG_MemoryLeak := False;
					end else if cmd = 'DEBUG_TRACEMACRO' then begin
						if ExtractTF(S) then DEBUG_TraceMacro := True else DEBUG_TraceMacro := False;
					end else if cmd = 'DEBUG_GRABBED_GEAR' then begin
						if ExtractTF(S) then DEBUG_Grabbed_Gear := True else DEBUG_Grabbed_Gear := False;
					end else if cmd = 'DEBUG_SCRIPT_DYNAMICENCOUNTER' then begin
						if ExtractTF(S) then DEBUG_SCRIPT_DynamicEncounter := True else DEBUG_SCRIPT_DynamicEncounter := False;
					end else if cmd = 'DEBUG_DONOT_NIL_GRABBED_GEAR_WHEN_NEWGEAR' then begin
						if ExtractTF(S) then DEBUG_DONOT_NIL_Grabbed_Gear_when_NewGear := True else DEBUG_DONOT_NIL_Grabbed_Gear_when_NewGear := False;
					end else if cmd = 'DEBUG_DONOT_NIL_GRABBED_GEAR_WHEN_DISPOSEGEAR' then begin
						if ExtractTF(S) then DEBUG_DONOT_NIL_Grabbed_Gear_when_DisposeGear := True else DEBUG_DONOT_NIL_Grabbed_Gear_when_DisposeGear := False;
					end else if cmd = 'DEBUG_DONOT_NIL_GRABBED_GEAR_WHEN_DELEGEGG' then begin
						if ExtractTF(S) then DEBUG_DONOT_NIL_Grabbed_Gear_when_DelegeGG := True else DEBUG_DONOT_NIL_Grabbed_Gear_when_DelegeGG := False;
					end else if cmd = 'DEBUG_DONOT_NIL_GRABBED_GEAR_WHEN_ENDSTORY' then begin
						if ExtractTF(S) then DEBUG_DONOT_NIL_Grabbed_Gear_when_EndStory := True else DEBUG_DONOT_NIL_Grabbed_Gear_when_EndStory := False;
					end else if cmd = 'DEBUG_DONOT_NIL_GRABBED_GEAR_WHEN_CLEANUPSTORYPLOTS' then begin
						if ExtractTF(S) then DEBUG_DONOT_NIL_Grabbed_Gear_when_CleanupStoryPlots := True else DEBUG_DONOT_NIL_Grabbed_Gear_when_CleanupStoryPlots := False;
					end else if cmd = 'DEBUG_DONOT_NIL_GRABBED_GEAR_WHEN_PURGE_GG_ABSOLUTELYNOTHING' then begin
						if ExtractTF(S) then DEBUG_DONOT_NIL_Grabbed_Gear_when_Purge_GG_AbsolutelyNothing := True else DEBUG_DONOT_NIL_Grabbed_Gear_when_Purge_GG_AbsolutelyNothing := False;
					end else if cmd = 'DEBUG_DONOT_NIL_GRABBED_GEAR_WHEN_MARK_GG_DisposeGear' then begin
						if ExtractTF(S) then DEBUG_DONOT_NIL_Grabbed_Gear_when_Mark_GG_DisposeGear := True else DEBUG_DONOT_NIL_Grabbed_Gear_when_Mark_GG_DisposeGear := False;
					end else if cmd = 'DEBUG_DONOT_NIL_GRABBED_GEAR_WHEN_PURGE_GG_DisposeGear' then begin
						if ExtractTF(S) then DEBUG_DONOT_NIL_Grabbed_Gear_when_Purge_GG_DisposeGear := True else DEBUG_DONOT_NIL_Grabbed_Gear_when_Purge_GG_DisposeGear := False;
					end else if cmd = 'DEBUG_DONOT_NIL_GRABBED_GEAR_WHEN_CHANGE_SCENE' then begin
						if ExtractTF(S) then DEBUG_DONOT_NIL_Grabbed_Gear_when_Change_Scene := True else DEBUG_DONOT_NIL_Grabbed_Gear_when_Change_Scene := False;
					end else if cmd = 'DEBUG_DONOT_NIL_SCRIPT_DYNAMICENCOUNTER' then begin
						if ExtractTF(S) then DEBUG_DONOT_NIL_SCRIPT_DynamicEncounter := True else DEBUG_DONOT_NIL_SCRIPT_DynamicEncounter := False;
					end else if cmd = 'DEBUG_FORCE_EXEC_MACROUPDATE_WHEN_RESTORE' then begin
						if ExtractTF(S) then DEBUG_FORCE_EXEC_MacroUPDATE_when_Restore := True else DEBUG_FORCE_EXEC_MacroUPDATE_when_Restore := False;
					end else if cmd = 'DEBUG_FORCE_EXEC_MACROSTART_WHEN_RESTORE' then begin
						if ExtractTF(S) then DEBUG_FORCE_EXEC_MacroSTART_when_Restore := True else DEBUG_FORCE_EXEC_MacroSTART_when_Restore := False;
					end else if cmd = 'DEBUG_STOP_MACRORESTORESTART_WHEN_RESTORE' then begin
						if ExtractTF(S) then DEBUG_STOP_MacroRESTORESTART_when_Restore := True else DEBUG_STOP_MacroRESTORESTART_when_Restore := False;
					end else if cmd = 'DEBUG_FORCE_RESTOCKRANDOMMONSTERS_WHEN_RESTORE' then begin
						if ExtractTF(S) then DEBUG_FORCE_RestockRandomMonsters_when_Restore := True else DEBUG_FORCE_RestockRandomMonsters_when_Restore := False;
					end else if cmd = 'DEBUG_MAXCID' then begin
						if ExtractTF(S) then DEBUG_MaxCID := True else DEBUG_MaxCID := False;
					end else if cmd = 'DEBUG_MAXNID' then begin
						if ExtractTF(S) then DEBUG_MaxNID := True else DEBUG_MaxNID := False;
					end else if cmd = 'DEBUG_CANSEEALL' then begin
						if ExtractTF(S) then DEBUG_CanSeeAll := True else DEBUG_CanSeeAll := False;
  {$ENDIF DEBUG}
{$ENDIF PATCH_GH}
{$IFDEF PATCH_GH}
					end else if cmd = '%' then begin
					end else if (False = Done) then begin
						ErrorMessage_fork('Unknown option : ' + cmd);
{$ENDIF PATCH_GH}
					end;
				end;
			end;

			{ Once the EOF has been reached, close the file. }
			Close(F);
		end;

	end;



initialization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: ui4gh.pp');
{$ENDIF DEBUG}
{$IFDEF PATCH_I18N}
	I18N_Help_Keymap_Name := LoadStringList( I18N_Help_Keymap_Name_File );
	I18N_Help_Keymap_Desc := LoadStringList( I18N_Help_Keymap_Desc_File );
	Load_I18N_Default;
{$ENDIF PATCH_I18N}
	LoadConfig;
end;


finalization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: ui4gh.pp(finalization)');
{$ENDIF DEBUG}
{$IFDEF PATCH_I18N}
	DisposeSAtt( I18N_Help_Keymap_Desc );
	DisposeSAtt( I18N_Help_Keymap_Name );
{$ENDIF PATCH_I18N}
end;

end.
