unit version;
{ Define version strings. }

interface


const
	Version_org = '1.100-github';
  {$I stamp.inc}
	Version_txt: String = '';
	Version_all: String = '';
	rcsid = '@(#) $version: GearHead Arena v' + Version_org + ' BIN:' + Version_I18N + ' $';

	Version_Generate_TAG = 'VERSION_GENERATE';
	Version_Start_TAG    = 'VERSION_START';
	Version_Running_TAG  = 'VERSION_RUNNING';



implementation

uses	dos
{$IFDEF DEBUG}
	,errmsg
{$ENDIF DEBUG}
	;

const
	FN_Version_txt = 'txt_stamp.txt';


Procedure load_version;
var
	S: String;
	F: Text;
begin
	S := FSearch( FN_Version_txt, '.' );
	if S <> '' then begin
		Assign( F, S );
		Reset( F );
		ReadLn( F, Version_txt );
		Close( F );
	end;
	Version_all := Version_org + ' BIN:' + Version_I18N + ' MSG:' + Version_txt;
end;


initialization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: version.pp');
{$ENDIF DEBUG}
	load_version;
end;

finalization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: version.pp(finalization)');
{$ENDIF DEBUG}
end;

end.
