{$IFDEF GUIMSWINMODE}
{ Proposed and made by l0ugh, Internationalizationed by G-HAL. }
{ GearHead W32 non-console ASCII port }
unit w32crt;

interface

uses windows,dos;

const
{ Foreground and background color constants }
	Black         = 0;
	Blue          = 1;
	Green         = 2;
	Cyan          = 3;
	Red           = 4;
	Magenta       = 5;
	Brown         = 6;
	LightGray     = 7;

{ Foreground color constants }
	DarkGray      = 8;
	LightBlue     = 9;
	LightGreen    = 10;
	LightCyan     = 11;
	LightRed      = 12;
	LightMagenta  = 13;
	Yellow        = 14;
	White         = 15;

{ configuration file }
{ to avoid circular unit reference this defined here instead of gears.pp }
	WIN_CONFIG_FILE = 'win.cfg';

	keybufsize = 63;

Procedure ClrEol( myhdc: Windows.HDC );
Procedure ClrEol;
Procedure ClrScr;
Procedure CursorOn;
Procedure CursorOff;
Procedure Delay( MS: Word );
Procedure GotoXY( X: Byte; Y: Byte );
Function KeyPressed: Boolean;
Function ReadKey: Char;
Procedure TextBackground( CL: Byte );
Procedure TextColor( CL: Byte );
Function WhereX: Byte;
Function WhereY: Byte;
Procedure Window( AX1, AY1, AX2, AY2: Byte );
Function W32GetLine( it: String ): String;
Function W32GetLine: String;
Procedure W32WriteLn( const Str: String );
Procedure W32Write( myhdc: Windows.HDC; const Str: String );
Procedure W32Write( const Str: String );
Procedure W32WriteChar( myhdc: Windows.HDC; c: Char );
Procedure W32WriteChar( c: Char );
Procedure W32CrtInit;
Procedure NormVideo;
Function DisposeWindow: LongInt;



implementation

uses iconv,texutil,
{$IFDEF PATCH_GH}
	errmsg,
{$ELSE PATCH_GH}
  {$IFDEF DEBUG}
	errmsg,
  {$ENDIF DEBUG}
{$ENDIF PATCH_GH}
	w32;

Procedure DebugLog( Str: String );
var
	F: Text;
	S: String;
begin
	Assign( F, 'debuglog.txt' );
	S := FSearch( 'debuglog.txt', '.' );
	if ( S <> '' ) then begin
		Append( F );
	end else begin
		Rewrite( F );
	end;

	WriteLn( F, Str );
	Close( F );
end;

{ -------- color table -------- }
const
	MaxColorTable = 15;
var
	colortable: array[0..MaxColorTable] of Windows.COLORREF = (
		$00000000,	{RGB(   0,    0,    0),}	{ black }
		$00c00000,	{RGB(   0,    0, 0xc0),}	{ blue }
		$00008000,	{RGB(   0, 0x80,    0),}	{ green }
		$00808000,	{RGB(   0, 0x80, 0x80),}	{ cyan }
		$000000c0,	{RGB(0xc0,    0,    0),}	{ red }
		$00800080,	{RGB(0x80,    0, 0x80),}	{ magenta }
		$00006080,	{RGB(0x80, 0x60,    0),}	{ brown }
		$00c0c0c0,	{RGB(0xc0, 0xc0, 0xc0),}	{ lightgray }
		$00808080,	{RGB(0x80, 0x80, 0x80),}	{ darkgray }
		$00ff0000,	{RGB(   0,    0, 0xff),}	{ light blue }
		$0000ff00,	{RGB(   0, 0xff,    0),}	{ light green }
		$00ffff00,	{RGB(   0, 0xff, 0xff),}	{ light cyan }
		$000000ff,	{RGB(0xff,    0,    0),}	{ light red }
		$00ff00ff,	{RGB(0xff,    0, 0xff),}	{ light magenta }
		$0000ffff,	{RGB(0xff, 0xff,    0),}	{ yellow }
		$00ffffff	{RGB(0xff, 0xff, 0xff)}		{ white }
	);

{ -------- Virtual Console-VRAM -------- }
const
	MaxMultibyteLen = 8;
var
	MaxCol: Integer = 80;
	MaxRow: Integer = 25;
	chara: PChar = NIL;	{ Text Image }
	fgcol: PBYTE = NIL;	{ foreground color }
	bgcol: PBYTE = NIL;	{ background color }
	currfgc: Integer = MaxColorTable;
	currbgc: Integer = 0;

	{ cursorstate: Integer; }
	cursorx: Integer = 0;
	cursory: Integer = 0;

	x1, x2, y1, y2: Integer;	{ clipping }

	FONTH, FONTW: Integer;
	WIN_X, WIN_Y: LongInt;
	FontName: String;
	FontWeight: Integer;
	bWindowClosing: Boolean = True;

	myhwnd: Windows.HWND;

{ -------- font -------- }
var
	myfont: Windows.HFONT;

Procedure PrepareFont;
var
	lf: Windows.LOGFONT;
begin
	Windows.ZeroMemory( @lf, sizeof(Windows.LOGFONT) );
	With lf do
	begin
		lfHeight		:= FONTH;
		lfOutPrecision		:= Windows.OUT_DEFAULT_PRECIS;
		lfClipPrecision		:= Windows.CLIP_DEFAULT_PRECIS;
		lfQuality		:= Windows.DEFAULT_QUALITY;
		lfWeight		:= FontWeight;
		lfPitchAndFamily	:= Windows.FIXED_PITCH or Windows.FF_DONTCARE;
		lfFaceName		:= FontName + #0;
		lfCharSet		:= Windows.DEFAULT_CHARSET;
	end;
	myfont := Windows.CreateFontIndirect( @lf );

	{if creating font failed, then create default font.}
	if ( myfont = 0 ) then begin
		FONTH := 16;
		FONTW := 8;
		FontName := 'Terminal';
		With lf do begin
			lfHeight		:= FONTH;
			lfFaceName		:= FontName + #0;
			lfWeight		:= 0;
		end;
		myfont := Windows.CreateFontIndirect( @lf );
		if ( myfont = 0 ) then begin
			Windows.MessageBox(
				myhwnd,
				'failed to create font. program will be aborted.'#0,
				'Sorry'#0,
				Windows.MB_OK or Windows.MB_ICONERROR );
			DisposeWindow;
		end;
	end;
end;

Procedure DestroyFont;
begin
	if ( not Windows.DeleteObject(myfont) ) then begin
{$IFDEF PATCH_GH}
		ErrorMessage( 'failed to delete font. ' );
{$ELSE PATCH_GH}
		WriteLn( 'failed to delete font. ' );
{$ENDIF PATCH_GH}
	end;
	myfont := 0;
end;

{ -------- Key Buffering -------- }
var
	keybuf: array[0..keybufsize] of Char;
	keybufrp: Integer;
	keybufwp: Integer;

Procedure KeybufPut( c: Char );
begin
	if (((keybufwp+1) and keybufsize) <> keybufrp) then
	begin
		keybuf[keybufwp] := c;
		keybufwp := (keybufwp + 1) and keybufsize;
	end;
end;

Function KeybufEmpty: Boolean;
begin
	KeybufEmpty := (keybufrp = keybufwp);
end;

Function KeybufGet: Char;
var
	c: Char;
begin
	if (KeybufEmpty) then Exit(#0);
	c := keybuf[keybufrp];
	keybufrp := (keybufrp + 1) and keybufsize;
	KeybufGet := c;
end;

{ -------- window proc -------- }
Procedure RedrawArea( myhdc: Windows.HDC; ax1, ay1, ax2, ay2: BYTE );
var
	mybrush: Windows.HBRUSH;
	r: Windows.RECT;
	i, j, k: Integer;
	hFontOld: Windows.HFONT;
	MBCharLen: Integer;
begin
	if bWindowClosing then Exit;
	if ( myfont = 0 ) then exit;
	hFontOld := Windows.SelectObject( myhdc, myfont );

{$IFDEF DEBUG}
	mybrush := Windows.CreateSolidBrush( colortable[currfgc] );
{$ELSE DEBUG}
	mybrush := Windows.CreateSolidBrush( colortable[currbgc] );
{$ENDIF DEBUG}
	Windows.SetRect( @r, ax1*FONTW, ay1*FONTH, (ax2+1)*FONTW, (ay2+1)*FONTH );
	Windows.FillRect( myhdc, r, mybrush );
	Windows.DeleteObject( mybrush );

	for i := ay1 to ay2 do begin
		k := i * MaxCol + ax1;
		j := ax1;
		while j <= ax2 do begin
			if (' ' = chara[k*MaxMultibyteLen]) or (#$0 = chara[k*MaxMultibyteLen]) then begin
				mybrush := Windows.CreateSolidBrush( colortable[bgcol[k]] );
				Windows.SetRect( @r, j*FONTW, i*FONTH, (j+1)*FONTW, (i+1)*FONTH );
				Windows.FillRect( myhdc, r, mybrush );
				Windows.DeleteObject( mybrush );
				Inc( k );
				Inc( j );
			end else begin
				Windows.SetTextColor( myhdc, colortable[fgcol[k]] );
				Windows.SetBkColor( myhdc, colortable[bgcol[k]] );
{$IFDEF WITH_TENC}
				MBCharLen := LengthMBChar( chara[k*MaxMultibyteLen], TENC );
{$ELSE WITH_TENC}
				MBCharLen := LengthMBChar( chara[k*MaxMultibyteLen] );
{$ENDIF WITH_TENC}
				if 1 < MBCharLen then begin
					Windows.TextOut( myhdc, j*FONTW, i*FONTH, @chara[k*MaxMultibyteLen], MBCharLen );
					k := k + 2;
					j := j + 2;
				end else begin
					Windows.TextOut( myhdc, j*FONTW, i*FONTH, @chara[k*MaxMultibyteLen], 1 );
					Inc( k );
					Inc( j );
				end;
			end;
		end;
	end;
	Windows.SelectObject( myhdc, hFontOld );
end;

Function MyWndProc( myhwnd: Windows.HWND; msg: Windows.UINT; wp: Windows.WPARAM; lp: Windows.LPARAM ): Windows.LRESULT; StdCall;
const
	KB_STAT_LEN = 256;
var
	myhdc: Windows.HDC;
	ps: Windows.PAINTSTRUCT;
	c: Char;
	kb_stat: array[0..(KB_STAT_LEN-1)] of BYTE;
begin
	Case msg of

	    Windows.WM_CREATE:
		begin
			PrepareFont;
		end;

	    Windows.WM_PAINT:
		begin
			myhdc := Windows.BeginPaint( myhwnd, @ps );
			RedrawArea( myhdc, 0,0, (MaxCol - 1),(MaxRow - 1) );
			Windows.EndPaint( myhwnd, @ps );
			exit(0);
		end;

	    Windows.WM_DESTROY:
		begin
			DestroyFont;
			Windows.PostQuitMessage( 0 );
			exit(0);
		end;

	    Windows.WM_CLOSE:
		begin
			if ( not bWindowClosing ) then begin
				Windows.MessageBox( myhwnd, 'Please Quit from a game menu.'#0, 'Sorry'#0, Windows.MB_OK );
				exit(0);
			end;
		end;

	    Windows.WM_CHAR:
		begin
			c := Chr( wp );
			KeybufPut( c );
			exit(0);
		end;

	    Windows.WM_KEYDOWN: {, Windows.WM_KEYUP:}
		begin
			{ get current keyboard status }
			Windows.ZeroMemory( @kb_stat[0], KB_STAT_LEN );
			Windows.GetKeyboardState( @kb_stat[0] );
			c := #0;

			{ process numberpad keys }
			Case wp of
			    Windows.VK_INSERT: c := ',';
			    Windows.VK_END:    c := '1';
			    Windows.VK_DOWN:   c := '2';
			    Windows.VK_NEXT:   c := '3';
			    Windows.VK_LEFT:   c := '4';
			    Windows.VK_CLEAR:  c := '5';
			    Windows.VK_RIGHT:  c := '6';
			    Windows.VK_HOME:   c := '7';
			    Windows.VK_UP:     c := '8';
			    Windows.VK_PRIOR:  c := '9';
			    Windows.VK_DELETE: c := #$1b;
			    Windows.VK_F1:     begin KeybufPut(#0); c := #123; end;
			    Windows.VK_F2:     begin KeybufPut(#0); c := #124; end;
			    Windows.VK_F3:     begin KeybufPut(#0); c := #125; end;
			    Windows.VK_F4:     begin KeybufPut(#0); c := #126; end;
			    Windows.VK_F5:     begin KeybufPut(#0); c := #127; end;
			    Windows.VK_F6:     begin KeybufPut(#0); c := #128; end;
			    Windows.VK_F7:     begin KeybufPut(#0); c := #129; end;
			    Windows.VK_F8:     begin KeybufPut(#0); c := #130; end;
			    Windows.VK_F9:     begin KeybufPut(#0); c := #131; end;
			    Windows.VK_F10:    begin KeybufPut(#0); c := #132; end;
			    Windows.VK_F11:    begin KeybufPut(#0); c := #133; end;
			    Windows.VK_F12:    begin KeybufPut(#0); c := #134; end;
			end;

			if ((c <> #0) and ((kb_stat[wp] and $80{KEY_PRESSED}) <> 0)) then
			begin
				KeybufPut( c );
				exit(0);
			end;

		end;{KEYDOWN,KEYUP}

	end;

	MyWndProc := Windows.DefWindowProc( myhwnd, msg, wp, lp );
end;

Procedure LoadWinCfg;
{$IFDEF WITH_TENC}
const
	cmsgLen = 32;
{$ENDIF WITH_TENC}
var
	F: Text;
	S, CMD, C: String;
	T: Integer;
	ColorNum: Integer;
{$IFDEF WITH_TENC}
	pmsg: PChar;
	tmsg: Array[0..cmsgLen] of Char;
	ptmsg: PChar;
{$ENDIF WITH_TENC}
begin

	WIN_X := -1;
	WIN_Y := -1;
	FONTH := MSWINGUI_FontSize;
	FONTW := MSWINGUI_FontSize div 2;
{$IFDEF WITH_TENC}
	pmsg := QuickPCopy( MSWINGUI_FontName );
	ptmsg := tmsg;
	Conv_FromTenc( pmsg, Length(pmsg), ptmsg, cmsgLen );
	Dispose( pmsg );
	FontName   := StrPas( tmsg );
{$ELSE WITH_TENC}
	FontName   := MSWINGUI_FontName;
{$ENDIF WITH_TENC}
	FontWeight := MSWINGUI_FontWeight;

	S := FSearch( WIN_CONFIG_FILE, '.' );
	if S <> '' then begin
		Assign( F, S );
		Reset( F );

		while not Eof(F) do begin
			ReadLn( F, S );
			if ( S[1] = '%' ) then continue;
			cmd := UpCase( ExtractWord( S ) );
			if ( cmd = 'FONTHEIGHT' ) then begin
				T := ExtractValue( S );
				if ( T > 0 ) then begin
					FONTH := T;
					FONTW := T DIV 2;
				end;
			end else if ( cmd = 'FONTNAME' ) then begin
				C := '';
				while S <> '' do begin
					if ( C <> '' ) then C := C + ' ';
					C := C + ExtractWord( S );
				end;
				FontName := C;
			end else if ( cmd = 'WINPOS_X' ) then begin
				T := ExtractValue( S );
				if ( T > 0 ) then begin
					WIN_X := T;
				end;
			end else if ( cmd = 'WINPOS_Y' ) then begin
				T := ExtractValue( S );
				if ( T > 0 ) then begin
					WIN_Y := T;
				end;
			end else if ( cmd = 'FONTWEIGHT' ) then begin
				T := ExtractValue( S );
				if ( ( T > 0 ) and ( T <= 900 ) ) then begin
					FontWeight := T;
				end;
			end else if ( cmd = 'COLOR' ) then begin
				ColorNum := ExtractValue( S );
				if (0 <= ColorNum) and (ColorNum <= MaxColorTable) then begin
					colortable[ColorNum] := ExtractValue( S ) * $10000 + ExtractValue( S ) * $100 + ExtractValue( S ) * $1;
				end;
			end;
		end;
		Close( F );
	end;
end;

{$IFDEF 0}
Procedure SaveWinCfg;
var
	F: Text;
	r: Windows.RECT;
begin
	Windows.GetWindowRect( myhwnd, @r );
	WIN_X := r.left;
	WIN_Y := r.top;

	Assign( F, WIN_CONFIG_FILE );
	Rewrite( F );
	WriteLn( F, '% window configuration file' );
	WriteLn( F, '' );
	WriteLn( F, '% font name' );
	WriteLn( F, 'FontName ' + FontName );
	WriteLn( F, '% height of the font' );
	WriteLn( F, 'FontHeight ' + BSTR(FONTH) );
	WriteLn( F, '% weight of the font (default 0, bold = 700)' );
	WriteLn( F, 'FontWeight ' + BSTR(FontWeight) );
	WriteLn( F, '% x position of the window' );
	WriteLn( F, 'WinPos_X ' + BSTR(WIN_X) );
	WriteLn( F, '% y position of the window' );
	WriteLn( F, 'WinPos_Y ' + BSTR(WIN_Y) );
	Close( F );
end;
{$ENDIF 0}

{ -------- main -------- }
Procedure MyMain;
const
	mywndclassname = 'GHWindow'#0;
	mywndtitle = 'GearHead'#0;
var
	wndclass: Windows.WNDCLASSEX;
	myhinst: Windows.HINST;
	r:  Windows.RECT;
	hDeskWnd: Windows.HWND;
	deskRect: Windows.RECT;
begin
	myhinst := Windows.GetModuleHandle( NIL );
	LoadWinCfg;

	With wndclass do
	begin
		cbSize        := sizeof(wndclass);
		style         := Windows.CS_HREDRAW or Windows.CS_VREDRAW;
		lpfnWndProc   := @MyWndProc;
		cbClsExtra    := 0;
		cbWndExtra    := 0;
		hInstance     := myhinst;
		hIcon         := Windows.LoadIcon( 0, Windows.IDI_APPLICATION );
		hCursor       := Windows.LoadCursor( 0, Windows.IDC_ARROW );
		hbrBackground := Windows.GetStockObject( Windows.BLACK_BRUSH );
		lpszMenuName  := NIL;
		lpszClassName := mywndclassname;
		hIconSm       := Windows.LoadIcon( 0, Windows.IDI_APPLICATION );
	end;

	Windows.RegisterClassEx( @wndclass );

	myhwnd := Windows.CreateWindow(
			mywndclassname,			{ name of window class }
			mywndtitle,				{ title of the window }
			Windows.WS_OVERLAPPEDWINDOW and (not Windows.WS_THICKFRAME),	
									{ style of the window }
			0, 0,					{ position of the window }
			10,{temp}				{ size of the window }
			10,{temp}
			0,						{ handle of the parent window }
			0,						{ handle of the menu }
			myhinst,				{ handle of the instance }
			NIL );					{ pointer to window arguments }

	With r do
	begin
		r.left   := 0;
		r.top    := 0;
		r.right  := FONTW * MaxCol;
		r.bottom := FONTH * MaxRow;
	end;
	Windows.AdjustWindowRect( @r, Windows.WS_OVERLAPPEDWINDOW and (not Windows.WS_THICKFRAME), FALSE{nomenu} );
	if ( ( WIN_X = -1 ) and ( WIN_Y = -1 ) ) then begin
		hDeskWnd := Windows.GetDesktopWindow;
		Windows.GetWindowRect( hDeskWnd, @deskRect );
		WIN_X := (deskRect.right - (r.right - r.left) ) DIV 2;
		WIN_Y := (deskRect.bottom - (r.bottom - r.top) ) DIV 2;
	end;
	Windows.SetWindowPos( myhwnd, 0, WIN_X, WIN_Y, r.right - r.left, r.bottom - r.top,
		Windows.SWP_NOACTIVATE or Windows.SWP_NOMOVE or Windows.SWP_NOZORDER {or Windows.SWP_NOREDRAW} );
	Windows.MoveWindow( myhwnd, WIN_X, WIN_Y, r.right - r.left, r.bottom - r.top, FALSE );
	Windows.ShowWindow( myhwnd, Windows.SW_SHOWDEFAULT );
	Windows.UpdateWindow( myhwnd );

end;

{----------------------------------------------------------------------------------}
Procedure ClrEol( myhdc: Windows.HDC );
var
	i, j, m: Integer;
	mybrush: Windows.HBRUSH;
	r: Windows.RECT;
begin
	if bWindowClosing then Exit;

	j := cursory * MaxCol + cursorx;
	for i := cursorx to x2 do
	begin
		for m := 0 to (MaxMultibyteLen - 1) do begin
			chara[j*MaxMultibyteLen+m] := #$0;
		end;
		chara[j*MaxMultibyteLen] := ' ';
		fgcol[j] := currfgc;
		bgcol[j] := currbgc;
		j := j+1;
	end;
	if (myhwnd = 0) then exit;
	if (myhdc  = 0) then exit;

{$IFDEF DEBUG}
	mybrush := Windows.CreateSolidBrush( colortable[currfgc] );
{$ELSE DEBUG}
	mybrush := Windows.CreateSolidBrush( colortable[currbgc] );
{$ENDIF DEBUG}
	Windows.SetRect( @r, cursorx*FONTW, cursory*FONTH, (x2+1)*FONTW, (cursory+1)*FONTH );
	Windows.FillRect( myhdc, r, mybrush );
	Windows.DeleteObject( mybrush );
end;

Procedure ClrEol;
var
	myhdc: Windows.HDC;
begin
	if ( myhwnd = 0 ) then exit;
	myhdc := Windows.GetDC( myhwnd );
	ClrEol( myhdc );
	Windows.ReleaseDC( myhwnd, myhdc );
end;


Procedure ClrScr;
var
	i, j, k, m: Integer;
	myhdc: Windows.HDC;
	mybrush: Windows.HBRUSH;
	r: Windows.RECT;
begin
	if bWindowClosing then Exit;

	for i := y1 to y2 do
	begin
		k := i * MaxCol + x1;
		for j := x1 to x2 do
		begin
			for m := 0 to (MaxMultibyteLen - 1) do begin
				chara[k*MaxMultibyteLen+m] := #$0;
			end;
			chara[k*MaxMultibyteLen] := ' ';
			fgcol[k] := currfgc;
			bgcol[k] := currbgc;
			k := k + 1;
		end;
	end;
	if (myhwnd = 0) then exit;
	myhdc := Windows.GetDC( myhwnd );
{$IFDEF DEBUG}
	mybrush := Windows.CreateSolidBrush( colortable[currfgc] );
{$ELSE DEBUG}
	mybrush := Windows.CreateSolidBrush( colortable[currbgc] );
{$ENDIF DEBUG}
	Windows.SetRect( @r, x1*FONTW, y1*FONTH, (x2+1)*FONTW, (y2+1)*FONTH );
	Windows.FillRect( myhdc, r, mybrush );
	Windows.DeleteObject( mybrush );
	Windows.ReleaseDC( myhwnd, myhdc );
end;

Procedure CursorOn;
begin
end;

Procedure CursorOff;
begin
end;

Procedure Delay(MS: Word);
begin
	Windows.Sleep( MS );
end;

Procedure GotoXY( X: Byte; Y: Byte );
begin
	cursorx := X - 1 + x1;
	cursory := Y - 1 + y1;
	if (cursorx < x1) then cursorx := x1
	else if (cursorx > x2) then cursorx := x2;
	if (cursory < y1) then cursory := y1
	else if (cursory > y2) then cursory := y2;
end;

Function KeyPressed: Boolean;
begin
	KeyPressed := not KeybufEmpty;
end;

Function ReadKeyOrig: Char;
var
	mymsg: Windows.MSG;
begin
	while KeybufEmpty do
	begin
		if (Windows.PeekMessage(@mymsg, 0, 0, 0, Windows.PM_NOREMOVE)) then
		begin
			if (not Windows.GetMessage(@mymsg, 0, 0, 0)) then break;
			Windows.TranslateMessage( @mymsg );
			Windows.DispatchMessage( @mymsg );
		end
		else Windows.Sleep( 10 );
	end;
	ReadKeyOrig := KeybufGet;
end;

Function ReadKey: Char;
var
	c: Char;
begin
	c := ReadKeyOrig;
	Case c of
	    #$08:	c := '[';	{^h}
	    #$0a:	c := '-';	{^j}
	    #$0b:	c := '=';	{^k}
	    #$0c:	c := ']';	{^l}
	    #$03:	c := #$1b;	{^c}
	    #$05:	c := '8';	{^e}
	    #$18:	c := '2';	{^x}
	end;
	ReadKey := c;
end;

Procedure TextBackground( CL: Byte );
begin
	currbgc := CL;
end;

Procedure TextColor( CL: Byte );
begin
	currfgc := CL;
end;

Function WhereX: Byte;
begin
	WhereX := cursorx - x1 + 1;
end;

Function WhereY: Byte;
begin
	WhereY := cursory - y1 + 1;
end;

Procedure Window( AX1, AY1, AX2, AY2: Byte );
var
	i: Integer;
begin
	x1 := AX1-1;
	y1 := AY1-1;
	x2 := AX2-1;
	y2 := AY2-1;
	if (x1 > x2) then begin i := x1; x1 := x2; x2 := i; end;
	if (y1 > y2) then begin i := y1; y1 := y2; y2 := i; end;
	if (x1 < 0) then x1 := 0;
	if (y1 < 0) then y1 := 0;
	if (x2 > (MaxCol - 1)) then x2 := (MaxCol - 1);
	if (y2 > (MaxRow - 1)) then y2 := (MaxRow - 1);
	cursorx := x1;
	cursory := y1;
end;

Procedure NormVideo;
begin
	currfgc := LightGray;
	currbgc := Black;
	Window( 0,0, (MaxCol - 1),(MaxRow - 1) );
	ClrScr;
end;

Procedure ScrollOneLine( myhdc: Windows.HDC );
var
	i, j, k, l, m: Integer;
begin
	if bWindowClosing then Exit;
	if ( myhdc = 0 ) then exit;

	if y1 < y2 then
	begin
		for i := y1 + 1 to y2 do
		begin
			k := (i-1) * MaxCol + x1;
			l := i * MaxCol + x1;
			for j := x1 to x2 do
			begin
				for m := 0 to (MaxMultibyteLen - 1) do begin
					chara[k*MaxMultibyteLen+m] := chara[l*MaxMultibyteLen+m];
				end;
				fgcol[k] := fgcol[l];
				bgcol[k] := bgcol[l];
				Inc( k );
				Inc( l );
			end;
		end;
		RedrawArea( myhdc, x1,y1, x2,y2-1 );
		ClrEol( myhdc );
	end;
end;

Procedure W32Write( myhdc: Windows.HDC; const Str: String );
var
	i, j, k: Integer;
	l, n, p: Integer;
	ux1, ux2, uy1, uy2: Integer;
	MBCharLen: Integer;
begin
	if bWindowClosing then Exit;
	if (myhwnd = 0) then exit;
	if (myhdc  = 0) then exit;

	l := Length(Str);
	if (l = 0) then exit;

	ux1 := cursorx;
	uy1 := cursory;
	ux2 := cursorx;
	uy2 := cursory;
	p := 1;
	repeat
		n := x2 - cursorx + 1;
		if (n > l) then n := l;

		j := cursory * MaxCol + cursorx;
		i := 1;
		while i <= n do begin
{$IFDEF WITH_TENC}
			MBCharLen := LengthMBChar( Str[p], TENC );
{$ELSE WITH_TENC}
			MBCharLen := LengthMBChar( Str[p] );
{$ENDIF WITH_TENC}
			if l < MBCharLen then begin
				{ If the last char is incompleted multibyte character, exit loop. }
				l := -1;
				break;
			end;
			if 1 < MBCharLen then begin
				if (i + 1) <= n then begin
					{ multibyte character }
					l := l - MBCharLen;
					for k := 0 to (MBCharLen - 1) do begin
						chara[j*MaxMultibyteLen+k] := Str[p];
						Inc( p );
					end;
					fgcol[j] := currfgc;
					bgcol[j] := currbgc;
					Inc( cursorx );
					Inc( j );
					Inc( i );
					chara[j*MaxMultibyteLen] := #$0;
					fgcol[j] := currfgc;
					bgcol[j] := currbgc;
					Inc( cursorx );
					Inc( j );
					Inc( i );
				end else begin
					{ first byte of multibyte char is placed at last of line }
					while cursorx <= x2 do begin
						for k := 0 to (MBCharLen - 1) do begin
							chara[j*MaxMultibyteLen+k] := #$0;
						end;
						chara[j*MaxMultibyteLen] := ' ';
						fgcol[j] := currfgc;
						bgcol[j] := currbgc;
						Inc( cursorx );
						Inc( j );
					end;
					cursorx := 9999;
					break;
				end;
			end else begin
				{ single byte character }
				Dec( l );
				for k := 0 to (MBCharLen - 1) do begin
					chara[j*MaxMultibyteLen+k] := #$0;
				end;
				chara[j*MaxMultibyteLen] := Str[p];
				Inc( p );
				fgcol[j] := currfgc;
				bgcol[j] := currbgc;
				Inc( cursorx );
				Inc( j );
				Inc( i );
			end;
		end;
		if ( ux2 < cursorx ) then ux2 := cursorx;

		if (cursorx > x2) then
		begin
			cursorx := x1;
			cursory := cursory + 1;
			ux2 := x2;
			if (cursory > y2) then
			begin
				cursory := y2;
				{ ScrollOneLine( myhdc ); }
				{ ClrEol( myhdc ); }
				uy1 := y1;
				uy2 := y2;
			end;
		end;
		if ( cursorx < ux1 ) then ux1 := cursorx;
		uy2 := cursory;

	until l <= 0;

	RedrawArea( myhdc, ux1, uy1, ux2, uy2 );
end;

Procedure W32Write( const Str: String );
var
	myhdc: Windows.HDC;
begin
	if (myhwnd = 0) then exit;
	myhdc := Windows.GetDC( myhwnd );
	W32Write( myhdc, Str );
	Windows.ReleaseDC( myhwnd, myhdc );
end;

Procedure W32WriteChar( myhdc: Windows.HDC; c: Char );
var
	j, k: Integer;
begin
	if bWindowClosing then Exit;
	if (myhwnd = 0) then exit;
	if (myhdc  = 0) then exit;

	j := cursory * MaxCol + cursorx;
	if ((chara[j*MaxMultibyteLen] <> c) or (fgcol[j] <> currfgc) or (bgcol[j] <> currbgc)) then begin
		for k := 0 to (MaxMultibyteLen - 1) do begin
			chara[j*MaxMultibyteLen+k] := #$0;
		end;
		chara[j*MaxMultibyteLen] := c;
		fgcol[j] := currfgc;
		bgcol[j] := currbgc;
		RedrawArea( myhdc, cursorx, cursory, cursorx, cursory );
	end;
	cursorx := cursorx + 1;
	if (cursorx > x2) then begin
		cursorx := x1;
		cursory := cursory + 1;
		if (cursory > y2) then begin
			cursory := y2;
			{ ScrollOneLine( myhdc ); }
			{ ClrEol( myhdc ); }
		end;
	end;
end;

Procedure W32WriteChar( c: Char );
var
	myhdc: Windows.HDC;
begin
	if ( myhwnd = 0 ) then exit;

	myhdc := Windows.GetDC( myhwnd );
	W32WriteChar( myhdc, c );
	Windows.ReleaseDC( myhwnd, myhdc );
end;


Procedure W32WriteLn( const Str: String );
var
	myhdc: Windows.HDC;
begin
	if (myhwnd = 0) then exit;
	myhdc := Windows.GetDC( myhwnd );

	if (Str <> '') then W32Write( myhdc, Str );
	cursorx := x1;
	Inc( cursory );
	if cursory > y2 then
	begin
		cursory := y2;
		ScrollOneLine( myhdc );
		ClrEol( myhdc );
	end;

	Windows.ReleaseDC( myhwnd, myhdc );
end;

Function W32GetLine: String;
begin
	W32GetLine := W32GetLine('');
end;

Function W32GetLine( it: String ): String;
const
{$IFDEF IBMGraphics}
	CARETCHR = #$16;
{$ELSE}
	CARETCHR = '_';
{$ENDIF}
var
	buf: String;
	c: Char;
	x, y: Integer;
	len, mxl: Integer;
	myhdc: Windows.HDC;
	clen: Integer;
	i: Integer;
begin
	if (myhwnd = 0) then exit;
	myhdc := Windows.GetDC( myhwnd );
	if (myhdc = 0 ) then exit;

	buf := it;
	len := Length(buf);

	x := WhereX;
	y := WhereY;
	mxl := (x2-x1+1) - (x-1) - 1;

	W32Write( myhdc, buf + CARETCHR );
	ClrEol( myhdc );
	repeat
		c := ReadKeyOrig;
		if #$08 = c then begin
			{ Backspace }
{$IFDEF WITH_TENC}
			clen := Length(TailMBChar(buf,TENC));
{$ELSE WITH_TENC}
			clen := Length(TailMBChar(buf));
{$ENDIF WITH_TENC}
			buf := Copy( buf, 1, Length(buf) - clen );
			len := len - clen;
		end else if #$15 = c then begin
			{ Clear Line }
			buf := '';
			len := 0;
		end else if #$1b = c then begin
			{ Esc - cancelled }
			buf := '';
			c := #$0d; {exit loop}
		end else if TextISO646_AllowableCheck(c) then begin
			if len < mxl then begin
				buf := buf + c;
				Inc( len );
			end;
{$IFDEF WITH_TENC}
		end else if IsMBCharLeadByte(c,TENC) then begin
			clen := LengthMBChar( c, TENC );
{$ELSE WITH_TENC}
		end else if IsMBCharLeadByte(c) then begin
			clen := LengthMBChar( c );
{$ENDIF WITH_TENC}
			if clen <= 1 then begin
			end else begin
					if (len + clen) < mxl then begin
					buf := buf + c;
					i := clen - 1;
					while 0 < i do begin
						buf := buf + ReadKeyOrig;
						Dec( i );
					end;
					len := len + clen;
				end else begin
					i := clen - 1;
					while 0 < i do begin
						ReadKeyOrig;
						Dec( i );
					end;
				end;
			end;
		end;
		GotoXY( x, y );
		W32Write( myhdc, buf + CARETCHR );
		ClrEol( myhdc );
	until (#$0d = c) or (#$0a = c);

	Windows.ReleaseDC( myhwnd, myhdc );
	W32GetLine := buf;
end;

Procedure W32CrtInit;
begin
	if bWindowClosing then begin
		MaxCol := MSWINGUI_Width;
		MaxRow := MSWINGUI_Height;
		chara := AllocMem( MaxCol * MaxRow * MaxMultibyteLen );
		fgcol := AllocMem( MaxCol * MaxRow );
		bgcol := AllocMem( MaxCol * MaxRow );
		if (NIL = chara) or (NIL = fgcol) or (NIL = bgcol) then begin
{$IFDEF PATCH_GH}
			ErrorMessage('ERROR- w32crt. Out of memory.');
{$ELSE PATCH_GH}
			WriteLn('ERROR- w32crt. Out of memory.');
{$ENDIF PATCH_GH}
			halt(255);
		end;
		bWindowClosing := False;
	end;
	MyMain;
	NormVideo;
end;

Function DisposeWindow: LongInt;
var
	mymsg: Windows.MSG;
begin
	if not bWindowClosing then begin
		{ SaveWinCfg; }
		bWindowClosing := true;
		Windows.SendMessage( myhwnd, Windows.WM_CLOSE, 0, 0 );
		{ while ( Windows.GetMessage(@mymsg, 0, 0, 0) > 0) do begin}
		while ( Windows.GetMessage( @mymsg, 0, 0, 0 ) ) do begin
			{ no dispatch. }
		end;
		FreeMem( bgcol );
		FreeMem( fgcol );
		FreeMem( chara );
		bgcol := NIL;
		fgcol := NIL;
		chara := NIL;
		DisposeWindow := mymsg.wParam;
	end else begin
		DisposeWindow := 0;
	end;
end;

{----------------------------------------------------------------------------------}
initialization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: w32crt.pp');
{$ENDIF DEBUG}
end;

finalization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: w32crt.pp(finalization)');
{$ENDIF DEBUG}
end;

end.
{$ENDIF GUIMSWINMODE}
