{$IFDEF Windows}
unit w32eb;
{GearHead W32 EditBox}


interface

uses windows;

Function EditBox( const title, text: String ): String;

implementation

uses strings,
{$IFDEF PATCH_GH}
	errmsg,
{$ELSE PATCH_GH}
  {$IFDEF DEBUG}
	errmsg,
  {$ENDIF DEBUG}
{$ENDIF PATCH_GH}
	iconv,texutil,
	imm,w32;

const
	mywcname = 'GHEditDialog'#0;
	MaxTextBuf = 255;

var
	myhwSDL: Windows.HWND;
	myhinst: Windows.HINST;
	mydlg: Windows.HWND;
	dlgTitle: Windows.HWND;
	dlgEdit: Windows.HWND;
	Org_edit: Windows.WNDPROC;
	myfont: Windows.HFONT;
	textbuf: array[0..MaxTextBuf] of Char;
	bIMEMode: Boolean = False;
	dw : LongInt = 550;
	bw : LongInt = 10;
	th : LongInt = 30;
	hbBorderBlue: Windows.HBRUSH;


Function myTextHeight( hw: Windows.HWND ): LongInt;
var
	hd: Windows.HDC;
	sz: Windows.SIZE;
begin
	hd := Windows.GetDC( hw );
	Windows.GetTextExtentPoint32( hd, 'My'#0, 2, sz );
	Windows.ReleaseDC( hw, hd );
	myTextHeight := sz.cy;
end;

Function myWndPos( myhwnd: Windows.HWND ): Windows.RECT;
{$IFDEF WITH_TENC}
const
	cmsgLen = 255;
{$ENDIF WITH_TENC}
var
	wp: Windows.WINDOWPLACEMENT;
	msg: String;
	pmsg: PChar;
{$IFDEF WITH_TENC}
	tmsg: Array[0..cmsgLen] of Char;
	ptmsg: PChar;
{$ENDIF WITH_TENC}
begin
	wp.length := sizeof(wp);
	if Windows.GetWindowPlacement( myhwnd, wp ) = False then begin
		msg := 'Windows.GetWindowPlacement() failed.';
		pmsg := QuickPCopy(msg);
{$IFDEF WITH_TENC}
		ptmsg := tmsg;
		Conv_ToTenc( pmsg, Length(pmsg), ptmsg, cmsgLen );
		Windows.MessageBox( 0, tmsg, 'Sorry'#0, MB_OK );
{$ELSE WITH_TENC}
		Windows.MessageBox( 0, pmsg, 'Sorry'#0, MB_OK );
{$ENDIF WITH_TENC}
		Dispose( pmsg );
	end;
	myWndPos := wp.rcNormalPosition;
end;

Function EditProc( myhwnd: Windows.HWND; msg: UINT; wp: Windows.WPARAM; lp: Windows.LPARAM ): Windows.LRESULT; StdCall;
var
	c: Char;
	i,j: Integer;
	state: Integer;
begin
	Case msg of
	    Windows.WM_CHAR:
		begin
			c := Chr( wp );
			if #$15 = c then begin
				Windows.SetWindowText( dlgEdit, ''#0 );
				exit(0);
			end else if (c <= #$1F) or (#$7F <= c) then begin
			end else if not TextISO646_AllowableCheck(c) then begin
				exit(0);
			end;
		end;

	    Windows.WM_KEYDOWN:
		begin
			if (wp = Windows.VK_ESCAPE) then begin
				textbuf[0] := #0;

				Windows.EnableWindow( myhwSDL, True );
				Windows.BringWindowToTop( myhwSDL );
				Windows.DestroyWindow( mydlg );
				mydlg := 0;
				exit(0);
			end;

			if (wp = Windows.VK_RETURN) or (wp = Windows.VK_SEPARATOR) then begin
				Windows.GetWindowText( dlgEdit, textbuf, MaxTextBuf);

				textbuf[MaxTextBuf] := #0;
				i := 0;
				while i < MaxTextBuf do begin
					if #0 = textbuf[i] then begin
						break;
					end else if TextISO646_AllowableCheck(textbuf[i]) then begin
						Inc( i );
{$IFDEF WITH_TENC}
					end else if IsMBCharLeadByte(textbuf[i],TENC) then begin
						state := LengthMBChar( textbuf[i], TENC );
						i := i + state;
{$ELSE WITH_TENC}
					end else if IsMBCharLeadByte(textbuf[i]) then begin
						state := LengthMBChar( textbuf[i] );
						i := i + state;
{$ENDIF WITH_TENC}
					end else begin
						for j := i + 1 to MaxTextBuf do begin
							textbuf[j - 1] := textbuf[j];
						end;
					end;
				end;

				Windows.EnableWindow( myhwSDL, True );
				Windows.BringWindowToTop( myhwSDL );
				Windows.DestroyWindow( mydlg );
				mydlg := 0;
				exit(0);
			end;
		end;
	end;
	EditProc := Windows.CallWindowProc( Org_edit, myhwnd, msg, wp, lp );
end;

Procedure PrepareDlgProc( myhwnd: Windows.HWND );
var
	lf: Windows.LOGFONT;
	myhimc: imm.HIMC;
{$IFDEF WITH_TENC}
	pmsg: PChar;
	ptmsg: PChar;
{$ENDIF WITH_TENC}
begin
	Windows.ZeroMemory( @lf, sizeof(Windows.LOGFONT) );
{$IFDEF WITH_TENC}
	pmsg := QuickPCopy( MSWINGUI_FontName );
	ptmsg := lf.lfFaceName;
	Conv_FromTenc( pmsg, Length(pmsg), ptmsg, sizeof(lf.lfFaceName) );
	Dispose( pmsg );
{$ENDIF WITH_TENC}
	With lf do
	begin
		lfHeight		:= MSWINGUI_FontSize;
		lfOutPrecision		:= Windows.OUT_DEFAULT_PRECIS;
		lfClipPrecision		:= Windows.CLIP_DEFAULT_PRECIS;
		lfQuality		:= Windows.DEFAULT_QUALITY;
		lfWeight		:= MSWINGUI_FontWeight;
		lfPitchAndFamily	:= Windows.FIXED_PITCH or Windows.FF_DONTCARE;
{$IFDEF WITH_TENC}
{$ELSE WITH_TENC}
		lfFaceName		:= MSWINGUI_FontName + #0;
{$ENDIF WITH_TENC}
		lfCharSet		:= Windows.DEFAULT_CHARSET;
	end;
	myfont := Windows.CreateFontIndirect( @lf );

	dlgTitle := Windows.CreateWindow(
		'STATIC'#0, Nil,
		Windows.WS_CHILD or Windows.WS_VISIBLE or Windows.SS_CENTER,
		bw, bw, dw-bw*2, th*2,
		myhwnd, Windows.HMENU(1), myhInst, NIL );
	dlgEdit := Windows.CreateWindow(
		'EDIT'#0, NIL,
		Windows.WS_CHILD or Windows.WS_VISIBLE or Windows.ES_CENTER,
		bw, bw*2+th*2, dw-bw*2, th,
		myhwnd, Windows.HMENU(2), myhInst, NIL );
	Org_edit := Windows.WNDPROC( Windows.GetWindowLong(dlgEdit, Windows.GWL_WNDPROC) );
	Windows.SetWindowLong( dlgEdit, Windows.GWL_WNDPROC, LongInt(@EditProc) );

	myhimc := imm.ImmGetContext( myhwnd );
	imm.ImmSetOpenStatus( myhimc, bIMEMode );
	imm.ImmReleaseContext( myhwnd, myhimc );
end;

Procedure DestroyDlgProc( myhwnd: Windows.HWND );
var
	myhimc: imm.HIMC;
begin
	if ( not Windows.DeleteObject(myfont) ) then begin
{$IFDEF PATCH_GH}
		ErrorMessage( 'failed to delete font. ' );
{$ELSE PATCH_GH}
		WriteLn( 'failed to delete font. ' );
{$ENDIF PATCH_GH}
	end;
	myfont := 0;

	myhimc := imm.ImmGetContext( myhwnd );
	bIMEMode := imm.ImmGetOpenStatus( myhimc );
	imm.ImmSetOpenStatus( myhimc, False );
	imm.ImmReleaseContext( myhwnd, myhimc );
end;

Function DlgProc( myhwnd: Windows.HWND; msg: UINT; wp: Windows.WPARAM; lp: Windows.LPARAM ): Windows.LRESULT; StdCall;
var
	hd: Windows.HDC;
begin
	Case msg of
	    Windows.WM_CREATE:
		begin
			PrepareDlgProc( myhwnd );
		end;

	    Windows.WM_DESTROY:
		begin
			DestroyDlgProc( myhwnd );
		end;

	    Windows.WM_SETFOCUS:
		begin
			Windows.SetFocus( dlgEdit );
		end;

	    Windows.WM_CTLCOLORSTATIC:
		begin
			hd := Windows.HDC(wp);
			if (dlgTitle = Windows.HWND(lp)) then begin
				Windows.SelectObject( hd, myfont );
				Windows.SetBkMode( hd, Windows.TRANSPARENT );
				Windows.SetTextColor( hd, Windows.RGB(255,255,255) );
				Windows.SetBkColor( hd, Windows.RGB(0,101,151) );
				exit(Windows.LRESULT(hbBorderBlue));
			end;
		end;

	    Windows.WM_CTLCOLOREDIT:
		begin
			hd := Windows.HDC(wp);
			if (dlgEdit = Windows.HWND(lp)) then begin
				Windows.SelectObject( hd, myfont );
				Windows.SetTextColor( hd, Windows.RGB(0,141,0) );
				Windows.SetBkColor( hd, Windows.RGB(0,0,0) );
				exit(Windows.LRESULT( Windows.GetStockObject(Windows.BLACK_BRUSH) ));
			end;
		end;
	end;
	DlgProc := Windows.DefWindowProc( myhwnd, msg, wp, lp );
end;


Function EditBox( const title , text: String ): String;
{$IFDEF WITH_TENC}
const
	cmsgLen = 255;
{$ENDIF WITH_TENC}
var
	mymsg: Windows.MSG;
	rc: Windows.RECT;
	pt: PChar;
	msg: String;
	pmsg: PChar;
{$IFDEF WITH_TENC}
	tmsg: Array[0..cmsgLen] of Char;
	ptmsg: PChar;
{$ENDIF WITH_TENC}
begin
	myhwSDL := GetSDLHWND;
	th := myTextHeight(myhwSDL) + 3;
	rc := myWndPos(myhwSDL);

	mydlg := Windows.CreateWindow(
		mywcname, NIL,
		DWORD(Windows.WS_POPUP) or Windows.WS_BORDER,	{<-Cast: error Range Check...}
		rc.left+40, rc.top+300, dw, bw*3+th*3,
		myhwSDL, 0, myhInst, NIL );

	if mydlg = 0 then begin
		msg := 'Windows.CreateWindow() failed.';
		pmsg := QuickPCopy(msg);
{$IFDEF WITH_TENC}
		ptmsg := tmsg;
		Conv_ToTenc( pmsg, Length(pmsg), ptmsg, cmsgLen );
		Windows.MessageBox( 0, tmsg, 'Sorry'#0, MB_OK );
{$ELSE WITH_TENC}
		Windows.MessageBox( 0, pmsg, 'Sorry'#0, MB_OK );
{$ENDIF WITH_TENC}
		Dispose( pmsg );
	end;

	pt := QuickPCopy( title );
{$IFDEF WITH_TENC}
	pmsg := pt;
	ptmsg := tmsg;
	Conv_ToTenc( pmsg, Length(pmsg), ptmsg, cmsgLen );
	Windows.SetWindowText( dlgTitle, tmsg );
{$ELSE WITH_TENC}
	Windows.SetWindowText( dlgTitle, pt );
{$ENDIF WITH_TENC}
	Dispose(pt);
	pt := QuickPCopy( text );
{$IFDEF WITH_TENC}
	pmsg := pt;
	ptmsg := tmsg;
	Conv_ToTenc( pmsg, Length(pmsg), ptmsg, cmsgLen );
	Windows.SetWindowText( dlgEdit, tmsg );
{$ELSE WITH_TENC}
	Windows.SetWindowText( dlgEdit, pt );
{$ENDIF WITH_TENC}
	Dispose(pt);

	Windows.SetFocus( dlgEdit );
	Windows.SendMessage( dlgEdit, Windows.EM_SETSEL, 0, -1 );
	Windows.ShowWindow( mydlg, SW_SHOW );
	Windows.EnableWindow( myhwSDL, FALSE );

	while( mydlg <> 0 ) do begin
		Windows.GetMessage( @mymsg, 0, 0, 0 );
		Windows.TranslateMessage( @mymsg );
		Windows.DispatchMessage( @mymsg );
	end;

	pmsg := textbuf;
{$IFDEF WITH_TENC}
	ptmsg := tmsg;
	Conv_FromTenc( pmsg, Length(pmsg), ptmsg, cmsgLen );
	EditBox := StrPas(tmsg);
{$ELSE WITH_TENC}
	EditBox := StrPas(pmsg);
{$ENDIF WITH_TENC}
end;

Procedure InitEditBox;
{$IFDEF WITH_TENC}
const
	cmsgLen = 255;
{$ENDIF WITH_TENC}
var
	mywc: Windows.WNDCLASSEX;
	msg: String;
	pmsg: PChar;
{$IFDEF WITH_TENC}
	tmsg: Array[0..cmsgLen] of Char;
	ptmsg: PChar;
{$ENDIF WITH_TENC}
begin
	myhinst := Windows.GetModuleHandle( NIL );

	With mywc do
	begin
		cbSize        := sizeof(mywc);
		style         := Windows.CS_HREDRAW or Windows.CS_VREDRAW;
		lpfnWndProc   := @DlgProc;
		cbClsExtra    := 0;
		cbWndExtra    := 0;
		hInstance     := myhinst;
		hIcon         := 0;
		hCursor       := Windows.LoadCursor( 0, Windows.IDC_ARROW );
		hbrBackground := hbBorderBlue;
		lpszMenuName  := NIL;
		lpszClassName := mywcname;
		hIconSm       := 0;
	end;

	if (Windows.RegisterClassEX( @mywc ) = 0) then begin
		msg := 'Windows.RegisterClassEX() failed.';
		pmsg := QuickPCopy(msg);
{$IFDEF WITH_TENC}
		ptmsg := tmsg;
		Conv_ToTenc( pmsg, Length(pmsg), ptmsg, cmsgLen );
		Windows.MessageBox( 0, tmsg, 'Sorry'#0, MB_OK );
{$ELSE WITH_TENC}
		Windows.MessageBox( 0, pmsg, 'Sorry'#0, MB_OK );
{$ENDIF WITH_TENC}
		Dispose( pmsg );
	end;
end;



initialization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: w32eb.pp');
{$ENDIF DEBUG}
	hbBorderBlue := Windows.CreateSolidBrush( Windows.RGB(0,101,151) );
	InitEditBox;
end;

finalization
begin
{$IFDEF DEBUG}
	ErrorMessage_fork('DEBUG: w32eb.pp(finalization)');
{$ENDIF DEBUG}
	Windows.DeleteObject( hbBorderBlue );
end;

end.
{$ENDIF Windows}
