<?php

###############################################################################
# japanese_utf-8.php
#
# This is the Japanese language file for Geeklog
# Special thanks to Mischa Polivanov for his work on this project
#
# Copyright (C) 2000 Jason Whittenburg
# jwhitten AT securitygeeks DOT com
# Copyright (C) 2002,2003,2004,2005,2006 SAKATA Yusuke
# sakata AT ecofirm.com
# Copyright (C) 2008 Takahiro Kambe
# taca AT back-street DOT net
# Copyright (C) 2006,2007,2008 Tetsuko Komma
# ivy AT geeklog DOT jp
# Copyright (C) 2006,2007,2008 Geeklog.jp group
# info AT geeklog DOT jp
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

$LANG_CHARSET = 'utf-8';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => '投稿者:',
    2 => '続きを読む',
    3 => 'コメント',
    4 => '編集',
    5 => '',
    6 => '',
    7 => '',
    8 => '',
    9 => '管理機能:',
    10 => '投稿管理',
    11 => '記事',
    12 => 'ブロック',
    13 => '話題',
    14 => '',
    15 => '',
    16 => '',
    17 => 'ユーザ',
    18 => 'SQL Query',
    19 => 'ログアウト',
    20 => 'ユーザ情報:',
    21 => 'ユーザ名',
    22 => 'ユーザID',
    23 => '管理レベル',
    24 => 'ゲストユーザ',
    25 => 'コメントを追加',
    26 => 'サイト管理者はコメントに関する責任を負いません。',
    27 => '最新の投稿',
    28 => '削除',
    29 => '-',
    30 => '過去の記事',
    31 => '使用できるHTMLタグ:',
    32 => 'エラー。ユーザ名が入力されていません。',
    33 => 'エラー。ログファイルに書き込めません。',
    34 => 'エラー',
    35 => 'ログアウト',
    36 => '',
    37 => '-',
    38 => 'フィード',
    39 => '更新',
    40 => '',
    41 => 'ゲストユーザ',
    42 => '投稿者:',
    43 => 'コメントを追加',
    44 => '元の記事',
    45 => 'MySQLのエラー番号は、',
    46 => 'MySQLのエラーメッセージは、',
    47 => 'ログイン',
    48 => 'マイアカウント',
    49 => '設定',
    50 => 'SQL文にエラーがあります。',
    51 => 'ヘルプ',
    52 => '新規',
    53 => '管理画面',
    54 => 'ファイルが開けません。',
    55 => 'エラー発生 ',
    56 => '投票',
    57 => 'パスワード',
    58 => 'ログイン',
    59 => "<a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">新規登録</a>",
    60 => 'コメント投稿',
    61 => 'アカウント登録',
    62 => 'ワード',
    63 => 'コメントの設定',
    64 => '記事を友人にメールする',
    65 => '印刷用ページ',
    66 => '',
    67 => 'ようこそ! ',
    68 => 'ホーム',
    69 => '連絡先',
    70 => '検索',
    71 => '記事投稿',
    72 => 'リンク',
    73 => '',
    74 => '',
    75 => '検索オプション',
    76 => 'サイト情報',
    77 => 'プラグイン',
    78 => '',
    79 => '新着情報',
    80 => '件の記事（',
    81 => '件の記事（',
    82 => '時間以内）',
    83 => 'コメント',
    84 => '',
    85 => '（48時間以内）',
    86 => '  -',
    87 => '（最近2週間）',
    88 => '',
    89 => '',
    90 => 'ホーム',
    91 => 'ページ作成時間',
    92 => '秒',
    93 => 'Copyright',
    94 => '本ページのすべての商標と著作権はそれぞれの所有者に帰属します。',
    95 => 'Powered by',
    96 => 'グループ',
    97 => 'ワードリスト',
    98 => 'プラグイン',
    99 => '記事',
    100 => '-',
    101 => '',
    102 => '',
    103 => 'データベース',
    104 => ':',
    105 => 'メール',
    106 => '閲覧数',
    107 => 'GLバージョンテスト',
    108 => 'キャッシュをクリア',
    109 => '迷惑報告',
    110 => '投稿をサイト管理者に通知する',
    111 => '',
    112 => '登録ユーザ数',
    113 => 'ドキュメント',
    114 => 'トラックバック',
    115 => '-',
    116 => 'トラックバック',
    117 => '記事一覧',
    118 => '続きのページへ:',
    119 => "<a href=\"{$_CONF['site_url']}/users.php?mode=getpassword\" rel=\"nofollow\">パスワード再設定</a>",
    120 => 'このコメントへのパーマリンク',
    121 => 'コメント (%d件)',
    122 => 'トラックバック (%d件)',
    123 => 'すべてのHTMLを許可。',
    124 => '選択されたアイテムを削除するならここをクリック',
    125 => '選択されたアイテムを削除してよいですか?',
    126 => 'すべて選択または選択を解除',
    127 => 'パーマリンク',
    128 => 'OpenIDログイン:',
    129 => 'コンフィギュレーション',
    130 => 'Webサービス',
    131 => 'HTMLは使えません',
    132 => 'インフォメーション',
    133 => '重要',
    134 => 'ヘルプ',
    135 => '警告',
    136 => '警告: 強化機能のためにJavaScriptを推薦します',
    137 => '警告: JavaScriptが機能を有効にするのに必要です',
    138 => "JavaScriptを使わないようアドバンストエディタを無効にしてノーマルエディタを有効にするには<a href=\"{$_CONF['site_url']}/usersettings.php\" rel=\"nofollow\">こちら</a>をクリックしてください。",
    139 => "ホームページへは<a href=\"{$_CONF['site_url']}/\" rel=\"nofollow\">こちら</a>をクリック"
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => 'コメントの投稿',
    2 => '投稿方法',
    3 => 'ログアウト',
    4 => 'アカウントを作る',
    5 => 'ユーザ名',
    6 => 'コメントの投稿の前にログインしてください。アカウントを登録していなければ、下のフォームで登録してください。',
    7 => 'あなたは',
    8 => " 秒前にコメントしています。投稿と投稿の間は {$_CONF['commentspeedlimit']} 秒以上あけてください。",
    9 => 'コメント',
    10 => 'レポートを送る',
    11 => 'コメントの投稿',
    12 => '投稿するためには、タイトルと本文が必要です。',
    13 => 'あなたの情報',
    14 => 'プレビュー',
    15 => 'この投稿のレポート',
    16 => 'タイトル',
    17 => 'エラーです',
    18 => '注意事項',
    19 => '内容にそった話題で投稿してください。',
    20 => 'できるだけ新しいスレッドを立てず、コメントを追加してください。',
    21 => '他の人のコメントをよく読んで同じようなコメントを投稿しないようにしてください。',
    22 => '内容がよくわかるタイトルをつけてください。',
    23 => 'あなたのメールアドレスは表示されません!（保護されています）',
    24 => 'ゲストユーザ',
    25 => '投稿をサイト管理者に通知してよいですか?',
    26 => '%s さんが以下の投稿を迷惑だと指摘しています:',
    27 => '迷惑通知',
    28 => 'プレビューする',
    29 => '投稿する',
    30 => '編集:',
    31 => 'by',
    32 => 'コメント編集',
    33 => 'コメント投稿編集',
    34 => '投稿プレビュー',
    35 => '変更をキューに保存',
    36 => '返信があったらメールで通知',
    37 => '新規コメント',
    38 => 'あなたのコメント\'%s\'に返信がありました。',
    39 => '次のアドレスでコメントのスレッドを見ることができます:',
    40 => '返信の通知が不要な場合は、次のリンクを参照してください:',
    41 => 'こんにちは %s,',
    42 => '通知解除',
    43 => '返信の通知を解除する',
    44 => 'あなたの名前'
);

###############################################################################
# users.php

$LANG04 = array(
    1 => 'アカウント情報',
    2 => 'ユーザ名',
    3 => '氏名',
    4 => 'パスワード',
    5 => 'メール',
    6 => 'ホームページ',
    7 => '自己紹介',
    8 => 'PGP鍵',
    9 => '保存する',
    10 => '最新コメント(10件)',
    11 => '-',
    12 => 'ユーザ情報',
    13 => 'メールでダイジェストを読む',
    14 => "なお、パスワードの変更をおすすめします。\nサイトにログインし、「マイアカウント」をクリックすると、パスワードを変更できます。",
    15 => "{$_CONF['site_name']}からのお知らせです。\n\n{$_CONF['site_name']} であなたのアカウントが作成されました。\n下記のユーザ名とパスワードでログインしてください。\nこのメールは念のため保存してください。",
    16 => 'ユーザ情報',
    17 => 'アカウントがありません',
    18 => 'このメールアドレスは有効なアドレスではないようです',
    19 => 'ユーザ名かメールアドレスが既に使われています。',
    20 => 'このメールアドレスは有効なアドレスではないようです',
    21 => 'エラー',
    22 => '新規登録',
    23 => "{$_CONF['site_name']}にユーザアカウントを登録すると、コメントや記事の投稿をあなたの名前で投稿できます。そうでなければゲストユーザとしてしか投稿できません。なお、サイト上でメールアドレスが表示されることはありませんのでご安心ください。ユーザ名は30文字以内で、半角・全角どちらも利用できます。",
    24 => 'パスワードはここに入力されたメールアドレス宛てに送信されます。',
    25 => 'パスワード再設定',
    26 => 'ご登録頂いているユーザ名またはメールアドレスの<strong>どちらかを入力</strong>して「送信」ボタンを押してください。ご登録のメールアドレス宛にパスワード再設定用のURLを記載したメールが送信されます。',
    27 => '新規登録',
    28 => '送信',
    29 => 'ログアウトしました:',
    30 => 'ログインしました:',
    31 => 'ログインが必要です。',
    32 => '署名',
    33 => '公開されることはありません',
    34 => '本名',
    35 => '変更後のパスワード',
    36 => 'http://から始めてください',
    37 => 'あなたのコメントに使用されます。',
    38 => 'あなたの紹介文です。公開されます。',
    39 => 'あなたの公開PGP鍵',
    40 => '話題アイコン非表示',
    41 => '修正を受け入れる',
    42 => '日時のフォーマット',
    43 => '記事の表示最大数',
    44 => 'ブロック非表示',
    45 => '表示設定',
    46 => '次のアイテムを除外',
    47 => 'ニュースボックスの設定',
    48 => '話題',
    49 => '記事に話題アイコンを表示しない',
    50 => '興味がなければチェックをはずしてください',
    51 => 'メインコンテンツだけを表示する',
    52 => 'デフォルト:',
    53 => 'その日の記事を毎晩メールで受け取る。',
    54 => '読みたくない投稿者名と話題をチェックしてください。',
    55 => 'すべてのチェックをはずした場合は、デフォルトが反映されます。一つでもチェックした場合、デフォルトは無視されますので、読みたいものを全部チェックするようにしてください。 デフォルトは強調表示されている話題です。',
    56 => '投稿者名',
    57 => '表示モード',
    58 => 'ソート順',
    59 => 'コメントの最大数',
    60 => 'コメントの表示方法',
    61 => '順番',
    62 => 'デフォルトは100件です',
    63 => "パスワードをメールで送信しました。メッセージにログイン方法をご案内しています。{$_CONF['site_name']}のご利用をお待ちしています。",
    64 => 'コメントの設定:',
    65 => '再度ログインしてください',
    66 => 'ログインに失敗しました。再度ログインしてください。',
    67 => '登録日時',
    68 => '認証の保存期間',
    69 => 'いったんログインした後、どのくらい認証情報を残しますか?',
    70 => "{$_CONF['site_name']}の表示と内容を設定",
    71 => "{$_CONF['site_name']}では、レイアウトを自由に変えることができます。そのためには、まず、{$_CONF['site_name']}に<a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">登録</a>する必要があります。もし、既に登録済みなら左のフォームを利用してログインしてください。",
    72 => 'テーマ',
    73 => '言語',
    74 => 'このサイトのデザインを変更',
    75 => '記事がメールで送信されました。送信先:',
    76 => '下記のリストから話題を選択すれば、毎晩その話題の記事をメールで受け取ることができます。興味のある話題だけ選択してください。',
    77 => '写真',
    78 => '写真を追加',
    79 => '写真を削除する場合、ここをチェックしてください',
    80 => 'ログイン',
    81 => 'メール送信',
    82 => '最新投稿（10件）',
    83 => '投稿状況',
    84 => '投稿記事の総数:',
    85 => 'コメントの総数:',
    86 => 'すべての投稿を検索する:',
    87 => 'あなたのログイン名',
    88 => "%s さん、こんにちは。\n\n{$_CONF['site_name']}よりお知らせです。\n\n以下のページよりパスワード再設定の手続きを行い、そのパスワードで\n今後はログインするようにしてください。\n\nなお、このメールに覚えがない場合、他の方がメールアドレスを間違えて\n入力された可能性があります。パスワードを変更されることはございません\nのでご安心ください。\n\n",
    89 => "パスワードを変えたくない場合はこのメッセージを無視してください。(パスワードは変わりません。) \n\n",
    90 => '新しいパスワードを入力して「再設定」ボタンを押してください。',
    91 => '再設定',
    92 => 'パスワードを再設定する',
    93 => 'パスワード再設定は %d 秒前に行われています。%d 秒お待ちください。',
    94 => 'アカウント（"%s"）を削除',
    95 => 'あなたのアカウントを削除するには、下の「アカウント削除」ボタンをクリックしてください。ただし、あなたのアカウント名で投稿された記事やコメントは<strong>削除されません</strong>。これらの記事やコメントは「ゲストユーザ」の投稿として表示されます。',
    96 => 'アカウント削除',
    97 => 'アカウント削除の確認',
    98 => '本当にアカウントを削除しますか。削除すると、このサイトに新しいアカウントを作らない限り、ログインできなくなります。よろしければ、もう一度「アカウント削除」ボタンをクリックしてください。',
    99 => 'プライバシーオプション:',
    100 => '管理者からのメール',
    101 => 'サイト管理者からのメールを受け取る',
    102 => '他のユーザからのメール',
    103 => '他のユーザからのメールを受け取る',
    104 => 'オンラインかどうかを表示する',
    105 => '「オンラインユーザ」ブロックにアカウントを表示する',
    106 => '居住地',
    107 => '公開プロフィールで表示',
    108 => 'パスワード（再入力）',
    109 => '新しいパスワードを再入力',
    110 => '現在のパスワード',
    111 => '現在のパスワードを入力してください',
    112 => 'ログイン試行回数を超えてしまいましたので、後ほどまたログインしてみてください。',
    113 => 'ログインできませんでした',
    114 => 'アカウントが無効になっています',
    115 => 'アカウントが無効になりましたのでログインできません。管理者に連絡してください。',
    116 => 'アカウントが有効になるのを待機しています',
    117 => 'あなたのアカウントは管理者が有効にするのを待っています。管理者が承認するまでログインできません。',
    118 => "{$_CONF['site_name']} のあなたのアカウントが有効になりました。以下のリンクから、あなたのユーザ名(<username>)とメールで送られてきたパスワードでログインできます。",
    119 => 'パスワードを紛失した場合、以下のリンクから新しいパスワードを再設定できます。',
    120 => 'アカウントが有効になりました。',
    121 => 'サービス',
    122 => '申し訳ありませんが、ユーザの新規登録は停止中です。',
    123 => "<a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">新規登録</a>",
    124 => '（確認）メールアドレス',
    125 => '両方の入力欄に同じメールアドレスを入力してください。',
    126 => '確認のために同じものを繰り返し入力してください。',
    127 => '設定を変更するには、現在のパスワードを入力する必要があります。',
    128 => 'お名前',
    129 => 'パスワードとメールアドレス',
    130 => '個人情報',
    131 => '毎日のダイジェスト版オプション',
    132 => '毎日のダイジェスト版機能',
    133 => 'コメント表示',
    134 => 'コメントオプション',
    135 => '<li>表示モードのデフォルトを設定してください。</li><li>コメントを表示する際のソート順のデフォルトを設定してください。</li><li>表示するコメントの最大数を設定してください。デフォルトは100件です。</li>',
    136 => '話題と投稿者の除外',
    137 => '記事のフィルタリング',
    138 => 'その他の設定',
    139 => 'レイアウトと言語',
    140 => '<li>「話題別アイコンを非表示」をチェックすると、記事に話題別アイコンが表示されなくなります。</li><li>「ブロック非表示」をチェックすると、管理者メニューブロック・ユーザメニューブロック・話題ブロックのみの表示となります。</li><li>1ページに表示する記事の最大数を設定してください。</li><li>テーマと好みの日時のフォーマットを設定してください。</li>',
    141 => 'プライバシーの設定',
    142 => 'デフォルトでは、他のユーザや管理者があなたにメールアドレスを送ることができ、オンラインかどうかを表示するようになっています。プライバシーを保護するには、対応するオプションのチェックを外してください。',
    143 => 'ブロックのフィルタリング',
    144 => 'ブロックの表示・非表示',
    145 => '公開プロフィール',
    146 => 'パスワードとメールアドレス',
    147 => 'パスワード、メールアドレス、自動ログイン機能を編集します。パスワードとメールアドレスは確認のため、2回入力する必要があります。',
    148 => '個人情報',
    149 => '他のユーザにも読める個人情報を編集します。<ul><li>「署名」はコメントや掲示板の投稿に付加されます。</li><li>「自己紹介」は他のユーザにも読める短い自己紹介です。</li><li>「PGP公開鍵」を公開しましょう。</li></ul>',
    150 => '',
    156 => 'アカウント削除',
    157 => 'アカウント削除オプション',
    158 => 'タイムゾーン',
    159 => 'このメールは自動送信されたものです。返信しないでください。',
    160 => '(最大. %d X %d ピクセル, %d バイト; %s)',
    161 => 'リサイズ',
    162 => 'リサイズなし',
    163 => '再認証エラー',
    164 => '再認証回数を超えました。残念ながら操作はアボートされ、今回の編集作業は失われました。',
    165 => 'アドバンストエディタを使う',
    166 => 'リモートアカウントの再同期'
);

###############################################################################
# Customize if need to modify the Tabbed navbar MyAccount panels used.
# Array index key matches preference div id

$LANG_MYACCOUNT = array(
    'pe_preview' => 'プレビュー',
    'pe_namepass' => 'ユーザ名とパスワード',
    'pe_userinfo' => '個人情報',
    'pe_layout' => 'レイアウトと言語',
    'pe_content' => 'コンテンツ',
    'pe_privacy' => 'プライバシー'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => '記事がありません',
    2 => '記事がありません。この話題の記事がないか表示設定を絞り過ぎなのかのどちらかです。',
    3 => '話題 %s に関する記事',
    4 => '今日の注目記事',
    5 => '次へ',
    6 => '前へ',
    7 => '最初',
    8 => '最後'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => 'メッセージを送信する際にエラーが発生しました。もう一度試してください。',
    2 => 'メッセージは送信されました。',
    3 => 'メールアドレスをただしく入力してください。',
    4 => '名前、メールアドレス、件名、内容をすべて入力してください',
    5 => 'エラー: 該当ユーザはいません。',
    6 => 'エラーが発生しました。',
    7 => 'ユーザ情報',
    8 => '氏名',
    9 => 'URL',
    10 => 'メールの宛先',
    11 => '名前:',
    12 => 'メールアドレス:',
    13 => '件名:',
    14 => '本文:',
    15 => 'HTMLタグは使えません。',
    16 => '送信',
    17 => '友だちに記事を送信する',
    18 => '送信先名',
    19 => '送信先Email',
    20 => '名前',
    21 => '送信元Email',
    22 => 'すべての項目を入力して送信ボタンをクリックしてください',
    23 => "こんにちは!{$_CONF['site_name']}よりお知らせです。\n\n%s さんが\n{$_CONF['site_url']}\nの記事をあなたに知らせたいと思ったため、\n%s のアドレスから送信されました。\nこれはいわゆる迷惑（SPAM）メールではありませんし、\n送信に使用されたアドレスを他の目的に使用することもありません。",
    24 => 'この記事に関するコメントは次の場所でできます。',
    25 => 'この機能を使用するためにはログインしてください。',
    26 => 'このフォームでメールを送ります。',
    27 => 'メッセージ',
    28 => '%s さんからのメッセージ: ',
    29 => "今日の{$_CONF['site_name']} に関するダイジェストです。宛先:",
    30 => ' 今日のニュースレターです。宛先: ',
    31 => 'タイトル',
    32 => '日付',
    33 => '以下の場所で記事全体を読むことができます。',
    34 => 'メッセージは以上です',
    35 => '残念ながらこのユーザはメールを受け付けておりません。',
    36 => 'コピー:',
    37 => '自分宛にコピーを送信',
    38 => "これはあなたが<{$_CONF['site_url']}>から %s へ送信したメールのコピーです:",
    39 => 'あなたはメッセージを ',
    40 => " 秒前に送信しています。少なくとも{$_CONF['speedlimit']}秒待って、次のメッセージを送信してください。"
);

###############################################################################
# search.php

$LANG09 = array(
    1 => '検索オプション',
    2 => 'キーワード',
    3 => '話題',
    4 => 'すべて',
    5 => 'タイプ',
    6 => '記事',
    7 => 'コメント',
    8 => '所有者',
    9 => 'すべて',
    10 => '検索',
    11 => '検索結果',
    12 => '件が該当',
    13 => '記事の検索結果: 該当なし',
    14 => '該当するものはありませんでした',
    15 => '他のキーワードで検索してください。',
    16 => 'タイトル',
    17 => '日付',
    18 => '所有者',
    19 => " {$_CONF['site_name']} サイト内を検索します。",
    20 => '日付',
    21 => ' - ',
    22 => '(書式は YYYY-MM-DD)',
    23 => '件の閲覧',
    24 => '%d件、見つかりました',
    25 => '次のキーワードについて検索:',
    26 => '件',
    27 => '秒',
    28 => '該当する記事・コメントは見つかりませんでした',
    29 => '記事・コメントの検索結果:',
    30 => '',
    31 => 'プラグインからは該当するものを見つかりませんでした',
    32 => '',
    33 => 'URL',
    34 => '場所',
    35 => '一日中',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '検索文字列は3文字以上必要です。',
    42 => '日付の書式は、YYYY-MM-DD（年-月-日）としてください。',
    43 => '完全一致',
    44 => 'すべて含む',
    45 => 'いずれか含む',
    46 => '次',
    47 => '前',
    48 => '所有者',
    49 => '日付',
    50 => '閲覧数',
    51 => '',
    52 => '場所',
    53 => '記事の検索結果',
    54 => 'コメントの検索結果',
    55 => '検索文字列',
    56 => 'AND',
    57 => 'OR',
    58 => '次の検索結果へ &gt;&gt;',
    59 => '1ページあたりの件数',
    60 => '件',
    61 => '検索条件の修正',
    62 => '#',
    63 => '詳細',
    64 => '検索結果 %1$d - %2$d / %3$d 件',
    65 => '記事',
    66 => 'コメント',
    67 => '検索結果 %d 件',
    68 => 'ソート',
    69 => 'タイトルのみ',
    70 => 'ありません ...',
    71 => '昇順',
    72 => '降順'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => 'サイトに関する統計',
    2 => 'システム全体のアクセス数',
    3 => '記事数（コメント数）',
    4 => '',
    5 => '',
    6 => '',
    7 => '記事（上位10件）',
    8 => '記事のタイトル',
    9 => '件',
    10 => 'このサイトには記事が投稿されていないか、閲覧者がいません。',
    11 => 'コメントされた記事（上位10件）',
    12 => '件',
    13 => 'このサイトには記事が投稿されていないか、コメントした人がいません。',
    14 => '',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '',
    22 => 'メールで紹介された記事（上位10件）',
    23 => 'メールアドレス',
    24 => 'メールで紹介された記事はありません。',
    25 => 'トラックバックされた記事（上位10件）',
    26 => 'トラックバックはありません。',
    27 => 'アクティブユーザ数',
    28 => '',
    29 => '',
    30 => '閲覧数',
    31 => ''
);

###############################################################################
# article.php

$LANG11 = array(
    1 => '関連情報',
    2 => '友だちに記事をメールする',
    3 => '印刷用ページ',
    4 => '記事のオプション',
    5 => '',
    6 => '\'%s\'を購読する'
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => ' %s を投稿する前にログインしてください。',
    2 => 'ログイン',
    3 => '新規登録',
    4 => '',
    5 => '',
    6 => '記事の投稿',
    7 => 'ログインが必要です',
    8 => '投稿',
    9 => 'このサイトに情報を投稿する際には、次のルールを守ってください。<ul><li>必要とされるすべての項目を入力してください。</li><li>正確かつ必要十分な情報を提供してください。</li><li>URLについては特に注意して確認してください。</li></ul>',
    10 => 'タイトル',
    11 => '',
    12 => '開始日',
    13 => '終了日',
    14 => '場所',
    15 => '詳細',
    16 => '',
    17 => '',
    18 => '',
    19 => 'はじめにお読みください',
    20 => '',
    21 => '',
    22 => '入力に不備があります',
    23 => 'すべてのフィールドに入力してください。',
    24 => '投稿を受け付けました',
    25 => '%s に関する投稿を受け付けました。',
    26 => '投稿間隔の制限',
    27 => 'ユーザ名',
    28 => '話題',
    29 => '記事',
    30 => '前回、あなたは、',
    31 => "秒前に投稿しています。投稿間隔を{$_CONF['speedlimit']}秒以上にしてください。",
    32 => 'プレビュー',
    33 => '記事のプレビュー',
    34 => 'ログアウト',
    35 => 'HTMLタグは使用できません',
    36 => '投稿モード',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '',
    42 => '',
    43 => '',
    44 => '住所1',
    45 => '住所2',
    46 => '市町村名',
    47 => '都道府県',
    48 => '郵便番号',
    49 => '',
    50 => '',
    51 => '場所',
    52 => '削除',
    53 => 'アカウント作成',
    54 => '記事冒頭文',
    55 => '記事本文'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => '管理権限が必要です',
    2 => 'ログインできません。もう一度入力してください',
    3 => 'パスワードが違います。ユーザ名:',
    4 => 'ユーザ名:',
    5 => 'パスワード:',
    6 => '管理ツールの使用はすべて記録されます。<br' . XHTML . '>このページは管理者のみ使用できます。',
    7 => 'ログイン'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => 'ここを管理する権限がない',
    2 => 'このブロックを編集する権限がありません。',
    3 => 'ブロックの編集',
    4 => 'フィードの読み込みでエラーが発生しました。（error.logを参照してください。）',
    5 => '',
    6 => '',
    7 => 'すべて',
    8 => 'ブロックのセキュリティレベル',
    9 => '順序',
    10 => '',
    11 => 'ポータルブロック',
    12 => 'ノーマルブロック',
    13 => 'ポータルブロックのオプション',
    14 => 'フィードURL',
    15 => 'フィード更新日時',
    16 => 'ノーマルブロックのオプション',
    17 => 'コンテンツ',
    18 => 'ブロックのタイトル・セキュリティレベル・コンテンツを入力してください。',
    19 => 'ブロック管理',
    20 => '',
    21 => 'セキュリティ',
    22 => '',
    23 => '順序',
    24 => '',
    25 => 'ブロックの編集・削除は編集アイコンをクリック、ブロックの作成は上の「新規作成」をクリックしてください。ブロックの移動は、[↑][↓][R][L]をクリックしてください。 ',
    26 => 'レイアウト用ブロック',
    27 => 'PHPブロック',
    28 => 'PHPブロックのオプション',
    29 => '関数',
    30 => 'PHPを使用したブロックを使う場合、接頭子「phpblock_」（例 phpblock_themetester）のPHP関数名を入力してください。この接頭子が付いていない関数は呼び出されません。これは、悪意を持ったユーザがサイトに有害な関数を定義することを避けるためです。ファンクション名の後に"()"を付けると、2つのパラメータをコールします。ひとつめは gl_blocksテーブルの配列。ふたつめは2つの括弧の間のテキストが格納されます。この関数は、あらかじめGeeklogの/path/to/geeklog/system/lib-custom.phpに記述しておかなければなりません。すべてのPHPブロックのコードは、lib-custom.phpに記述します。そうすることにより、Geeklogをスムーズにアップグレードできます。訳注:日本語版では、フォルダ system/customを作成し、その中にカスタム関数を入れて、よりアップグレードしやすい構成にしています。',
    31 => 'PHPブロックにエラーがあります。%sが存在しません。',
    32 => 'エラー。未入力の項目があります',
    33 => 'ポータルブロックのフィードURLを入力してください',
    34 => 'PHPブロックにはタイトルと関数名を入力してください',
    35 => 'ノーマルブロックにはタイトルと内容を入力してください',
    36 => 'レイアウト用ブロックには内容を入力してください',
    37 => 'PHPブロックの関数名が不適切です',
    38 => 'PHPブロックの関数名は、接頭子\'phpblock_\' (例 phpblock_themetester)が必要です。セキュリティ対策のため必要となっています。',
    39 => '表示場所',
    40 => '左',
    41 => '右',
    42 => 'ブロックのタイトルと表示順序を入力してください。',
    43 => 'ホームページのみ',
    44 => '',
    45 => "管理権限のないブロックを編集しようとしました。この行為は記録されます。<a href=\"{$_CONF['site_admin_url']}/block.php\">ブロックの編集</a>画面に戻ってください.",
    46 => '移動',
    47 => '',
    48 => 'ブロックID',
    49 => '(半角英数字とハイフン)',
    50 => 'ブロックIDを入力してください。',
    51 => 'http://を含む',
    52 => '空欄のままにしておくと、このブロックに対するヘルプのアイコンは表示されません',
    53 => '有効',
    54 => '保存',
    55 => 'キャンセル',
    56 => '削除',
    57 => 'ブロックを下に',
    58 => 'ブロックを上に',
    59 => 'ブロックを右側に',
    60 => 'ブロックを左側に',
    61 => 'タイトルなし',
    62 => '表示件数',
    63 => 'ブロックのタイトルが不適切です',
    64 => 'タイトルは空欄ではいけませんし、HTMLを含んでもいけません!',
    65 => '順番',
    66 => '自動タグ',
    67 => '自動タグ使用許可',
    68 => 'このポータルブロックのフィードは長すぎて表示できません。ブロック設定画面でブロックに表示する記事の最大数を設定するか、コンフィギュレーションで標準の最大数を設定してください。'
);

###############################################################################
# admin/story.php

$LANG24 = array(
    1 => '前の記事',
    2 => '後の記事',
    3 => 'モード',
    4 => '投稿モード',
    5 => '記事の編集',
    6 => '記事がありません',
    7 => 'ユーザ',
    8 => '保存',
    9 => 'プレビュー',
    10 => 'キャンセル',
    11 => '削除',
    12 => '記事ID',
    13 => '',
    14 => '',
    15 => '日時',
    16 => '冒頭文',
    17 => '本文',
    18 => '閲覧数',
    19 => 'コメント数',
    20 => 'ピング',
    21 => 'トラックバック・ピングを送る',
    22 => '記事管理',
    23 => '記事の編集・削除は編集アイコンをクリック、記事の閲覧は記事のタイトルをクリック、記事の作成は上の「新規作成」をクリックしてください。',
    24 => '指定した記事IDは既に使われています。他の記事IDを入力してください。',
    25 => '記事の登録中にエラーがありました。',
    26 => '記事のプレビュー',
    27 => '<p>自動タグ[imageX]のかわりに[unscaledX]を使うと、画像はオリジナルのサイズで表示されます。</p>',
    28 => '<p><strong>プレビュー</strong>: 画像付きの記事をプレビューする場合、プレビューボタンをクリックしないで一旦ドラフトモードで保存してください。プレビューボタンは画像がない場合にのみクリックしてください。</p>',
    29 => 'トラックバック数',
    30 => 'ファイルのアップロード時にエラーが発生しました',
    31 => 'タイトルと冒頭文を入力してください',
    32 => '注目記事',
    33 => '注目記事は最後に指定した1件が指定されます',
    34 => 'ドラフト',
    35 => '○',
    36 => '－',
    37 => '同じ投稿者からの投稿:',
    38 => '同じ話題:',
    39 => 'メール紹介',
    40 => '',
    41 => "管理権限のない記事を編集しようとしました。この行為は記録されます。下記の記事は読み取り専用です。読み終わったら、<a href=\"{$_CONF['site_admin_url']}/story.php\">記事の編集画面</a>に戻ってください。",
    42 => "管理権限のない記事を編集しようとしました。この行為は記録されます。<a href=\"{$_CONF['site_admin_url']}/story.php\">記事の編集画面</a>に戻ってください",
    43 => '',
    44 => '',
    45 => '',
    46 => '<strong>注意:</strong> 記事の日時を将来の日時に変更すると、その日まで記事は公開されません。また、フィードにも反映せず、検索やサイト情報にも反映されません。',
    47 => '画像',
    48 => '画像',
    49 => '右',
    50 => '左',
    51 => '<p>添付した画像は、自動タグで記述してください。書式は、[imageX]、[imageX_right]、[imageX_left]（Xは添付した画像の番号）（例 [image1]）。注意: 添付した画像は記事内ですべて使用しなければ記事を保存できません。<br' . XHTML . '><strong>プレビュー</strong>: 画像付きの記事はドラフト（下書き）として保存して閲覧してください。プレビューボタンは画像が無いときにのみ利用できます。</p>',
    52 => '',
    53 => 'は使用されていません。保存する前に冒頭文または本文で画像を使用しなければなりません。',
    54 => '添付された画像が使用されていません。',
    55 => '記事を保存する際に下記のエラーが発生しました。保存する前に修正してください。',
    56 => '話題アイコン表示',
    57 => '元のサイズの画像を表示',
    58 => 'アーカイブ',
    59 => 'オプション',
    60 => '',
    61 => '自動アーカイブ',
    62 => '自動削除',
    63 => 'コメントの設定',
    64 => '',
    65 => '',
    66 => '',
    67 => '編集エリアの拡大',
    68 => '編集エリアの縮小',
    69 => '投稿日時と公開モードの設定',
    70 => 'ツールバーの選択',
    71 => '基本的なツールバー',
    72 => '一般的なツールバー',
    73 => '拡張ツールバー',
    74 => '拡張ツールバーその2',
    75 => '全機能',
    76 => '公開オプション',
    77 => 'アドバンストエディタの利用は、ブラウザでJavaScriptが使える環境にする必要があります。このオプションはコンフィギュレーションの管理パネルで無効にできます。',
    78 => '<a href="%s/story.php?mode=edit&amp;sid=%s&amp;editopt=default">ノーマルエディタを使う場合</a>',
    79 => 'プレビュー',
    80 => 'エディタ',
    81 => '公開オプション',
    82 => '画像',
    83 => 'アーカイブ',
    84 => 'パーミッション',
    85 => 'すべて表示',
    86 => 'アドバンストエディタ',
    87 => '記事の情報',
    88 => 'Wikiスタイル',
    89 => '説明文のメタタグ',
    90 => 'キーワードのメタタグ',
    91 => '「プレビュー」ボタンをクリックすれば、いつでも有効期限を延長できます。',
    'autotag_desc_story' => '[story: id alternate title] - 記事タイトルで記事へのリンクを表示。アンカーテキストの指定は任意。'
);

###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => '話題の編集',
    2 => '話題ID',
    3 => '話題名',
    4 => '話題アイコンファイル指定',
    5 => '(半角英数字とハイフン)',
    6 => '話題を削除すると、関連した記事・ブロックもすべて削除されます。',
    7 => '話題IDと話題名を入力してください',
    8 => '話題管理',
    9 => '話題とは、記事カテゴリのことです。話題の編集・削除は各話題名を、新しい話題の作成は「新規作成」リンクをクリックしてください。カッコ内はあなたのアクセスレベルです。アスタリスク(*)付きの話題は、記事投稿時のデフォルトです。',
    10 => '順序',
    11 => '1ページあたりの記事数',
    12 => 'アクセスが拒否されました',
    13 => "管理権限のない話題を編集しようとしました。この行為は記録されます。<a href=\"{$_CONF['site_admin_url']}/topic.php\">話題の編集画面</a>に戻ってください",
    14 => '並べ替え方法',
    15 => 'アルファベット順',
    16 => '記事数のデフォルト:',
    17 => '新規話題',
    18 => '管理画面',
    19 => '保存',
    20 => 'キャンセル',
    21 => '削除',
    22 => 'デフォルト',
    23 => 'この話題を新規記事投稿の際のデフォルトにします。',
    24 => '(*)',
    25 => 'アーカイブ',
    26 => 'この話題をアーカイブ記事用の話題にします。アーカイブ記事用の話題に設定できるのはひとつだけです。',
    27 => '話題アイコンアップロード',
    28 => '最大',
    29 => 'ファイルアップロード時にエラー',
    30 => 'この話題の記事数'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => 'ユーザの編集',
    2 => 'ユーザID',
    3 => 'ユーザ名',
    4 => '氏名',
    5 => 'パスワード',
    6 => 'セキュリティレベル',
    7 => 'メールアドレス',
    8 => 'ホームページ',
    9 => '(半角英数字とハイフン)',
    10 => 'ユーザ名・メールアドレスを入力してください。',
    11 => 'ユーザ管理',
    12 => 'ユーザの編集・削除は編集アイコンをクリック、ユーザの作成は「新規作成」をクリック、ユーザの一括登録（インポート）は「一括登録」をクリック、ユーザの一括削除は「一括削除」をクリックしてください。',
    13 => 'セキュリティ',
    14 => '登録日',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '保存',
    21 => '登録しようとしたユーザ名は既に存在します。',
    22 => 'エラー',
    23 => '一括登録',
    24 => 'ユーザの一括登録',
    25 => 'ユーザをGeeklogに一括登録できます（重複チェック付き）。一括登録するファイルはユーザは1行あたり1人ずつで、各ユーザのデータはタブ区切りで「氏名、ユーザ名、メールアドレス」のフィールド順です。ユーザのパスワードは無作為に決定されます。ファイルはかならず本サイトと同じ文字コードのテキスト形式で保存してください。',
    26 => '',
    27 => '',
    28 => '画像を削除する場合チェックする',
    29 => 'パス',
    30 => '実行',
    31 => '新規ユーザ',
    32 => '処理が完了しました。登録成功: %d 件 エラー: %d 件',
    33 => '検索',
    34 => 'エラー: 登録するファイルを指定してください。',
    35 => '最後のログイン日時',
    36 => '未',
    37 => 'ユーザID',
    38 => 'グループ一覧',
    39 => 'パスワード（再入力）',
    40 => '登録日',
    41 => '最終ログイン',
    42 => '禁止',
    43 => '有効になるのを待機中',
    44 => '承認されるのを待機中',
    45 => '有効',
    46 => 'ユーザの状態',
    47 => '編集',
    48 => '管理者グループを表示',
    49 => '管理者グループ',
    50 => 'このグループを管理者グループとしてフィルタリングするには、チェックしてください。',
    51 => 'オンライン期間',
    52 => '<br' . XHTML . '>注: 「オンライン期間」とは、最初にアカウントを登録してから前回ログインした時までの日数です。',
    53 => '登録済み',
    54 => '一括削除',
    55 => 'この機能はコンフィギュレーションの管理パネルで「最終ログインを記録する」を有効に設定している場合にのみ動作します。',
    56 => '削除したいユーザの種類を選択して「リスト更新」をクリックしてください。次に、削除したくないユーザのチェックを外して「削除」アイコンをクリックしてください。このリストがページをまたがっている場合、現在表示されているユーザしか削除されないので注意してください。',
    57 => '幽霊ユーザ',
    58 => '一時的ユーザ',
    59 => '過去のユーザ',
    60 => 'Users that registered more than ',
    61 => 'ヶ月以前に登録後、一度もログインしていないユーザ。',
    62 => 'Users that registered more than ',
    63 => 'ヶ月以前に登録して24時間以内にログイン後、再びログインしていないユーザ。',
    64 => 'Normal users, who simply did not visit your site since ',
    65 => 'ヶ月間、サイトを訪問していないユーザ。',
    66 => 'リストを更新',
    67 => '登録して何ヶ月経つか',
    68 => 'オンライン時間',
    69 => 'オフライン月数',
    70 => '削除できませんでした',
    71 => '削除されました',
    72 => '削除するユーザが選択されていません',
    73 => '削除すると元に戻せません。選択したユーザをすべて削除してよいですか?',
    74 => '直近のユーザ',
    75 => '直近',
    76 => 'ヶ月に登録したユーザ。',
    77 => '選択したユーザにログインのリマインダーをメールで送信',
    78 => 'リマインダーを送信',
    79 => 'リマインダーを送信するユーザが選択されていません',
    80 => 'リマインダーの送信に成功しました',
    81 => '%sのアカウントを検証するためのリマインダー',
    82 => "あなたの{$_CONF['site_name']}のアカウントは%sからアクセスがありません。今後30日以内にアクセスが無ければ無効となりますのでご注意ください。",
    83 => "あなたの{$_CONF['site_name']}のアカウントは作成後使用されていません。このままアクセスが無ければ近日中に削除されますのでご注意ください。",
    84 => "あなたのログイン名: %s  サイト名: {$_CONF['site_url']}",
    85 => 'パスワードを紛失した場合には、以下のリンクをクリックしてください: %s',
    86 => '含む',
    87 => 'リマインダー',
    88 => 'デフォルトグループ',
    89 => '新規登録ユーザのデフォルトグループをチェック',
    90 => '登録済みユーザアカウントにデフォルトグループを追加する',
    'autotag_desc_user' => '[user: id alternate title] - ユーザ名でユーザへのリンクを表示。アンカーテキストの指定は任意。'
);

###############################################################################
# admin/moderation.php

$LANG29 = array(
    1 => '承認',
    2 => '削除',
    3 => '編集',
    4 => 'プロフィール',
    10 => 'タイトル',
    11 => '開始日',
    12 => 'URL',
    13 => '投稿',
    14 => '日付',
    15 => '話題',
    16 => 'ユーザ名',
    17 => '氏名',
    18 => 'メールアドレス',
    34 => '投稿管理',
    35 => '記事の投稿申請',
    36 => 'コメントの親',
    37 => '',
    38 => '実行',
    39 => '現在のところ申請はありません',
    40 => 'ユーザの登録申請',
    41 => 'コメントの投稿申請',
    42 => 'ユーザ名',
    43 => '自動で公開'
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => 'メール送信',
    2 => '送信者名',
    3 => '返信先',
    4 => '件名',
    5 => '内容',
    6 => '送信先:',
    7 => 'すべてのユーザ',
    8 => '管理者',
    9 => 'オプション',
    10 => 'HTML',
    11 => '緊急!',
    12 => 'メールを送信する',
    13 => '入力しなおす',
    14 => 'ユーザの受信許可設定を無視して送る',
    15 => '送信中にエラーが発生。宛先: ',
    16 => 'メッセージの送信が完了しました。宛先: ',
    17 => "<a href={$_CONF['site_admin_url']}/mail.php>他のメッセージを送る</a>",
    18 => '送信先',
    19 => '補足: 登録者全員に送信するには、送信先を「Logged-in Users」としてください。',
    20 => "<successcount> 件のメッセージの送信に成功し、<failcount> 件のメッセージの送信には失敗しました。個別のメッセージの送信状態は次のとおりです。<a href=\"{$_CONF['site_admin_url']}/mail.php\">別のメッセージを送信</a>するか、<a href=\"{$_CONF['site_admin_url']}/moderation.php\">管理画面に戻る</a>ことができます",
    21 => '送信失敗',
    22 => '送信成功',
    23 => '失敗したものはありません',
    24 => '成功したものはありません',
    25 => '-- グループを選択 --',
    26 => 'すべてのフィールドに入力してください。また、グループはドロップダウンリストで選択してください。'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => 'プラグインをインストールすることで、Geeklogや最悪の場合はシステムに悪影響を与えることがあります。悪影響を避けるために、Geeklogのホームページでは様々なOSでテストしたプラグインのみを掲載していますので、<a href="http://www.geeklog.net" target="_blank">Geeklogのホームページ</a>からのみダウンロードするようにしてください。プラグインのインストールに際しては、システムのコマンドを実行する必要がありますので、特に公式サイト以外からダウンロードしたばあいは、この点に注意してください。また、これらの注意は、プラグインのインストールの成功やプラグインによる影響について我々がなんらかの保証をするものではありません。プラグインのインストール方法は、それぞれのプラグインに同梱されています。',
    2 => 'プラグインのインストールに関する注意',
    3 => 'プラグインのインストールフォーム',
    4 => 'プラグインのファイル',
    5 => 'プラグイン管理',
    6 => '注意: プラグインは既にインストールされています。',
    7 => 'インストールしようとしているプラグインは既に存在しています。再インストールする前にいったん削除してください。',
    8 => 'プラグインの互換性チェックに失敗しました。',
    9 => 'このプラグインはより新しいバージョンのGeeklogに対応しています。<a href=http://www.geeklog.jp>Geeklog</a>からダウンロードするか、このGeeklogに対応しているバージョンのプラグインを入手してください。',
    10 => '<br' . XHTML . '><strong>プラグインはインストールされていません</strong><br' . XHTML . '><br' . XHTML . '>',
    11 => 'プラグインの編集・削除は編集アイコンをクリックしてください。プラグイン作者のページリンクも表示されます。プラグインのバージョンは、インストール中のものとファイルから得られたものが表示されます。プラグインアップグレードに関してはそれぞれのプラグインが提供するドキュメントをご覧ください。',
    12 => 'plugineditor()にプラグイン名が渡されませんでした',
    13 => 'プラグイン情報',
    14 => '新規プラグイン',
    15 => '管理画面',
    16 => 'プラグイン名',
    17 => 'プラグインバージョン',
    18 => 'GLバージョン',
    19 => '有効',
    20 => 'はい',
    21 => 'いいえ',
    22 => 'インストール',
    23 => '保存',
    24 => 'キャンセル',
    25 => '削除',
    26 => 'プラグイン名',
    27 => 'プラグインWebページ',
    28 => 'プラグインバージョン',
    29 => 'GLバージョン',
    30 => 'このプラグインを削除しますか?',
    31 => 'このプラグインを削除してよいですか? 削除すると関連するファイルやデータがすべて削除されます。削除する場合は「削除」ボタンをもう一度クリックしてください。',
    32 => '<p><strong>自動タグのフォーマットエラーです。</strong></p>',
    33 => '最新のバージョン',
    34 => 'アップデート',
    35 => '編集',
    36 => 'コード',
    37 => 'データ',
    38 => 'アップデートしてください!',
    39 => 'プラグインアップロード',
    40 => 'プラグインの圧縮ファイル (.tar.gz, .tgz, .zip) を直接ここにアップロードできます:',
    41 => 'アップロード',
    42 => 'アップデート',
    43 => 'ロード順',
    44 => 'ロード順を上げる',
    45 => 'ロード順を下げる',
    46 => 'プラグインを削除する',
    47 => '%s プラグインを本当に削除してよいですか?',
    48 => 'プラグインを有効にする',
    49 => 'プラグインを無効にする',
    50 => '対応',
    51 => 'OK',
    52 => '未定',
    53 => '不可',
    54 => '利用不可',
    55 => 'アンインストールされた',
    56 => '間違ったバージョン',
    57 => '不明',
    58 => '依存関係を設定するためプラグインのロード順を変更しました。',
    59 => '情報',
    60 => '閉じる',
    61 => '状態',
    62 => 'プラグインをインストールする',
    63 => 'インストールできませんでした',
    64 => '有効にできませんでした',
    65 => 'プラグインアップロード機能は以下のエラーのため無効にされました。:',
    66 => 'ファイルアップロードは、PHPコンフィギュレーション設定により無効になりました。',
    67 => 'ディレクトリ "%s" は書き込み不可です。',
    68 => 'あなたには、プラグインをインストールする権限がありません。',
    69 => 'あなたには、プラグインをアップロードする権限がありません。',
    99 => '不明なエラーが発生しました。',
    100 => 'Ok.',
    101 => 'アップロードファイルのサイズは、php.ini 内の upload_max_filesize の値を超えています。',
    102 => 'アップロードファイルのサイズは、HTMLフォームで指定された MAX_FILE_SIZE の値を超えています。',
    103 => '一部のファイルだけがアップロードされました。',
    104 => 'アップロードされませんでした。',
    105 => '(未定義エラー)',
    106 => 'テンポラリフォルダがみつかりません。',
    107 => 'ファイルの保存に失敗しました。',
    108 => 'ファイル拡張子の制限によりアップロードは中止されました。'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => 'フィードの作成',
    2 => '保存',
    3 => '削除',
    4 => 'キャンセル',
    10 => 'フィード',
    11 => '新しいフィード',
    12 => '管理画面',
    13 => 'フィードの編集・削除は編集アイコンをクリック、フィードの作成は上の「新規作成」をクリックしてください。',
    14 => 'タイトル',
    15 => 'タイプ',
    16 => 'ファイル名',
    17 => 'フォーマット',
    18 => '更新日',
    19 => '有効',
    20 => 'Yes',
    21 => 'No',
    22 => '<i>(フィードがありません)</i>',
    23 => 'すべての記事',
    24 => 'フィードの編集',
    25 => 'フィードタイトル',
    26 => '制限',
    27 => 'エントリの長さ',
    28 => '(0 = 本文なし、1 = 本文すべて、その他 = 指定した文字数に制限)',
    29 => '説明',
    30 => '更新',
    31 => '文字コード',
    32 => '言語',
    33 => 'コンテンツ',
    34 => 'エントリ数',
    35 => '時間',
    36 => 'フィードのタイプを選択してください。',
    37 => '',
    38 => 'エラー: 入力していない項目があります。',
    39 => 'フィードのタイトル、詳細、ファイル名を入力してください。',
    40 => 'エントリ数または、取得する時間を入力してください。',
    41 => 'リンク',
    42 => '',
    43 => 'すべて',
    44 => 'なし',
    45 => 'ヘッダーリンクする話題',
    46 => '表示件数',
    47 => '検索',
    48 => '編集',
    49 => 'フィードロゴ',
    50 => "本サイト({$_CONF['site_url']})からの相対URL",
    51 => '選択したフィード名は他のフィードで使用されています。別の名前にしてください。',
    52 => 'エラー: このファイル名は既に使用されています',
    53 => 'トップページのすべての記事',
    54 => '新規作成するフィードのタイプを選んでください。',
    55 => '記事'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "パスワードをメールで送信しましたので確認してください。利用方法はメールを参照してください。{$_CONF['site_name']}",
    2 => "{$_CONF['site_name']} に記事を投稿してくれてありがとうございます。記事はスタッフに通知しました。承認されればすぐにサイトに掲載されます。",
    3 => '',
    4 => '',
    5 => 'アカウント情報を変更しました。',
    6 => '表示を設定しました。',
    7 => 'コメントを設定しました。',
    8 => 'ログアウトしました。',
    9 => '記事を変更しました。',
    10 => '記事を削除しました。',
    11 => 'ブロックを変更しました。',
    12 => 'ブロックを削除しました。',
    13 => '話題を変更しました。',
    14 => '話題とその話題に属するすべての記事とブロックを削除しました',
    15 => '投稿されました。管理者の承認をお待ちください。',
    16 => 'あなたは登録解除されています。以後、新たな通知を受けることはできません。',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => 'ユーザ情報を保存しました。',
    22 => 'ユーザ情報を削除しました。',
    23 => '',
    24 => '',
    25 => '',
    26 => '',
    27 => 'メッセージを送信しました。',
    28 => 'プラグインを保存しました',
    29 => 'あなたはこの管理ページにアクセスできません。不正なアクセスはすべて記録されます。',
    30 => 'アクセスが拒否されました',
    31 => '',
    32 => '',
    33 => '',
    34 => '',
    35 => '',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => 'システムからのメッセージ',
    41 => '',
    42 => '',
    43 => '',
    44 => 'プラグインをインストールしました!',
    45 => 'プラグインを削除しました。',
    46 => '',
    47 => '',
    48 => "{$_CONF['site_name']}にご登録ありがとうございます。管理者の間で審査し、登録が認められたら、あなたの登録したメールアドレスにパスワードを送信します。",
    49 => 'グループが無事登録されました。',
    50 => 'グループを削除しました。',
    51 => 'ユーザ名が既に使われています。別の名前を指定してください。',
    52 => '入力されたメールアドレスは無効なアドレスだと思われます。',
    53 => '新しいパスワードが登録されました。このパスワードを使ってログインしてください。',
    54 => 'あなたの新規パスワード発行申請は期限が切れています。下のフォームから再申請してください。',
    55 => 'メールが送信されました。届いたメールの指示にしたがって新しいパスワードを設定してください。',
    56 => 'メールアドレスは別のアカウントで既に使われています。',
    57 => 'アカウントの削除が完了しました。',
    58 => 'フィードが無事保存されました。',
    59 => 'フィードが削除されました。',
    60 => 'プラグインがアップデートされました。',
    61 => '%sプラグイン: メッセージのプレイスホルダーが不明です。',
    62 => 'トラックバックのコメントが削除されました。',
    63 => 'トラックバックのコメントを削除する際に問題が発生しました。',
    64 => 'トラックバックが無事送られました。',
    65 => 'Weblog ディレクトリサービスがセーブされました。',
    66 => 'Weblog ディレクトリサービスが削除されました。',
    67 => '新しいパスワードと確認用パスワードが一致しません。',
    68 => '正しいパスワードを入力してください。',
    69 => 'アカウントが停止されています。',
    70 => 'アカウントは管理者の承認を待っています。',
    71 => 'アカウントが登録されて、管理者の承認を待っています。',
    72 => 'プラグインのインストール時にエラーがありました。error.logを確認してください。',
    73 => 'プラグインの削除時にエラーがありました。error.logを確認してください。',
    74 => 'ピングバックが無事送られました。',
    75 => 'トラックバックはPOSTリクエストで送信する必要があります。',
    76 => 'この項目を削除してもよいですか?',
    77 => '警告:<br' . XHTML . '>エンコーディングのデフォルトをUTF-8に設定していますが、サーバがマルチバイトエンコーディングをサポートしていません。PHP用に mbstring モジュールをインストールするか、UTF-8ではないキャラクタセットないし言語に変更してください。',
    78 => 'メールアドレスと確認用メールアドレスには同じものを入力してください。',
    79 => '開こうしたページは、このサイトにもはや存在していない関数を参照しています。',
    80 => 'このフィードを作成したプラグインは、現在無効にされています。そのプラグインを再び有効にしなければ、フィードを編集できません。',
    81 => 'ログイン情報の入力が不正確だったようです。もう一度、ログインし直してください。',
    82 => 'ログイン回数制限を超えました。しばらく経って、再度ログインしてください。',
    83 => 'パスワード、メールアドレス、認証の保存期間を変更するには、現在のパスワードを入力してください。',
    84 => 'アカウントを削除するには、現在のパスワードを入力してください。',
    85 => 'メール送信エラーです。',
    86 => 'OpenIDサーバがログインを受け付けませんでした。',
    87 => 'OpenIDログインをキャンセルしました。',
    88 => 'OpenIDサーバがエラーを返しました。',
    89 => 'OpenIDサーバのURLが見つかりません。',
    90 => 'OpenID認識がキャンセルされました。',
    91 => '無効なURLが指定されました。',
    92 => "使用する前に<a href=\"{$_CONF['site_admin_url']}/sectest.php\">セキュリティチェックを行ってください</a>!",
    93 => 'データベースのバックアップに成功しました。',
    94 => 'バックアップ失敗: ファイルサイズが1Kバイト未満です。',
    95 => 'エラーが発生しました。',
    96 => '',
    97 => '',
    98 => 'プラグインのアップロードが完了しました。',
    99 => 'プラグインは既に存在します。',
    100 => 'あなたがアップロードしたファイルは GZip または Zip 形式のアーカイブではありませんでした。',
    101 => '(あなたがアクセスできる)話題はありません。記事を投稿するためには、少なくとも1つの話題が必要です。',
    110 => '認証用URLが取得できません。',
    111 => '認証でエラーが発生しました。',
    112 => '認証がキャンセルされました。',
    113 => 'あなたのアカウントがTwitter経由で作成されました。 {site_url}',
    114 => 'あなたのリモートアカウントの再同期が失敗しましたが、他のアカウント情報はただしく保存されました。',
    115 => 'リモートサービスは無効になりました。',
    400 => '検証に合格していない必須フィールドがあります。',
    401 => '氏名を入力してください。'
);

###############################################################################

$LANG_ACCESS = array(
    'access' => 'アクセス',
    'ownerroot' => '所有者/Root',
    'group' => 'グループ',
    'readonly' => '読み取り専用',
    'accessrights' => 'アクセス権',
    'owner' => '所有者',
    'grantgrouplabel' => '上記のグループに編集権限を与える',
    'permmsg' => '参考: メンバーとはログインしているメンバー。ゲストユーザとは、ログインせずに閲覧している一般の閲覧者。',
    'securitygroups' => 'セキュリティグループ',
    'editrootmsg' => "管理権限を持っていても、rootユーザにならずにrootユーザを編集することはできません。それ以外のユーザの編集は可能です。権限なしにrootユーザを編集しようとした場合、記録に残ることに注意してください。<a href=\"{$_CONF['site_admin_url']}/user.php\">ユーザ管理ページ</a>に戻る",
    'securitygroupsmsg' => 'このユーザが所属するグループにチェックしてください。',
    'groupeditor' => 'グループの編集',
    'description' => '詳細',
    'name' => '名前',
    'rights' => '権限',
    'missingfields' => '未入力項目',
    'missingfieldsmsg' => '名前と詳細を入力してください。',
    'groupmanager' => 'グループ管理',
    'newgroupmsg' => 'グループの編集・削除は編集アイコンをクリック、グループ作成は上の「新規作成」をクリックしてください。ただし、「コア（中核）グループ」はシステムで使用するため削除できません。',
    'groupname' => 'グループ名',
    'coregroup' => 'コアグループ',
    'yes' => 'はい',
    'no' => 'いいえ',
    'corerightsdescr' => "このグループは、{$_CONF['site_name']}の「コア（中核）グループ」です。そのため、本グループの権限を編集することはできないため、下記の権限リストは読み取り専用となっています。",
    'groupmsg' => '本サイトのセキュリティグループは階層的になっています。本グループを下記のグループに追加する場合、そのグループの持つ権限と同じ権限を本グループにも与えることになります。可能であれば、本グループに権限を与える場合、下記のグループの権限を継承させることが望ましい方法です。本グループに個別に権限を与える場合は、下記の「権限」部分から様々な機能に関する権限を選択することができます。本グループを追加する場合は、下記のグループの横にあるボックスをチェックするだけです。',
    'coregroupmsg' => "本グループは{$_CONF['site_name']}の「コア（中核）グループ」です。そのため、本グループの所属するグループは編集できません。下記のリストは読み取り専用となっています。",
    'rightsdescr' => 'グループのアクセス権は下記の権限で与えられているか、グループが所属するグループ全体の権限を継承しています。下記のうち、チェックのない権限は、本グループの所属するグループから継承した権限です。チェックのある権限は本グループが直接与えられている権限です。',
    'lock' => 'ロック',
    'members' => 'メンバー ',
    'anonymous' => 'ゲストユーザ',
    'permissions' => 'パーミッション',
    'permissionskey' => 'R = 閲覧, E = 編集, （編集権は閲覧権を含みます）',
    'edit' => '編集',
    'none' => 'なし',
    'accessdenied' => 'アクセスが拒否されました',
    'storydenialmsg' => "この記事を閲覧する権限がありません。これは、あなたが{$_CONF['site_name']}のメンバーでないためだと思われます。{$_CONF['site_name']} の<a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">メンバーになること</a>で閲覧が可能になります。",
    'nogroupsforcoregroup' => 'このグループは他のどのグループにも所属していません',
    'grouphasnorights' => 'このグループは管理権限を一切所有していません。',
    'newgroup' => '新規',
    'adminhome' => '管理画面',
    'save' => '保存',
    'cancel' => 'キャンセル',
    'delete' => '削除',
    'canteditroot' => 'Rootグループに所属していないのにRootグループを編集しようとしたため、アクセスが拒否されました。このエラーがおかしいと思った場合はシステムの管理者に連絡してください。',
    'listusers' => 'ユーザの表示と編集',
    'listthem' => 'リスト',
    'usersingroup' => '"%s"に含まれるユーザの一覧',
    'usergroupadmin' => 'グループ管理',
    'add' => '追加',
    'remove' => '削除',
    'availmembers' => 'ユーザ一覧',
    'groupmembers' => 'グループメンバー',
    'canteditgroup' => 'グループを編集するためには、グループのメンバーでなければなりません。このメッセージがエラーである場合は、システム管理者に連絡してください。',
    'cantlistgroup' => 'メンバーリストを閲覧するためには、グループのメンバーでなければなりません。このメッセージがエラーである場合は、システム管理者に連絡してください。',
    'editgroupmsg' => 'グループメンバーの編集は、メンバー名をクリックして「追加」または「削除」ボタンをクリックしてください。ユーザがグループメンバーのときは右側だけに表示されます。編集が終わったら、「保存」ボタンをクリックしてください。管理画面に戻ります。',
    'listgroupmsg' => 'グループ<strong>%s</strong>に含まれるユーザ:',
    'search' => '検索',
    'submit' => '実行',
    'limitresults' => '件数',
    'group_id' => 'グループID',
    'plugin_access_denied_msg' => 'このプラグインの管理権限がないのに管理画面にアクセスしようとしました。この行為は記録されます。',
    'groupexists' => 'このグループ名は既に存在しています。',
    'groupexistsmsg' => '同じグループ名があります。グループ名はそれぞれ異なっている必要があります。'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'last_ten_backups' => 'データベースバックアップ',
    'do_backup' => 'バックアップの実行',
    'backup_successful' => 'データベースのバックアップが完了しました。',
    'db_explanation' => 'Geeklogをバックアップするには、「新規作成」をクリックしてください。',
    'not_found' => "不正確なパス、セキュリティ上の制限、またはmysqldumpが実行できません。<br" . XHTML . "> コンフィギュレーションで<strong>mysqldump_path</strong>の設定を確認してください。<br" . XHTML . "> PHPの<a href=\"http://www.php.net/manual/en/features.safe-mode.php#ini.open-basedir\">open_basedir</a>の設定を確認してください。<br" . XHTML . "> 現在のパスは<var>{$_DB_mysqldump_path}</var>に設定されています。",
    'zero_size' => 'バックアップに失敗しました。ファイルの大きさが0バイトです。',
    'path_not_found' => "{$_CONF['backup_path']} は存在しないか、ディレクトリではありません。",
    'no_access' => "エラー: {$_CONF['backup_path']} ディレクトリにアクセスできません。",
    'backup_file' => 'バックアップファイル',
    'size' => 'サイズ',
    'bytes' => 'バイト',
    'total_number' => 'バックアップ総数は %d です。',
    'download' => 'ファイルダウンロード',
    'new_backup' => '新規バックアップ',
    'delete_failure' => '1つ以上のバックアップファイルが削除できませんでした。',
    'delete_success' => 'バックアップファイルの削除が完了しました。',
    'convert_menu' => 'InnoDBへの変換',
    'convert_title' => 'InnoDBテーブルへの変換',
    'convert_button' => '変換',
    'sorry_no_innodb' => '申し訳ありませんが、あなたのMySQLのバージョンはInnoDBテーブルをサポートしていません。',
    'innodb_explain' => 'InnoDBテーブルは <em>真に</em> 大きなデータベースではより良い性能を提供しますが、バックアップ作業をより複雑にします。この操作を実行する前に、InnoDBテーブルの長所と短所について<a href="http://dev.mysql.com/doc/mysql/en/innodb.html">調べて</a>ください。',
    'already_converted' => '注意: 全てのテーブルが既にInnoDBに変換されているようです。',
    'conversion_patience' => '注意: 変換にはある程度の時間を要します。気長にお待ちください。',
    'innodb_success' => 'InnoDBテーブルへの変換が完了しました。',
    'table_issues' => 'いくつかのテーブルで問題が発生した可能性があります。詳細については、error.logを確認してください。',
    'optimize_menu' => 'テーブルの最適化',
    'optimize_title' => 'テーブルの最適化',
    'optimize_button' => '最適化',
    'optimize_explain' => 'テーブルの最適化はサイトの性能を改善することに役立つかもしれません。実際の効果はテーブルの利用状況に依存し、テーブルによっては比較的大きな効果が得られるかも知れません。性能に大きな差がでることは期待しないでください。<a href="http://dev.mysql.com/doc/mysql/en/optimize-table.html">MySQLマニュアル</a>サイトは次のように述べています: <q>1週間または1ヶ月のうちに何回もこれを行う必要はないでしょう。</q>',
    'last_optimization' => '最新の最適化',
    'optimization_patience' => '注意: 最適化にはある程度の時間を要します。辛抱強くお待ちください。',
    'optimize_success' => 'データベーステーブルの最適化が完了しました。'
);

###############################################################################

$LANG_BUTTONS = array(
    1 => 'ホーム',
    2 => 'メールを送る',
    3 => '記事公開',
    4 => '',
    5 => '',
    6 => '',
    7 => 'サイト情報',
    8 => '個人設定',
    9 => '検索',
    10 => '検索オプション',
    11 => '記事管理'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => '404 Error',
    2 => '<strong>%s</strong>はどこにも見つかりませんでした。',
    3 => '指定されたファイルは存在しません。メインページをチェックしてみるか、検索ページで探してみてください。'
);

###############################################################################
# login form

$LANG_LOGIN = array(
    1 => 'ログインしてください',
    2 => '申し訳ありませんが、先にログインしてください。',
    3 => 'ログイン',
    4 => '新規登録'
);

###############################################################################
# trackback.php

$LANG_TRB = array(
    'trackback' => 'トラックバック',
    'from' => 'from',
    'tracked_on' => 'トラックバック オン',
    'read_more' => '続きを読む',
    'intro_text' => '\'%s\'について他のサイトでは次のように言及されています:',
    'no_comments' => 'この記事にはトラックバック・コメントがありません。',
    'this_trackback_url' => 'このエントリのトラックバックURL:',
    'num_comments' => '%d件のトラックバック',
    'send_trackback' => 'トラックバック・ピングを送る',
    'preview' => 'プレビュー',
    'editor_title' => 'トラックバックを送る',
    'trackback_url' => 'トラックバックURL',
    'entry_url' => 'エントリのURL',
    'entry_title' => 'エントリのタイトル',
    'blog_name' => 'サイト名',
    'excerpt' => '概要',
    'truncate_warning' => '注: 受信したサイト側で概要を切り詰めることがあります',
    'button_send' => '送信',
    'button_preview' => 'プレビュー',
    'send_error' => 'エラー',
    'send_error_details' => 'トラックバックの送信中にエラーが発生しました:',
    'url_missing' => 'エントリのURL',
    'url_required' => 'エントリのURLは必ず入力してください。',
    'target_missing' => 'トラックバックURLがありません',
    'target_required' => 'トラックバックURLを入力してください',
    'error_socket' => 'ソケットをオープンできませんでした。',
    'error_response' => '不明な応答が返されました。',
    'error_unspecified' => '不明なエラーです。',
    'select_url' => 'トラックバックURLを選択してください',
    'not_found' => 'トラックバックURLが見つかりません',
    'autodetect_failed' => 'コメントを送ろうとした記事のトラックバックURLを見つけられませんでした。URLを下に入力してください。',
    'trackback_explain' => '以下のリンクからトラックバックを送りたいURLを選択してください。その記事の正しいトラックバックURLを決定します。URLがわかっているなら<a href="%s">自分で入力</a>することもできます。',
    'no_links_trackback' => 'リンクが見つかりません。このエントリにトラックバックを送信できません。',
    'pingback' => 'ピングバック',
    'pingback_results' => 'ピングバックの結果',
    'send_pings' => 'ピングを送信',
    'send_pings_for' => '"%s"にトラックバック・ピングを送る',
    'no_links_pingback' => 'リンクが見つかりません。このエントリへのピングバックは送信されませんでした。',
    'pingback_success' => 'ピングバックを送信しました。',
    'no_pingback_url' => 'ピングバックURLが見つかりません。',
    'resend' => '再送',
    'ping_all_explain' => 'あなたがリンクしたことを相手のサイトに知らせたり(<a href="http://en.wikipedia.org/wiki/Pingback">ピングバック</a>)、ウェブログディレクトリサービスにピングを送ってサイトが更新されたことを知らせたり、誰かのサイトの記事について書いたときに<a href="http://ja.wikipedia.org/wiki/%E3%83%88%E3%83%A9%E3%83%83%E3%82%AF%E3%83%90%E3%83%83%E3%82%AF">トラックバック</a>を送ったりすることができます。',
    'pingback_button' => 'ピングバック送信',
    'pingback_short' => '記事のすべてのリンク先にピングバックを送信します。',
    'pingback_disabled' => '(ピングバックは無効です)',
    'ping_button' => 'ピング送信',
    'ping_short' => '登録したウェブログサイトにピングを一斉送信します。',
    'ping_disabled' => '(ピングは無効です)',
    'trackback_button' => 'トラックバック送信',
    'trackback_short' => '記事のリンク先にトラックバックを送信します。',
    'trackback_disabled' => '(トラックバックは無効です)',
    'may_take_a_while' => 'ピングバックやピングの送信には時間がかかることがあります。',
    'ping_results' => 'ピングの結果',
    'unknown_method' => '不明なピングメソッドです。',
    'ping_success' => 'ピングを送信しました。',
    'error_site_name' => 'サイト名を入力してください。',
    'error_site_url' => 'サイトのURLを入力してください。',
    'error_ping_url' => '正しいピングURLを入力してください。',
    'no_services' => 'ウェブログディレクトリサービスが設定されていません。',
    'services_headline' => 'トラックバック管理',
    'service_explain' => 'ピング送信先のウェブログディレクトリサービスの編集・削除は編集アイコンをクリック、ウェブログディレクトリサービスを作成する場合は「新規作成」をクリックしてください。',
    'service' => 'サービス',
    'ping_method' => 'ピングメソッド',
    'service_website' => 'ウェブサイト',
    'service_ping_url' => 'ピングのURL',
    'ping_standard' => '標準ピング',
    'ping_extended' => '拡張ピング',
    'ping_unknown' => '(不明なメソッド)',
    'edit_service' => 'ウェブログディレクトリサービスの編集',
    'trackbacks' => 'トラックバック',
    'editor_intro' => '<a href="%s">%s</a>へのトラックバックを準備してください。',
    'editor_intro_none' => 'トラックバックを準備してください。',
    'trackback_note' => '記事にトラックバックを送るには、記事一覧でその記事の"トラックバック・ピングを送る"をクリックしてください。 記事に関係のないトラックバックを送るには <a href="%s">ここをクリック</a>。',
    'pingback_explain' => 'ピングバックするURLを入力してください。ピングバックで他のサイトからリンク が張られたことを自動的に通知されます。',
    'pingback_url' => 'ピングバックURL',
    'site_url' => 'このサイトのURL',
    'pingback_note' => '記事へのピングバックを送るには、記事をクリックしてください。"トラックバック・ピングを送る" に関係している記事にピングバックを送るには、<a href="%s">ここをクリック</a>。',
    'pbtarget_missing' => 'ピングバックURLではありません。',
    'pbtarget_required' => 'ピングバックURLを入力してください',
    'pb_error_details' => '次のピングバックの送信中にエラー:',
    'delete_trackback' => 'トラックバック削除: '
);

###############################################################################
# directory.php

$LANG_DIR = array(
    'title' => '記事一覧',
    'title_year' => '%d年の記事一覧',
    'title_month_year' => '%d年%s月の記事一覧',
    'nav_top' => '記事一覧のトップに戻る',
    'no_articles' => '記事がありません'
);

###############################################################################
# admin/sectest.php

$LANG_SECTEST = array(
    'sectest' => 'Geeklog セキュリティチェック',
    'results' => 'セキュリティチェックの結果',
    'okay' => 'すべて適正です。',
    'please_fix' => 'サイトを使用する前に上記の問題を修正してください!',
    'please_note' => '100% セキュアなサイトはありません。このスクリプトは明白なセキュリティの問題しか検証できません。',
    'stay_informed' => 'Geeklogの新しい公開情報やセキュリティ問題の情報を継続してお知らせできるようにするために、あなたが(トラフィックの低い) %s メーリングリストに参加し、かつ（または）アップデート可能かどうかを確認するために、時々管理メニューの%sを行うことをお勧めします。',
    'public_html' => '"public_html"はあなたのサイトURLの一部に含まれないようにしてください。再度 %s 内のpublic_htmlに関する部分を読んで、設定を変更してから次に進んでください。',
    'installation' => 'インストール手順',
    'directory' => 'ディレクトリ',
    'failed_tmp' => '%sディレクトリに一時ファイルを作成できませんでした。ディレクトリのパーミッションを確認してください!',
    'fix_it' => 'これはセキュリティリスクであり、修正すべきです!',
    'reachable' => 'あなたの %s はWebからアクセス可能です。',
    'not_reachable' => 'Good! あなたの %s はWebからアクセス不可能です。',
    'not_sure' => 'HTTPの応答コード%sを(%sのテストの実行時に)受信しました。この意味するところは不明です ...',
    'remove_inst' => 'サイトが正常に動き始めたら、必ずinstallディレクトリ%sを削除してください。',
    'remove_inst2' => 'そのままにしておくと、悪意のあるユーザがあなたがインストールしたものを破壊したり、サイトを乗っ取ったり、重要な情報を読み出したりするおそれがあります。',
    'inst_removed' => 'Good! あなたは既にinstallディレクトリを削除しています。',
    'fix_password' => 'あなたはまだ %s の Rootユーザアカウントの<strong>パスワード</strong>をデフォルトの"password"から変更していません。',
    'password_okay' => 'Good! Rootユーザアカウントのパスワードをデフォルトから変更しています。'
);

###############################################################################
# "What's New" Time Strings
# 
# For the first two strings, you can use the following placeholders.
# Order them so it makes sense in your language:
# %i    item, "Stories"
# %n    amount, "2", "20" etc.
# %t    time, "2" (weeks)
# %s    scale, "hrs", "weeks"

$LANG_WHATSNEW = array(
    'new_string' => '新着%i %n件(%t%s)',
    'new_last' => '(%t%s)',
    'minutes' => '分',
    'hours' => '時間',
    'days' => '日',
    'weeks' => '週',
    'months' => 'ヶ月',
    'years' => '年',
    'minute' => '分',
    'hour' => '時間',
    'day' => '日',
    'week' => '週',
    'month' => 'ヶ月',
    'year' => '年'
);

###############################################################################
# Month names

$LANG_MONTH = array(
    1 => ' 1',
    2 => ' 2',
    3 => ' 3',
    4 => ' 4',
    5 => ' 5',
    6 => ' 6',
    7 => ' 7',
    8 => ' 8',
    9 => ' 9',
    10 => '10',
    11 => '11',
    12 => '12'
);

###############################################################################
# Weekdays

$LANG_WEEK = array(
    1 => '日',
    2 => '月',
    3 => '火',
    4 => '水',
    5 => '木',
    6 => '金',
    7 => '土'
);

###############################################################################
# Admin - Strings
# 
# These are some standard strings used by core functions as well as plugins to
# display administration lists and edit pages

$LANG_ADMIN = array(
    'search' => '検索',
    'limit_results' => '件数',
    'submit' => '実行',
    'edit' => '編集',
    'edit_adv' => 'アドバンストエディタ',
    'admin_home' => '管理画面',
    'create_new' => '新規作成',
    'create_new_adv' => '新規作成(アドバンスト)',
    'enabled' => '有効',
    'disabled' => 'Disabled',
    'title' => 'タイトル',
    'page_title' => 'ページタイトル',
    'type' => 'タイプ',
    'topic' => '話題',
    'info' => 'Info',
    'help_url' => 'ヘルプURL',
    'save' => '保存',
    'cancel' => 'キャンセル',
    'install' => 'Install',
    'delete' => '削除',
    'deleteitem' => 'Delete',
    'delete_sel' => '削除選択',
    'copy' => 'コピー',
    'no_results' => '- 見つかりませんでした -',
    'data_error' => '送信データに問題があります。データをチェックしてください',
    'preview' => 'プレビュー',
    'records_found' => '件数',
    'addchild' => '子を追加',
    'list' => 'リスト',
    'list_all' => 'すべてのリスト',
    'meta_description' => '説明文のメタタグ',
    'meta_keywords' => 'キーワードのメタタグ',
    'na' => 'N/A',
    'unavailable' => 'N/A',
    'warning' => '!!!',
    'token_expiry' => '%s までに編集してください。この時刻を過ぎると、このページに埋め込まれたセキュリティートークンは期限切れとなり、編集内容は失われます。',
    'token_expired' => 'この操作のセキュリティトークンは期限切れになりました。続けるには再度認証してください。',
    'reauth_msg' => 'この操作のセキュリティトークンは期限切れになりました。続けるには下に表示されている認証を行なってください。そうすることによって今回の編集作業が失われることはありません。',
    'authenticate' => '認証する'
);

# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0 => 'コメント有効',
    -1 => 'コメント停止',
    1 => 'コメント終了'
);

$LANG_commentmodes = array(
    'flat' => '一覧',
    'nested' => '入れ子',
    'threaded' => 'ツリー',
    'nocomment' => '表示しない'
);

$LANG_cookiecodes = array(
    0 => '受け付けない',
    3600 => '1時間',
    7200 => '2時間',
    10800 => '3時間',
    28800 => '8時間',
    86400 => '1日',
    604800 => '1週間',
    2678400 => '1ヶ月'
);

$LANG_dateformats = array(
    0 => 'デフォルト'
);

$LANG_featurecodes = array(
    0 => '通常の記事',
    1 => '注目記事'
);

$LANG_frontpagecodes = array(
    0 => '該当する話題にのみ表示',
    1 => 'トップページに表示'
);

$LANG_postmodes = array(
    'plaintext' => 'テキスト',
    'html' => 'HTML'
);

$LANG_sortcodes = array(
    'ASC' => '古い順に',
    'DESC' => '新しい順に'
);

$LANG_trackbackcodes = array(
    0 => 'トラックバック有効',
    -1 => 'トラックバック停止'
);

###############################################################################
# Localization of the Admin Configuration UI

$LANG_CONFIG = array(
    'home' => 'ホーム',
    'admin_home' => 'サイト管理',
    'sections' => 'コンフィギュレーション',
    'restore' => 'リストア',
    'add_element' => '要素を追加する',
    'save_changes' => '変更を保存する',
    'reset_form' => 'リセット',
    'changes_made' => '変更が完了しました',
    'title' => 'コンフィギュレーション管理',
    'disable' => 'クリックしてこのオプションを無効にする',
    'enable' => '有効にする',
    'default_tab_name' => 'メイン',
    'search_configuration_label' => 'コンフィギュレーションの検索',
    'error_validation_occurs' => '入力値を修正してください。'
);

$LANG_configsections['Core'] = array(
    'label' => 'Geeklog',
    'title' => 'Geeklogの設定'
);

$LANG_confignames['Core'] = array(
    'path_html' => 'HTMLパス',
    'site_url' => 'サイトURL',
    'site_admin_url' => '管理画面のURL',
    'site_mail' => 'サイトのメールアドレス',
    'noreply_mail' => 'No-Replyメールアドレス',
    'site_name' => 'サイト名',
    'site_slogan' => 'スローガン',
    'owner_name' => '管理者名',
    'microsummary_short' => 'マイクロサマリ接頭子',
    'path_log' => 'ログ',
    'path_language' => '言語',
    'backup_path' => 'バックアップ',
    'path_data' => 'データ',
    'path_images' => '画像',
    'path_pear' => 'PEARのパス',
    'have_pear' => 'PEARをインストールしている',
    'mail_settings' => 'メール設定',
    'allow_mysqldump' => 'MySQLのダンプを許可する',
    'mysqldump_path' => 'mysqldumpのパス',
    'mysqldump_options' => 'mysqldumpのオプション',
    'mysqldump_filename_mask' => 'バックアップファイル名',
    'theme' => 'テーマ',
    'doctype' => 'DOCTYPE宣言',
    'menu_elements' => 'メニュー項目',
    'path_themes' => 'テーマパス',
    'disable_new_user_registration' => '新規ユーザ登録を拒否する',
    'allow_user_themes' => 'テーマ選択を許可する',
    'allow_user_language' => '言語選択を許可する',
    'allow_user_photo' => '写真登録を許可する',
    'allow_username_change' => 'ユーザ名変更を許可する',
    'allow_account_delete' => 'アカウント削除を許可する',
    'hide_author_exclusion' => '所有者を表示しない',
    'show_fullname' => 'ユーザ名の代わりに氏名を表示する',
    'show_servicename' => 'サービス名を表示する',
    'custom_registration' => 'カスタム登録を有効にする',
    'user_login_method' => 'ログイン方法',
    'facebook_login' => 'FacebookのOAuthを有効にする',
    'facebook_consumer_key' => 'Facebook OAuth Application ID',
    'facebook_consumer_secret' => 'Facebook OAuth Application Secret',
    'linkedin_login' => ' LinkedInのOAuthを有効にする',
    'linkedin_consumer_key' => 'LinkedIn OAuth API Key',
    'linkedin_consumer_secret' => 'LinkedIn OAuth Secret Key',
    'twitter_login' => 'TwitterのOAuthを有効にする',
    'twitter_consumer_key' => 'Twitter OAuth Consumer Key',
    'twitter_consumer_secret' => 'Twitter OAuth Consumer Secret',
    'spamx' => 'Spam-X',
    'sort_admin' => 'リンクをソートする',
    'language' => '言語',
    'locale' => 'ロケール',
    'date' => '日時',
    'daytime' => '日時の短縮',
    'shortdate' => '日付',
    'dateonly' => '月日',
    'timeonly' => '時刻',
    'week_start' => '週の開始',
    'hour_mode' => '時間制',
    'thousand_separator' => '千単位の区切り文字',
    'decimal_separator' => '小数点',
    'decimal_count' => '小数点以下の桁数',
    'language_files' => '言語ファイル[多言語モード]',
    'languages' => '言語名[多言語モード]',
    'timezone' => 'タイムゾーン',
    'site_disabled_msg' => 'サイト閉鎖のメッセージまたはURL',
    'rootdebug' => 'Rootデバッグ',
    'cookie_session' => 'セッションのクッキー名',
    'cookie_name' => 'パーマネントクッキー名',
    'cookie_password' => 'パスワードのクッキー名',
    'cookie_theme' => 'テーマのクッキー名',
    'cookie_language' => '言語のクッキー名',
    'cookie_tzid' => 'タイムゾーンのクッキー名',
    'cookie_anon_name' => 'ゲストユーザ名のクッキー名',
    'cookie_ip' => 'クッキーにIPを埋め込む',
    'default_perm_cookie_timeout' => 'パーマネントクッキーの有効期限',
    'session_cookie_timeout' => 'セッションの有効期限',
    'cookie_path' => 'クッキーのパス',
    'cookiedomain' => 'クッキーのドメイン',
    'cookiesecure' => 'セキュア(HTTPS)なクッキー',
    'lastlogin' => '最終のログインを記録する',
    'num_search_results' => '検索結果表示件数のデフォルト',
    'loginrequired' => 'すべてにログインを要求する',
    'submitloginrequired' => '投稿[ログイン要求]',
    'commentsloginrequired' => 'コメント投稿[ログイン要求]',
    'statsloginrequired' => '統計の参照[ログイン要求]',
    'searchloginrequired' => '検索[ログイン要求]',
    'profileloginrequired' => 'プロフィール閲覧[ログイン要求]',
    'emailuserloginrequired' => 'メール送信[ログイン要求]',
    'emailstoryloginrequired' => '記事メール送信[ログイン要求]',
    'directoryloginrequired' => '記事一覧表示[ログイン要求]',
    'storysubmission' => '管理者が承認する',
    'usersubmission' => '管理者の承認が必要',
    'listdraftstories' => 'ドラフト記事の一覧を表示する',
    'notification' => '通知',
    'postmode' => '投稿モードのデフォルト',
    'speedlimit' => '投稿間隔制限',
    'skip_preview' => 'プレビューしないで投稿する',
    'advanced_editor' => 'アドバンストエディタを使う',
    'wikitext_editor' => 'Wikiテキストエディタを使う',
    'cron_schedule_interval' => 'Cronスケジュール間隔',
    'sortmethod' => 'ソート方法',
    'showstorycount' => '記事数を表示する',
    'showsubmissioncount' => '記事投稿数を表示する',
    'hide_home_link' => 'Homeへのリンクを表示しない',
    'whosonline_threshold' => 'セッションのしきい値',
    'whosonline_anonymous' => 'ゲストユーザには表示しない',
    'whosonline_photo' => 'サムネイル写真を表示する',
    'emailstories' => 'デイリーダイジェストを送信する',
    'emailstorieslength' => '記事の長さ',
    'emailstoriesperdefault' => 'ユーザ登録で有効をデフォルトにする',
    'allow_domains' => '自動的に許可するドメイン',
    'disallow_domains' => '自動的に拒否するドメイン',
    'newstoriesinterval' => '記事の"新着"の期間',
    'newcommentsinterval' => 'コメントの"新着"の期間',
    'newtrackbackinterval' => 'トラックバックの"新着"の期間',
    'hidenewstories' => '新着記事を表示しない',
    'hidenewcomments' => '新規コメントを表示しない',
    'hidenewtrackbacks' => '新規トラックバックを表示しない',
    'hidenewplugins' => 'プラグインの新着データを表示しない',
    'title_trim_length' => 'タイトル最大長',
    'trackback_enabled' => 'トラックバックを有効にする',
    'pingback_enabled' => 'ピングバックを有効にする',
    'ping_enabled' => 'ピングを有効にする',
    'trackback_code' => '新規作成時のデフォルト',
    'multiple_trackbacks' => 'マルチプルトラックバック',
    'trackbackspeedlimit' => 'トラックバックの間隔制限',
    'check_trackback_link' => 'トラックバックのリンクチェック',
    'pingback_self' => '自身へピングバックする',
    'pingback_excerpt' => 'ピングバックを要約する',
    'link_documentation' => 'ドキュメントをリンクする',
    'link_versionchecker' => 'バージョンチェッカーをリンクする',
    'maximagesperarticle' => '記事に配置する画像の最大数',
    'limitnews' => '1ページあたりの記事の表示数',
    'minnews' => '記事の最小表示数',
    'contributedbyline' => '所有者を表示する',
    'hideviewscount' => '閲覧数を表示しない',
    'hideemailicon' => 'メールアイコンを表示しない',
    'hideprintericon' => '印刷アイコンを表示しない',
    'allow_page_breaks' => '改ページを許可する',
    'page_break_comments' => '改ページ時のコメント表示位置',
    'article_image_align' => '話題アイコンの表示位置',
    'show_topic_icon' => '話題アイコン表示をデフォルトにする',
    'draft_flag' => 'ドラフトモードをデフォルトにする',
    'frontpage' => 'トップページ配置をデフォルトにする',
    'hide_no_news_msg' => '記事がない場合のメッセージを表示しない',
    'hide_main_page_navigation' => 'ページナビゲーションを表示しない',
    'onlyrootfeatures' => 'Rootユーザのみ注目記事を設定できる',
    'aftersave_story' => '記事保存後の画面遷移',
    'aftersave_user' => 'ユーザ保存後の画面遷移',
    'show_right_blocks' => '右ブロックを常時表示する',
    'showfirstasfeatured' => '最初の記事を注目記事にする',
    'backend' => 'フィードを有効にする',
    'rdf_file' => '出力ファイル',
    'rdf_limit' => 'フィード制限',
    'rdf_storytext' => 'エントリの長さ',
    'rdf_language' => 'フィードの言語',
    'syndication_max_headlines' => 'インポートする記事の最大数',
    'copyrightyear' => 'Copyrightの年数設定',
    'image_lib' => '画像処理ライブラリ',
    'path_to_mogrify' => 'Mogrifyへのパス',
    'path_to_netpbm' => 'Netpbmへのパス',
    'debug_image_upload' => '画像アップロードのデバッグを行う',
    'keep_unscaled_image' => '元画像を保存する',
    'allow_user_scaling' => 'ユーザに画像サイズ変更を許可',
    'jpeg_quality' => 'JPEGの画質',
    'max_image_width' => '幅の最大値',
    'max_image_height' => '高さの最大値',
    'max_image_size' => 'ファイルサイズの最大値',
    'max_topicicon_width' => '幅の最大値',
    'max_topicicon_height' => '高さの最大値',
    'max_topicicon_size' => 'ファイルサイズの最大値',
    'max_photo_width' => '幅の最大値',
    'max_photo_height' => '高さの最大値',
    'max_photo_size' => 'ファイルサイズの最大値',
    'use_gravatar' => 'Gravatarを使う',
    'gravatar_rating' => 'Gravatar評価',
    'force_photo_width' => '幅を固定する',
    'default_photo' => '写真のデフォルト',
    'commentspeedlimit' => '投稿間隔制限',
    'comment_limit' => '表示件数',
    'comment_mode' => '表示モード',
    'comment_code' => '新規作成時のデフォルト',
    'comment_edit' => '編集を許可する',
    'comment_edittime' => '編集時間 (秒)',
    'commentsubmission' => '承認待ちリストに入れる',
    'passwordspeedlimit' => 'パスワード入力間隔制限',
    'login_attempts' => 'ログイン回数制限',
    'login_speedlimit' => 'ログイン間隔制限',
    'user_html' => 'ユーザHTML',
    'admin_html' => '管理者HTML',
    'advanced_html' => 'アドバンストエディタ用追加HTML',
    'skip_html_filter_for_root' => 'RootユーザはHTMLフィルタ無効',
    'allowed_protocols' => '許可されたプロトコル',
    'disable_autolinks' => '自動タグを無効にする',
    'clickable_links' => 'URLを自動リンクさせる',
    'compressed_output' => 'HTML出力を圧縮して送信する',
    'frame_options' => '"クリックジャッキング"を防止する',
    'censormode' => 'チェックする',
    'censorreplace' => '置き換えるワード',
    'censorlist' => 'バッドワード',
    'ip_lookup' => 'IP検索',
    'url_rewrite' => 'URLリライト',
    'cdn_hosted' => 'CDNのjQueryを使う',
    'meta_tags' => 'メタタグ',
    'meta_description' => 'サイトの説明文のメタタグ',
    'meta_keywords' => 'キーワードのメタタグ',
    'default_permissions_block' => 'パーミッション',
    'default_permissions_story' => 'パーミッション',
    'default_permissions_topic' => 'パーミッション',
    'atom_max_stories' => 'フィードの最大記事数',
    'disable_webservices' => '無効にする',
    'restrict_webservices' => '制限する',
    'article_comment_close_enabled' => '自動的にコメントの受付を停止する(デフォルト)',
    'article_comment_close_days' => '停止までの日数(デフォルト)',
    'comment_close_rec_stories' => 'コメント可能な記事の最大数',
    'allow_reply_notifications' => '返信のメール通知を許可する',
    'search_style' => '検索結果表示スタイル',
    'search_limits' => '表示件数の選択オプション',
    'search_show_num' => '検索順の番号を表示する',
    'search_show_type' => 'タイプを表示する',
    'search_show_sort' => 'ユーザにソートを許可する',
    'search_show_limit' => '表示件数の選択オプションを表示する',
    'search_separator' => 'グループのセパレータ',
    'search_def_keytype' => '検索条件のデフォルト',
    'search_def_sort' => 'ソート順のデフォルト',
    'autotag_permissions_story' => '[story: ] パーミッション',
    'autotag_permissions_user' => '[user: ] パーミッション'
);

$LANG_configsubgroups['Core'] = array(
    'sg_site' => 'サイト',
    'sg_stories' => '記事とトラックバック',
    'sg_theme' => 'テーマ',
    'sg_blocks' => 'ブロック',
    'sg_users' => 'ユーザと投稿',
    'sg_images' => '画像',
    'sg_locale' => '言語とロケール',
    'sg_misc' => 'その他'
);

$LANG_fs['Core'] = array(
    'fs_site' => 'サイト',
    'fs_paths' => 'パス',
    'fs_theme' => 'テーマ',
    'fs_mail' => 'メール',
    'fs_pear' => 'PEAR',
    'fs_mysql' => 'MySQL',
    'fs_users' => 'ユーザ',
    'fs_misc' => 'その他',
    'fs_spamx' => 'Spam-X',
    'fs_admin_block' => '管理者ブロック',
    'fs_locale' => 'ロケール',
    'fs_language' => '言語',
    'fs_debug' => 'デバッグ',
    'fs_cookies' => 'クッキー',
    'fs_login' => 'ログイン',
    'fs_search' => '検索',
    'fs_user_submission' => 'ユーザ登録',
    'fs_submission' => '投稿',
    'fs_topics_block' => '話題ブロック',
    'fs_whosonline_block' => 'オンラインユーザブロック',
    'fs_daily_digest' => 'デイリーダイジェスト',
    'fs_whatsnew_block' => '新着情報ブロック',
    'fs_trackback' => 'トラックバック',
    'fs_pingback' => 'ピングバック',
    'fs_story' => '記事',
    'fs_theme_advanced' => 'テーマの拡張設定',
    'fs_syndication' => 'フィード',
    'fs_imagelib' => '画像処理ライブラリ',
    'fs_upload' => 'アップロード',
    'fs_articleimg' => '記事の画像',
    'fs_topicicon' => '話題アイコン',
    'fs_userphoto' => 'ユーザの写真',
    'fs_gravatar' => 'Gravatar',
    'fs_comments' => 'コメント',
    'fs_htmlfilter' => 'HTMLフィルタ',
    'fs_censoring' => 'バッドワードチェック',
    'fs_iplookup' => 'IP検索',
    'fs_perm_story' => '記事のパーミッションのデフォルト（[0]所有者 [1]グループ [2]メンバー [3]ゲスト）',
    'fs_perm_topic' => '話題のパーミッションのデフォルト（[0]所有者 [1]グループ [2]メンバー [3]ゲスト）',
    'fs_perm_block' => 'ブロックのパーミッションのデフォルト（[0]所有者 [1]グループ [2]メンバー [3]ゲスト）',
    'fs_webservices' => 'Webサービス',
    'fs_autotag_permissions' => '自動タグのパーミッション'
);

$LANG_tab['Core'] = array(
    'tab_site' => 'サイト',
    'tab_paths' => 'パス',
    'tab_theme' => 'テーマ',
    'tab_mail' => 'メール',
    'tab_pear' => 'PEAR',
    'tab_mysql' => 'MySQL',
    'tab_users' => 'ユーザ',
    'tab_misc' => 'その他',
    'tab_spamx' => 'Spam-X',
    'tab_admin_block' => '管理者ブロック',
    'tab_locale' => 'ロケール',
    'tab_language' => '言語',
    'tab_debug' => 'デバッグ',
    'tab_cookies' => 'クッキー',
    'tab_login' => 'ログイン',
    'tab_search' => '検索',
    'tab_user_submission' => 'ユーザ登録',
    'tab_submission' => '投稿',
    'tab_topics_block' => '話題ブロック',
    'tab_whosonline_block' => 'オンラインユーザブロック',
    'tab_daily_digest' => 'デイリーダイジェスト',
    'tab_whatsnew_block' => '新着ブロック',
    'tab_trackback' => 'トラックバック',
    'tab_pingback' => 'ピングバック',
    'tab_story' => '記事',
    'tab_theme_advanced' => '拡張設定',
    'tab_syndication' => 'フィード',
    'tab_imagelib' => '画像処理ライブラリ',
    'tab_upload' => 'アップロード',
    'tab_articleimg' => '記事の画像',
    'tab_topicicon' => '話題アイコン',
    'tab_userphoto' => 'ユーザの写真',
    'tab_gravatar' => 'Gravatar',
    'tab_comments' => 'コメント',
    'tab_htmlfilter' => 'HTMLフィルタ',
    'tab_censoring' => 'バッドワードチェック',
    'tab_iplookup' => 'IP検索',
    'tab_permissions' => 'パーミッション',
    'tab_webservices' => 'Webサービス'
);

$LANG_configselects['Core'] = array(
    0 => array('はい' => 1, 'いいえ' => 0),
    1 => array('はい' => true, 'いいえ' => false),
    2 => array('拒否する' => 0, '最新ポストのみ保存する' => 1, 'マルチポストを許可する' => 2),
    3 => array('トラックバック有効' => 0, 'トラックバック停止' => -1),
    4 => array('ノーチェック' => 0, 'URLリンクをチェックする' => 1, 'フルURLをチェックする' => 2, 'URLリンクとフルURLをチェックする' => 3, 'IPとサイトのIPをチェックする' => 4, 'IPとURLリンクをチェックする' => 5, 'IPとフルURLをチェックする' => 6, 'IPとフルURLとURLリンクをチェックする' => 7),
    5 => array('テキスト' => 'plaintext', 'HTML' => 'html'),
    6 => array('12' => 12, '24' => 24),
    7 => array('最後のページ' => 'last', '最初のページ' => 'first', '全ページ' => 'all'),
    8 => array('右' => 'right', '左' => 'left'),
    9 => array('ページを表示する' => 'item', 'リストを表示する' => 'list', 'ホームを表示する' => 'home', '管理画面トップを表示する' => 'admin'),
    10 => array('なし' => '', 'Netpbm' => 'netpbm', 'ImageMagick' => 'imagemagick', 'GDライブラリ' => 'gdlib'),
    11 => array('一覧' => 'flat', '入れ子' => 'nested', 'ツリー' => 'threaded', '表示しない' => 'nocomment'),
    12 => array('アクセス不可' => 0, '表示' => 2, '表示・編集' => 3),
    13 => array('スキップする' => 0, '許可する(間隔制限あり)' => 1, '許可する(間隔制限なし)' => 2),
    14 => array('日曜日' => 'Sun', '月曜日' => 'Mon'),
    15 => array('番号順' => 'sortnum', 'アルファベット順' => 'alpha'),
    16 => array('いいえ' => 0, '検索オプションのみ要求' => 1, 'すべての検索機能で要求' => 2),
    17 => array('許可する' => 0, '許可しない' => -1),
    18 => array('チェックしない' => 0, 'チェックする（完全一致）' => 1, 'チェックする（前方一致）' => 2, 'チェックする（部分一致）' => 3),
    19 => array('Google' => 'google', 'Table' => 'table'),
    20 => array('完全一致' => 'phrase', 'すべてのキーワードを含む' => 'all', 'いずれかのキーワードを含む' => 'any'),
    21 => array('HTML 4.01 Transitional' => 'html401transitional', 'HTML 4.01 Strict' => 'html401strict', 'XHTML 1.0 Transitional' => 'xhtml10transitional', 'XHTML 1.0 Strict' => 'xhtml10strict'),
    22 => array('Strict' => 'DENY', 'Same Origin' => 'SAMEORIGIN', '(無効にする)' => ''),
    23 => array('無効にする' => 0, '有効にする' => 1, '有効にする(トップページにのみデフォルトを使用する)' => 2),
    24 => array('投稿する' => 'contribute', 'Home' => 'home', '詳しい検索' => 'search', 'ディレクトリ' => 'directory', 'マイアカウント' => 'prefs', 'プラグインエントリ' => 'plugins', 'カスタムエントリ' => 'custom', 'サイトステータス' => 'stats'),
    25 => array('新着記事' => 'story', '新着コメント' => 'comment', '新着トラックバック' => 'trackback', '新着ピングバック' => 'pingback', '新着ユーザ' => 'user'),
    26 => array('G (一般向け)' => 'G', 'PG (保護者の指導が望ましい)' => 'PG', 'R (保護者同伴制限付き' => 'R', 'X (17歳未満利用禁止)' => 'X'),
    27 => array('閲覧数 (昇順)' => 'hits|asc', '閲覧数 (降順)' => 'hits|desc', '日付 (昇順)' => 'date|asc', '日付 (降順)' => 'date|desc', 'タイトル (昇順)' => 'title|asc', 'タイトル (降順)' => 'title|desc', '所有者 (昇順)' => 'uid|asc', '所有者 (降順)' => 'uid|desc'),
    28 => array('アクセス不可' => 0, '利用する' => 2)
);

###############################################################################
# Localization of validation error messages

$LANG_VALIDATION = array(
    'default' => 'このフィールドには許可されていない値が含まれています',
    'notEmpty' => 'このフィールドは必須入力です',
    'alphaNumeric' => 'このフィールドは半角英数です。',
    'between' => 'このフィールドは特定の範囲内の値を入れなければなりません',
    'blank' => 'このフィールドは空でなければなりません',
    'comparison' => 'このフィールドは比較操作に適合していません',
    'date' => 'このフィールドはdateフォーマットで入力してください',
    'year' => 'このフィールドはyearフォーマットで入力してください',
    'time' => 'このフィールドはdateフォーマットで入力してください',
    'datetime' => 'このフィールドはdatetimeフォーマットで入力してください',
    'boolean' => 'このフィールドはbooleanフォーマットで入力してください',
    'decimal' => 'このフィールドはdecimalフォーマットで入力してください',
    'email' => 'このフィールドにはemailアドレスフォーマットで入力してください',
    'equalTo' => 'このフィールドは同じではありません',
    'extension' => 'このフィールドには許可された拡張子のファイルのみ入力できます',
    'ip' => 'IPフォーマットが間違っています',
    'minLength' => 'このフィールドは短すぎます',
    'maxLength' => 'このフィールドは長すぎます',
    'numeric' => 'このフィールドには数値を入力してください',
    'phone' => 'このフィールドは電話番号フォーマットで入力してください',
    'range' => 'このフィールドは特定範囲内の数値を入力してください',
    'url' => 'このフィールドはURLフォーマットです',
    'inList' => 'このフィールドは特定のリストを含まなければなりません',
    'mail_settings_backend' => 'このフィールドは \'smtp\', \'sendmail\', or \'mail\'のどれかひとつだけです',
    'mail_settings_sendmail_path' => 'このフィールドにはsendmail binaryへのパスを入力してください',
    'mail_settings_host' => 'このフィールドにはhostnameを入力してください',
    'mail_settings_port' => 'このフィールドには0から65535の数値を入力してください',
    'rdf_limit' => 'このフィールドには数値または24hのようなhourフォーマットで入力してください',
    'path' => 'パスはありません',
    'file' => 'ファイルはありません',
    'search_limits' => 'このフィールドにはカンマで区切られた数値を入力してください',
    'num_search_results' => 'このフィールドには下の\'search_limits\'の数値を入力してください',
    'theme' => 'テーマディレクトリがありません',
    'path_themes' => 'テーマパスは絶対パスです。最後にディレクトリセパレータの\'/\'が必要です',
    'path_to_mogrify' => '画像処理ライブラリimagemagickのセットアップを行い、このフィールドにmogrifyが可能になるようパスを入力してください',
    'path_to_netpbm' => '画像処理ライブラリnetpbmのセットアップを行い、このフィールドにNetpbmのパッケージソースへのパスを入力してください',
    'language' => '言語ファイルがありません',
    'timezone' => '無効なtimezoneです',
    'single_char' => 'このフィールドには半角1文字を入力してください'
);


?>
