<?php

###############################################################################
# chinese_traditional_utf-8.php
#
# Last Modified: 2008-05-23
# Version: 1.5
#
# This is the Chinese Traditional (UTF-8) language set for Geeklog 1.5
#
# Copyright (C) 2003 Samuel Maung Stone
# sam@stonemicro.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

$LANG_CHARSET = 'utf-8';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => '作者︰',
    2 => '讀整文',
    3 => '個評論',
    4 => '編輯',
    5 => '',
    6 => '',
    7 => '',
    8 => '',
    9 => '管理者功能︰',
    10 => '提交物',
    11 => '文章',
    12 => '組件',
    13 => '主題',
    14 => 'Command &amp; Control',
    15 => '',
    16 => '',
    17 => '用戶',
    18 => 'SQL 質問',
    19 => '退出',
    20 => '用戶訊息︰',
    21 => '用戶名',
    22 => '用戶識別號',
    23 => '安全等級',
    24 => '匿名',
    25 => '回復',
    26 => '以下評論只屬張貼者個人觀點。',
    27 => '最近發表的',
    28 => '刪除',
    29 => '沒有評論。',
    30 => '舊的文章',
    31 => '允許的 HTML 標記:',
    32 => '錯誤，無效的用戶名',
    33 => '錯誤，不能寫系統日誌;',
    34 => '錯誤',
    35 => '退出',
    36 => '於',
    37 => '沒有文章',
    38 => '內容辛迪加',
    39 => '使新',
    40 => 'Error in password request, invalid username',
    41 => '客人',
    42 => '作者:',
    43 => '回復這個',
    44 => '母體',
    45 => 'MySQL 錯誤號碼',
    46 => 'MySQL 錯誤訊息',
    47 => '用戶功能',
    48 => '我的帳戶',
    49 => '風格選擇',
    50 => '錯誤的 SQL 句子',
    51 => '幫助',
    52 => '新',
    53 => '管理者首頁',
    54 => '不能打開檔。',
    55 => '錯處',
    56 => '投票',
    57 => '密碼',
    58 => '登入',
    59 => "沒有帳戶？<a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">在此登記</a>",
    60 => '發表評論',
    61 => '新增帳戶',
    62 => '字',
    63 => '評論設定',
    64 => '把文章電郵給朋友',
    65 => '觀看可列印的版本',
    66 => '',
    67 => '歡迎來到',
    68 => '首頁',
    69 => '聯絡',
    70 => '搜尋',
    71 => '投稿',
    72 => '網路資源',
    73 => '',
    74 => '',
    75 => '進階搜索',
    76 => '本站統計資料',
    77 => '插件',
    78 => '',
    79 => '新鮮的東西',
    80 => '個新文章(',
    81 => '新的文章(',
    82 => ' 小時內)',
    83 => '評論',
    84 => '',
    85 => '最近四十八小時',
    86 => '沒有新的評論',
    87 => '最近兩個星期',
    88 => '',
    89 => '',
    90 => '首頁',
    91 => '載入這頁用了',
    92 => '秒',
    93 => '版權',
    94 => '此網站所有的商標和版權屬於他們各自的所有者.',
    95 => '動力於',
    96 => '小組',
    97 => '字詞單',
    98 => '插件',
    99 => '文章',
    100 => '沒有新的文章',
    101 => '',
    102 => '',
    103 => '資料庫備份',
    104 => '由',
    105 => '寄給用戶',
    106 => '採樣數:',
    107 => 'GL 版本測試',
    108 => '清除緩衝貯存區',
    109 => '報告濫用',
    110 => '報告此濫登文給網站管理員',
    111 => '',
    112 => '登記用戶',
    113 => '使用說明',
    114 => '跡回',
    115 => '沒有新跡回的評論',
    116 => '跡回',
    117 => '目錄',
    118 => '請繼續看下頁',
    119 => "丟失了<a ref=\"{$_CONF['site_url']}/users.php?mode=getpassword\" rel=\"nofollow\">密碼</a>?",
    120 => '永久聯結此評論',
    121 => '評論 (%d)',
    122 => '跡回 (%d)',
    123 => '准許用所有的HTML',
    124 => '點擊刪除所選的項目',
    125 => '你肯定要刪除所選的專案嗎？',
    126 => '選 或 不選 所有的項目',
    127 => 'Permalink',
    128 => '用OpenID 登入:',
    129 => '設定',
    130 => '網路服務',
    131 => 'No HTML is allowed',
    132 => 'Information',
    133 => 'Critical',
    134 => 'Help',
    135 => 'Warning',
    136 => 'Warning: Javascript recommended for enhanced functionality',
    137 => 'Warning: Javascript required to enable functionality',
    138 => "Click <a href=\"{$_CONF['site_url']}/usersettings.php\" rel=\"nofollow\">here</a> to disable the advanced editor and use the default editor which does not require JavaScript",
    139 => "Click <a href=\"{$_CONF['site_url']}/\" rel=\"nofollow\">here</a> to return to the homepage",
    140 => 'Allowed Autotags:',
    'facebook' => 'Login with Facebook',
    'twitter' => 'Login with Twitter',
    'linkedin' => 'Login with LinkedIn',
    'google' => 'Login with Google',
    'microsoft' => 'Login with Microsoft',
    'yahoo' => 'Login with Yahoo',
    'ctl' => 'Clear Cache',
    'filemanager' => 'File Manager'
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => '發表評論',
    2 => '發表方式',
    3 => '退出',
    4 => '新增帳戶',
    5 => '用戶名',
    6 => '本站需要登入才可發表評論，請登入。如果你沒有帳戶，請使用下面的表格登記。',
    7 => '你最後發表的評論是在 ',
    8 => " 秒之前。本站限定至少 {$_CONF['commentspeedlimit']} 秒後才可再發表評論",
    9 => '評論',
    10 => '送出報告',
    11 => '發表評論',
    12 => '請填寫標題注評論欄',
    13 => '供你參考',
    14 => '預覽',
    15 => '報告這篇濫登文',
    16 => '標題',
    17 => '錯誤',
    18 => '重要的東西',
    19 => '請儘量不要離題。',
    20 => '盡可能回復別人的評論，而不是開新的評論。',
    21 => '為避免重複，發表評論之前請先讀別人所寫的。',
    22 => '請儘量用簡潔的標題。',
    23 => '我們不會公開你的電郵地址。',
    24 => '匿名用戶',
    25 => '你肯定想要報告此濫登文給網站管理員否?',
    26 => '%s 報告以下濫登的評論:',
    27 => '濫用報告',
    28 => 'Preview Changes',
    29 => 'Submit Changes',
    30 => 'Edited on',
    31 => 'by',
    32 => 'Editing a Comment',
    33 => 'Editing a Comment Submission',
    34 => 'Preview Submission Changes',
    35 => 'Save Changes to Queue',
    36 => 'Notify me of new replies',
    37 => 'New Comment Reply',
    38 => 'A reply has been made to your comment \'%s\'.',
    39 => 'You may view the comment thread at the following address:',
    40 => 'If you wish to receive no further notifications of replies, visit the following link:',
    41 => 'Hello %s,',
    42 => 'Unsubscribe',
    43 => 'Unsubscribe from reply notifications',
    44 => 'Your Name',
    45 => "Thank you for your comment. You must wait {$_CONF['commentspeedlimit']} seconds to post a new comment."
);

###############################################################################
# users.php

$LANG04 = array(
    1 => '用戶概況',
    2 => '用戶名',
    3 => '全名',
    4 => '密碼',
    5 => '電子郵件',
    6 => '首頁',
    7 => '小傳',
    8 => 'PGP 鑰匙',
    9 => '保存設定',
    10 => '給用戶的最後十個評論',
    11 => '沒有評論',
    12 => '用戶設定',
    13 => '每夜電郵文摘',
    14 => '這是個隨機的密碼，請儘快更改。要更改密碼請先登入系統，然後點擊帳戶訊息。',
    15 => "你在 {$_CONF['site_name']} 的帳戶已建立了。請使用以下訊息登入系統並保留這郵件作日後參考。",
    16 => '你的帳戶訊息',
    17 => '帳戶並不存在',
    18 => '你提供的不是一個有效的的電郵',
    19 => '用戶名或電郵已經存在',
    20 => '提供的不是一個有效的的電郵',
    21 => '錯誤',
    22 => "登記用 {$_CONF['site_name']} ！",
    23 => "在 {$_CONF['site_name']} 登記的用戶可享有的會員好處。他們可以用自己的名字發表評論和存取本站的資源。請注意本站<b><i>絕不會</i></b>公開用戶的電郵。",
    24 => '你的密碼將被送到你輸入的電郵信箱',
    25 => '忘記了你的密碼嗎？',
    26 => '請你輸入的用戶名和點擊電郵密碼，我們會發送一個新的密碼到你的電郵信箱。',
    27 => '現在就登記！',
    28 => '電郵密碼',
    29 => '退出時',
    30 => '登入時',
    31 => '需要登入才可用',
    32 => '署名',
    33 => '絕不會公開',
    34 => '這是你的真名',
    35 => '要改變請輸入密碼',
    36 => '開始是 http://',
    37 => '將會附加在你發表的評論上',
    38 => '你的簡介',
    39 => '你的公共 PGP 鑰匙',
    40 => '沒有主題圖示',
    41 => '願意主持',
    42 => '日期格式',
    43 => '文章限度',
    44 => '沒有組件',
    45 => '顯示設定',
    46 => '不包括的',
    47 => '新元件配置為',
    48 => '主題',
    49 => '文章裏沒有圖像',
    50 => '不要打鉤如果你不感興趣',
    51 => '只是新文章',
    52 => '預設值的是',
    53 => '每晚接收當日的文章',
    54 => '打鉤如果你不看這些主題或作者。',
    55 => '如果你沒有選擇，這意味你要用預設的組件。如果你選擇元件，所有預設的箱將被忽略。預設的東西會用粗筆劃顯示。',
    56 => '作者',
    57 => '顯示方式',
    58 => '排序方式',
    59 => '評論限制(個)',
    60 => '可顯示你的評論嗎？',
    61 => '最新或最舊的先？',
    62 => '預設是100',
    63 => '密碼已被發送，你會很快收到的。',
    64 => '評論設定',
    65 => '請嘗試再登入',
    66 => "你可能打錯了，請嘗試再登入。你是否<a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">新用戶</a>？",
    67 => '成員自',
    68 => '記住我為',
    69 => '在登入以後，我們應該記住你多久？',
    70 => "定做 {$_CONF['site_name']} 的佈局和內容",
    71 => "一個 {$_CONF['site_name']} 的主要特點是你可以定做自己的佈局和內容，但是你必須是本站的會員。<a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">在此登記</a>。如果你已經是登記，請使用左邊的區域登入。",
    72 => '題材',
    73 => '語言',
    74 => '改變本站外表',
    75 => '主題已電郵給',
    76 => '請只選擇你感興趣的主題，因為所有當日新張貼的文章將會電郵到你的信箱。',
    77 => '相片',
    78 => '你自己的圖片',
    79 => '要刪除圖片，在這裏打鉤',
    80 => '登入',
    81 => '發送電子郵件',
    82 => '用戶最近發表的十個文章為',
    83 => '用戶發表統計',
    84 => '文章總數︰',
    85 => '評論總數︰',
    86 => '尋找所有發表過的文章︰',
    87 => '你的登入名',
    88 => "有人(也許是你)要了新密碼 \"%s\" 於 {$_CONF['site_name']}, <{$_CONF['site_url']}>.\n\n若你真的要這樣作, 請你點擊以下聯結:\n\n",
    89 => "你若不想要這樣作, 請忽視這資訊。這項事就將會被拋棄，而你的密碼就保持原有.\n\n",
    90 => '你可在下面輸入一個新的密碼。請注意你的舊密碼任然有效直到你將此表提交。',
    91 => '設定新密碼',
    92 => '輸入新密碼',
    93 => '你在 %d 秒鐘前剛要了一個新密碼. 此站規定最少要 %d 秒鐘以後才可再次要求新密碼。',
    94 => '將用戶 \'%s\' 刪除',
    95 => '單據下面的 \'刪除用戶\' 便將你在我們資料庫裏的用戶。請注意，你以其用戶所登載過的文章和評論不會刪除，可是會以無名作者的身份顯示。',
    96 => '刪除用戶',
    97 => '確定用戶刪除',
    98 => '你肯定要刪除你的用戶嗎? 其後你就不在能使用此站,除非你重新設定新用戶. 若你肯定的話請再次單據下面的 “刪除用戶”.',
    99 => '隱私選項於',
    100 => '管理員來信',
    101 => '准許管理員來信',
    102 => '用戶來信',
    103 => '准許其他用戶來信',
    104 => '顯示聯機狀況',
    105 => '讓在“誰在聯機”元件裏顯示',
    106 => '位置',
    107 => '顯示在你的公開簡介',
    108 => '肯定新密碼',
    109 => '再次輸入密碼',
    110 => '目前的密碼',
    111 => '請輸入目前的密碼',
    112 => '你已超過准許的登入次數. 情稍候再努力.',
    113 => '登入失敗',
    114 => '帳戶已被中止',
    115 => '你的帳戶已被中止, 你不能繼續登入. 請跟管理員聯絡.',
    116 => '等待啟動的帳戶',
    117 => '你的帳戶現在等待管理員的啟動. 在帳戶未批准以前, 你還不能登入.',
    118 => "你的 {$_CONF['site_name']} 帳戶已被啟動. 你可通過以下的url 用先前以電信寄給你的用戶名 (<username>) 和密碼來登入.",
    119 => '你若已忘記了你的密碼你可通過此 url 來要求一個新密碼',
    120 => '帳戶已被啟動',
    121 => '服務',
    122 => '對不起, 目前禁止新用戶登記',
    123 => "你是否 <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">新用戶</a>?",
    124 => '確認電信',
    125 => '你必需要輸入同樣的電信位址!',
    126 => '請重複輸入來確認',
    127 => '你必須輸入目前的密碼來做任何修改.',
    128 => '姓名',
    129 => '密碼 &amp; 電信',
    130 => '關於你',
    131 => '每日摘要選項',
    132 => '每日摘要功能',
    133 => '評論顯示',
    134 => '評論選項',
    135 => '<li>顯示評論的默認模式</li><li>顯示評論的默認次序</li><li>設定顯示評論的極大數位 – 默認數位是 100</li>',
    136 => '排除標題和作者',
    137 => '過濾文章內容',
    138 => '其他設定',
    139 => '版面和語言',
    140 => '<li>不要標題的圖示：勾此處就不會顯示標題的圖示</li><li>不要元件：勾了此處就不會顯示元件，只會顯示管理功能表，用戶功能表，和主題功能表<li>設定每頁顯示的極大文章數位</li><li>設定你的版面主題和喜歡的日期格式</li>',
    141 => '隱私設定',
    142 => '默認設定的是讓用戶和管理員們彼此可用電信交通而顯示你的線上狀態。取消這設定可保護你的隱私權.',
    143 => '過濾元件內容',
    144 => '顯示或隱藏元件',
    145 => '你的公開簡介',
    146 => '密碼和電信',
    147 => '修改你的用戶密碼，電信，和自動登入作用。你需要輸入你的密碼或電信位址兩次來避免錯誤。',
    148 => '用戶資訊',
    149 => '修改要顯示給其他用戶的你的用戶資訊.<li>你的簽名會顯示在你的評論或論壇標語的下面</li><li>個人簡歷是用來分享你自己的簡介</li><li>分享你得 PGP 鑰匙</li>',
    150 => '',
    156 => '刪除用戶',
    157 => '刪除選項',
    158 => '時區',
    159 => '這電郵是自動產生的。請不要回信。',
    160 => '(max. %d x %d pixels, %d bytes; %s)',
    161 => 'will be scaled down',
    162 => 'will not be scaled',
    163 => 'Re-Authentication Failed',
    164 => 'You have exceeded the number of allowed attempts for re-authentication. The operation has been aborted and your recent changes were lost, sorry.',
    165 => 'Use Advanced Editor',
    166 => 'Re-synch Remote Account',
    167 => 'Remote login',
    168 => 'You may also login with one on of the below remote authentication services',
    'user_login' => 'User Login',
    'user_login_message' => 'Please login below. You must enter both a username and password.',
    'user_logged_in_message' => "You are already logged in. Whould you like to <a href=\"{$_CONF['site_url']}/users.php?mode=logout\" rel=\"nofollow\">logout</a>?"
);

###############################################################################
# Customize if need to modify the Tabbed navbar MyAccount panels used.
# Array index key matches preference div id

$LANG_MYACCOUNT = array(
    'pe_preview' => '預覽',
    'pe_namepass' => '用戶名 &amp; 密碼',
    'pe_userinfo' => '關於你',
    'pe_layout' => '版面 &amp; 語言',
    'pe_content' => '內容',
    'pe_privacy' => '秘密'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => '沒有新聞可顯示',
    2 => '沒有新文章可顯示。',
    3 => '',
    4 => '今天頭條',
    5 => '下頁',
    6 => '上頁',
    7 => '第一',
    8 => '最終'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => '發送電子郵件時發生錯誤。請再嘗試。',
    2 => '電郵已送出。',
    3 => '請確定你在回復欄有一個可用的電子郵件位址。',
    4 => '請填寫你的名字、回復欄、主題和內容',
    5 => '錯誤：沒有這用戶。',
    6 => '發生錯誤。',
    7 => '用戶資料',
    8 => '用戶名',
    9 => '用戶名的 URL',
    10 => '發送郵件到',
    11 => '你的名字：',
    12 => '回復到：',
    13 => '主題：',
    14 => '內容：',
    15 => 'HTML 不會被翻譯。',
    16 => '發送郵件',
    17 => '把文章電郵給朋友',
    18 => '收件人名字',
    19 => '收件人電郵',
    20 => '寄件人名字',
    21 => '寄件人電郵',
    22 => '所有欄都要填寫',
    23 => "這電子郵件是由 %s (%s) 寄給你的，他認為你也許對這篇在 {$_CONF['site_url']} 的文章感興趣。這不是垃圾郵件(SPAM)，你的電郵位址也不會被紀錄。",
    24 => '關於這個文章的評論在',
    25 => '為幫助我們防止系統被濫用，你必須登入。',
    26 => '這個表格允許你送電子郵件到你選擇的用戶中。請填寫所有的欄位。',
    27 => '短信',
    28 => '%s 寫道：',
    29 => "來自於 {$_CONF['site_name']} 的每日文摘，給予：",
    30 => ' 每日的時事通訊，給予：',
    31 => '標題',
    32 => '日期',
    33 => '完整的文章在：',
    34 => '電郵結束',
    35 => '對不起，此用戶不願意收電信.',
    36 => 'Copy:',
    37 => 'Send me a copy of this email',
    38 => "This is a copy of the email that you sent to %s from <{$_CONF['site_url']}>:",
    39 => 'Your last message was ',
    40 => " seconds ago.  This site requires at least {$_CONF['speedlimit']} seconds between sending messages"
);

###############################################################################
# search.php

$LANG09 = array(
    1 => '進階搜尋',
    2 => '關鍵字',
    3 => '主題',
    4 => '所有',
    5 => '類型',
    6 => '文章',
    7 => '評論',
    8 => '作者',
    9 => '所有',
    10 => '搜尋',
    11 => '搜尋結果',
    12 => '相配',
    13 => '搜尋結果：沒有相配的',
    14 => '沒有你尋找的東西︰',
    15 => '請再嘗試',
    16 => '標題',
    17 => '日期',
    18 => '作者',
    19 => "搜尋整個 {$_CONF['site_name']} 的新舊文章資料庫",
    20 => '日期',
    21 => '到',
    22 => '(日期格式 年-月-日 YYYY-MM-DD)',
    23 => '採樣數',
    24 => '找到',
    25 => '個相配在',
    26 => '個項目中，共用了',
    27 => '秒',
    28 => '沒有你所尋找的文章或評論',
    29 => '文章和評論的結果',
    30 => '',
    31 => '沒有你所尋找的插件',
    32 => '',
    33 => 'URL',
    34 => '地點',
    35 => '所有日子',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '搜尋的關鍵字最少要有三個字。',
    42 => '請使用 YYYY-MM-DD (年-月-日) 日期格式。',
    43 => '整個短語',
    44 => '所有字詞',
    45 => '其中任何字詞',
    46 => '以下',
    47 => '以上',
    48 => '作者',
    49 => '日期',
    50 => '採樣數',
    51 => '',
    52 => '位置',
    53 => '文章結果',
    54 => '評論結果',
    55 => '句子',
    56 => '和',
    57 => '或',
    58 => '更多的結果 &gt;&gt;',
    59 => '結果',
    60 => '每頁',
    61 => '改進搜尋',
    62 => '#',
    63 => 'Description',
    64 => 'Showing %1$d - %2$d of %3$d results',
    65 => 'Story',
    66 => 'Comment',
    67 => 'Show %d Results',
    68 => 'Sort By',
    69 => 'Titles Only',
    70 => 'Not available ...',
    71 => 'asc',
    72 => 'desc'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => '本站統計資料',
    2 => '系統點擊總數',
    3 => '文章(評論)總數',
    4 => '',
    5 => '',
    6 => '',
    7 => '採樣數最高的十個文章',
    8 => '文章標題',
    9 => '採樣數',
    10 => '看來本站沒有文章或是沒人觀看過本站的文章。',
    11 => '最多評論的十個文章',
    12 => '評論',
    13 => '看來本站沒有文章或是沒人評論過本站的文章。',
    14 => '',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '',
    22 => '最多人寄出的十個文章',
    23 => '電郵',
    24 => '看來沒人寄出過本站的文章',
    25 => '頭十個跡回評論的文章',
    26 => '找不到跡回評論.',
    27 => '用戶人數',
    28 => '',
    29 => '',
    30 => '採樣數',
    31 => ''
);

###############################################################################
# article.php

$LANG11 = array(
    1 => '有什麽是相關的',
    2 => '寄文章給朋友',
    3 => '可印的文章格式',
    4 => '文章選項',
    5 => '',
    6 => 'Subscribe to \'%s\''
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => '你需要登入才可發表 %s ',
    2 => '登入',
    3 => '新用戶',
    4 => '',
    5 => '',
    6 => '發表一個文章',
    7 => '你需要登入',
    8 => '發表',
    9 => '在本站發表東西時請跟隨以下建議...<ul><li>填寫所有的欄<li>提供完全和準確的訊息<li>再三檢查那些 URLs</ul>',
    10 => '標題',
    11 => '',
    12 => '開始日期',
    13 => '結束日期',
    14 => '地點',
    15 => '描述',
    16 => '',
    17 => '',
    18 => '',
    19 => '讀這先',
    20 => '',
    21 => '',
    22 => '錯誤：缺少欄位',
    23 => '請填寫所有的欄位',
    24 => '你發表的已被保存了',
    25 => '你的 %s 已被保存了',
    26 => '限速',
    27 => '用戶名',
    28 => '主題',
    29 => '文章',
    30 => '你最後發表的是',
    31 => " 秒之前。本站限定至少 {$_CONF['speedlimit']} 秒後才可再發表",
    32 => '預覽',
    33 => '文章 預覽',
    34 => '退出',
    35 => '不准許 HTML 標記',
    36 => '發表模式',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '',
    42 => '',
    43 => '',
    44 => '地址 1',
    45 => '地址 2',
    46 => '城市/市鎮',
    47 => '州',
    48 => '郵遞區號',
    49 => '',
    50 => '',
    51 => '地點',
    52 => '刪除',
    53 => '新加帳戶',
    54 => '文章介紹',
    55 => '文章整文'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/logviewer.php

$LANG_LOGVIEW = array(
    'log_viewer' => 'Log Viewer',
    'info' => 'Geeklog log file administration.',
    'logs' => 'Logs',
    'view' => 'View Log File',
    'clear' => 'Clear Log File',
    'log_file' => 'Log File'
);

###############################################################################
# admin/envcheck.php - distribution integrity checker

$LANG_ENVCHECK = array(
    'correct_perms' => 'Please correct the issues identified below. Once they have been corrected, use the <b>Recheck</b> button to validate the environment.',
    'current' => 'Current',
    'current_php_settings' => 'Current PHP Settings',
    'directory_permissions' => 'Directory Permissions',
    'enabled' => 'Enabled',
    'env_check' => 'Environment Check',
    'file_permissions' => 'File Permissions',
    'file_uploads' => 'Many features of Geeklog require the ability to upload files, this should be enabled.',
    'filesystem_check' => 'Directory / File Permissions',
    'gd_lib' => 'GD Libraries',
    'gd_not_found' => 'Unable to locate the GD library functions.  Please ensure that the GD libraries were compiled into PHP or select an alternate graphics library.',
    'gd_ok' => 'GD Libraries v2 are installed.',
    'gd_v1' => 'GD Libraries v1 is installed - This version does not fully support JPG image processing so there may be some quality issues.',
    'graphics' => 'Graphics Library',
    'libraries' => 'Libraries',
    'hosting_env' => 'Hosting Environment Check',
    'imagemagick' => 'ImageMagick Programs',
    'im_not_found' => 'Unable to locate the <strong>convert</strong> executable for ImageMagick.',
    'im_ok' => 'The <strong>convert</strong> executable appears to be valid.',
    'memory_limit' => 'It is recommended that you have at least 48M of memory enabled on your site.',
    'not_writable' => 'NOT WRITABLE',
    'notes' => 'Notes',
    'not_found' => 'Not Found',
    'netpbm' => 'NetPBM Library',
    'np_ok' => 'The NetPBM library is installed',
    'np_not_found' => 'The NetPBM executables were not found.',
    'openssl_library' => 'OpenSSL Library',
    'openssl_ok' => 'The OpenSSL library is loaded. This library is required if you wish to use the OAuth user login method with Geeklog.',
    'openssl_not_found' => 'The OpenSSL library is not loaded. This is required <strong>only</strong> if you wish to use the OAuth user login method with Geeklog.',
    'off' => 'Off',
    'ok' => 'OK',
    'on' => 'On',
    'open_basedir' => 'If <strong>open_basedir</strong> restrictions are enabled on your site, it may cause permission problems during the install. The File System Check below should point out any issues.',
    'php_req_version' => 'Geeklog requires PHP version 5.2.0 or newer.',
    'php_settings' => 'PHP Settings',
    'php_version' => 'PHP Version',
    'php_warning' => 'If any of the items below are marked in <span class="no">red</span>, you may encounter problems with your Geeklog site.  Check with your hosting provider for information on changing any of these PHP settings.',
    'post_max_size' => 'Geeklog allows you to upload plugins, images, and files. You should allow at least 8M for the maximum post size.',
    'recheck' => 'Recheck Environment',
    'recommended' => 'Recommended',
    'register_globals' => 'If PHP\'s <strong>register_globals</strong> is enabled, it can create security issues.',
    'safe_mode' => 'If PHP\'s <strong>safe_mode</strong> is enabled, some functions of Geeklog may not work correctly. Specifically the Media Gallery plugin.',
    'setting' => 'Setting',
    'unable_mkdir' => 'Unable to create directory',
    'upload_max_filesize' => 'Geeklog allows you to upload plugins, images, and files. You should allow at least 8M for the upload size.',
    'not_checked' => 'Skipped',
    'bypass_note' => 'Since either Safe Mode or open_basedir restrictions were detected, the check for graphic libraries were skipped.',
    'not_used_note' => 'No graphic libraries are set to be used by Geeklog.',
    'location' => 'Location',
    'status' => 'Status',
    'item' => 'Item',
    'jhead' => 'jhead Program',
    'jhead_not_found' => 'Unable to locate the jhead executable.',
    'jhead_ok' => 'The jhead executable is installed.',
    'jpegtran' => 'jpegtran Program',
    'jpegtran_not_found' => 'Unable to locate the jpegtran executable.',
    'jpegtran_ok' => 'The jpegtran executable is installed.',
    'showhide_phpinfo' => 'Show/Hide Full PHP Info',
    'view_online' => 'Click here %s to view online',
    'no_new_items' => 'No New Items',
    'max_execution_time' => 'Geeklog recommends the PHP default value of 30 seconds as a minimum, but plugin uploads and other operations may take longer than this depending upon your hosting environment.  If safe_mode (above) is Off, you may be able to increase this by modifying the value of <b>max_execution_time</b> in your php.ini file.'
);

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => '要求認證',
    2 => '拒絕！不正確的登入資料',
    3 => '無效的密碼',
    4 => '用戶名：',
    5 => '密碼：',
    6 => '這頁只供授權人員使用。<br' . XHTML . '>所有存取將被記錄和檢查。',
    7 => '登入'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => '權力不足',
    2 => '你沒有權去編輯這個元件。',
    3 => '組件編輯器',
    4 => '讀取此文流時發現錯誤，請在你的錯誤記錄檔案 error.log 裏看細節.',
    5 => 'Yes',
    6 => 'No',
    7 => '所有',
    8 => '元件安全水平',
    9 => '組件次序',
    10 => '',
    11 => '入口組件',
    12 => '正常元件',
    13 => '入口元件選項',
    14 => '文流 RDF 的 URL',
    15 => '最後的文流 RDF 更新',
    16 => '正常元件選項',
    17 => '元件內容',
    18 => '請填寫元件的標題和內容。',
    19 => '組件管理員',
    20 => 'Regular Blocks',
    21 => '元件安全水平',
    22 => 'Dynamic Blocks',
    23 => '組件次序',
    24 => 'Dynamic',
    25 => '點擊下面的組件可修改或刪除它，點擊上面的新元件可創造一個新的。',
    26 => '版面組件',
    27 => 'PHP 組件',
    28 => 'PHP 元件選項',
    29 => '元件函數',
    30 => '如果你想用自己的 PHP 函數元件，請在上面輸入函數的名字。為防止執行任性的編碼，PHP 元件函數名必須以 "phpblock_" 作開始 (e.g. phpblock_getweather)。請不要把空的圓括號 "()" 放在函數後。最後，建議你把所有的 PHP 組件放在 /path/to/geeklog/system/lib-custom.php 裏以方便系統升級。',
    31 => 'PHP 元件錯誤︰函數 %s 並不存在。',
    32 => '錯誤︰缺少欄位元。',
    33 => '在入口元件你必須把 URL 輸入到 .rdf 檔案',
    34 => '在 PHP 元件你必須輸入標題和函數',
    35 => '在正常元件你必須輸入標題和內容',
    36 => '在版面元件你必須輸入內容',
    37 => '不適當的 PHP 元件函數名',
    38 => '為防止執行任性的編碼，PHP 元件函數名必須以 "phpblock_" 作開始 (e.g. phpblock_getweather)。',
    39 => '放在那邊',
    40 => '左',
    41 => '右',
    42 => '在本系統的預設元件你必須輸入元件標題和次序',
    43 => '只可是首頁',
    44 => 'Multiple',
    45 => "企圖存取不允許的元件已被記錄。請<a href=\"{$_CONF['site_admin_url']}/block.php\">反回組件管理員晝面</a>。",
    46 => '新組件',
    47 => 'None',
    48 => '組件名',
    49 => ' (不可有空隔和必須是唯一的)',
    50 => 'The Block Name can not be empty',
    51 => '包括 http://',
    52 => '如果這裏留白，元件的求助檔圖示將不被顯示',
    53 => '使有效',
    54 => '保存',
    55 => '取消',
    56 => '刪除',
    57 => '下移組件',
    58 => '上移組件',
    59 => '移組件到右邊',
    60 => '移組件到左邊',
    61 => '無標題',
    62 => '文章限制',
    63 => '錯誤元件標題',
    64 => '你的標題不能空白或有HTML!',
    65 => '次序',
    66 => '自動標籤',
    67 => '打勾來准許自動標籤',
    68 => '這入口組件的新聞饋入太長. 請在組件設定區裏設定最多文章數限，或在志樂的全面設定區裏設定最多文章數限。',
    69 => 'Plugin Name',
    'cache_time' => 'Cache Time',
    'cache_time_desc' => 'This block will be cached for no longer than this many seconds. If 0 caching is disabled. (3600 = 1 hour,  86400 = 1 day)'
);

###############################################################################
# admin/story.php

$LANG24 = array(
    1 => '上篇文章',
    2 => '下篇文章',
    3 => '模式',
    4 => '發表模式',
    5 => '文章編輯器',
    6 => '沒有文章',
    7 => '作者',
    8 => '保存',
    9 => '預覽',
    10 => '取消',
    11 => '刪除',
    12 => 'ID',
    13 => '',
    14 => '',
    15 => '日期',
    16 => '文章簡介',
    17 => '文章內容',
    18 => '點擊次數',
    19 => '評論',
    20 => 'Ping',
    21 => '傳送 Ping',
    22 => '文章清單',
    23 => '點擊下面的文章編號可修改或刪除它，點擊下面的文章標題可觀看它，點擊上面的新文章可創造一個新的。',
    24 => '你選的用戶名以有人在用。請用另一個用戶名。',
    25 => '存續文章時發生錯誤',
    26 => '文章預覽',
    27 => '你若用 [unscaledX] 而不是[imageX], 圖像將會以原來的尺寸插入.',
    28 => '<p><b>預覽</b>: 預覽有圖像的文章的最好方法是將它存為草稿。用預覽按鈕來預覽沒有圖像的文章。',
    29 => '跡回',
    30 => '上載錯誤',
    31 => '你需要提供作者、標題和文章簡介！',
    32 => '頭條的',
    33 => '只可有一個頭條文章',
    34 => '草稿',
    35 => '是',
    36 => '否',
    37 => '更多來自於',
    38 => '更多發表於',
    39 => '電郵',
    40 => '',
    41 => "企圖存取不允許的文章已被記錄。你可以以唯讀模式觀看下面文章。看完後請<a href=\"{$_CONF['site_admin_url']}/story.php\">反回文章管理員晝面</a>。",
    42 => "企圖存取不允許的文章已被記錄。請<a href=\"{$_CONF['site_admin_url']}/story.php\">反回文章管理員晝面</a>。",
    43 => '',
    44 => '',
    45 => '',
    46 => '<b>注意︰</b>如果你把日期改成將來，在那個日期前這篇文章將不會被發表。並且 意味著這篇文章不會包括在你的 RDF 標題內，在搜尋和統計頁中會被忽略。',
    47 => '圖像',
    48 => '圖像',
    49 => '右',
    50 => '左',
    51 => '請用特別格式的文字([imageX]、[imageX_right] 或 [imageX_left])來插入圖像， X 是你附加圖像的編號。注意︰你只可使用你附加的圖像否則你將無法保存你的文章。<BR><P><B>預覽</B>︰最佳預覽文章的方法是把文章保存成草稿而不是直擊預覽按鈕。只有沒有附加圖像時才用預覽按鈕。',
    52 => '',
    53 => '沒有被使用。保存前，你必須把這個圖像包含在文章簡介或文章內容中。',
    54 => '附加圖像未被使用',
    55 => '保存你的文章時發生以下錯誤。請改正這些錯誤再保存',
    56 => '顯示主題圖示',
    57 => '看沒味縮小的圖像',
    58 => '有期文章管理',
    59 => '選項',
    60 => '',
    61 => '過期後自動封存',
    62 => '過期後自動刪除',
    63 => 'Disable Comments',
    64 => '',
    65 => '',
    66 => '',
    67 => '擴大內容編輯範圍',
    68 => '縮小內容編輯範圍',
    69 => '登高日期',
    70 => '工具列選擇',
    71 => '基本工具列',
    72 => '普通工具列',
    73 => '先進工具列',
    74 => '先進II 工具列',
    75 => '全部功能',
    76 => '出版選項',
    77 => '必須啟動Javascript 來用高級的編輯器。此選項可再config.php 關掉。',
    78 => '點擊<a href="%s/story.php?mode=edit&amp;sid=%s&amp;editopt=default">這裏</a>來用預設值的編輯器',
    79 => '預覽',
    80 => '編輯器',
    81 => '出版選項',
    82 => '圖像處理',
    83 => '有期文章管理',
    84 => '許可權',
    85 => '完全顯示',
    86 => '高等編輯器',
    87 => '文章統計',
    88 => 'Wiki 式的格式',
    89 => 'Meta Description',
    90 => 'Meta Keywords',
    91 => 'You can always hit "Preview" to extend the expiry time.',
    'autotag_desc_story' => '[story: id alternate title] - Displays a link to a Story using the Story Title as the title. An alternate title may be specified but is not required.',
    'cache_time' => 'Cache Time',
    'cache_time_desc' => 'This article will be cached for no longer than this many seconds. If 0 caching is disabled. If -1 cached until article is edited again. (3600 = 1 hour,  86400 = 1 day)'
);

###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => '主題編輯器',
    2 => '主題編號',
    3 => '主題名',
    4 => '主題圖像',
    5 => '(不可有空隔)',
    6 => '刪除主題會同時刪除所有有關的文章和組件！',
    7 => '你需要提供主題編號和主題名！',
    8 => '主題管理員',
    9 => '點擊下面的主題可修改或刪除它，點擊上面的新主題可創造一個新的。在括弧裏你將發現你的存取級別。',
    10 => '排序次序',
    11 => '文章 / 頁',
    12 => '存取被拒絕',
    13 => "企圖存取不允許的主題已被記錄。請<a href=\"{$_CONF['site_admin_url']}/topic.php\">反回主題管理員晝面</a>.",
    14 => '排序方法',
    15 => '按字母排序',
    16 => '預設是',
    17 => '新主題',
    18 => '管理員首頁',
    19 => '保存',
    20 => '取消',
    21 => '刪除',
    22 => '預設',
    23 => '用此主題作為新稿的預設主體',
    24 => '(*)',
    25 => '保存檔的題目',
    26 => '用此題目作保存檔的默認題目。只准許一個題目。',
    27 => '或上載主題圖像',
    28 => '最大',
    29 => '文件上載出了問題',
    30 => 'Stories in Topic',
    31 => 'You have used a restricted Topic ID. Please choose another one.',
    32 => 'Parent Topic',
    33 => 'Inherit',
    34 => 'Items of child topic are inherited',
    35 => 'Hidden',
    36 => 'Topic will be hidden and cannot be viewed directly, only inherited',
    37 => 'Root',
    38 => 'All',
    39 => 'Homepage Only',
    40 => 'Assign one or more topics. ',
    41 => 'If "All" is selected then the item will appear for all topics. If "Homepage Only" is selected then item will appear just on the homepage. Else you must select at least one topic to assign the item to. ',
    42 => 'Inherit contains the list of assigned topics. If the topic is selected then the item will be inherited by the parent topic. You must save your item first before anything is listed in the inherit box. ',
    43 => 'Default contains the list of assigned topics. This is the default topic that will be used when displaying the item if the actual topic the user is in is not found. ',
    44 => 'Inherit',
    45 => 'Default',
    46 => 'Your parent topic cannot be the Archive topic. Please choose a different Parent Topic.',
    47 => 'An Archive Topic cannot have any child topics. Please remove any child topics before making a topic the Archive Topic.',
    48 => 'Parent Topic Id not found.',
    49 => 'This Topic ID is already being used. Please choose another one.',
    50 => 'Yes',
    51 => 'No',
    52 => 'Story',
    53 => 'Image',
    54 => 'Selected',
    55 => 'Assigned',
    'breadcrumb_separator' => '>',
    'breadcrumb_root' => 'Home',
    'autotag_desc_topic' => '[topic: id alternate title] - Displays a link to a topic using the ID as the title. An alternate title may be specified but is not required.',
    'autotag_desc_related_topics' => '[related_topics:id type:plugin max:max_items_listed] - Creates a clickable horizontal list of related topics based on the item id and type.',
    'autotag_desc_related_items' => '[related_items:id type:plugin max:max_items_listed trim:max_length include:plugin] - Create a clickable list of related items based on the item id and type.',
    'no_related_items' => 'No related items found.',
    'topics:' => 'Topics:',
    'filed_under:' => 'Filed under:'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => '用戶編輯器',
    2 => '用戶編號',
    3 => '用戶名',
    4 => '全名',
    5 => '密碼',
    6 => '安全級別',
    7 => '電郵地址',
    8 => '首頁',
    9 => '(不可有空隔)',
    10 => '你需要提供用戶名、全名、安全級別和電郵地址。',
    11 => '用戶管理員',
    12 => '點擊下面的用戶可修改或刪除它，點擊上面的新用戶可創造一個新的。在下面的表格中輸入部份的用戶名、電郵位址或全名 (e.g.*son* or *.edu) ，可做簡單的尋找。',
    13 => '安全級別',
    14 => '登記日',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '保存',
    21 => '用戶名已經存在',
    22 => '錯誤',
    23 => '大量增加',
    24 => '大量輸入用戶',
    25 => '你可一次過輸入大量的用戶到志樂。輸入檔案必須是一個用 tab 分隔的文字檔案，欄位元的順序是︰全名、用戶名、電郵地址。每一個被輸入的用戶將會收到一個以電子郵件發送的隨機密碼。檔案中每一行是一個用戶。沒遵守這些要求將造成問題，也許需要手動作業，請再三檢查你檔案！',
    26 => '',
    27 => '',
    28 => '在這裏打鉤可刪除這張圖片',
    29 => '路徑',
    30 => '輸入',
    31 => '新用戶',
    32 => '處理完成。輸入了 %d 個；%d 個失敗',
    33 => '遞交',
    34 => '錯誤︰你必須指定上載檔案。',
    35 => '最後一次登入',
    36 => '(從未)',
    37 => 'UID',
    38 => '小組目錄',
    39 => '密碼 (再次)',
    40 => '登記日期',
    41 => '最後登入日期',
    42 => '被禁止的',
    43 => '等待啟動',
    44 => '等待准許',
    45 => '有效的',
    46 => '用戶狀態',
    47 => '編輯',
    48 => '顯示管理組',
    49 => '管理組',
    50 => '打勾來准許過濾此組為管理組',
    51 => '線上日',
    52 => '<br' . XHTML . '>注: "線上日" 是從登記的第一天到最後一次登入.',
    53 => '登記過的',
    54 => '批量的刪除',
    55 => '這功能只會有效若你已在 config.php 裏設定為 <code>$_CONF[\'lastlogin\'] = true;</code>',
    56 => '請選你想要刪除的用戶種類，然後按 "更新名單". 然後, 取消那些你不想刪除的用戶，再按刪除. 請注意，你只會刪除你現在所看見的用戶。若有多頁，後頁不會刪除。',
    57 => '幻影用戶',
    58 => '短期用戶',
    59 => '老用戶',
    60 => '用戶登記超過 ',
    61 => ' 個月, 但未曾登入過.',
    62 => '用戶登記超過 ',
    63 => ' 個月, 然後在24小時內登入過, 但從此就未曾回來過.',
    64 => '正常用戶, 但已經沒有回來 ',
    65 => ' 個月.',
    66 => '更新名單',
    67 => '登記月數',
    68 => '線上時數',
    69 => '離線月數',
    70 => '無法刪除',
    71 => '刪除成功',
    72 => '為選任何要刪除的用戶',
    73 => '你肯定要將所選的用戶永久刪除嗎？',
    74 => '最近用戶',
    75 => '在最近',
    76 => ' 月內登記的用戶。',
    77 => '給所選的用戶寄送提醒電郵',
    78 => '寄送提醒電郵',
    79 => '沒有所選的用戶',
    80 => '寄送成功',
    81 => '提醒查證 %s 的帳戶',
    82 => "你的帳戶於 {$_CONF['site_name']} 自從 %s 就未曾運用，如果此帳戶在三十天內不再運用，它會變成無效。",
    83 => "你的帳戶於 {$_CONF['site_name']} 自從登記時就未曾運用。若不繼續運用，它將變成無效。",
    84 => "你的用戶名是: %s 我們的網站是: {$_CONF['site_url']}",
    85 => '若你忘記你的密碼請跟從這個連結: %s',
    86 => 'Include',
    87 => 'Reminders',
    88 => 'Default Group',
    89 => 'Check to make this a default group for new users',
    90 => 'Apply "Default Group" change to existing user accounts',
    'autotag_desc_user' => '[user: id alternate title] - Displays a link to a User using the Username as the title. An alternate title may be specified but is not required.'
);

###############################################################################
# admin/moderation.php

$LANG29 = array(
    1 => '批准',
    2 => '刪除',
    3 => '編輯',
    4 => '簡要描述',
    10 => '標題',
    11 => '開始日期',
    12 => 'URL',
    13 => '類別',
    14 => '日期',
    15 => '主題',
    16 => '用戶名',
    17 => '全名',
    18 => '電子郵件',
    34 => '命令和控制',
    35 => '已遞交的文章',
    36 => 'Parent or Comment',
    37 => 'Author',
    38 => '遞交',
    39 => '此時沒有遞交的東西',
    40 => '申請的用戶',
    41 => 'Comment Submissions',
    42 => 'Username',
    43 => 'Auto-publish Comments?',
    'core' => 'Core',
    'plugins' => 'Plugins',
    'tools' => 'Tools',
    'users' => 'Users',
    'submissions_desc' => 'To modify or delete a user submssion, click on that item\'s edit icon below. To approve and delete multiple submissions use the radio options in the lists and then click submit.'
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => "{$_CONF['site_name']} 郵件程式",
    2 => '寄件人',
    3 => '回復到',
    4 => '主題',
    5 => '內容',
    6 => '收件人︰',
    7 => '所有用戶',
    8 => '管理員',
    9 => '選項',
    10 => 'HTML',
    11 => '迫切的訊息！',
    12 => '發送',
    13 => '重設',
    14 => '忽略用戶設定',
    15 => '錯誤，當發送到︰',
    16 => '訊息已發送到︰',
    17 => "<a href={$_CONF['site_admin_url']}/mail.php>發送其他信件</a>",
    18 => '收件人',
    19 => '注意︰如果你希望發送訊息到本站所有的成員，請在小組選擇欄位中選擇 Logged-in Users group。',
    20 => "已發送 <successcount> 個訊息，有 <failcount> 個不能發送。發送的細節在下面。如不想看細節，你可<a href=\"{$_CONF['site_admin_url']}/mail.php\">發送其他訊息</a> 或 <a href=\"{$_CONF['site_admin_url']}/moderation.php\">反回管理員首頁</a>。",
    21 => '失敗',
    22 => '成功 ',
    23 => '全部成功 ',
    24 => '全部失敗',
    25 => '-- 請選小組 --',
    26 => '請填寫所有表格上的欄位元和選擇一個小組。'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => '安裝插件能損壞你的主系統。 必需要特別小心。 最好不要安裝任何你不瞭解的插件。',
    2 => '插件安裝聲明',
    3 => '插件安裝表格',
    4 => '插件檔案',
    5 => '插件清單',
    6 => '警告︰插件已經被安裝過！',
    7 => '你想安裝的插件已經存在，請先把它刪除再安裝。',
    8 => '插件不能通過相容性校驗。',
    9 => '這插件要求一個更新版本的志樂. 你可以升級你的<a href="http://www.geeklog.net">志樂</a>或是另找一個適合的版本。',
    10 => '<br' . XHTML . '><b>沒有安裝的插件。</b><br' . XHTML . '><br' . XHTML . '>',
    11 => '若想修改或刪除插件，點擊以下插件的名稱。這會顯示插件的詳細內容和製作者的網站。安裝的版本和從代碼中來的版本都會顯出來。這會讓你知道此插件是否應該更新。若要安裝或升級插件請諮詢它的說明文件。',
    12 => 'plugineditor() 找不到插件名',
    13 => '插件編輯器',
    14 => '新插件',
    15 => '管理員首頁',
    16 => '插件名字',
    17 => '插件版本',
    18 => '志樂版本',
    19 => '使有效',
    20 => '是',
    21 => '否',
    22 => '安裝',
    23 => '保存',
    24 => '取消',
    25 => '刪除',
    26 => '插件名',
    27 => '插件首頁',
    28 => '已安裝的插件版本',
    29 => '志樂版本',
    30 => '刪除插件？',
    31 => '你肯定要刪除這個插件嗎？這麽會刪除所有有關這插件的檔、資料和資料結構。如果你肯定的，請再點擊下面表格中的刪除鈕。',
    32 => '<p><b>錯誤：AutoLink 標籤不對</b></p>',
    33 => '代碼版本',
    34 => '更新',
    35 => '編輯',
    36 => '代碼',
    37 => '數據',
    38 => '更新!',
    39 => 'Upload a plugin',
    40 => 'You can upload a plugin archive (.tar.gz, .tgz, .zip) directly here:',
    41 => 'Upload',
    42 => 'Click to update',
    43 => 'Load Order',
    44 => 'Move plugin up the load order',
    45 => 'Move plugin down the load order',
    46 => 'Click to Delete this Plugin',
    47 => 'Really Delete %s Plugin?',
    48 => 'Click to Enable this Plugin',
    49 => 'Click to Disable this Plugin',
    50 => 'Dependencies',
    51 => 'OK',
    52 => 'Unresolved',
    53 => 'Disabled',
    54 => 'Unavailable',
    55 => 'Uninstalled',
    56 => 'Wrong Version',
    57 => 'Unknown',
    58 => 'The load order of one or more plugins has been altered in order to resolve dependencies',
    59 => 'Info',
    60 => 'Close',
    61 => 'Status',
    62 => 'Click to Install this Plugin',
    63 => 'This Plugin Cannot be Installed',
    64 => 'This Plugin Cannot be Enabled',
    65 => 'The plugin upload function has been disabled due to the following errors:',
    66 => 'File uploads are disabled in your PHP configuration.',
    67 => 'The directory "%s" is not writable.',
    68 => 'You do not have the required permissions to install plugins.',
    69 => 'You do not have the required permissions to upload plugins.',
    99 => 'An unknown error occured',
    100 => 'Ok.',
    101 => 'The uploaded file exceeds the upload_max_filesize directive in php.ini.',
    102 => 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form.',
    103 => 'The uploaded file was only partially uploaded.',
    104 => 'No file was uploaded.',
    105 => '(undefined error)',
    106 => 'Missing a temporary folder.',
    107 => 'Failed to write file to disk.',
    108 => 'File upload stopped by extension.'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => '建立文流',
    2 => '保存',
    3 => '刪除',
    4 => '取消',
    10 => '內容辛迪加',
    11 => '新文流',
    12 => '管理處首頁',
    13 => '若要修改或刪除一個文流, 再一下主題上點擊. 若要建立新的文流, 點擊以上的新文流.',
    14 => '標題',
    15 => '種類',
    16 => '檔案名',
    17 => '格式',
    18 => '最後一次更新',
    19 => '啟動',
    20 => '是',
    21 => '否',
    22 => '<i>(無文流)</i>',
    23 => '所有文章',
    24 => '文流編輯',
    25 => '文流標題',
    26 => '限定',
    27 => '條目長度',
    28 => '(0 = 無內文, 1 = 整文, other = 限定於此字數.)',
    29 => '說明',
    30 => '最後一次更新',
    31 => '字元集',
    32 => '語言',
    33 => '內容',
    34 => '條目',
    35 => '小時',
    36 => '選擇文流種類',
    37 => '',
    38 => '錯誤: 缺少資訊',
    39 => '請填入文流標題, 說明, 和檔案名.',
    40 => '請輸入條目數目或小時數目.',
    41 => '連結',
    42 => '',
    43 => '全部',
    44 => '無',
    45 => '題目內的標題聯結',
    46 => '限制結果',
    47 => '搜尋',
    48 => '編輯',
    49 => '新聞 Feed 的標誌',
    50 => "跟網址有關 ({$_CONF['site_url']})",
    51 => '你所選的檔案名已經在另一個文流中用著了。請選另一個。',
    52 => '錯誤: 檔案名已存在',
    53 => 'All Frontpage Stories',
    54 => 'Please select the type of feed to create.',
    55 => 'Articles'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "我們已電郵了你的密碼到你的電郵信箱，請跟隨郵件中的指示。多謝使用 {$_CONF['site_name']}",
    2 => "多謝遞交你的文章到 {$_CONF['site_name']} 。只要經過我們員工的核對，你的文章將出現在我們的綱頁上。",
    3 => '',
    4 => '',
    5 => '你的帳戶設定已被保存了。',
    6 => '你的個人設定已被保存了。',
    7 => '你的評論介面設定已被保存了。',
    8 => '你已退出。',
    9 => '你的文章已被保存了。',
    10 => '你的文章已被刪除了。',
    11 => '你的組件已被保存了。',
    12 => '你的組件已被刪除了。',
    13 => '你的主題已被保存了。',
    14 => '你的主題和所有相關的文章已被刪除了。',
    15 => 'Your comment has been submitted for review and will be published when approved by a moderator.',
    16 => 'You have been unsubscribed. You will no longer be notified of new replies.',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '用戶已被保存了。',
    22 => '用戶已被刪除了。',
    23 => '',
    24 => '',
    25 => '',
    26 => '',
    27 => '資訊已發送。',
    28 => '插件已被保存了。',
    29 => 'Sorry, you do not have access to this administration page.  Please note that all attempts to access unauthorized features are logged',
    30 => '存取被拒絕',
    31 => '',
    32 => '',
    33 => '',
    34 => '',
    35 => '',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => '系統訊息',
    41 => '',
    42 => '',
    43 => '',
    44 => '插件已被安裝了。',
    45 => '插件已被刪除了。',
    46 => '',
    47 => '',
    48 => "感謝你申請成為 {$_CONF['site_name']} 的會員。只要經過我們員工的核對，我們會把密碼寄到你所登記的電郵中。",
    49 => '你的小組已被保存了。',
    50 => '小組已被刪除了。',
    51 => '此用戶名已有人在用。請選擇另一個。',
    52 => '你給的電信位址不像是有效。',
    53 => '你的新密碼已被接受。現在以下請用你的新密碼來登入.',
    54 => '你要求新密碼的期限以過。請在下面從新要求。',
    55 => '已經給你寄了一封電信。請照此信的說明來設定新密碼。',
    56 => '你供給的電信位址已有別的用戶在使用。',
    57 => '你的用戶已經成功地刪除了。',
    58 => '你的文流已成功的保存了.',
    59 => '你的文流已成功的刪除了.',
    60 => '插件已經更新成功',
    61 => '插件 %s: 不知名的資訊占位元符',
    62 => '跡回評論已被刪除.',
    63 => '刪除跡回評論時發生錯誤.',
    64 => '你的跡回評論已成功地傳送出.',
    65 => '網志目錄服務已成功的存續.',
    66 => '網志目錄服務已被刪除.',
    67 => '你輸入的新密碼跟證實密碼不同!',
    68 => '你必要輸入正確的目前密碼.',
    69 => '你的帳戶已被禁止!',
    70 => '你的帳戶在等待管理員的批准.',
    71 => '你的帳戶已證實並且等待管理員的批准.',
    72 => '安裝插件時發生錯誤，細節請看 error.log.',
    73 => '卸載插件時發生錯誤，細節請看error.log.',
    74 => 'Ping 回已成功地送出.',
    75 => '跡回必須用 POST 要求.',
    76 => '你真的要刪除這項目嗎？',
    77 => '警告:<br' . XHTML . '>你已默認UTF-8 為語文編碼。 但是，你的伺服器不支援多位元組編碼。請安裝 mbstring 入 PHP 或選另一種語文編碼。',
    78 => '請確定你的電信位址跟你的確認電信位址是完全同樣的。',
    79 => '你想打開的網頁提交到已經在這網站不存在的功能。',
    80 => '建立此文流的插件已被關閉。你不能修改此文流除非你從新啟動有關插件。',
    81 => '你可能錯誤的輸入了你的用戶資料。請在下面再次登入。',
    82 => '你已超過准許的登入次數。 等會兒再試。',
    83 => '要改密碼，電信位址，或要記得你多久，請輸入你的目前密碼。',
    84 => '要刪除你的用戶帳號，請輸入你的目前密碼。',
    85 => '寄送電郵是出了錯誤。',
    86 => 'OpenID 伺服器不批准你的輸入。',
    87 => 'OpenID 輸入被用戶取消。',
    88 => 'OpenID 伺服器傳回錯誤。',
    89 => '無法找到一個 OpenID 伺服器承認這身份 URL.',
    90 => 'OpenID 證明取消。',
    91 => '你提供了一個無效的身份 URL.',
    92 => "請 <a href=\"{$_CONF['site_admin_url']}/sectest.php\"> 檢查你的網站的安全 </a> 然後再開始運用!",
    93 => '資料庫備份成功。',
    94 => '備份失敗: 文件小於 1kb',
    95 => '有錯誤。',
    96 => '',
    97 => '',
    98 => 'The plugin was successfully uploaded.',
    99 => 'The plugin already exists.',
    100 => 'The plugin file you uploaded was not a GZip or Zip compressed archive.',
    101 => 'There are no topics (that you have access to). You need at least one topic to be able to submit stories.',
    110 => 'Can not get URL for authentication.',
    111 => 'Authentication error.',
    112 => 'Certification has been canceled.',
    113 => 'Your account has been created successfully. {site_url}',
    114 => 'Your re-synch with your remote account has failed but your other account information has been successfully saved.',
    115 => 'Remote service has been disabled.',
    116 => 'Loading...',
    117 => 'Help page is not found.',
    118 => 'Click to select a date',
    119 => 'More..',
    120 => 'Send this?',
    400 => 'Not all required fields have been passed validation',
    401 => 'Please enter Fullname',
    500 => 'The Template Cache has been successfully cleared.'
);

###############################################################################

$LANG_ACCESS = array(
    'access' => '存取',
    'ownerroot' => '所有者/Root',
    'group' => '小組',
    'readonly' => '唯讀',
    'accessrights' => '存取權',
    'owner' => '所有者',
    'grantgrouplabel' => '給予之上小組編輯權利',
    'permmsg' => '注意︰會員是指所有註冊和登入的用戶；而匿名是指所有非註冊的流覽者或沒有登入的用戶。',
    'securitygroups' => '安全小組',
    'editrootmsg' => "即使你是用戶管理員；但你不能編輯 root 用戶。你能編輯所有的用戶除了 root 用戶。請注意所有企圖非法地編輯 root 用戶的動作已被記錄。請回到<a href=\"{$_CONF['site_admin_url']}/user.php\">用戶管理頁</a>去。",
    'securitygroupsmsg' => '選擇這位用戶屬於的小組。',
    'groupeditor' => '小組編輯器',
    'description' => '描述',
    'name' => '名字',
    'rights' => '許可權',
    'missingfields' => '缺少欄位',
    'missingfieldsmsg' => '你必須提供小組的名字和描述',
    'groupmanager' => '小組管理員',
    'newgroupmsg' => '點擊下面的小組可修改或刪除它，點擊上面的新小組可創造一個新的。請注意所核心小組不能被刪除。',
    'groupname' => '組名',
    'coregroup' => '核心小組',
    'yes' => '是',
    'no' => '否',
    'corerightsdescr' => "這個小組的許可權不能被編輯，因為這是個 {$_CONF['site_name']} 的核心小組。以下是這小組的許可權清單(唯讀的)。",
    'groupmsg' => '安全小組在這綱站是有等級制度的。當增加這個小組到另一組別，這個小組將得到那組別的許可權。請盡可能小組加下列的組別去。如果這小組需要特別的許可權，你可以在以下的"權利"區域中挑選。要把小組加到組別去，你只需要在組別旁邊的挑選盒打鉤。',
    'coregroupmsg' => "因為這是個 {$_CONF['site_name']} 的核心小組，這個小組的許可權不能被編輯。以下是這小組的組別清單(唯讀的)。",
    'rightsdescr' => '小組的許可權可以是來自於小組本身或是這小組所屬的組別。以下的許可權中如沒有檢驗盒即代表這許可權是來自於小組所屬的組別；如有檢驗盒即代表你可以直接把許可權給予這小組。',
    'lock' => '鎖住',
    'members' => '成員',
    'anonymous' => '匿名',
    'permissions' => '許可權',
    'permissionskey' => 'R = 唯讀， E = 編輯，有編輯權即有唯讀權',
    'edit' => '編輯',
    'none' => '沒有',
    'accessdenied' => '存取被拒絕',
    'storydenialmsg' => "因未被批准，你不可以觀看這個文章。這是可能是因為你並不是 {$_CONF['site_name']} 的會員。請<a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">成為會員</a>。",
    'nogroupsforcoregroup' => '這小組不屬於任何其他的小組',
    'grouphasnorights' => ' 這小組沒有管理權。',
    'newgroup' => '新小組',
    'adminhome' => '管理員首頁',
    'save' => '保存',
    'cancel' => '取消',
    'delete' => '刪除',
    'canteditroot' => '因為你不屬於 Root 小組，所以你對 Root 小組的修改被拒絕了。如有問題請與系統管理員聯繫。',
    'listusers' => '列出用戶',
    'listthem' => '列出',
    'usersingroup' => '屬於 "%s" 小組的用戶',
    'usergroupadmin' => '用戶小組管理',
    'add' => '加入',
    'remove' => '免除',
    'availmembers' => '可用的成員',
    'groupmembers' => '小組成員',
    'canteditgroup' => '若要修改此小組, 你必要時這個小組的成員. 若你認為這是錯誤, 請你聯絡系統管理員.',
    'cantlistgroup' => '要看此小組的會員，你必須是此小組的會員。你若認為這是錯誤，請聯絡系統管理員。',
    'editgroupmsg' => '若要修改小組會員，點擊會員名，然後用增加或刪除的按鈕. 如果一個會員是一個小組的會員，他們的名字只會顯現在右邊. 一旦完成，按 <b>保存</b> 來更新小組，然後回到小組管理主頁.',
    'listgroupmsg' => '列出此小組目前所有的會員: <b>%s</b>',
    'search' => '搜尋',
    'submit' => '提交',
    'limitresults' => '控制結果',
    'group_id' => '小組 ID',
    'plugin_access_denied_msg' => '你在非法的進入插件管理頁.  請注意所有的非法登入都被登記.',
    'groupexists' => '小組名稱已存在',
    'groupexistsmsg' => '目前已有用此名的小組. 小組名稱必須獨特.'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'last_ten_backups' => '最後十個備份',
    'do_backup' => '做備份',
    'backup_successful' => '資料庫備份完成。',
    'db_explanation' => '要做新的志樂備份，點擊以下的按鈕',
    'not_found' => "不正確的路徑或 mysqldump 程式不可執行。<br" . XHTML . ">檢查<strong>\$_DB_mysqldump_path</strong>定義在 config.php.<br" . XHTML . ">變數現在被定義為︰<var>{$_DB_mysqldump_path}</var>",
    'zero_size' => '備份失敗︰檔案是 0 大小',
    'path_not_found' => "{$_CONF['backup_path']} 不存在或不是目錄",
    'no_access' => "錯誤︰目錄 {$_CONF['backup_path']} ，不能存取。",
    'backup_file' => '備份檔案',
    'size' => '大小',
    'bytes' => '位元組',
    'total_number' => '總備份次數: %d',
    'download' => '點擊下載',
    'new_backup' => 'New Backup',
    'delete_failure' => 'One or more backup files could not be deleted.',
    'delete_success' => 'Backup file(s) successfully deleted.',
    'convert_menu' => 'Convert to InnoDB',
    'convert_title' => 'Convert to InnoDB tables',
    'convert_button' => 'Convert',
    'sorry_no_innodb' => 'Sorry, your version of MySQL does not support InnoDB tables.',
    'innodb_explain' => 'InnoDB tables provide better performance on <em>really</em> large databases but make the backup process more complicated. Please <a href="http://dev.mysql.com/doc/mysql/en/innodb.html">read up</a> on the pros and cons of InnoDB tables before you perform this operation.',
    'already_converted' => 'Note: It appears that all of the tables have already been converted to InnoDB.',
    'conversion_patience' => 'Note: Conversion may take some time - please be patient.',
    'innodb_success' => 'Successfully converted tables to InnoDB.',
    'table_issues' => 'There may have been problems with some tables, though. Please check error.log for details.',
    'optimize_menu' => 'Optimize Tables',
    'optimize_title' => 'Optimize Tables',
    'optimize_button' => 'Optimize',
    'optimize_explain' => 'Optimizing tables may help to improve the performance of your site. The actual impact depends on the table usage and some tables may benefit from it more than others. Do no expect to see a huge difference in performance. The <a href="http://dev.mysql.com/doc/mysql/en/optimize-table.html">MySQL manual</a> states: <q>it is not likely that you need to do this more than once a week or month</q>.',
    'last_optimization' => 'Last optimization',
    'optimization_patience' => 'Note: Optimization may take some time - please be patient.',
    'optimize_success' => 'Successfully optimized database tables.'
);

###############################################################################

$LANG_BUTTONS = array(
    1 => '首頁',
    2 => '聯絡',
    3 => '投稿',
    4 => '',
    5 => '',
    6 => '',
    7 => '本站統計資料',
    8 => '個人化',
    9 => '搜索',
    10 => '進階搜尋',
    11 => '目錄'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => '404 錯誤',
    2 => '咦，我到處都看過了但找不到<b>%s</b>.',
    3 => "<p>很抱歉，但你要求的檔不存在。請檢查<a href=\"{$_CONF['site_url']}\">主頁</a>或<a href=\"{$_CONF['site_url']}/search.php\">搜索頁</a>看看能發現什麽。",
    4 => "<p>We're sorry, but the page you have requested does not exist. We recommend going back to this <a href=\"%s\">related page</a>, or you may want to check the <a href=\"{$_CONF['site_url']}/\">home page</a>, or the <a href=\"{$_CONF['site_url']}/search.php\">search page</a> to see if you can find what you lost."
);

###############################################################################
# login form

$LANG_LOGIN = array(
    1 => '要求登入',
    2 => '抱歉，要求登入才可存取這個區域。',
    3 => '登入',
    4 => '新用戶'
);

###############################################################################
# trackback.php

$LANG_TRB = array(
    'trackback' => '跡回',
    'from' => '從',
    'tracked_on' => '跡回於',
    'read_more' => '[讀下文]',
    'intro_text' => '這是別人對 \'%s\' 的看法:',
    'no_comments' => '此登錄無跡回評論.',
    'this_trackback_url' => '此登錄的跡回 URL:',
    'num_comments' => '%d 跡回評論',
    'send_trackback' => '送出 Ping',
    'preview' => '預覽',
    'editor_title' => '送出跡回評論',
    'trackback_url' => '跡回 URL',
    'entry_url' => '登錄 URL',
    'entry_title' => '登錄標題',
    'blog_name' => '網站名',
    'excerpt' => '摘錄',
    'truncate_warning' => '注: 目的站可能將你的摘錄縮短',
    'button_send' => '送出',
    'button_preview' => '預覽',
    'send_error' => '錯誤',
    'send_error_details' => '送出跡回評論時發生錯誤:',
    'url_missing' => '無登錄 URL',
    'url_required' => '請輸入登錄的最少一個 URL.',
    'target_missing' => '無跡回 URL',
    'target_required' => '請輸入一個跡回 URL',
    'error_socket' => '無法打開 socket.',
    'error_response' => '不明白你的反應.',
    'error_unspecified' => '為指明的錯誤.',
    'select_url' => '選擇跡回 URL',
    'not_found' => '找不到跡回 URL',
    'autodetect_failed' => '志樂探測不到關於你要送出評論的跡回 URL. 以下請輸入.',
    'trackback_explain' => '從以下的聯結中，請選你要送出評論的 URL. 志樂將會決定正確的跡回 URL. 或者你若已知道的話，可 <a href="%s">在此輸入它</a>.',
    'no_links_trackback' => '找不到聯結. 你不能送出此登錄的跡回評論.',
    'pingback' => 'Ping 回',
    'pingback_results' => 'Ping 回的結果',
    'send_pings' => '送出 ping',
    'send_pings_for' => '送出ping 於 "%s"',
    'no_links_pingback' => '找不到聯結. 為此登錄無 Ping 回送出.',
    'pingback_success' => 'Ping 回已送出.',
    'no_pingback_url' => '無 ping 回 URL.',
    'resend' => '重送',
    'ping_all_explain' => '你現在可通知你所聯結的網站 (<a href="http://en.wikipedia.org/wiki/Pingback">Ping 回</a>), 廣告你的站已經被更新於ping 過網志目錄服務, 或送出一個 <a href="http://en.wikipedia.org/wiki/Trackback">跡回</a> 評論若你寫過有關一個在別人的網站上的登錄.',
    'pingback_button' => '送出Ping 回',
    'pingback_short' => '送出Ping 回到所有跟此登錄聯結的網站.',
    'pingback_disabled' => '(Ping 回已中止)',
    'ping_button' => '送出Ping',
    'ping_short' => 'Ping 網志目錄服務.',
    'ping_disabled' => '(Ping 已中止)',
    'trackback_button' => '送出跡回',
    'trackback_short' => '送出一個跡回評論.',
    'trackback_disabled' => '(跡回一中止)',
    'may_take_a_while' => '請注意，送出 Ping回 和 Ping 可需要一段時間.',
    'ping_results' => 'Ping 的結果',
    'unknown_method' => '無知 ping 法',
    'ping_success' => 'Ping 已送出.',
    'error_site_name' => '請輸入網站名.',
    'error_site_url' => '請輸入網站 URL.',
    'error_ping_url' => '請輸入正確的 Ping URL.',
    'no_services' => '未設定網志目錄服務.',
    'services_headline' => '網志目錄服務',
    'service_explain' => '若要更改或刪除網志目錄服務，請點擊一下服務的編輯標圖. 要增加一個新的網志目錄服務，請點擊以上的 "建新".',
    'service' => '服務',
    'ping_method' => 'Ping 法',
    'service_website' => '網站',
    'service_ping_url' => '要ping 的URL',
    'ping_standard' => '標準 Ping',
    'ping_extended' => '擴大的 Ping',
    'ping_unknown' => '(無知法)',
    'edit_service' => '編輯網志目錄服務',
    'trackbacks' => '跡回',
    'editor_intro' => '準備你的跡回評論於 <a href="%s">%s</a>.',
    'editor_intro_none' => '準備你的跡回評論.',
    'trackback_note' => '若要送出一個跡回評論于一個文章，去到文章目錄然後點擊那文章的"傳送 Ping". 若要送出跟任何文章都無關的跡回, <a href="%s">請點擊此處</a>.',
    'pingback_explain' => '輸入一個 URL 來送出 Ping回. Ping回將會指到你的網站主頁.',
    'pingback_url' => 'Ping回 URL',
    'site_url' => '此站的 URL',
    'pingback_note' => '若要給一個文章送出 ping回, 去到文章目錄然後點擊那文章的 "傳送 Ping". 要送出一個跟任何文章都無關的 ping回, <a href="%s">請點擊此處</a>.',
    'pbtarget_missing' => '無 Ping回 URL',
    'pbtarget_required' => '請輸入一個ping回 URL',
    'pb_error_details' => '送出 ping回時發生錯誤:',
    'delete_trackback' => '要刪除這跡回請按: '
);

###############################################################################
# directory.php

$LANG_DIR = array(
    'title' => '文章目錄',
    'title_year' => '文章目錄為 %d',
    'title_month_year' => '文章目錄為 %s %d',
    'nav_top' => '回到文章目錄',
    'no_articles' => '沒有文章.'
);

###############################################################################
# admin/sectest.php

$LANG_SECTEST = array(
    'sectest' => 'Geeklog Security Check',
    'results' => 'Results of the Security Check',
    'okay' => 'Everything seems to be in order.',
    'please_fix' => 'Please fix the above issues before using your site!',
    'please_note' => 'Please note that no site is ever 100% secure. This script can only test for obvious security issues.',
    'stay_informed' => 'To stay informed about new Geeklog releases and possible security issues, we suggest that you subscribe to the (low-traffic) %s mailing list and/or use the %s option in your Admin menu from time to time to check for available updates.',
    'public_html' => '"public_html" should never be part of your site\'s URL.  Please read the part about public_html in the %s again and change your setup accordingly before you proceed.',
    'installation' => 'installation instructions',
    'directory' => 'directory',
    'failed_tmp' => 'Failed to create a temporary file in your %s directory. Check your directory permissions!',
    'fix_it' => 'This is a security risk and should be fixed!',
    'reachable' => 'Your %s is reachable from the web.',
    'not_reachable' => 'Good! Your %s is not reachable from the web.',
    'not_sure' => 'Got an HTTP result code %s when trying to test your %s. Not sure what to make of it ...',
    'remove_inst' => 'You should really remove the install directory %s once you have your site up and running without any errors.',
    'remove_inst2' => 'Keeping it around would allow malicious users the ability to destroy your current install, take over your site, or retrieve sensitive information.',
    'inst_removed' => 'Good! You seem to have removed the install directory already.',
    'fix_password' => 'You still have not changed the <strong>default password</strong> from "password" on %s Root user account(s).',
    'password_okay' => 'Good! You seem to have changed the default account password already.'
);

###############################################################################
# "What's New" Time Strings
# 
# For the first two strings, you can use the following placeholders.
# Order them so it makes sense in your language:
# %i    item, "Stories"
# %n    amount, "2", "20" etc.
# %t    time, "2" (weeks)
# %s    scale, "hrs", "weeks"

$LANG_WHATSNEW = array(
    'new_string' => '%n 新 %i 在最後 %t %s',
    'new_last' => '最後 %t %s',
    'minutes' => '分鐘',
    'hours' => '小時',
    'days' => '日',
    'weeks' => '周',
    'months' => '月',
    'years' => 'years',
    'minute' => '分鐘',
    'hour' => '小時',
    'day' => '日',
    'week' => '周',
    'month' => '月',
    'year' => 'year'
);

###############################################################################
# Month names

$LANG_MONTH = array(
    1 => '一月',
    2 => '二月',
    3 => '三月',
    4 => '四月',
    5 => '五月',
    6 => '六月',
    7 => '七月',
    8 => '八月',
    9 => '九月',
    10 => '十月',
    11 => '十一月',
    12 => '十二月'
);

###############################################################################
# Weekdays

$LANG_WEEK = array(
    1 => '周日',
    2 => '週一',
    3 => '週二',
    4 => '週三',
    5 => '週四',
    6 => '週五',
    7 => '週六'
);

###############################################################################
# Admin - Strings
# 
# These are some standard strings used by core functions as well as plugins to
# display administration lists and edit pages

$LANG_ADMIN = array(
    'search' => '搜尋',
    'limit_results' => '限制結果',
    'submit' => '提交',
    'edit' => '編輯',
    'edit_adv' => 'Adv. 編輯',
    'admin_home' => '管理主頁',
    'create_new' => '建新',
    'create_new_adv' => '建新 (Adv.)',
    'enabled' => '啟動',
    'disabled' => 'Disabled',
    'title' => '標題',
    'page_title' => 'Page Title',
    'type' => '類型',
    'topic' => '題目',
    'info' => 'Info',
    'help_url' => '幫助文 URL',
    'save' => '存續',
    'cancel' => '取消',
    'install' => 'Install',
    'delete' => '刪除',
    'deleteitem' => 'Delete',
    'delete_sel' => '刪除所選的',
    'copy' => '複製',
    'no_results' => '- 找不到任何登錄 -',
    'data_error' => '處理訂閱資料時發現錯誤. 請檢查資料來源.',
    'preview' => '預覽',
    'records_found' => '已找到的資料',
    'addchild' => '加入子單',
    'list' => '列',
    'list_all' => '列所有',
    'meta_description' => 'Meta Description',
    'meta_keywords' => 'Meta Keywords',
    'na' => 'N/A',
    'unavailable' => 'N/A',
    'warning' => '!!!',
    'token_expiry' => 'You have until %s to make changes. After that time, the security token embedded into this page will expire and you will lose your changes.',
    'token_expired' => 'The security token for this operation has expired. Please authenticate again to continue.',
    'reauth_msg' => 'The security token for this operation has expired. If you want to continue with this operation, then please authenticate again below. This will ensure that the changes you just made will not be lost.',
    'authenticate' => 'Authenticate'
);

# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0 => '評論已啟動',
    -1 => '評論已關掉',
    1 => 'Comments Closed'
);

$LANG_commentmodes = array(
    'flat' => '平面的',
    'nested' => '嵌套的',
    'threaded' => '線狀的',
    'nocomment' => '勿評論'
);

$LANG_cookiecodes = array(
    0 => '(don\'t)',
    3600 => '1 小時',
    7200 => '2 小時',
    10800 => '3 小時',
    28800 => '8 小時',
    86400 => '1 日',
    604800 => '1 周',
    2678400 => '1 月'
);

$LANG_dateformats = array(
    0 => '系統指定的'
);

$LANG_featurecodes = array(
    0 => '不定為重要文章',
    1 => '定為重要文章'
);

$LANG_frontpagecodes = array(
    0 => '只顯在主提版',
    1 => '顯在標題版'
);

$LANG_postmodes = array(
    'plaintext' => '普通文字',
    'html' => 'HTML 格式',
    'wikitext' => 'Wiki-style format'
);

$LANG_sortcodes = array(
    'ASC' => '最老的在前',
    'DESC' => '最新的在前'
);

$LANG_trackbackcodes = array(
    0 => '跡回已啟動',
    -1 => '跡回已關掉'
);

###############################################################################
# Localization of the Admin Configuration UI

$LANG_CONFIG = array(
    'home' => '主頁',
    'admin_home' => '網站管理',
    'sections' => '設定項目',
    'restore' => '恢復',
    'add_element' => '增加元件',
    'save_changes' => '存續所更改的',
    'reset_form' => '恢復表格原狀',
    'changes_made' => '更改已成功地安置於',
    'title' => '設定管理',
    'disable' => 'Click to disable this option',
    'enable' => 'Enable',
    'default_tab_name' => 'Main',
    'search_configuration_label' => 'Search Configuration',
    'error_validation_occurs' => 'There are invalid configuration values. Please correct these fields (just click the config variable to point you to the error field)'
);

$LANG_configsections['Core'] = array(
    'label' => '志樂',
    'title' => '志樂設定'
);

$LANG_confignames['Core'] = array(
    'path_html' => 'HTML 路徑',
    'site_url' => '網站 URL',
    'site_admin_url' => '管理 URL',
    'site_mail' => '網站電郵',
    'noreply_mail' => '無可回信的電郵',
    'mail_cc_enabled' => 'Allow to Send Carbon Copies',
    'mail_cc_default' => '"Carbon Copy" on by Default',
    'site_name' => '網站名稱',
    'site_slogan' => '標語',
    'owner_name' => 'Owner Name',
    'microsummary_short' => '細微摘要',
    'path_log' => '記錄',
    'path_language' => '語言',
    'backup_path' => '備份',
    'path_data' => '數據',
    'path_images' => '圖像',
    'path_editors' => 'Advanced Editors',
    'path_pear' => 'Pear 路徑',
    'have_pear' => '有 Pear 嗎?',
    'mail_settings' => '電郵設定',
    'allow_mysqldump' => '准許 MySQL Dump',
    'mysqldump_path' => 'Executable 路徑',
    'mysqldump_options' => 'MySQL Dump 選項',
    'mysqldump_filename_mask' => 'Backup File Name Mask',
    'theme' => '畫面主題',
    'doctype' => 'DOCTYPE Declaration',
    'menu_elements' => '才當成分',
    'path_themes' => '畫面主題的路徑',
    'cache_templates' => 'Cache Templates?',
    'disable_new_user_registration' => '關閉新登記',
    'allow_user_themes' => '允許用戶版面主題',
    'allow_user_language' => '允許用戶語言',
    'allow_user_photo' => '允許用戶照片',
    'allow_username_change' => '允許用戶名更改',
    'allow_account_delete' => '允許用戶刪除',
    'hide_author_exclusion' => '允許隱藏作者',
    'show_fullname' => '顯現全名',
    'show_servicename' => '顯現服務名',
    'custom_registration' => '啟動自定登記',
    'user_login_method' => '用戶登入方式',
    'facebook_login' => 'Enable OAuth Login Method Facebook',
    'facebook_consumer_key' => 'Facebook OAuth Application ID',
    'facebook_consumer_secret' => 'Facebook OAuth Application Secret',
    'linkedin_login' => 'Enable OAuth Login Method LinkedIn',
    'linkedin_consumer_key' => 'LinkedIn OAuth API Key',
    'linkedin_consumer_secret' => 'LinkedIn OAuth Secret Key',
    'twitter_login' => 'Enable OAuth Login Method Twitter',
    'twitter_consumer_key' => 'Twitter OAuth Consumer Key',
    'twitter_consumer_secret' => 'Twitter OAuth Consumer Secret',
    'google_login' => 'Enable OAuth Login Method Google',
    'google_consumer_key' => 'Google OAuth Consumer Key',
    'google_consumer_secret' => 'Google OAuth Consumer Secret',
    'microsoft_login' => 'Enable OAuth Login Method Microsoft',
    'microsoft_consumer_key' => 'Microsoft OAuth Consumer Key',
    'microsoft_consumer_secret' => 'Microsoft OAuth Consumer Secret',
    'yahoo_login' => 'Enable OAuth Login Method Yahoo',
    'yahoo_consumer_key' => 'Yahoo OAuth Consumer Key',
    'yahoo_consumer_secret' => 'Yahoo OAuth Consumer Secret',
    'spamx' => 'Spam-X 作用',
    'sort_admin' => '排列聯結',
    'language' => '語言',
    'locale' => '地區',
    'date' => '日期格式',
    'daytime' => '日時格式',
    'shortdate' => '間斷日期格式',
    'dateonly' => '只顯日期格式',
    'timeonly' => '只顯時間格式',
    'week_start' => '周初',
    'hour_mode' => '時式',
    'thousand_separator' => '千段標點',
    'decimal_separator' => '小數點標點',
    'decimal_count' => '小數點數',
    'language_files' => '語言檔案',
    'languages' => '語言',
    'timezone' => '時區',
    'site_disabled_msg' => '網站關閉信息和 URL',
    'rootdebug' => '根本用戶調試',
    'cookie_session' => '短期 Cookie 名',
    'cookie_name' => '永久 Cookie 名',
    'cookie_password' => '密碼 Cookie 名',
    'cookie_theme' => '版面主題 Cookie 名',
    'cookie_language' => '語言 Cookie 名',
    'cookie_tzid' => '時區 Cookie 名',
    'cookie_anon_name' => 'Anon. Username Cookie Name',
    'cookie_ip' => 'Cookies 嵌入IP?',
    'default_perm_cookie_timeout' => '永恆休息',
    'session_cookie_timeout' => '短期休息',
    'cookie_path' => 'Cookie 路徑',
    'cookiedomain' => 'Cookie 功能變數名稱',
    'cookiesecure' => 'Cookie 保護',
    'lastlogin' => '記錄最後登入?',
    'num_search_results' => '搜尋結果次數',
    'loginrequired' => '需要登入嗎?',
    'submitloginrequired' => '提交需要登入嗎?',
    'commentsloginrequired' => '評論需要登入嗎?',
    'statsloginrequired' => '看統計資料需要登入嗎?',
    'searchloginrequired' => '使用搜尋需要登入嗎?',
    'profileloginrequired' => '看個人檔案需要登入嗎?',
    'emailuserloginrequired' => '寄送點郵給用戶需要登入嗎?',
    'emailstoryloginrequired' => '電郵文章需要登入嗎?',
    'directoryloginrequired' => '看目錄需要登入嗎?',
    'storysubmission' => '投稿佇列?',
    'usersubmission' => '用戶提交佇列?',
    'listdraftstories' => '排列草稿?',
    'notification' => '通知',
    'postmode' => '默認登稿方式',
    'speedlimit' => '登稿速度限制',
    'skip_preview' => '登稿時跳過預覽',
    'advanced_editor' => '進階編輯器?',
    'advanced_editor_name' => 'Advanced Editor Name?',
    'wikitext_editor' => 'Wikitext 編輯器?',
    'cron_schedule_interval' => 'Cron 時間表間隔',
    'sortmethod' => '題目分類',
    'showstorycount' => '顯示文章數目?',
    'showsubmissioncount' => '顯示提交數目?',
    'hide_home_link' => '隱藏主頁聯結?',
    'whosonline_threshold' => '運用時間極限',
    'whosonline_anonymous' => '對客人隱藏用戶名?',
    'whosonline_photo' => 'Display Thumbnail Photo?',
    'emailstories' => '啟動每日擇要?',
    'emailstorieslength' => '文章長度',
    'emailstoriesperdefault' => '啟動給新用戶?',
    'allow_domains' => '自動允許的功能變數名稱',
    'disallow_domains' => '自動禁止的功能變數名稱',
    'newstoriesinterval' => '新文章間隔',
    'newcommentsinterval' => '新評論間隔',
    'newtrackbackinterval' => '新跡回間隔',
    'hidenewstories' => '隱藏新文章',
    'hidenewcomments' => '隱藏新評論',
    'hidenewtrackbacks' => '隱藏新跡回',
    'hidenewplugins' => '隱藏新插件條目',
    'title_trim_length' => '題目長度裁減',
    'whatsnew_cache_time' => 'Max Cache Time',
    'trackback_enabled' => '啟動跡回?',
    'pingback_enabled' => '啟動Ping回?',
    'ping_enabled' => '啟動Ping?',
    'trackback_code' => '跡回預設',
    'multiple_trackbacks' => '多跡回',
    'trackbackspeedlimit' => '跡回數度',
    'check_trackback_link' => '檢查跡回',
    'pingback_self' => 'Ping回自己?',
    'pingback_excerpt' => '建設Ping回摘錄?',
    'link_documentation' => '聯結用戶指南?',
    'link_versionchecker' => '聯結版本檢查?',
    'maximagesperarticle' => '每文章的最多圖像限度',
    'limitnews' => '每頁最多文章顯示',
    'minnews' => '每頁最少文章顯示',
    'contributedbyline' => '顯示 "提交者"?',
    'hideviewscount' => '隱藏文章觀數?',
    'hideemailicon' => '隱藏電郵圖示?',
    'hideprintericon' => '隱藏列印圖示?',
    'allow_page_breaks' => '允許文章分頁?',
    'page_break_comments' => '評論顯示在多頁文章',
    'article_image_align' => '主題圖示校直',
    'show_topic_icon' => '顯示主題圖示?',
    'draft_flag' => '草稿標記預設',
    'frontpage' => '主頁預設',
    'hide_no_news_msg' => '隱藏 "沒有新聞" 資訊?',
    'hide_main_page_navigation' => '隱藏主頁底的頁數導航?',
    'onlyrootfeatures' => '只有根用戶能指定特載文章?',
    'aftersave_story' => '存續文章後',
    'related_topics' => 'Related Topics',
    'related_topics_max' => 'Max Related Topics to Display',
    'whats_related' => 'What\'s Related',
    'whats_related_max' => 'Max What\'s Related to Display',
    'whats_related_trim' => 'What\'s Related Title Length',
    'default_cache_time_article' => 'Default Article Cache Time',
    'aftersave_user' => '存續用戶後',
    'show_right_blocks' => '總是顯示右邊的元件?',
    'showfirstasfeatured' => '顯示第一個文章為特載文章?',
    'template_comments' => 'Template Comments in Output?',
    'backend' => '啟動新聞供應(RSS Feeds)?',
    'rdf_file' => '新聞供應輸出檔案夾',
    'rdf_limit' => '新聞供應速度',
    'rdf_storytext' => '新聞供應文章長度',
    'rdf_language' => '新聞供應語言',
    'syndication_max_headlines' => '題目數目限度 (門戶元件)',
    'comment_feeds_article_tag' => 'Article Tag',
    'comment_feeds_article_tag_position' => 'Article Tag Position',
    'comment_feeds_article_author_tag' => 'Article Author Tag',
    'comment_feeds_comment_author_tag' => 'Comment Author Tag',
    'copyrightyear' => '版權年',
    'image_lib' => '圖像庫',
    'path_to_mogrify' => 'Mogrify 的路徑',
    'path_to_netpbm' => 'Netpbm 的路徑',
    'debug_image_upload' => '調試圖像上載?',
    'keep_unscaled_image' => '保存未修改過的圖像?',
    'allow_user_scaling' => '准許用戶修改?',
    'jpeg_quality' => 'JPEG Quality?',
    'max_image_width' => '圖像寬度限定?',
    'max_image_height' => '圖像高度限定?',
    'max_image_size' => '圖像大小限定?',
    'max_topicicon_width' => '最大主題縮圖寬度?',
    'max_topicicon_height' => '最大主題縮圖高度?',
    'max_topicicon_size' => '最大主題縮圖體積?',
    'max_photo_width' => '最大照片寬度?',
    'max_photo_height' => '最大照片高度?',
    'max_photo_size' => '最大照片體積?',
    'use_gravatar' => '運用 Gravatar?',
    'gravatar_rating' => '許可Gravatar 級別',
    'force_photo_width' => '硬定照片寬度',
    'default_photo' => '默認照片',
    'commentspeedlimit' => '評論速度限定',
    'comment_limit' => '評論限定',
    'comment_mode' => '評論方式',
    'comment_order' => 'Comment Order',
    'comment_code' => '評論默認',
    'comment_edit' => 'Allow Comment Edit?',
    'comment_edittime' => 'Comment Edit Time (seconds)',
    'commentsubmission' => 'Queue Comment Submissions',
    'passwordspeedlimit' => '密碼速度限定',
    'login_attempts' => '最多登入企圖次數',
    'login_speedlimit' => '登入速度限定',
    'pass_alg' => 'Password Hash Algorithm',
    'pass_stretch' => 'Hash Stretch Count',
    'user_html' => '用戶 HTML',
    'admin_html' => '管理員 HTML',
    'advanced_html' => 'Additional HTML for Adv. Editor',
    'skip_html_filter_for_root' => '根用戶跳過 HTML 過濾?',
    'allowed_protocols' => '許可 Protocols',
    'disable_autolinks' => '關閉 Autotags?',
    'clickable_links' => 'Make URLs clickable?',
    'linktext_maxlen' => 'Max Link Text Length',
    'compressed_output' => 'Send compressed output?',
    'frame_options' => 'Protection against "clickjacking"',
    'page_navigation_max_pages' => 'Max Pages for Navigation',
    'default_cache_time_block' => 'Default Block Cache Time',
    'titletoid' => 'Enable Title To Id?',
    'censormode' => '檢查方式?',
    'censorreplace' => '檢查代替文字',
    'censorlist' => '檢查列',
    'ip_lookup' => 'IP 搜尋',
    'url_rewrite' => '啟動 URL Rewrite',
    'cdn_hosted' => 'Use CDN-hosted copy of jQuery',
    'meta_tags' => 'Meta Tags',
    'meta_description' => 'Default Meta Description',
    'meta_keywords' => 'Default Meta Keywords',
    'default_permissions_block' => '防礙默認許可設定',
    'default_permissions_story' => '文章默認許可設定',
    'default_permissions_topic' => '主題默認許可設定',
    'atom_max_stories' => 'Webservices Feed裏的文章數定',
    'disable_webservices' => '關閉 Webservices?',
    'restrict_webservices' => '限制 Webservices?',
    'article_comment_close_enabled' => 'Automatically close comments (default)',
    'article_comment_close_days' => 'Days to close comments (default)',
    'comment_close_rec_stories' => 'Number of most recent stories enabled for comments',
    'allow_reply_notifications' => 'Allow comment reply notifications?',
    'comment_on_same_page' => 'Comment on Same Page?',
    'show_comments_at_replying' => 'Show Comments at Replying?',
    'search_style' => 'Results List Style',
    'search_limits' => 'Page Limits',
    'search_show_num' => 'Show Result Number?',
    'search_show_type' => 'Show Result Type?',
    'search_show_sort' => 'Allow User to Sort Results?',
    'search_show_limit' => 'Show Page Limits?',
    'search_separator' => 'Group Separator',
    'search_def_keytype' => 'Default Search Method',
    'search_def_sort' => 'Default Sort Order',
    'autotag_permissions_story' => '[story: ] Permissions',
    'autotag_permissions_user' => '[user: ] Permissions',
    'autotag_permissions_topic' => '[topic: ] Permissions',
    'autotag_permissions_related_topics' => '[related_topics: ] Permissions',
    'autotag_permissions_related_items' => '[related_items: ] Permissions',
    'multiple_breadcrumbs' => 'Multiple Breadcrumbs',
    'disable_breadcrumbs_topics' => 'Disable Topic Breadcrumbs',
    'disable_breadcrumbs_articles' => 'Disable Article Breadcrumbs',
    'disable_breadcrumbs_plugins' => 'Disable Plugins Breadcrumbs',
    'breadcrumb_root_site_name' => 'Site Name as Breadcrumb Root?',
    'filemanager_disabled' => 'Disable Filemanager?',
    'filemanager_browse_only' => 'Browse only mode?',
    'filemanager_default_view_mode' => 'Default view mode',
    'filemanager_show_confirmation' => 'Show confirmation?',
    'filemanager_search_box' => 'Show search box?',
    'filemanager_file_sorting' => 'File sorting',
    'filemanager_chars_only_latin' => 'Allow only latin chars?',
    'filemanager_date_format' => 'Date time format',
    'filemanager_logger' => 'Enable logger?',
    'filemanager_show_thumbs' => 'Show thumbnails?',
    'filemanager_generate_thumbnails' => 'Generate thumbnails?',
    'filemanager_upload_restrictions' => 'Allowed file extensions',
    'filemanager_upload_overwrite' => 'Overwrite existing file?',
    'filemanager_upload_images_only' => 'Upload images only?',
    'filemanager_upload_file_size_limit' => 'Upload file size limit (MiB)',
    'filemanager_unallowed_files' => 'Unallowed files',
    'filemanager_unallowed_dirs' => 'Unallowed directories',
    'filemanager_unallowed_files_regexp' => 'Regular expression for unallowed files',
    'filemanager_unallowed_dirs_regexp' => 'Regular expression for unallowed directories',
    'filemanager_images_ext' => 'Image file extensions',
    'filemanager_show_video_player' => 'Show video player?',
    'filemanager_videos_ext' => 'Video file extensions',
    'filemanager_videos_player_width' => 'Video player width (px)',
    'filemanager_videos_player_height' => 'Video player height (px)',
    'filemanager_show_audio_player' => 'Show audio player?',
    'filemanager_audios_ext' => 'Audio file extensions'
);

$LANG_configsubgroups['Core'] = array(
    'sg_site' => '網站',
    'sg_stories' => '文章及跡回',
    'sg_theme' => '版面主題',
    'sg_blocks' => '組件',
    'sg_users' => '用戶及提交物',
    'sg_images' => '圖像',
    'sg_locale' => '語言及地區',
    'sg_misc' => '其他',
    'sg_filemanager' => 'Filemanager'
);

$LANG_fs['Core'] = array(
    'fs_site' => '網站',
    'fs_paths' => '路徑',
    'fs_theme' => '版面主題',
    'fs_mail' => '電郵',
    'fs_pear' => 'Pear',
    'fs_mysql' => 'MySQL',
    'fs_users' => '用戶',
    'fs_misc' => '其他',
    'fs_spamx' => 'Spam-X',
    'fs_admin_block' => '管理員組件',
    'fs_locale' => '地區',
    'fs_language' => '語言',
    'fs_multilanguage' => 'Multi-Language Content',
    'fs_debug' => '調試',
    'fs_cookies' => 'Cookies',
    'fs_login' => '登入設定',
    'fs_search' => '搜尋',
    'fs_user_submission' => '用戶提交',
    'fs_submission' => '提交設定',
    'fs_topics_block' => '主題元件',
    'fs_whosonline_block' => '誰線上 組件',
    'fs_daily_digest' => '每日文集',
    'fs_whatsnew_block' => '有什麼新的 組件',
    'fs_trackback' => '跡回',
    'fs_pingback' => 'Ping 回',
    'fs_story' => '文章',
    'fs_theme_advanced' => '進階設定',
    'fs_syndication' => '辛迪加',
    'fs_syndication_comment' => 'Comment Syndication',
    'fs_imagelib' => '圖像庫',
    'fs_upload' => '上載',
    'fs_articleimg' => '文章裏的圖像數定',
    'fs_topicicon' => '主題圖示',
    'fs_userphoto' => '照片',
    'fs_gravatar' => 'Gravatar',
    'fs_comments' => '評論',
    'fs_htmlfilter' => 'HTML 過濾',
    'fs_censoring' => '文字檢查',
    'fs_iplookup' => 'IP 搜尋',
    'fs_perm_story' => '文章默認許可設定',
    'fs_perm_topic' => '主題默認許可設定',
    'fs_perm_block' => '組件默認許可設定',
    'fs_webservices' => 'Webservices',
    'fs_autotag_permissions' => 'Autotag Usage Permissions',
    'fs_breadcrumbs' => 'Breadcrumbs',
    'fs_pass' => 'Password Settings',
    'fs_filemanager_general' => 'General Settings',
    'fs_filemanager_upload' => 'Upload',
    'fs_filemanager_images' => 'Images',
    'fs_filemanager_videos' => 'Videos',
    'fs_filemanager_audios' => 'Audios'
);

$LANG_tab['Core'] = array(
    'tab_site' => 'Site',
    'tab_paths' => 'Paths',
    'tab_theme' => 'Theme',
    'tab_mail' => 'Mail',
    'tab_pear' => 'Pear',
    'tab_mysql' => 'MySQL',
    'tab_users' => 'Users',
    'tab_misc' => 'Miscellaneous',
    'tab_spamx' => 'Spam-X',
    'tab_admin_block' => 'Admin Block',
    'tab_locale' => 'Locale',
    'tab_language' => 'Language',
    'tab_debug' => 'Debug',
    'tab_cookies' => 'Cookies',
    'tab_login' => 'Login Settings',
    'tab_search' => 'Search',
    'tab_user_submission' => 'User Submission',
    'tab_submission' => 'Submission Settings',
    'tab_topics_block' => 'Topics Block',
    'tab_whosonline_block' => 'Who\'s Online Block',
    'tab_daily_digest' => 'Daily Digest',
    'tab_whatsnew_block' => 'What\'s New Block',
    'tab_trackback' => 'Trackback',
    'tab_pingback' => 'Pingback',
    'tab_story' => 'Story',
    'tab_theme_advanced' => 'Advanced Settings',
    'tab_syndication' => 'Syndication',
    'tab_imagelib' => 'Image Library',
    'tab_upload' => 'Upload',
    'tab_articleimg' => 'Images in Articles',
    'tab_topicicon' => 'Topic Icons',
    'tab_userphoto' => 'Photos',
    'tab_gravatar' => 'Gravatar',
    'tab_comments' => 'Comments',
    'tab_htmlfilter' => 'HTML Filtering',
    'tab_censoring' => 'Censoring',
    'tab_iplookup' => 'IP Lookup',
    'tab_permissions' => 'Permissions',
    'tab_webservices' => 'Webservices',
    'tab_topics' => 'Topics',
    'tab_filemanager_general' => 'General Settings',
    'tab_filemanager_upload' => 'Upload',
    'tab_filemanager_images' => 'Images',
    'tab_filemanager_videos' => 'Videos',
    'tab_filemanager_audios' => 'Audios'
);

$LANG_configselects['Core'] = array(
    0 => array('True' => 1, 'False' => 0),
    1 => array('True' => true, 'False' => false),
    2 => array('Reject' => 0, 'Only Keep Latest' => 1, 'Allow Multiple Posts' => 2),
    3 => array('Trackback Enabled' => 0, 'Trackback Disabled' => -1),
    4 => array('Don\'t Check Anything' => 0, 'Check against Site URL' => 1, 'Check full URL' => 2, 'Check against Site URL and full URL' => 3, 'Check IP against Site IP' => 4, 'Check IP and Site URL' => 5, 'Check IP and Full URL' => 6, 'Check IP, Full URL, and Site URL' => 7),
    5 => array('Plain Old Text' => 'plaintext', 'HTML Formatted' => 'html', 'Wiki-style Format' => 'wikitext'),
    6 => array('12' => 12, '24' => 24),
    7 => array('Last Page' => 'last', 'First Page' => 'first', 'Every Page' => 'all'),
    8 => array('Right' => 'right', 'Left' => 'left'),
    9 => array('Forward to page' => 'item', 'Display List' => 'list', 'Display Home' => 'home', 'Display Admin' => 'admin'),
    10 => array('None' => '', 'Netpbm' => 'netpbm', 'ImageMagick' => 'imagemagick', 'gdLib' => 'gdlib'),
    11 => array('Flat' => 'flat', 'Nested' => 'nested', 'Threaded' => 'threaded', 'No Comments' => 'nocomment'),
    12 => array('No access' => 0, 'Read-Only' => 2, 'Read-Write' => 3),
    13 => array('Skip' => 0, 'Allow, with speedlimit' => 1, 'Allow, no speedlimit' => 2),
    14 => array('Sunday' => 'Sun', 'Monday' => 'Mon'),
    15 => array('By Number' => 'sortnum', 'Alphabetically' => 'alpha'),
    16 => array('No Login required' => 0, 'Advanced Search only' => 1, 'Simple + Advanced Search' => 2),
    17 => array('Comments Enabled' => 0, 'Comments Disabled' => -1),
    18 => array('Disabled' => 0, 'Enabled (Exact Match)' => 1, 'Enabled (Word Beginning)' => 2, 'Enabled (Word Fragment)' => 3),
    19 => array('Google' => 'google', 'Table' => 'table'),
    20 => array('Exact Phrase' => 'phrase', 'All of The Words' => 'all', 'Any of The Words' => 'any'),
    21 => array('HTML 4.01 Transitional' => 'html401transitional', 'HTML 4.01 Strict' => 'html401strict', 'XHTML 1.0 Transitional' => 'xhtml10transitional', 'XHTML 1.0 Strict' => 'xhtml10strict', 'HTML5' => 'html5', 'HTML5 with XHTML syntax' => 'xhtml5'),
    22 => array('Strict' => 'DENY', 'Same Origin' => 'SAMEORIGIN', '(disabled)' => ''),
    23 => array('Disabled' => 0, 'Enabled' => 1, 'Enabled (Default for Homepage only)' => 2),
    24 => array('Contribute' => 'contribute', 'Home' => 'home', 'Advanced Search' => 'search', 'Directory' => 'directory', 'Login' => 'login', 'My Account' => 'prefs', 'Plugin Entries' => 'plugins', 'Custom Entries' => 'custom', 'Site Statistics' => 'stats'),
    25 => array('New Stories' => 'story', 'New Comments' => 'comment', 'New Trackbacks' => 'trackback', 'New Pingbacks' => 'pingback', 'New Users' => 'user'),
    26 => array('G (General Audiences)' => 'G', 'PG (Parental Guidance)' => 'PG', 'R (Restricted)' => 'R', 'X (Explicit)' => 'X'),
    27 => array('Hits (asc)' => 'hits|asc', 'Hits (desc)' => 'hits|desc', 'Date (asc)' => 'date|asc', 'Date (desc)' => 'date|desc', 'Title (asc)' => 'title|asc', 'Title (desc)' => 'title|desc', 'Author (asc)' => 'uid|asc', 'Author (desc)' => 'uid|desc'),
    28 => array('No access' => 0, 'Use' => 2),
    29 => array('md5' => 0, 'sha1' => 1, 'sha256' => 2, 'sha512' => 3, 'blowfish' => 4),
    30 => array('Start' => 'start', 'End' => 'end', 'None' => 'none'),
    31 => array('Newest First' => 'DESC', 'Oldest First' => 'ASC'),
    32 => array('Disabled' => 0, 'Just Article Pages' => 1, 'Articles and Topics' => 2),
    33 => array('Disabled' => 0, 'Enabled' => 1, 'Enabled (No Links)' => 2, 'Enabled (No Outbound Links)' => 3),
    34 => array('grid' => 'grid', 'list' => 'list'),
    35 => array('default' => 'default', 'Name (asc)' => 'NAME_ASC', 'Name (desc)' => 'NAME_DESC', 'Type (asc)' => 'TYPE_ASC', 'Type (desc)' => 'TYPE_DESC', 'Modified (asc)' => 'MODIFIED_ASC', 'Modified (desc)' => 'MODIFIED_DESC')
);

###############################################################################
# Localization of validation error messages

$LANG_VALIDATION = array(
    'default' => 'This field contains an invalid value',
    'notEmpty' => 'This field cannot be empty',
    'alphaNumeric' => 'This field must be in alpha numeric',
    'between' => 'This field must be in specified range',
    'blank' => 'This field must be blank',
    'comparison' => 'This field does not match the comparison operation',
    'date' => 'This field must be in date format',
    'year' => 'This field must be in year format such as 2010',
    'yearOrRange' => 'This field must be in a year format such as 2010 or range like 2010 - 2012',
    'time' => 'This field must be in time format',
    'datetime' => 'This field must be in datetime format',
    'boolean' => 'This field must be in boolean',
    'decimal' => 'This field must be in decimal',
    'email' => 'This field must contains valid email address',
    'equalTo' => 'This field does not equal',
    'extension' => 'This field only accept allowable file extension',
    'ip' => 'This field must be in valid IP format',
    'minLength' => 'This field is too short',
    'maxLength' => 'This field is too long',
    'numeric' => 'This field must be a numeric',
    'phone' => 'This field must contains valid phone number',
    'range' => 'This field must be in specified range',
    'url' => 'This field must contains valid URL',
    'inList' => 'This field must contain specified list',
    'mail_settings_backend' => 'This field must be one of \'smtp\', \'sendmail\', or \'mail\'',
    'mail_settings_sendmail_path' => 'This field must contains valid path to sendmail binary',
    'mail_settings_host' => 'This field must contain valid hostname',
    'mail_settings_port' => 'This field must be between 0 - 65535',
    'rdf_limit' => 'This field must in numeric or hour such as 24h',
    'path' => 'Path does not exist',
    'file' => 'File does not exist',
    'search_limits' => 'This field must be numeric separated with a comma',
    'num_search_results' => 'This field must be numeric and from \'search_limits\' above',
    'theme' => 'Theme directory does not exist',
    'path_themes' => 'Theme path must be in absolute path and make sure the last character contains directory separator',
    'path_to_mogrify' => 'You must set image library to imagemagick and fill this field with complete path to the mogrify executable',
    'path_to_netpbm' => 'You must set image library to netpbm and fill this field with directory where the binaries from the Netpbm package are kept',
    'language' => 'Language file does not exist',
    'timezone' => 'Invalid timezone',
    'single_char' => 'This field must be a single character',
    'page_navigation_max_pages' => 'This field must be between 2 - 21',
    'hash' => 'This field must be a hash function supported by your version of PHP'
);


?>
