/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import main.PageConfigManager;
import main.Setting;
import main.SplashScreen;
import main.UI;
import main.Update;
import mkbrowser.MKBrowser;
import mkgethtml.Config;
import resource.text.Messages;
import utils.CheckUpdate;
import utils.CommonValue;

public class Main {
    public static UI window;
    public static PageConfigManager pageConfigManager;
    public static Setting setting;
    public static MKBrowser browser;

    public static void main(String[] args) throws Exception {
        Config.initConfig();
        Platform.setImplicitExit((boolean)false);
        File f = new File("jssecacerts");
        if (f.exists()) {
            System.setProperty("javax.net.ssl.trustStore", "jssecacerts");
        }
        System.setProperty("file.encoding", "UTF-8");
        if (args.length == 0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Timer timer = new Timer("Loading");
                        timer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                try {
                                    window = new UI();
                                    SplashScreen ss = new SplashScreen();
                                    ss.setVisible(true);
                                    pageConfigManager = new PageConfigManager();
                                    setting = new Setting();
                                    ss.setStatus(Messages.getGlobalString("lblStatus.checkingUpdate"));
                                    CheckUpdate c = window.checkUpdate(true);
                                    Update frameUpdate = null;
                                    if (!c.isAppUpdated.booleanValue() || !c.isConfigUpdated.booleanValue()) {
                                        if (!c.isAppUpdated.booleanValue()) {
                                            ss.setStatus(String.format(Messages.getGlobalString("notify.hasNewVersion"), c.jarName.replaceAll("[^\\.\\d]", "")));
                                            Thread.sleep(1000L);
                                            ss.setVisible(false);
                                            frameUpdate = new Update(String.format(Messages.getGlobalString("notify.updateSoftware"), CommonValue.APP_VERSION, c.jarName.replaceAll("[^\\.\\d]", "")), c.message, Messages.getGlobalString("btn.update"), Messages.getGlobalString("btn.skip"), c);
                                        } else if (!c.isConfigUpdated.booleanValue()) {
                                            ss.setStatus(String.format(Messages.getGlobalString("lblStatus.hasNewConfigUpdate"), c.message.substring(0, 20)));
                                            Thread.sleep(1000L);
                                            ss.setVisible(false);
                                            frameUpdate = new Update(Messages.getGlobalString("notify.updateNweConfigFile"), c.message, Messages.getGlobalString("btn.update"), Messages.getGlobalString("btn.skip"), c);
                                        }
                                        frameUpdate.frmUpdate.setVisible(true);
                                    } else {
                                        Thread.sleep(100L);
                                        String messageUpdateStatus = "";
                                        switch (c.updateStatus) {
                                            case NoNetWorking: {
                                                messageUpdateStatus = Messages.getGlobalString("lblStatus.noNetworking");
                                                break;
                                            }
                                            case GetAppUpdateInfoFailed: {
                                                messageUpdateStatus = Messages.getGlobalString("lblStatus.getUpdateInfoFailed");
                                                break;
                                            }
                                            default: {
                                                messageUpdateStatus = Messages.getGlobalString("lblStatus.allAreUpdate");
                                            }
                                        }
                                        ss.setStatus(messageUpdateStatus);
                                        Thread.sleep(250L);
                                        ss.setVisible(false);
                                        Thread.sleep(100L);
                                        Main.window.jfrmUiGetHtml.setVisible(true);
                                    }
                                }
                                catch (IOException | InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                        }, 100L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } else if (args[0].toLowerCase().equals("launcher") && args[1].toLowerCase().equals("off")) {
            window = new UI();
            pageConfigManager = new PageConfigManager();
            setting = new Setting();
            Main.window.jfrmUiGetHtml.setVisible(true);
        }
        CheckUpdate.deleteOldVersion();
    }
}

