/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.util.Locale;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import mkgethtml.Config;
import mkgethtml.Enumeration;
import resource.text.Messages;

public class PreviewHtml
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private JFXPanel jfxPanel = new JFXPanel();
    private WebEngine engine;
    private String currentTitle = "";

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PreviewHtml preview = new PreviewHtml();
                preview.setVisible(true);
            }
        });
    }

    public PreviewHtml() {
        this.init();
    }

    public void init() {
        this.createScene();
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e2) {
            e2.printStackTrace();
        }
        Locale.setDefault(new Locale(Config.get(Enumeration.EnumConfigKey.LANGUAGE).toString()));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(PreviewHtml.class.getResource("/resource/box-16.png")));
        this.setTitle(Messages.getString("PreviewHtml.this.title"));
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 600, 460);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        this.contentPane.add((Component)this.jfxPanel, "Center");
    }

    private void createScene() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebView view = new WebView();
                PreviewHtml.this.engine = view.getEngine();
                PreviewHtml.this.engine.titleProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> observable, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (PreviewHtml.this.currentTitle != newValue) {
                                    PreviewHtml.this.currentTitle = newValue;
                                    PreviewHtml.this.setTitle(String.valueOf(Messages.getString("PreviewHtml.this.title")) + ": " + PreviewHtml.this.currentTitle);
                                }
                            }
                        });
                    }
                });
                PreviewHtml.this.jfxPanel.setScene(new Scene((Parent)view));
            }
        });
    }

    public void loadHtmlContent(final String htmlContent) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                PreviewHtml.this.engine.loadContent(htmlContent);
            }
        });
    }
}

