/*
 * Decompiled with CFR 0.152.
 */
package mkgethtml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javafx.application.Platform;
import javax.swing.SwingUtilities;
import mkgethtml.Enumeration;
import mkgethtml.XMLParse;
import models.PageConfig;
import utils.CommonValue;

public class Config {
    private static HashMap<Enumeration.EnumConfigKey, Object> configData = new HashMap();
    private static ArrayList<PageConfig> listPageConfig;

    public static void add(PageConfig p) {
        listPageConfig.add(p);
        configData.put(Enumeration.EnumConfigKey.DATASITE, listPageConfig);
        Config.saveConfig();
    }

    static HashMap<Enumeration.EnumConfigKey, Object> createDefaultConfig() {
        HashMap<Enumeration.EnumConfigKey, Object> config = new HashMap<Enumeration.EnumConfigKey, Object>();
        File f = new File(CommonValue.CONFIG_DATA_PATH);
        try {
            f.createNewFile();
            config.put(Enumeration.EnumConfigKey.LANGUAGE, "vi");
            config.put(Enumeration.EnumConfigKey.MAXCONNECTION, 4);
            config.put(Enumeration.EnumConfigKey.EBOOKCREATOR, "mkbyme");
            config.put(Enumeration.EnumConfigKey.CONVERTER, "");
            config.put(Enumeration.EnumConfigKey.SOURCE, "");
            config.put(Enumeration.EnumConfigKey.AUTHOR, "");
            config.put(Enumeration.EnumConfigKey.EBOOKNAME, "");
            config.put(Enumeration.EnumConfigKey.STATUS, "");
            config.put(Enumeration.EnumConfigKey.INFO, "<br/>Created Tools:<a href =\"https://sourceforge.net/projects/gethtmlfromurl/\"> " + CommonValue.getAppName() + "</a>");
            config.put(Enumeration.EnumConfigKey.ENCODING, "UTF-8");
            ArrayList<PageConfig> listPageConfig = new ArrayList<PageConfig>();
            PageConfig p = new PageConfig();
            p.setPageCode("truyenfull.vn");
            p.setPagingPattern("trang-");
            p.setCssQueryGetListChapter("#list-chapter .row ul{start=0&end=n}");
            p.setCssQueryGetChapterTitle(".row .chapter-title");
            p.setCssQueryGetChapterContent(".row .chapter-c");
            p.setUrlPageTest("http://truyenfull.vn/dai-hoc-la-gi-inspired-by-a-true-story/");
            p.setOverMaxSizePageCountState(Enumeration.OverMaxSizePageCountState.MOVE_TO_LAST);
            listPageConfig.add(p);
            config.put(Enumeration.EnumConfigKey.DATASITE, listPageConfig);
            XMLParse.saveConfig(CommonValue.CONFIG_DATA_PATH, config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return config;
    }

    public static void delete(String pageCode) {
        if (listPageConfig.contains(new PageConfig(pageCode))) {
            listPageConfig.remove(new PageConfig(pageCode));
            configData.put(Enumeration.EnumConfigKey.DATASITE, listPageConfig);
            Config.saveConfig();
        }
    }

    public static void edit(PageConfig replace, PageConfig replacement) {
        if (listPageConfig.contains(replace)) {
            listPageConfig.set(listPageConfig.indexOf(replace), replacement);
            configData.put(Enumeration.EnumConfigKey.DATASITE, listPageConfig);
            Config.saveConfig();
        }
    }

    public static Object get(Enumeration.EnumConfigKey key) {
        return Config.getConfig().get((Object)key);
    }

    public static ArrayList<PageConfig> getAll() {
        return listPageConfig;
    }

    public static PageConfig getByPageCode(String pageCode) {
        PageConfig p = new PageConfig(pageCode);
        if (listPageConfig.contains(p)) {
            return listPageConfig.get(listPageConfig.indexOf(p));
        }
        return null;
    }

    private static HashMap<Enumeration.EnumConfigKey, Object> getConfig() {
        if (configData.isEmpty()) {
            try {
                configData = (HashMap)XMLParse.loadConfig(CommonValue.CONFIG_DATA_PATH);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            listPageConfig = (ArrayList)Config.getConfig().get((Object)Enumeration.EnumConfigKey.DATASITE);
        }
        return configData;
    }

    public static void initConfig() {
        File f = new File(CommonValue.CONFIG_DATA_PATH);
        if (!f.exists()) {
            Config.createDefaultConfig();
        }
        Config.getConfig();
        CommonValue.initValue();
    }

    public static int isSupport(String url) {
        PageConfig check = new PageConfig(url.toLowerCase());
        for (PageConfig pageConfig : listPageConfig) {
            if (!check.equals(pageConfig)) continue;
            if (pageConfig.getIsManualGet().booleanValue()) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public static void put(final Enumeration.EnumConfigKey key, final Object value) {
        if (Platform.isFxApplicationThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    configData.put(key, value);
                }
            });
        } else {
            configData.put(key, value);
        }
    }

    public static void put(final Enumeration.EnumConfigKey key, final Object value, final Boolean isSave) {
        if (Platform.isFxApplicationThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    configData.put(key, value);
                    if (isSave.booleanValue()) {
                        Config.saveConfig();
                    }
                }
            });
        } else {
            configData.put(key, value);
            if (isSave.booleanValue()) {
                Config.saveConfig();
            }
        }
    }

    public static void reConfig() {
        Config.createDefaultConfig();
        configData.clear();
        Config.getConfig();
    }

    public static void remove(Enumeration.EnumConfigKey key) {
        if (configData != null) {
            configData.remove((Object)key);
        }
    }

    public static void saveConfig() {
        File f = new File(CommonValue.CONFIG_DATA_PATH);
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
            XMLParse.saveConfig(CommonValue.CONFIG_DATA_PATH, configData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

