/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2002 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: listview_prefs.c,v 1.1.2.2 2003/04/22 12:05:42 makeinu Exp $
 */

#include "listview_prefs.h"

#include "intl.h"
#include "gimv_prefs_win.h"
#include "gimv_prefs_ui_utils.h"
#include "listview.h"
#include "gimv_plugin.h"

typedef struct ListViewConf_Tag
{
   gchar    *data_order;
   gboolean  show_title;
} ListViewConf;

ListViewConf listview_conf, *listview_conf_pre;

static GimvPluginPrefsEntry listview_prefs_entry[] = {
   {"data_order", GIMV_PLUGIN_PREFS_STRING,
    LISTVIEW_DEFAULT_DATA_ORDER, &listview_conf.data_order},
   {"show_title", GIMV_PLUGIN_PREFS_BOOL,
    "FALSE", &listview_conf.show_title},
};

GIMV_PLUGIN_PREFS_GET_VALUE(listview, "Thumbnail View List Mode",
                            GIMV_PLUGIN_THUMBVIEW_EMBEDER,
                            listview_prefs_entry)

static GtkWidget *listview_prefs_ui        (void);
static gboolean   listview_prefs_ui_apply  (GimvPrefsWinAction action);

static GimvPrefsWinPage listview_prefs_page =
{
   path:           N_("/Thumbnail Window/Thumbnail View/List View"),
   priority_hint:  20,
   icon:           NULL,
   icon_open:      NULL,
   create_page_fn: listview_prefs_ui,
   apply_fn:       listview_prefs_ui_apply,
};


gboolean
gimv_prefs_ui_listview_get_page (guint idx, GimvPrefsWinPage **page, guint *size)
{
   g_return_val_if_fail(page, FALSE);
   *page = NULL;
   g_return_val_if_fail(size, FALSE);
   *size = 0;

   if (idx == 0) {
      *page = &listview_prefs_page;
      *size = sizeof(listview_prefs_page);
      return TRUE;
   } else {
      return FALSE;
   }
}


static GtkWidget *
listview_prefs_ui (void)
{
   GtkWidget *main_vbox, *frame;
   gint i;
   GList *list = NULL;

   GIMV_PLUGIN_PREFS_GET_ALL (listview, listview_prefs_entry,
                              listview_conf_pre, listview_conf);

   main_vbox = gtk_vbox_new (FALSE, 0);
   gtk_container_set_border_width(GTK_CONTAINER(main_vbox), 5);

   for (i = 0; i < listview_get_titles_num (); i++) {
      gchar *text = listview_get_title (i);
      list = g_list_append (list, text);
   }

   frame = gimv_prefs_ui_double_clist (_("Data Order on List View (Thumbnail)"),
                                       _("Possible data"),
                                       _("Displayed data"),
                                       list,
                                       listview_conf_pre->data_order,
                                       &listview_conf.data_order,
                                       ',');
   g_list_free (list);

   gtk_box_pack_start(GTK_BOX (main_vbox), frame, FALSE, TRUE, 0);

   gtk_widget_show_all (main_vbox);

   return main_vbox;
}


static gboolean
listview_prefs_ui_apply (GimvPrefsWinAction action)
{
   GIMV_PLUGIN_PREFS_APPLY_ALL (listview_prefs_entry,
                                "Thumbnail View List Mode",
                                GIMV_PLUGIN_THUMBVIEW_EMBEDER,
                                action,
                                listview_conf_pre, listview_conf);

   switch (action) {
   case GIMV_PREFS_WIN_ACTION_OK:
   case GIMV_PREFS_WIN_ACTION_CANCEL:
      GIMV_PLUGIN_PREFS_FREE_ALL (listview_prefs_entry,
                                  listview_conf_pre, listview_conf);
      break;
   default:
      break;
   }

   return FALSE;
}
