/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: gimv_image.h,v 1.26.2.4 2003/05/14 15:30:00 makeinu Exp $
 */

#ifndef __GIMV_IMAGE_H__
#define __GIMV_IMAGE_H__

#include "gimageview.h"
#include "gimv_io.h"


typedef enum {
   NORMAL_MODE       = 0,
   DISSOLVE_MODE     = 1,
   MULTIPLY_MODE     = 3,
   SCREEN_MODE       = 4,
   OVERLAY_MODE      = 5,
   DIFFERENCE_MODE   = 6,
   ADDITION_MODE     = 7,
   SUBTRACT_MODE     = 8,
   DARKEN_ONLY_MODE  = 9,
   LIGHTEN_ONLY_MODE = 10,
   HUE_MODE          = 11,
   SATURATION_MODE   = 12,
   COLOR_MODE        = 13,
   VALUE_MODE        = 14
} GimvImageLayerMode;


typedef enum {
   GIMV_IMAGE_VECTOR_FLAGS   = 1 << 0,
   GIMV_IMAGE_ANIMATION_FLAG = 1 << 1
} GimvImageFlags;


typedef enum {
   GIMV_IMAGE_ROTATE_0,
   GIMV_IMAGE_ROTATE_90,
   GIMV_IMAGE_ROTATE_180,
   GIMV_IMAGE_ROTATE_270
} GimvImageAngle;


typedef struct GimvImage_Tag {
   gpointer       image;   /* library dependent data */
   GimvImageAngle angle;
   GimvImageFlags flags;
   gint           ref_count;
   GHashTable    *comments;
   gpointer       additional_data;
} GimvImage;


void         gimv_image_init                 (void);

GimvImage   *gimv_image_load_file            (const gchar  *filename,
                                              gboolean      animation);
GimvImage   *gimv_image_create_from_data     (guchar       *data,
                                              gint          width,
                                              gint          height,
                                              gboolean      alpha);
GimvImage   *gimv_image_create_from_drawable (GdkDrawable  *drawable,
                                              gint          x,
                                              gint          y,
                                              gint          width,
                                              gint          height);
GimvImage   *gimv_image_rotate_90            (GimvImage    *src_image,
                                              gboolean      counter_clockwise);
GimvImage   *gimv_image_rotate_180           (GimvImage    *src_image);
GimvImage   *gimv_image_rotate               (GimvImage    *src_image,
                                              GimvImageAngle abs_angle);
void         gimv_image_get_pixmap_and_mask  (GimvImage    *image,
                                              GdkPixmap   **pixmap_return,
                                              GdkBitmap   **mask_return);
void         gimv_image_free_pixmap_and_mask (GdkPixmap    *pixmap,
                                              GdkBitmap    *mask);
gboolean     gimv_image_is_scalable          (GimvImage    *image);
GimvImage   *gimv_image_scale                (GimvImage    *src_image,
                                              gint          width,
                                              gint          height);
GimvImage   *gimv_image_scale_down           (GimvImage    *image,
                                              int           dest_width,
                                              int           dest_height);
void         gimv_image_scale_get_pixmap     (GimvImage    *src_image,
                                              gint          width,
                                              gint          height,
                                              GdkPixmap   **pixmap_return,
                                              GdkBitmap   **mask_return);
void         gimv_image_get_size             (GimvImage    *image,
                                              gint         *width,
                                              gint         *height);
gint         gimv_image_width                (GimvImage    *image);
gint         gimv_image_height               (GimvImage    *image);
gint         gimv_image_depth                (GimvImage    *image);
gboolean     gimv_image_has_alpha            (GimvImage    *image);
gboolean     gimv_image_can_alpha            (GimvImage    *image);
gint         gimv_image_rowstride            (GimvImage    *image);
guchar      *gimv_image_get_pixels           (GimvImage    *image);
const gchar *gimv_image_get_comment          (GimvImage    *image,
                                              const gchar  *key);
GimvImage   *gimv_image_ref                  (GimvImage    *image);
void         gimv_image_unref                (GimvImage    *image);
void         gimv_image_finalize             (GimvImage    *image);
gboolean     gimv_image_save_file            (GimvImage    *image,
                                              const gchar  *filename,
                                              const gchar  *format,
                                              gpointer      data,
                                              gboolean      use_specific_data);
const gchar *gimv_image_detect_type_by_ext   (const gchar  *str);

/* protected */
void         gimv_image_memset               (GimvImage    *image);
GimvImage   *gimv_image_new                  (void);
void         gimv_image_add_comment          (GimvImage    *image,
                                              const gchar  *key,
                                              const gchar  *val);
void         gimv_image_free_comments        (GimvImage    *image);

/* animation */
#define      GIMV_IMAGE_IS_ANIM(image)       gimv_image_is_anim (image)
gboolean     gimv_image_is_anim              (GimvImage    *image);


/* FIXME!! */
gboolean   gimv_image_add_layer             (guchar *buffer,
                                             gint width,
                                             gint left,
                                             gint components,
                                             gint pass,
                                             GimvImageLayerMode mode,
                                             guchar *rgbbuffer);
GimvImage *gimv_image_rgba2rgb              (GimvImage *image,
                                             gint       bg_red,
                                             gint       bg_green,
                                             gint       bg_blue,
                                             gboolean   ignore_alpha);
/* END FIXME!! */

#endif /* __GIMV_IMAGE_H__ */
