/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: image_saver.c,v 1.5.2.2 2003/05/13 11:25:57 makeinu Exp $
 */

#include "gimageview.h"

#include "image_saver.h"

GHashTable *image_savers = NULL;


/*******************************************************************************
 *
 *  Public functions
 *
 ******************************************************************************/
gboolean
image_saver_plugin_regist (const gchar *plugin_name,
                           const gchar *module_name,
                           gpointer impl,
                           gint     size)
{
   ImageSaverPlugin *saver = impl;

   g_return_val_if_fail (module_name, FALSE);
   g_return_val_if_fail (saver, FALSE);
   g_return_val_if_fail (size > 0, FALSE);
   g_return_val_if_fail (saver->if_version == GIMV_IMAGE_SAVER_IF_VERSION, FALSE);
   g_return_val_if_fail (saver->format && saver->save, FALSE);

   if (!image_savers)
      image_savers = g_hash_table_new (g_str_hash, g_str_equal);

   g_hash_table_insert (image_savers, saver->format, saver);

   return TRUE;
}


gboolean
image_saver_save_image (GimvImage   *image,
                        const gchar *filename,
                        const gchar *format,
                        gpointer     data,
                        gboolean     use_specific_data)
{
   ImageSaverPlugin *saver;
   gboolean retval;

   g_return_val_if_fail (filename, FALSE);
   g_return_val_if_fail (format, FALSE);
   g_return_val_if_fail (image, FALSE);

   saver = g_hash_table_lookup (image_savers, format);
   g_return_val_if_fail (saver, FALSE);

   retval = saver->save (image, filename, format, data, use_specific_data);

   return retval;
}


ImageSaveInfo *
image_saver_save_info_new (gint n_text)
{
   ImageSaveInfo *info;

   info = g_new0 (ImageSaveInfo, 1);
   g_return_val_if_fail (info, NULL);

   if (n_text > 0) {
      info->comment   = g_new0 (ImageSaveText, n_text);
      info->n_comment = n_text;
   } else {
      info->comment   = NULL;
      info->n_comment = 0;
   }
   info->cache_info = NULL;

   return info;
}


void
image_saver_save_info_delete (ImageSaveInfo *info)
{
   g_return_if_fail (info);

   if (info->comment)
      g_free (info->comment);
   g_free (info);
}
