/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: image_saver.h,v 1.8.2.2 2003/05/13 11:25:57 makeinu Exp $
 */

#ifndef __IMAGE_SAVER_H__
#define __IMAGE_SAVER_H__

#include "gimv_image.h"
#include "thumbnail_support.h"

typedef struct ImageSaveText_Tag
{
   gchar *key;
   gchar *text;
} ImageSaveText;

typedef struct ImageSaveInfo_Tag
{
   ImageSaveText      *comment;
   gint                n_comment;
   ThumbCacheSaveInfo *cache_info;
} ImageSaveInfo;


#define GIMV_IMAGE_SAVER_IF_VERSION 1

typedef gboolean   (*ImageSaverSaveFn)       (GimvImage   *image,
                                              const gchar *filename,
                                              const gchar *format,
                                              gpointer     data,
                                              gboolean     use_format_specific_data);
typedef GtkWidget *(*ImageSaverSaveDialogFn) (GimvImage   *image,
                                              const gchar *filename,
                                              const gchar *format,
                                              gpointer     data,
                                              gboolean     use_format_specific_data);

typedef struct ImageSaverPlugin_Tag
{
   const guint32          if_version; /* plugin interface version */
   gchar                  *format;
   ImageSaverSaveFn        save;
   ImageSaverSaveDialogFn  save_with_dialog;
} ImageSaverPlugin;


gboolean       image_saver_save_image       (GimvImage   *image,
                                             const gchar *filename,
                                             const gchar *format,
                                             gpointer     data,
                                             gboolean     use_format_specific_data);
ImageSaveInfo *image_saver_save_info_new    (gint n_text);
void           image_saver_save_info_delete (ImageSaveInfo *info);

#endif /* __IMAGE_SAVER_H__ */
