/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2001-2002 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: similar_window.h,v 1.2.2.4 2003/05/21 09:13:06 makeinu Exp $
 */


#ifndef __SIMILAR_WINDOW_H__
#define __SIMILAR_WINDOW_H__

#include "gimageview.h"

#include <gtk/gtkdialog.h>

#include "duplicates_finder.h"
#include "thumbnail_view.h"

#define SIMILAR_WIN(obj)         GTK_CHECK_CAST (obj, similar_win_get_type (), SimilarWin)
#define SIMILAR_WIN_CLASS(klass) GTK_CHECK_CLASS_CAST (klass, similar_win_get_type, SimilarWinClass)
#define IS_SIMILAR_WIN(obj)      GTK_CHECK_TYPE (obj, similar_win_get_type ())

typedef struct SimilarWin_Tag      SimilarWin;
typedef struct SimilarWinClass_Tag SimilarWinClass;
typedef struct SimilarWinPriv_Tag  SimilarWinPriv;


struct SimilarWin_Tag
{
   GtkDialog         parent;

   GtkWidget        *ctree;
   GtkWidget        *radio_thumb;
   GtkWidget        *radio_icon;
   GtkWidget        *select_button;
   GtkWidget        *stop_button;
   GtkWidget        *progressbar;

   DuplicatesFinder *finder;
   ThumbView        *tv;

   SimilarWinPriv   *priv;
};


struct SimilarWinClass_Tag
{
   GtkDialogClass parent_class;
};


/* result window */
guint                similar_win_get_type       (void);
SimilarWin          *similar_win_new            (gint                 thumbnail_size);
void                 similar_win_set_relation   (SimilarWin          *sw,
                                                 ThumbView           *tv);
void                 similar_win_unset_relation (SimilarWin          *sw);
void                 similar_win_set_thumb      (SimilarWin          *sw,
                                                 Thumbnail           *thumb1,
                                                 Thumbnail           *thumb2,
                                                 gfloat               similar);

#endif /* __SIMILAR_WINDOW_H__ */
