/* -*- Mode: C; tab-width: 3; indent-tabs-mode: nil; c-basic-offset: 3 -*- */

/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: slideshow.h,v 1.9.2.2 2003/05/11 16:02:52 makeinu Exp $
 */

#ifndef __SLIDESHOW_H__
#define __SLIDESHOW_H__

#include "gimageview.h"


typedef enum {
   SlideShowWinModeFullScreen,
   SlideShowWinModeMaximize,
   SlideShowWinModeNormal
} SlideShowWinMode;


struct SlideShow_Tag
{
   ImageWindow *iw;
   GList       *filelist;
   GList       *current;
   gboolean     repeat;
};


SlideShow   *slideshow_new               (void);
SlideShow   *slideshow_new_with_filelist (GList     *filelist,
                                          GList     *start);
void         slideshow_delete            (SlideShow *slideshow);
ImageWindow *slideshow_open_window       (SlideShow *slideshow);
void         slideshow_play              (SlideShow *slideshow);
void         slideshow_stop              (SlideShow *slideshow);
void         slideshow_set_interval      (SlideShow *slideshow,
                                          guint      interval);  /* [msec] */

#endif /* __SLIDESHOW_H__ */
