#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2008 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: EPCR.pm,v 1.1.1.1 2002/04/02 20:25:44 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#

package G::Tools::WebServices;

use SubOpt;
use G::Messenger;

use strict;
use base qw(Exporter);
use SelfLoader;

our @EXPORT = qw(
		 ws
		 );


__DATA__


#:::::::::::::::::::::::::::::::::
#       Perldoc
#:::::::::::::::::::::::::::::::::


=head1 NAME

    G::Tools::WebServices - Interface to web services, including BioMOBY

=head1 DESCRIPTION

    This class is a part of G-language Genome Analysis Environment, 
    collecting interfaces to web services.

=cut



#:::::::::::::::::::::::::::::::::
#       Let the code begin...
#:::::::::::::::::::::::::::::::::


=head2 ws

 Name: ws   -   runs web services through BioMOBY

 Description:
    This is a wrapper around MOBY::Client::Service to run web services
    through BioMOBY. Use help -w <keyword> to search for web services,
    help -w <service name> to view service description. 
    
 Usage:
    ws(<service_name>, $argument1=>$ontology_or_namespace, ...);

    arguments are given as hash, where the key is the argument and the 
    value is the MOBY ontology or Namespace.

    ex: 
      ws('MOBYSHoundGetGenBankWhateverSequence', 'EX5B_ECOLI'=>'Swiss-Prot')

 Options:
    None.  

 References:
   1. Wilkinson MD, Links M (2002) "BioMOBY: an open source biological web services
      proposal.", Brief Bioinform., 3(4):331-341.
   2. Wilkinson M, Schoof H, Ernst R, Haase D (2005) "BioMOBY successfully integrates 
      distributed heterogeneous bioinformatics Web Services. The PlaNet exemplar case.",
      Plant Physiol., 138(1):5-17.

 Author: 
    Kazuharu Arakawa (gaou@sfc.keio.ac.jp)

 History:
   20080227-01 initial posting

=cut


sub ws {
    my $service = shift;

    require MOBY::Client::Central;
    require MOBY::Client::Service;
    my $m = MOBY::Client::Central->new();
    my %ns = %{$m->retrieveNamespaces()};

    my ($sv, $reg) = $m->findService(serviceName=>$service);
    die("Web Service: $service not found.") unless($sv);

    my @inputlist;
    my %hash = @_;
    
    foreach my $input (@{$$sv[0]->{input}}){
	my ($query, $name) = each %hash;
	last unless($query);

	my $article = $input->articleName();
	my $xml = ($ns{$name}) ? '<Object id="'.$query.'" namespace="'.$name.'"/>' : '<'.$name.' id="'.$query.'"/>';
	push(@inputlist, [$article, $xml]);
    }

    my $wsdl = $m->retrieveService($$sv[0]);
    my $serv = MOBY::Client::Service->new( service => $wsdl );
    my $result =  $serv->execute(XMLinputlist => [@inputlist]);

    $result =~ s/\n/=%=/g;

    if($result =~ /<moby:Simple.*?>(.*)<\/moby:Simple>/){
	my $res = $1;
	$res =~ s/=%=/\n/g;
	return $res;
    }

}





1;
