(defclass Clause ()
    ((new-id
      :allocation :class
      :initarg initNewId
      :reader getNewId
      :writer setNewId )
     (clause :initform nil :reader getClause :writer setClause)
     (origin :initform nil :reader getOrigin :writer setOrigin)
     (id :initform nil :reader getId :writer setId)
     (answer :initform nil :reader getAnswer :writer setAnswer) )
  )

(defmethod new ((thisClause Clause) cl ty i a)
  (dbg-indent :clause 0 "Clause new: ~a" cl)
  (setClause thisClause cl)
  (setOrigin thisClause ty)
  (setId thisClause i)
  (setAnswer thisClause a)
  thisClause )

(defmethod literals ((thisClause Clause))
  (length (getClause thisClause)) )

(defmethod nil? ((thisClause Clause))
  (null (getClause thisClause)) )

(defmethod reportSolution ((thisClause Clause))
  (with-slots (id clause origin answer) thisClause
    (print (list id clause origin answer)) ))

(defmethod =Clause ((thisClause Clause) (another Clause))
  (equal (getClause thisClause) (getClause another)) )

(defmethod resolve ((thisClause Clause) papa)
  (labels
      ((or? (op) (eq op '!))
       (and? (op) (eq op '&))
       (neg? (op) (eq op '~))

       (quantifier? (c) (and (not (atom c))
			     (member (car c) '(A E) :test #'equal) ))
       (cond? (op) (eq op '=>))
       (bicond? (op) (eq op '==))

       (operator (wff)
	 (if (atom wff) nil
	     (if (null (cdr wff)) nil
		 (if (null (cddr wff))
		     (if (or (neg? (car wff)) (quantifier? (car wff)))
			 (car wff) nil )
		     (if (member (cadr wff) '(! & => ==) :test #'equal)
			 (cadr wff) nil )))))

       (newvar ()
	 (let ((v (gensym "x")))
	   (setf (get v 'wff-variable) t)
	   v ))
       (newconst ()
	 (let ((v (gensym "C")))
	   (setf (get v 'wff-constant) t)
	   v ))
       (newfunc ()
	 (let ((v (gensym "f")))
	   (setf (get v 'wff-function) t)
	   v ))

       (variable? (a) (if (symbolp a) (get a 'wff-variable) nil))
       (constant? (a) (if (symbolp a) (get a 'wff-constant) nil))
       (function? (a) (if (symbolp a) (get a 'wff-function) nil))

       (variables (cl)
	 (if (null cl) nil
	     (if (variable? (car cl)) (insert (car cl) (variables (cdr cl)))
		 (if (atom (car cl)) (variables (cdr cl))
		     (merge (variables (car cl)) (variables (cdr cl))) ))))
       (constants (cl)
	 (if (null cl) nil
	     (if (constant? (car cl)) (insert (car cl) (constants (cdr cl)))
		 (if (atom (car cl)) (constants (cdr cl))
		     (merge (constants (car cl)) (constants (cdr cl))) ))))
       (functions (cl)
	 (if (atom cl) nil
	     (if (function? (car cl)) (list cl)
		 (merge (functions (car cl)) (functions (cdr cl))) )))

       (rename (cl)
	 (apply-subst
	  (mapcar (lambda (x) (cons x (newvar))) (variables cl))
	  cl ))

       (try-clash (cl1 cl2)
	 (dbg-indent :clause 0 "try-clash loop cl1: ~a" cl1)
	 (dbg-indent :clause 0 "try-clash loop cl2: ~a" cl2)
	 (let ((newcls nil))
	   (labels
	       ((loop (ccl1 f1)
		  (dbg-indent :clause 0 "try-clash loop: ~a"
			      (list ccl1 f1 newcls))
		  (if (null (car cl2)) newcls
		      (progn
			(loop2 ccl1 f1 (cdar cl2) (caar cl2) newcls)
			(if (and (consp newcls) (null (caar newcls))) newcls
			    (if (null ccl1) newcls
				(loop (cdr ccl1) (car ccl1)) )))))
		(loop2 (ccl1 f1 ccl2 f2 subst)
		  (dbg-indent :clause 0 "try-clash loop2 f1: ~a" f1)
		  (dbg-indent :clause 0 "try-clash loop2 f2: ~a" f2)
		  (dbg-indent :clause 0 "try-clash loop2 newcls: ~a" newcls)
		  (if (or (and (neg? (operator f1)) (null (operator f2))
			       (progn
				 (setq subst (unify (cadr f1) f2))
				 subst ))
			  (and (null (operator f1)) (neg? (operator f2))
			       (progn
				 (setq subst (unify f1 (cadr f2)))
				 subst )))
		      (progn
			(dbg-indent :clause 0
				    "try-clash loop2 unified subst: ~a"
				    subst)
			(setq newcls
			      (cons
			       (list
				(merge (apply-subst
					subst
					(remove f1 (car cl1) :test #'equal) )
				       (merge
					(apply-subst
					 subst
					 (remove f2 (car cl2) :test #'equal) )
					nil ))
				(merge (apply-subst
					subst
					(remove f1 (cadr cl1) :test #'equal) )
				       (merge
					(apply-subst
					 subst
					 (remove f2 (cadr cl2) :test #'equal) )
					nil )))
			       newcls ))
			(dbg-indent :clause 0
				    "try-clash loop2 merged newcls: ~a"
				    newcls)
			)
		      (progn
			(dbg-indent :clause 0
				    "try-clash loop2 not merged newcls: ~a"
				    newcls)
			newcls
			))
		  (if (and (consp newcls) (null (caar newcls))) t
		      (if (null ccl2) t
			  (loop2 ccl1 f1 (cdr ccl2) (car ccl2) newcls) )))
		)
	     (loop (cdar cl1) (caar cl1)) )))

       (merge (l1 l2) (if (null l1) l2 (merge (cdr l1) (insert (car l1) l2))))

       (insert (s l) (if (member s l :test #'equal) l (cons s l)))

       (addnew (s2 news1)
	 (dbg-indent :clause 0 "addnew s2: ~a" s2)
	 (dbg-indent :clause 0 "addnew news1: ~a" news1)
	 (if (null s2) news1
	     (if (null news1) s2
		 (if (assoc (caar s2) news1 :test #'equal)
		     (addnew (cdr s2) news1)
		     (cons (car s2) (addnew (cdr s2) news1)) ))))
       (compose-subst (s1 s2)
	 (dbg-indent :clause 0 "compose-subst s1: ~a" s1)
	 (dbg-indent :clause 0 "compose-subst s2: ~a" s2)
	 (labels ((loop (s1 s2)
		    (dbg-indent :clause 0 "compose-subst loop s1: ~a" s1)
		    (dbg-indent :clause 0 "compose-subst loop s2: ~a" s2)
		    (if (null s1) nil
			(cons (cons (caar s1)
				    (apply-subst s2 (cdar s1)) )
			      (loop (cdr s1) s2) ))))
	   (addnew s2 (loop s1 s2)) ))

       (occur-in (s1 s2)
	 (if (equal s1 s2) t
	     (if (atom s2) nil
		 (if (occur-in s1 (car s2)) t
		     (occur-in s1 (cdr s2)) ))))
       (apply-subst (subst clause)
	 (if (atom clause)
	     (cdr (or (assoc clause subst :test #'equal) (cons nil clause)))
	     (if (assoc clause subst :test #'equal)
		 (cdr (assoc clause subst :test #'equal))
		 (cons (apply-subst subst (car clause))
		       (apply-subst subst (cdr clause)) ))))

       (unify1 (f1 f2)
	 (dbg-indent :clause 0 "unify1 f1: ~a" f1)
	 (dbg-indent :clause 0 "unify1 f2: ~a" f2)
	 (labels ((loop (a1 a2)
		    (dbg-indent :clause 0 "unify1 loop: ~a" (list a1 a2))
		    (if (not (equal (car a1) (car a2)))
			(unify1 (car a1) (car a2))
			(loop (cdr a1) (cdr a2)) )))
	   (if (variable? f1) (if (occur-in f1 f2) nil (cons f1 f2))
	       (if (variable? f2) (if (occur-in f2 f1) nil (cons f2 f1))
		   (if (or (atom f1) (atom f2)) nil
		       (if (equal (car f1) (car f2))
			   (loop (cdr f1) (cdr f2))
			   nil ))))))

       (unify (negf f2)
	 (dbg-indent :clause 0 "unify negf: ~a" negf)
	 (dbg-indent :clause 0 "unify f2: ~a" f2)
	 (labels
	     ((loop (negf f2 subst spair)
		(dbg-indent :clause 0 "unify loop negf: ~a" negf)
		(dbg-indent :clause 0 "unify loop f2: ~a" f2)
		(dbg-indent :clause 0 "unify loop subst: ~a" subst)
		(let
		    ((unified
		      (if (equal negf f2)
			  (if (equal subst '((nil . nil)))
			      subst
			      (setq subst
				    (delete '(nil . nil) subst
					    :test #'equal)) )
			  (progn
			    (setq spair (list (unify1 negf f2)))
			    (dbg-indent :clause 0 "unify spair: ~a" spair)
			    (dbg-indent :clause 0 "unify apply-subst negf: ~a"
					negf)
			    (dbg-indent :clause 0
					"unify apply-subst f2: ~a" f2)
			    (if (null (car spair)) nil
				(loop (apply-subst spair negf)
				      (apply-subst spair f2)
				      (compose-subst subst spair)
				      nil ))))
		       ))
		  (dbg-indent :clause 0 "unify loop after subst: ~a" subst)
		  unified )))
	   (loop negf f2 '((nil . nil)) nil) ))

       (reverse-subst (s)
	 (mapcar (lambda (x) (cons (cdr x) (car x))) s) )

       (same-literal (s1 s2)
	 (if (and (symbol? s1) (symbol? s2))
	     (if (variable? s1)
		 (if (variable? s2) t nil)
		 (if (constant? s1)
		     (if (constant? s2) t nil)
		     (if (or (variable? s2) (constant? s2)) nil
			 (equal s1 s2) )))
	     (if (and (consp s1) (consp s2))
		 (if (and (symbol? (car s1)) (function? (car s1)))
		     (if (and (symbol? (car s1)) (function? (car s2)))
			 (same-literal (cdr s1) (cdr s2)) nil )
		     (if (same-literal (car s1) (car s2))
			 (same-literal (cdr s1) (cdr s2)) nil ))
		 (equal s1 s2) )))


       )

    (let ((clauses nil))
      (dolist (cl (try-clash
		   (rename (with-slots (clause answer) thisClause
			     (list clause answer)))
		   (with-slots (clause answer) papa (list clause answer)) ))
	(dbg-indent :clause 0 "resolve cl: ~a" cl)
	(let ((clause (make-instance 'Clause)))
	  (new clause (car cl)
	       (list 'resolved (getId thisClause) (getId papa))
	       (getNewId thisClause)
	       (cadr cl) )
	  (setNewId thisClause (+ (getNewId thisClause) 1))
	  (setq clauses (append clauses (list clause)))
	  ))
      (mapcar (lambda (x)
		(dbg-indent :clause 0 "resolve returns: ~a" (getClause x)))
	      clauses)
      clauses )))

(defmethod make-clauses ((thisClause Clause) wff type original-id)

  (dbg-indent :clause 0 "make-clause wff: ~a" wff)

  (labels
      ((or? (op) (eq op '!))
       (and? (op) (eq op '&))
       (neg? (op) (eq op '~))

       (cond? (op) (eq op '=>))

       (quantifier? (c) (and (not (atom c))
			     (member (car c) '(A E) :test #'equal) ))

       (operator (wff)
	 (if (atom wff) nil
	     (if (null (cdr wff)) nil
		 (if (null (cddr wff))
		     (if (or (neg? (car wff)) (quantifier? (car wff)))
			 (car wff) nil )
		     (if (member (cadr wff) '(! & => ==) :test #'equal)
			 (cadr wff) nil )))))

       (newvar ()
	 (let ((v (gensym "x")))
	   (setf (get v 'wff-variable) t)
	   v ))

       (clauses (wff)
	 (if (and? (operator wff))
	     (append (clauses (car wff)) (clauses (caddr wff)))
	     (if (or? (operator wff)) (list (clause-it wff))
		 (list (list wff)) )))

       (clause-it (wff)
	 (if (or? (operator wff))
	     (append (clause-it (car wff)) (clause-it (caddr wff)))
	     (list wff) ))

       (condelim (wff)
	 (let ((wff wff) (op (operator wff)))
	   (if (null op) wff
	       (if (or (quantifier? op) (neg? op))
		   (list (car wff) (condelim (cadr wff)))
		   (if (cond? op)
		       (list (list '~ (condelim (car wff)))
			     `! (condelim (caddr wff)) )
		       (if (bicond? op)
			   (list (list (condelim (car wff)) '!
				       (list '~ (condelim (caddr wff))) )
				 (list (list '~ (condelim (car wff)))
				       `! (condelim (caddr wff)) ))
			   (list (condelim (car wff))
				 (cadr wff)
				 (condelim (caddr wff)) )))))))

       (miniscope (wff)
	 (let ((wff wff) (op (operator wff)))
	   (if (null op) wff
	       (if (quantifier? op) (list (car wff) (miniscope (cadr wff)))
		   (if (neg? op) (negate (cadr wff))
		       (list (miniscope (car wff))
			     (cadr wff)
			     (miniscope (caddr wff)) ))))))

       (negate (wff)
	 (let ((wff wff) (op (operator wff)))
	   (if (and? wff) '!
	       (if (or? wff) '&
		   (if (null op) (list '~ wff)
		       (if (neg? op) (miniscope (cadr wff))
			   (if (quantifier? op)
			       (list (cons (if (eq (car op) 'A) 'E 'A)
					   (cdr op) )
				     (negate (cadr wff)) )
			       (mapcar #'negate wff) )))))))

       (standardize (wff)
	 (let ((wff wff) (op (operator wff)))
	   (if (null op) wff
	       (if (quantifier? op)
		   (subst (newvar)
			  (cadr op)
			  (list op (standardize (cadr wff))) )
		   (mapcar #'standardize wff) ))))

       (skolemize (wff type)
	 (labels ((loop (vars wff op)
		    (if (null op) wff
			(if (quantifier? op)
			    (if (eq (car op) 'A)
				(loop (append vars (list (cadr op)))
				      (cadr wff)
				      (operator (cadr wff)) )
				(if (null vars)
				    (loop vars
					  (subst (if (eq type 'conclusion)
						     (newvar)
						     (newconst) )
						 (cadr op)
						 (cadr wff) )
					  (operator (cadr wff)) )
				    (loop vars
					  (subst (if (eq type 'conclusion)
						     (newvar)
						     (cons (newfunc) vars) )
						 (cadr op)
						 (cadr wff) )
					  (operator (cadr wff)) )))
			    (mapcar (lambda (x) (loop vars x (operator x)))
				    wff )))))
	   (loop nil wff (operator wff)) ))

       (cnf (wff)
	 (if (atom wff) wff
	     (let ((wff (mapcar #'cnf wff)))
	       (if (or? (operator wff))
		   (labels ((distrib (f1 f2)
			      (if (and? (operator f1))
				  (list (distrib (car f1) f2) '&
					(distrib (caddr f1) f2) )
				  (if (and? (operator f2))
				      (list (distrib f1 (car f2)) '&
					    (distrib f1 (caddr f2)) )
				      (list f1 '! f2) ))
			      ))
		     (distrib (car wff) (caddr wff)) )
		   wff ))))

       (negate-clause (clause)
	 (labels ((loop (cl wff)
		    (if (null cl) (cdr wff)
			(loop (cdr cl)
			      (append wff (list '! (car cl))) ))))
	   (if (= (length clause) 1) (negate (car clause))
	       (cnf (negate (loop clause nil) )))))
       )

    (labels ((loop (cl-list id clauses)
	       (if (null cl-list)
		   (progn
		     (setNewId thisClause id)
		     clauses )
		   (let ((clause (make-instance 'Clause)))
		     (new clause (car cl-list) type id
			  (if (eq type 'conclusion)
			      (append (car cl-list)
				      (list (negate-clause (car cl-list))) )
			      (car cl-list) ))
		     (loop (cdr cl-list) (1+ id)
			   (append clauses (list clause)) ))
		   )))

      (loop (clauses (cnf (skolemize
			   (standardize (miniscope (condelim wff)))
			   type )))
	    original-id
	    nil )
    )))

;;; readers and writers(getters and setters)
(defmethod getNewId ((thisClause Clause))
  (slot-value thisClause 'new-id) )

(defmethod setNewId ((thisClause Clause) newId)
  (setf (slot-value thisClause 'new-id) newId) )

(defmethod getClause ((thisClause Clause))
  (slot-value thisClause 'clause) )

(defmethod setClause ((thisClause Clause) list)
  (setf (slot-value thisClause 'clause) list) )

(defmethod getOrigin ((thisClause Clause))
  (slot-value thisClause 'origin) )

(defmethod setOrigin ((thisClause Clause) list)
  (setf (slot-value thisClause 'origin) list) )

(defmethod getId ((thisClause Clause))
  (slot-value thisClause 'id) )

(defmethod setId ((thisClause Clause) id)
  (setf (slot-value thisClause 'id) id) )

(defmethod getAnswer ((thisClause Clause))
  (slot-value thisClause 'answer) )

(defmethod setAnswer ((thisClause Clause) answer)
  (setf (slot-value thisClause 'answer) answer) )

