(require "auxfns" "auxfns.lisp")
;(require 'GraphNode "GraphNode.lisp")
(require 'GraphSearch "GraphSearchA.lisp")
(require 'Clause "Clause.lisp")

(defclass ClauseNode (GraphNode)
  ((graph :initform nil :reader getGraph :writer setGraph))
  )

(defmethod graphExpand ((thisNode GraphNode))
  (dbg-indent :clause 0 "graphExpand thisNode: ~a" thisNode)
  (dbg-indent :clause 0 "graphExpand graph: ~a"
	      (getGraph thisNode))
  (dbg-indent :clause 0 "graphExpand clause: ~a"
	      (getClause (getState thisNode)))
  (dbg-indent :clause 0 "graphExpand clause in closed: ~a"
	      (mapcar (lambda (x) (getClause (getState x)))
		      (getClosed (getGraph thisNode)) ))
  (labels ((loop (clauses new-clauses nil-on)
	     (if (or nil-on (null clauses))
		 new-clauses
		 (if (=State thisNode (first clauses))
		     (loop (rest clauses) new-clauses nil-on)
		     (loop (rest clauses)
			   (append
			    new-clauses
			    (mapcar
			     (lambda (x)
			       (if (null (getClause x)) (setq nil-on t))
			       (let
				   ((successor
				     (makeSuccessor thisNode (list x 0)) ))
				 (setParent
				  successor
				  (list thisNode (first clauses)) )
				 successor ))
			     (resolve (getState thisNode)
				      (getState (first clauses)) )))
			   nil-on )))))
    (list (loop (getClosed (getGraph thisNode)) nil nil) thisNode) ))

(defmethod makeSuccessor ((thisNode GraphNode) (stateAndCost list))
  (if (null stateAndCost) nil
      (let ((new (make-instance (class-name (class-of thisNode)))))
	(setState new (first stateAndCost))
	(setGhat new (+ (getGhat thisNode) (second stateAndCost)))
	(setFhat new (+ (getGhat thisNode) (hhat thisNode)))
	(setGraph new (getGraph thisNode))
	(setSuccessors thisNode
		       (append (getSuccessors thisNode) (list new)) )
	(dbg-indent :clause 0 "makeSuccessor new: ~a" new)
	(dbg-indent :clause 0 "makeSuccessor new: ~a" (getGraph new))
	new )))

(defmethod goal-p ((thisNode GraphNode))
  (nil? (getState thisNode)) )

(defmethod hhat ((thisNode GraphNode))
  (literals (getState thisNode)) )

(defmethod reportSolution ((thisNode GraphNode))
  (reportSolution (getState thisNode))
  t )

(defmethod =State ((thisNode GraphNode) (anotherNode GraphNode))
  (=Clause (getState thisNode) (getState anotherNode)) )

(defmethod noSolution ((thisNode GraphNode))
  (print "no solution")
  nil )

;;; readers and writers(getters and setters)
(defmethod getGraph ((thisNode GraphNode))
  (slot-value thisNode 'graph) )

(defmethod setGraph ((thisNode GraphNode) graph)
  (setf (slot-value thisNode 'graph) graph) )
