(require "auxfns" "auxfns.lisp")
;(require 'GraphNode "GraphNode.lisp")
(require 'GraphSearch "GraphSearchA.lisp")
(defun requires (&optional args) (require args))
(require "gps1" "gps1.lisp")
;(require "gps" "gps.lisp")

(defclass GPS1GraphNode (GraphNode)
  ((goal
    :allocation :class
    :initform '(son-at-school)
    :reader getGoal ))
  )

(defmethod goal-p ((thisNode GraphNode))
  (let ((state (getState thisNode))
	(goals (getGoal thisNode)))
    (every #'(lambda (goal) (member goal state)) goals) ))

(defmethod hhat ((thisNode GraphNode))
  (let ((state (getState thisNode))
	(goals (getGoal thisNode)))
    (setq *state* state)
    (length (remove-if-not #'achieve goals)) ))

(defmethod =State ((thisNode GraphNode) (anotherNode GraphNode))
  (let ((state (getState thisNode))
	(anotherState (getState anotherNode)))
    (labels ((loop (list)
	       (if (null? list) t
		   (if (not (member (car list) anotherState)) nil
		       (loop (cdr list)) ))))
      (loop state) )))

;(debug ':gps)
(setf *dbg-ids* (union '(:gps) *dbg-ids*))

(defmethod graphExpand ((thisNode GraphNode))
  (dbg-indent :gps 0 "graphExpand state: ~a" (getState thisNode))
  (dbg-indent :gps 0 "graphExpand goal: ~a" (getGoal thisNode))
  (let ((nodes nil)
	(goal (first (getGoal thisNode))))
    (setq *state* (getState thisNode))
    (labels ((appropriate-p (states conds)
	       (if (null conds) t
		   (if (member (car conds) states)
		       (appropriate-p states (cdr conds)) )) )
	     (effective-p (states adds)
	       (if (null adds) nil
		   (if (not (member (car adds) states)) t
		       (effective-p states (cdr adds)) )))
	     (loop (ops)
	       (if (null ops) nil
		   (if (and (appropriate-p *state* (op-preconds (first ops)))
			    (effective-p *state* (op-add-list (first ops))) )
		       (first ops)
		       (loop (rest ops)) ))))
      (dbg-indent :gps 0 "*ops*: ~a" *ops*)
      (let ((achieved (loop *ops*)))
	(dbg-indent :gps 0 "achieved: ~a" achieved)
	(when achieved
	  (dbg-indent :gps 0 "*state*: ~a" *state*)
	  (apply-op achieved)
	  (let ((expanded
		 (makeSuccessor thisNode (list (copy-list *state*) 1)) ))
	    (when (not (null expanded))
	      (setq nodes (append nodes (list expanded))) ))))
      (list nodes thisNode)
      )))

(setq *ops* *school-ops*)

(let ((gps-node (make-instance 'GpsGraphNode)))

  (setState gps-node
	    '(son-at-home car-needs-battery have-money have-phone-book))
  (setGhat gps-node 0)
  (setFhat gps-node (hhat gps-node))

  (let ((gps-graph (make-instance 'GraphSearchA)))
    (setOpen gps-graph (list gps-node))

    (let ((solutions
	   (graph-search gps-graph 1)))
      (dolist (node solutions)
	(let ((parents nil))
	  (do ((parent (getParent node) (getParent parent)))
	      ((null parent) parents)
	    (setq parents (cons (getState parent) parents)) )
	  (print (list parents 'parents)) )
	(print (list (getState node) 'solution)) )) ))
