(defclass GraphNode ()
  ((state :initform nil :reader getState :writer setState)
   (ghat :initform 0 :reader getGhat :writer setGhat)
   (fhat :initform 0 :reader getFhat :writer setFhat)
   (parent :initform nil :reader getParent :writer setParent)
   (successors :initform nil :reader getSuccessors :writer setSuccessors))
  )

(defmethod graphExpand ((thisNode GraphNode))
  (let ((nodes nil))
    (dolist (ops (operators thisNode))
      (if (null ops)
	  nodes
	  (let ((expanded (makeSuccessor thisNode ops)))
	    (when (not (null expanded))
	      (setq nodes (append nodes (list expanded))) )) ))
    (list nodes thisNode)
    ))

(defmethod makeSuccessor ((thisNode GraphNode) (stateAndCost list))
  (if (null stateAndCost) nil
    (let ((successor (make-instance (class-name (class-of thisNode)))))
      (with-slots (state ghat fhat parent successors) thisNode
	(setState successor (first stateAndCost))
	(setGhat successor (+ ghat (second stateAndCost)))
	(setFhat successor (+ ghat (hhat thisNode)))
	(setParent successor thisNode)
	(setSuccessors thisNode
		       (append (getSuccessors thisNode) (list successor)) )
	successor ))
    ))

(defmethod betterNode-p ((thisNode GraphNode) (anotherNode GraphNode))
  (let ((thisFhat (getFhat thisNode))
	(anotherFhat (getFhat anotherNode)))
    (if (< thisFhat anotherFhat)
	t
      (if (> thisFhat anotherFhat)
	  nil
	(goal-p thisNode) ))
    ))

(defmethod onGraph-p ((thisNode GraphNode) (nodelist list))
  (dolist (check nodelist)
    (when (equal (getState thisNode) (getState check))
      check ))
  nil )

;;; method (goal-p thisNode) boolean must be defined in subclass
;;; method (operators thisNode) list must be defined in subclass
;;; method (hhat thisNode) number must be defined in subclass

;;; readers and writers(getters and setters)
(defmethod getState ((thisNode GraphNode))
  (slot-value thisNode 'state) )

(defmethod setState ((thisNode GraphNode) list)
  (setf (slot-value thisNode 'state) list) )

(defmethod getGhat ((thisNode GraphNode))
  (slot-value thisNode 'ghat) )

(defmethod setGhat ((thisNode GraphNode) (number number))
  (setf (slot-value thisNode 'ghat) number) )

(defmethod getFhat ((thisNode GraphNode))
  (slot-value thisNode 'fhat) )

(defmethod setFhat ((thisNode GraphNode) (number number))
  (setf (slot-value thisNode 'fhat) number) )

(defmethod getParent ((thisNode GraphNode))
  (slot-value thisNode 'parent) )

(defmethod setParent ((thisNode GraphNode) list)
  (setf (slot-value thisNode 'parent) list) )

(defmethod getSuccessors ((thisNode GraphNode))
  (slot-value thisNode 'successors) )

(defmethod setSuccessors ((thisNode GraphNode) list)
  (setf (slot-value thisNode 'successors) list) )

