(require 'GraphNode "GraphNode.lisp")

(defclass GraphSearch ()
  ((open :initform nil :reader getOpen :writer setOpen)
   (closed :initform nil :reader getClosed :writer setClosed)
   (solutions :initform nil :reader getSolutions :writer setSolutions))
)

(defmethod search1 ((thisGraph GraphSearch)) 
  (graph-search thisGraph 1) )

(defmethod searchAll ((thisGraph GraphSearch)) 
  (graph-search thisGraph -1) )

(defmethod searchN ((thisGraph GraphSearch) (numSolutions integer))
  (graph-search thisGraph numSolutions) )

(defmethod graph-search ((thisGraph GraphSearch) (numSolutions integer))
  (do ((expand nil nil) (node nil nil))
      ((null (getOpen thisGraph)) (getSolutions thisGraph))
    (when (reachSolution-p thisGraph numSolutions)
      (return (getSolutions thisGraph)))
    (setq node (first (getOpen thisGraph)))
    (dbg-indent :clause 0 "graph-search node: ~a"
		(getClause (getState (first (getOpen thisGraph)))))
    (setOpen thisGraph (rest (getOpen thisGraph)))
    (setq expand (graphExpand node))
    (dbg-indent :clause 0 "graph-search expand: ~a" expand)
    (when (and (= (length expand) 2) (not (null (second expand))))
      (setClosed thisGraph
		 (cons (second expand)
		       (remove (second expand) (getClosed thisGraph)
			       :test #'equal ) )) )
    (dbg-indent :clause 0 "graph-search (first expand): ~a" (first expand))
    (when (first expand)
      (mapcar (lambda (suc) (addSuccessors thisGraph suc)) (first expand)) )
    (getSolutions thisGraph) ))

(defmethod reachSolution-p ((thisGraph GraphSearch) (numSolutions integer))
  (let ((node (first (getOpen thisGraph))))
    (when (and node (goal-p node))
      (setSolutions thisGraph (append (getSolutions thisGraph) (list node))))
    (if (< numSolutions 0)
	nil
      (if (>= (length (getSolutions thisGraph)) numSolutions)
	  t
	nil )))
  )

(defmethod addSuccessors ((thisGraph GraphSearch) (node GraphNode))
  (let ((oldOnOpen (onGraph-p node (getOpen thisGraph))))
    (if oldOnOpen
	(when (betterNode-p node oldOnOpen)
	  (insertNode thisGraph node (remove oldOnOpen (getOpen thisGraph))) )
      (let ((oldOnClose (onGraph-p node (getClosed thisGraph))))
	(when (and oldOnClose (betterNode-p node oldOnClose))
	  (setClosed thisGraph
		     (cons node (remove oldOnClose (getClosed thisGraph))) ))
	(insertNode thisGraph node (getOpen thisGraph)) ))
    ))

;;; method (insertNode thisGraph node list) list must be defined in subclass
;;; deBug
(defmethod insertNode ((thisGraph GraphSearch) (node GraphNode) list)
  (cons node list) )

;;; readers and writers(getters and setters)
(defmethod getOpen ((thisGraph GraphSearch))
  (slot-value thisGraph 'open) )

(defmethod setOpen ((thisGraph GraphSearch) list)
  (setf (slot-value thisGraph 'open) list) )

(defmethod getClosed ((thisGraph GraphSearch))
  (slot-value thisGraph 'closed) )

(defmethod setClosed ((thisGraph GraphSearch) list)
  (setf (slot-value thisGraph 'closed) list) )

(defmethod getSolutions ((thisGraph GraphSearch))
  (slot-value thisGraph 'solutions) )

(defmethod setSolutions ((thisGraph GraphSearch) list)
  (setf (slot-value thisGraph 'solutions) list) )
