(require 'GraphNode "GraphNode.lisp")
(require 'GraphSearch "GraphSearchA.lisp")

(defclass ProblemGraphNode (GraphNode) ())

(defmethod processExpandedNodes ((thisNode ProblemGraphNode) (problems list))
  (if (null problems)
      nil
    (let ((node (makeSuccessor thisNode (list (first problems) 1))))
;      (if (not (solved-p (getState node)))
;	  (cons node (processExpandedNodes thisNode (rest problems)))
;	(processExpandedNodes thisNode (rest problems)) )
      (cons node (processExpandedNodes thisNode (rest problems))) )
	 ))

(defmethod graphExpand ((thisNode GraphNode))
  (let ((nodes (processExpandedNodes thisNode
				     (problemExpand (getState thisNode)) ) ))
    (list nodes thisNode) ))

(defmethod goal-p ((thisNode GraphNode))
  (solved-p (getState thisNode)) )

(defmethod hhat ((thisNode GraphNode))
  (hhat (getState thisNode)) )

(defmethod =State ((thisNode GraphNode) (anotherNode GraphNode))
  (=Pnode (getState thisNode) (getState anoterNode)) )
