(defclass ProblemNode ()
  ((problem :initform nil :reader getProblem :writer setProblem)
   (or? :initform nil :reader getOr? :writer setOr?)
   (solved? :initform nil :reader getSolved? :writer setSolved?)
   (successors :initform nil :reader getSuccessors :writer setSuccessors))
  )

(defmethod makeTerm ((thisNode ProblemNode) (problem list))
  (let ((new (make-instance (class-name (class-of thisNode)))))
    (setProblem new problem)
    (setOr? new t)
    (setSolved? new (solved-p new))
    (setSuccessors new nil)
    new ))

(defmethod =Successors ((thisNode ProblemNode) (anotherNode ProblemNode))
  (let ((successors (getSuccessors thisNode))
	(anotherSuccessors (getSuccessors anotherNode)))
    (labels ((rotate (problemNodes anotherProblemNodes)
		     (let ((rotated nil)
			   (rotatedResult nil))
		       (do ((nodes problemNodes (rest nodes)))
			   ((or (null nodes) rotatedResult) rotatedResult)
			 (if (=Pnode (first nodes) anotherProblemNode)
			     (setq rotatedResult (append nodes rotated))
			   (setq rotated (cons (first nodes) rotated)) ))))
	     (loop (successors anotherSuccessors)
		   (if (null successors)
		       (null anotherSuccessors)
		     (if (null anotherSuccessors)
			 nil
		       (let ((rotated
			      (rotate anotherSuccessors (car successors))))
			 (if rotated
			     (loop (rest successors) (rest rotated)) )))))
	     )
      (loop successors anotherSuccessors) )))

(defmethod =Pnode ((thisNode ProblemNode) (anotherNode ProblemNode))
  (and (equal (getProblem thisNode) (getProblem anotherNode))
       (eq (getOr? thisNode) (getOr? anotherNode))
       (eq (getSolved? thisNode) (getSolved? anotherNode))
       (=Successors thisNode anotherNode) ))

;;; method (problemExpand thisNode list) list must be defined in subclass
;(defmethod (problemExpand ((thisNode ProblemNode) (list state)) nil)

;;; method (solved-p thisNode list) boolean must be defined in subclass
;(defmethod (solved-p ((thisNode ProblemNode) (list state)) nil)

;;; readers and writers(getters and setters)
(defmethod getProblem ((thisNode ProblemNode))
  (slot-value thisNode 'problem) )

(defmethod setProblem ((thisNode ProblemNode) list)
  (setf (slot-value thisNode 'problem) list) )

(defmethod getOr? ((thisNode ProblemNode))
  (slot-value thisNode 'or?) )

(defmethod setOr? ((thisNode ProblemNode) list)
  (setf (slot-value thisNode 'or?) list) )

(defmethod getSolved? ((thisNode ProblemNode))
  (slot-value thisNode 'solved?) )

(defmethod setSolved? ((thisNode ProblemNode) list)
  (setf (slot-value thisNode 'solved?) list) )

(defmethod getSuccessors ((thisNode ProblemNode))
  (slot-value thisNode 'successors) )

(defmethod setSuccessors ((thisNode ProblemNode) list)
  (setf (slot-value thisNode 'successors) list) )

