(require 'ProblemNode "ProblemNode.lisp")

(defclass PtreeNode (ProblemNode) ())

;;;class variable operators must be defined in subclass

(defmethod problemExpand ((thisNode ProblemNode))
  (labels ((loop (tnodes nodelist)
		 (if (null tnodes) nodelist
		   (if (getSolved? (first tnodes))
		       (loop (rest tnodes)
			     (append nodelist (list (first tnodes))) )
		     (loop (rest tnodes)
			   (append nodelist (list (expandTerm (first tnodes))))
		      ))) ))
    (let ((nodelist (loop (getSuccessors thisNode) nil)))
      (getSuccessors
       (associateProblem (distributeProblem
			  (buildPnode thisNode (getProblem thisNode)
				      nil nodelist )))) )))

(defmethod expandTerm ((thisNode ProblemNode))
  (labels ((makeProblemTerms (problems terms)
		 (if (null problems) terms
		   (makeProblemTerms
		    (cdr problems)
		    (append terms
			    (list (makeTerm thisNode (first problems))) ))))
	   (applyOperators
	    (operators)
	    (if (null operators)
		nil
	      (let* ((problems (apply (first operators) (list thisNode)))
		     (terms (makeProblemTerms problems nil))
		     (pnode (if (null (getProblem thisNode)) nil
			      (buildPnode thisNode (getProblem thisNode)
					  nil terms ))))
		(if (null pnode) (applyOperators (rest operators))
		  (cons pnode (applyOperators (rest operators))) )))))
    (buildPnode thisNode (getProblem thisNode) t
		(applyOperators (getOperators thisNode)) )))

(defmethod buildPnode ((thisNode ProblemNode) (problem list) or?
		       (successors list) )
  (let ((pnode (make-instance (class-name (class-of thisNode)))))
    (setProblem pnode problem)
    (setOr? pnode or?)
    (setSolved? pnode nil)
    (setSuccessors pnode successors)
    (upwardPropagation pnode)
    )
  )

(defmethod upwardPropagation ((thisNode ProblemNode))
  (labels ((loop (successors bsolved?)
		 (if (null successors)
		     (setSolved? thisNode bsolved?)
		   (if (eq (getSolved? (first successors)) (getOr? thisNode))
		       (setSolved? thisNode (getOr? thisNode))
		     (if (null (getSolved? (first successors)))
			 (loop (rest successors) nil)
		       (loop (rest successors) bsolved?) )))
		 ))
    (loop (getSuccessors thisNode) (not (getOr? thisNode)))
    thisNode ))

(defmethod distributeProblem ((thisNode ProblemNode))
  (if (null (getSuccessors thisNode)) thisNode
    (labels
	((min-stat (s1 s2)
		   (if s1 s2
		     (if (or (null s1) (null s2)) nil
		       nil )))
	 (first-or (suc)
		   (if (null suc) nil
		     (if (or (null (getSuccessors (first suc)))
			     (not (getOr? (first suc))) )
			 (first-or (rest suc))
		       (first suc) )))

	 (distribute
	  (anode)
	  (if (not (getOr? anode))
	      (distribute0 anode (first-or (getSuccessors anode)) )
	    anode ))

	 (distribute0
	  (anode onode)
	  (if (null onode) anode
	    (let* ((sucs (remove onode (getSuccessors anode)))
		   (new (make-instance (class-name (class-of anode)))) )
	      (setProblem new (getProblem anode))
	      (setOr? new (getOr? anode))
	      (setSolved? new (getSolved? anode))
	      (setSuccessors new sucs)
	      (setq new (distribute1 onode new))
	      (setSolved? new
			  (min-stat (getSolved? anode) (getSolved? onode)))
	      new )))

	 (distribute1
	  (onode anode)
	  (let* ((sucs (mapcar (lambda (node) (distribute node))
			       (distribute2 anode (getSuccessors onode)) ))
		 (new (make-instance (class-name (class-of onode))) ))
	    (setProblem new (getProblem onode))
	    (setOr? new (getOr? onode))
	    (setSolved? new (getSolved? onode))
	    (setSuccessors new sucs)
	    new ))

	 (distribute2
	  (anode suc)
	  (if (null suc) nil
	    (let* ((solv (min-stat (getSolved? (first suc))
				   (getSolved? anode) ))
		   (sucs (cons (first suc) (getSuccessors anode)))
		   (new (make-instance (class-name (class-of anode))))
		   (d2 (distribute2 anode (rest suc))) )
	      (setProblem new (getProblem anode))
	      (setOr? new (getOr? anode))
	      (setSolved? new solv)
	      (setSuccessors new sucs)
	      (cons new d2) )))
	 (loop (suc ret)
	       (if (null suc) ret
		 (loop
		  (rest suc)
		  (append ret (list (distributeProblem (first suc)))) ))) )
      (setSuccessors thisNode (loop (getSuccessors thisNode) nil))
      (let ((new (distribute thisNode)))
	(setProblem new nil)
	new ))))
    
(defmethod associateProblem ((thisNode ProblemNode))
  (labels
      ((loop
	(suc ret)
	(if (null suc) ret
	  (loop (rest suc)
		(append ret (list (associateProblem (first suc)))) )))
       (insertProblemNode
	(thisNode nodelist)
	(labels
	    ((loop
	      (nodelist resultNodes)
	      (if (null nodelist)
		  (append resultNodes (list thisNode))
		(if (=Pnode thisNode (first nodelist))
		    (append resultNodes nodelist)
		  (loop (rest nodelist)
			(append resultNodes (list (first nodelist))) ))) ))
	  (loop nodelist nil) ))
       (unionProblemNode
	(nodes1 nodes2)
	(do ((nodes nodes1 (rest nodes)))
	    ((null nodes) nodes2)
	  (setq nodes2 (insertProblemNode (first nodes) nodes2)) )) )

    (let ((associatedSuccessors (loop (getSuccessors thisNode) nil))
	  (nodelist nil) )
      (setSuccessors
       thisNode 
       (do ((successors associatedSuccessors (rest successors)))
	   ((null successors) nodelist)
	 (if (null (getSuccessors (first successors)))
	     (setq nodelist (insertProblemNode (first successors) nodelist))
	   (if (eq (getOr? (first successors)) (getOr? thisNode))
	       (setq nodelist
		     (unionProblemNode
		      (getSuccessors (first successors)) nodelist ))
	     (setq nodelist
		   (insertProblemNode (first successors) nodelist) ) )))))
    )
  thisNode )
