;(require 'GraphSearch "GraphSearch.lisp")
(require 'GraphSearch "GraphSearchA.lisp")

(defclass HanoiGraphNode (GraphNode)
  ((goal :allocation :class :initform '(() () (1 2 3)) :reader getGoal))
  )

(defmethod goal-p ((thisNode HanoiGraphNode))
  (equal (getState thisNode) (getGoal thisNode)) )

(defmethod hhat ((thisNode HanoiGraphNode))
  (hanoi-evaluate (getState thisNode) (getGoal thisNode)) )

(defmethod reportSolution ((thisNode HanoiGraphNode))
  (when (getParent thisNode) (reportSolution (getParent thisNode)))
  (print (getState thisNode)) )

(defmethod =State ((thisNode HanoiGraphNode) (anotherNode HanoiGraphNode))
  (equal (getState thisNode) (getState anotherNode)) )

(defun hanoi-evaluate (hanoi goal)
  (labels ((level (scr) (if (zerop scr) 1 (* 2 (level (1- scr))))))
    (let* ((from (first hanoi))
	   (to (third hanoi))
	   (sub (second hanoi))
	   (len (length (third goal)))
	   (modulo (mod len 2))
	   (val (level len)) )
      (labels ((loop (tol tog div)
		     (if (null tol) val
		       (if (= (first tol) (first tog))
			   (progn
			     (if (null div)
				 (setq val (/ val 2))
			       (setq val (* val 2)) )
			     (loop (rest tol) (rest tog)
				   (if (null div) div (/ div 2)) ))
			 (loop tol (rest tog)
			       (if (null div) (/ val 2) nil) )))))
	(print (list hanoi goal 'len len 'modulo modulo 'val val))
	(print (list 'loop (loop (reverse to) (reverse (third goal)) nil)))
	(setq val (loop (reverse to) (reverse (third goal)) nil))
	(print (list 'val 'after 'loop val))
	(print (list 'sub sub
		     (when sub
		       (append
			(list 'mod (mod (first (last sub)) 2)
			      'modulo modulo
			      'judge
			      (= (mod (first (last sub)) 2) modulo) )) )))
	(if (and sub (= (mod (first (last sub)) 2) modulo))
	    (progn
	      (print (list '+ 'val (level (length sub))))
	      (setq val (+ val (level (length sub)))) ))
	(print (list 'level (level (length sub)) 'val val))
	(print (list 'from from
		     (when from
		       (append
			(list 'mod (mod (first (last from)) 2)
			      'modulo modulo
;			      'judge
;			      i
			      (not (= (mod (first (last from)) 2) modulo)) ))
		       )))
	(if (and from (not (= (mod (first (last from)) 2) modulo)))
	    (progn
	      (print (list '+ 'val (level (length sub))))
	      (setq val (+ val (level (length sub)))) ))
	(print (list 'level (level (length sub)) 'val val))
	val ))))

(defmethod graphExpand ((thisNode GraphNode))
  (labels
;;; move one circle from left(first) to right(third)
      ((fopLeftRight
	(old)
	(let* ((from (first old))
	       (sub (second old))
	       (to (third old)))
	  (when (and from (or (null to) (< (first from) (first to))))
	    (list (list (rest from) sub (cons (first from) to)) 1) )))

;;; move one circle from left(first) to center(second)
       (fopLeftCenter
	(old)
	(let* ((from (first old))
	       (sub (second old))
	       (to (third old)))
	  (when (and from (or (null sub) (< (first from) (first sub))))
	    (list (list (rest from) (cons (first from) sub) to) 1) )))

;;; move one circle from right(third) to left(first)
       (fopRightLeft
	(old)
	(let* ((from (first old))
	       (sub (second old))
	       (to (third old)))
	  (when (and to (or (null from) (< (first to) (first from))))
	    (list (list (cons (first to) from) sub (rest to)) 1) )))

;;; move one circle from right(third) to center(second)
       (fopRightCenter
	(old)
	(let* ((from (first old))
	       (sub (second old))
	       (to (third old)))
	  (when (and to (or (null sub) (< (first to) (first sub))))
	    (list (list from (cons (first to) sub) (rest to)) 1) )))

;;; move one circle from center(second) to left(first)
       (fopCenterLeft
	(old)
	(let* ((from (first old))
	       (sub (second old))
	       (to (third old)))
	  (when (and sub (or (null from) (< (first sub) (first from))))
	    (list (list (cons (first sub) from) (rest sub) to) 1) )))

;;; move one circle from center(second) to right(third)
       (fopCenterRight
	(old)
	(let* ((from (first old))
	       (sub (second old))
	       (to (third old)))
	  (when (and sub (or (null to) (< (first sub) (first to))))
	    (list (list from (rest sub) (cons (first sub) to)) 1) )))

       (operators (thisNode)
		  (let ((old (getState thisNode)))
		    (list (fopLeftRight old) (fopLeftCenter old)
			  (fopRightLeft old) (fopRightCenter old)
			  (fopCenterLeft old) (fopCenterRight old)) )))
    (let ((nodes nil))
      (dolist (ops (operators thisNode))
	(if (null ops)
	    nodes
	  (let ((expanded (makeSuccessor thisNode ops)))
	    (when (not (null expanded))
	      (setq nodes (append nodes (list expanded))) )) ))
    ;;; deBug
      (print
       (list (getState thisNode) 'hat (getGhat thisNode) (getFhat thisNode)) )
      (print
       (list
	(mapcar
	 (lambda (node)
	   (list (getState node)
		 'hat (getGhat thisNode) (getFhat thisNode) )) nodes )
	'expanded))
;    (print (list (mapcar (lambda (node) (getState node)) nodes) 'expanded))
      (list nodes thisNode)
      )))

(let ((hanoi-node (make-instance 'HanoiGraphNode)))

  (setState hanoi-node '((1 2 3) () ()))
  (setGhat hanoi-node 0)
  (setFhat hanoi-node (hhat hanoi-node))

  (let ((hanoi-graph (make-instance 'GraphSearchA)))
    (setOpen hanoi-graph (list hanoi-node))

;;; deBug
;(let ((solutions (graph-search hanoi-graph 1)))
;  (dolist (node solutions) (reportSolution node)) )
    (let ((solutions (graph-search hanoi-graph 1)))
      (dolist (node solutions)
	(let ((parents nil))
	  (do ((parent (getParent node) (getParent parent)))
	      ((null parent) parents)
	    (setq parents (cons (getState parent) parents))
	    )
	  (print (list parents 'parents)) )
	(print (list (getState node) 'solution)) )) ))
