(require 'ClauseNode "ClauseNode.lisp")

(defun prove (premises conclusion)
  (dbg-indent :clause 0 "prove premises: ~a" premises)
  (dbg-indent :clause 0 "prove conclusion: ~a" conclusion)
  (let ((dummyClause (make-instance 'Clause)))
    (dbg-indent :clause 0 "prove dummyClause: ~a" dummyClause)
    (labels ((loop (premises clauses id)
	       (if (null premises) clauses
		   (let ((new (make-clauses
			       dummyClause (car premises) 'premise id )))
		     (dbg-indent :clause 0 "prove loop: ~a"
				 (append clauses new))
		     (loop (cdr premises) (append clauses new)
			   (+ id (length new)) )))))
      (let* ((prem-clause (loop premises nil 1))
	     (conc-clause
	      (if (null conclusion) nil
		  (make-clauses dummyClause (list '~ conclusion) 'conclusion
				(1+ (length prem-clause)) ))))
	(dbg-indent :clause 0 "prove prem-clause: ~a"
		    (mapcar (lambda (x) (getClause x))
			    prem-clause))
	(dbg-indent :clause 0 "prove conc-clause: ~a"
		    (mapcar (lambda (x) (getClause x))
			    conc-clause))
	(let ((graph (make-instance 'GraphSearchA)))
	  (labels ((set-cl (x)
		     (let ((node (make-instance 'ClauseNode)))
		       (setState node x)
		       (setFhat node (literals x))
		       (setGraph node graph)
		       node )))
	    (if (null conclusion)
		(setOpen graph (mapcar #'set-cl prem-clause))
		(progn
		  (setOpen graph (mapcar #'set-cl conc-clause))
		  (setClosed graph (mapcar #'set-cl prem-clause)))) )
	  (dbg-indent :clause 0 "prove open: ~a"
		      (mapcar (lambda (x) (getClause (getState x)))
			      (getOpen graph) ))
	  (dbg-indent :clause 0 "prove closed: ~a"
		      (mapcar (lambda (x) (getClause (getState x)))
			      (getClosed graph) ))
	  (let ((solutions (graph-search graph 1))
		(closedNodes
		 (mapcar (lambda (x) (getState x)) (getClosed graph)) ))
	    (mapcar #'reportSolution
		    (sort closedNodes
			  (lambda (x y) (< (getId x) (getId y)))) )
	    (dolist (node solutions) (reportSolution node)) )
	  )))))
