// Copyright (c) 2006  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.glj.graph;

import java.util.*;

public abstract class GraphNode {
  Object	state;
  int	ghat = 0;
  int	fhat;
  GraphNode	parent = null;
  LinkedList	successors = null;
  /* ;;; ??? graph ??? */

  public void	setState(Object state) {
    this.state = state;
  }
  
  public void	setGhat(int ghat) {
    this.ghat = ghat;
  }
  
  public void	setFhat(int fhat) {
    this.fhat = fhat;
  }
  
  public void	setParent(GraphNode parent) {
    this.parent = parent;
  }
  
  public void	addSuccessors(GraphNode node) {
    if (successors == null) {
      successors = new LinkedList();
    }
    successors.add(node);
  }
  
  public LinkedList	graphExpand() {
    LinkedList	nodes = null;
    LinkedList	applied = null;
    for (int i = 0; (applied = operators(i)) != null; i++) {
      GraphNode	node = makeSuccessor(applied);
      if (node != null) {
	if (nodes == null) {
	  nodes = new LinkedList();
	}
	nodes.add(node);
      }
    }
    LinkedList	ret = new LinkedList();
    ret.addFirst(nodes);
    ret.addLast(this);
    return ret;
  }
  
  public GraphNode	makeSuccessor(LinkedList stateAndCost) {
    GraphNode	node = null;
    if (stateAndCost.isEmpty()) {
      return null;
    }
    try {
      node = (GraphNode)getClass().newInstance();
    }
    catch (Exception e) {
      System.err.println("make instance failed");
    }
    node.setState(stateAndCost.getFirst());
    node.setGhat(ghat + ((Integer)stateAndCost.getLast()).intValue());
    node.setFhat(node.ghat + hhat());
    node.setParent(this);
    /* ;;; ??? graph ??? */
    this.addSuccessors(node);
    return node;
  }
  
  public boolean	isBetterNode(GraphNode anotherNode) {
    int	anotherFhat = anotherNode.fhat;
    if (fhat < anotherFhat) {
      return true;
    }
    if (fhat > anotherFhat) {
      return false;
    }
    return isGoal();
  }
  
  public GraphNode	isOnGraph(LinkedList nodeList) {
    LinkedList	list = new LinkedList(nodeList);
    GraphNode	result = null;
    for (;
	 !list.isEmpty();
	 list.removeFirst()) {
      if (isStateEqual(list.getFirst())) {
	result = (GraphNode)list.getFirst();
      }
      if (result != null) {
	return result;
      }
    }
    return result;
  }
  
  public abstract boolean	isGoal();
  public abstract LinkedList	operators(int index);
  public abstract void	reportSolution();
  /* public abstract void	print();*/
  public abstract boolean	isStateEqual(Object node);
  public abstract int	hhat();

  public LinkedList getSuccessors() {
    return successors;
  }

  public void setSuccessors(LinkedList successors) {
    this.successors = successors;
  }

  public Object getState() {
    return state;
  }

  public int getGhat() {
    return ghat;
  }

  public int getFhat() {
    return fhat;
  }

  public GraphNode getParent() {
    return parent;
  }
}
