// Copyright (c) 2006  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.glj.graph;

import java.util.*;

public abstract class GraphSearch {
  LinkedList	open = new LinkedList();
  LinkedList	closed = new LinkedList();
  LinkedList	solutions = new LinkedList();

  public LinkedList	search1() {
    return graphSearch(1);
  }

  public LinkedList	searchAll() {
    return graphSearch(-1);
  }

  public LinkedList searchN(int numSolutions) {
    return graphSearch(numSolutions);
  }

  public LinkedList	graphSearch(int numSolutions) {
    GraphNode	node = null;
    LinkedList	expand = null;
    while (!open.isEmpty()) {
      if (isGoal(numSolutions)) {
	break;
      }
      node = (GraphNode)open.getFirst();
      open.removeFirst();
      expand = node.graphExpand();
      if (expand.size() == 2 && expand.getLast() != null) {
	closed.addFirst(expand.getLast());
      }
      LinkedList	expandList = (LinkedList)expand.getFirst();
      if (expandList == null) {
	continue;
      }
      for (int i = 0; i < expandList.size(); i++) {
	addSuccessors(((GraphNode)expandList.get(i)));
      }
    }
    return solutions;
  }
  
  boolean	isGoal(int numSolutions) {
    GraphNode	node = (GraphNode)open.getFirst();
    if (node.isGoal()) {
      solutions.add(node);
    }
    if (numSolutions < 0) {
      return false;
    }
    if (solutions.size() >= numSolutions) {
      return true;
    }
    return false;
  }

  void	addSuccessors(GraphNode node) {
    GraphNode	old = node.isOnGraph(open);
    if (old != null) {
      if (node.isBetterNode(old)) {
	open.remove(old);
	open = insertNode(node, open);
      }
    }
    else {
      old = node.isOnGraph(closed);
      if (old != null) {
	if (node.isBetterNode(old)) {
	  open = insertNode(node, open);
	  closed.remove(old);
	}
      }
      else {
	open = insertNode(node, open);
      }
    }
  }

  abstract LinkedList	insertNode(GraphNode node,
				   LinkedList nodeList);

  public LinkedList getOpen() {
    return open;
  }

  public void setOpen(LinkedList open) {
    this.open = open;
  }

  public LinkedList getClosed() {
    return closed;
  }

  public void setClosed(LinkedList closed) {
    this.closed = closed;
  }

  public LinkedList getSolutions() {
    return solutions;
  }

  public void setSolutions(LinkedList solutions) {
    this.solutions = solutions;
  }
}
