// Copyright (c) 2006  Hitoshi Guutara Maruyama.
// This is free software;  for terms and warranty disclaimer see ./COPYING.

package jp.sourceforge.glj.graph;

import java.io.*;
import java.util.*;

import gnu.lists.*;
import jp.sourceforge.glj.lisp.Lisp;

class Symbol {
  static int	id = 0;
  String	name;
  String	type;
  String	putName(String name) {
    this.name = name + id;
    id++;
    return this.name;
  }
  String	putType(String type) {
    this.type = type;
    return	this.type;
  }
  String	getName() {
    return name;
  }
  String	getType() {
    return type;
  }
  public String	toString() {
    return "@" + name;
  }
}

class	Clause {
  static int	uniqueId;
  LList	literals;
  String	type;
  int	id;
  LList	answer;
    
  Clause	newClause(LList literals, String type, LList answer) {
    this.literals = literals;
    this.type = type;
    this.id = uniqueId++;
    this.answer = answer;
    return this;
  }

  int	numLiterals() {
    return literals.size();
  }

  boolean	isNil() {
    return literals.isEmpty();
  }

  void	reportSolution() {
    System.out.println("" + id + " " + literals + " " + type + " " + answer);
  }

  boolean	isClauseEqual(Clause another) {
    return literals.equals(another.literals);
  }

  /* ;;; literals?? clauses?? */
  LList	resolve(Clause parent) {
    return resolvedClauses(tryClash(rename(new Pair((LList)literals,
						    (LList)answer)),
				    new Pair(parent.literals,
					     parent.answer)),
			   id, parent.id);
  }
  LList	resolvedClauses(LList literals, int id1, int id2) {
    /* ;;; deBug */
    System.err.println("resolvedClauses = (" + id1 + "," + id2 + ")"
		       + literals);
    /**/
    LList	newClauses = LList.Empty;
    if (literals.isEmpty()) {
      return newClauses;
    }
    String	type = "R " + id1 + " " + id2;
    for (int i = 0; i < literals.size(); i++) {
      Clause	newClause = new Clause();
      newClause.newClause((LList)Lisp.car(literals.get(i)), type,
			  (LList)Lisp.cdr(literals.get(i)));
      newClauses = Lisp.append(newClauses, new Pair(newClause, LList.Empty));
      if (newClause.isNil()) {
	return newClauses;
      }
    }
    return newClauses;
  }

  Object	operator(Object wff) {
    if (!(wff instanceof Pair)) {
      return null;
    }
    if (Lisp.cdr(wff) instanceof LList
	&& ((LList)Lisp.cdr(wff)).isEmpty()) {
      return null;
    }
    if (Lisp.cdr(Lisp.cdr(wff)) instanceof LList
	&& ((LList)Lisp.cdr(Lisp.cdr(wff))).isEmpty()) {
      if (isNeg(Lisp.car(wff)) || isQuantifier(Lisp.car(wff))) {
	return Lisp.car(wff);
      }
      return null;
    }
    if (Lisp.car((Lisp.cdr(wff))).equals("!")
	|| Lisp.car(Lisp.cdr(wff)).equals("&")
	|| Lisp.car(Lisp.cdr(wff)).equals("=>")
	|| Lisp.car(Lisp.cdr(wff)).equals("==")) {
      return Lisp.car(Lisp.cdr(wff));
    }
    return null;
  }

  boolean	isOr(Object operator) {
    if (operator == null || Lisp.isNil(operator)) {
      return false;
    }
    return operator.equals("!");
  }
  boolean	isAnd(Object operator) {
    if (operator == null || Lisp.isNil(operator)) {
      return false;
    }
    return operator.equals("&");
  }
  boolean	isNeg(Object operator) {
    if (operator == null || Lisp.isNil(operator)) {
      return false;
    }
    return operator.equals("~");
  }
  boolean	isQuantifier(Object wff) {
    if (wff == null || Lisp.isNil(wff)) {
      return false;
    }
    if (!(wff instanceof Pair)) {
      return false;
    }
    return (Lisp.car(wff).equals("A") || Lisp.car(wff).equals("E"));
  }
  boolean	isCond(Object operator) {
    if (operator == null || Lisp.isNil(operator)) {
      return false;
    }
    return operator.equals("=>");
  }
  boolean	isBicond(Object operator) {
    if (operator == null || Lisp.isNil(operator)) {
      return false;
    }
    return operator.equals("==");
  }

  Symbol	gensym(String name) {
    Symbol symbol = new Symbol();
    symbol.putName(name);
    return symbol;
  }
  Symbol	newVar() {
    Symbol symbol = gensym("x");
    symbol.putType("variable");
    return symbol;
  }
  Symbol	newConst() {
    Symbol symbol = gensym("C");
    symbol.putType("constant");
    return symbol;
  }
  Symbol	newFunc() {
    Symbol symbol = gensym("f");
    symbol.putType("function");
    return symbol;
  }

  boolean	isVariable(Object sym) {
    return (sym instanceof Symbol
	    && ((Symbol)sym).getType().equals("variable"));
  }
  boolean	isConstant(Object sym) {
    return (sym instanceof Symbol
	    && ((Symbol)sym).getType().equals("constant"));
  }
  boolean	isFunction(Object sym) {
    return (sym instanceof Symbol
	    && ((Symbol)sym).getType().equals("function"));
  }

  LList	variables(LList literal) {
    if (literal.isEmpty()) {
      return LList.Empty;
    }
    Object   	carPart = Lisp.car(literal);
    if (isVariable(carPart)) {
      return Lisp.insert(carPart,
			 variables((LList)Lisp.cdr(literal)));
    }
    if (Lisp.isAtom(carPart)) {
      return variables((LList)Lisp.cdr(literal));
    }
    return Lisp.merge(variables((LList)carPart),
		      variables((LList)Lisp.cdr(literal)));
  }

  LList	rename(LList literals) {
    LList	variableList = variables(literals);
    LList	substList = LList.Empty;
    for (int i = 0; i < ((LList)variableList).size(); i++) {
      Object	obj = ((LList)variableList).get(i);
      substList = Lisp.append(substList,
			      new Pair(new Pair(obj, (Object)newVar()),
				       LList.Empty));
    }
    return (LList)applySubst(substList, literals);
  }

  LList	tryClash(LList literals1, LList literals2) {
    LList	newLiterals = LList.Empty;
    if (literals1.isEmpty()) {
      return newLiterals;
    }
    LList	answer1 = (LList)Lisp.cdr(literals1);
    literals1 = (LList)Lisp.car(literals1);
    if (literals2.isEmpty()) {
      return newLiterals;
    }
    LList	answer2 = (LList)Lisp.cdr(literals2);
    literals2 = (LList)Lisp.car(literals2);
    for (int i = 0; i < literals1.size(); i++) {
      Object	literal1 = literals1.get(i);
      for (int j = 0; j < literals2.size(); j++) {
	Object	s = null;
	Object	literal2 = literals2.get(j);
	if ((isNeg(operator(literal1))
	     && (operator(literal2) == null || Lisp.isNil(literal2))
	     && (literal1 instanceof Pair)
	     && (Lisp.cdr(literal1) instanceof Pair)
	     && ((s = unify((LList)Lisp.car(Lisp.cdr(literal1)),
			    (LList)literal2)) != null)
	     )
	    || ((operator(literal1) == null || Lisp.isNil(literal1))
		&& isNeg(operator(literal2))
		&& (literal2 instanceof Pair)
		&& (Lisp.cdr(literal2) instanceof Pair)
		&& ((s = unify((LList)Lisp.car(Lisp.cdr(literal2)),
				(LList)literal1)) != null)
		) ) {
	  LList	newLiteral
	    = new Pair(Lisp.merge((LList)applySubst((LList)s,
						    Lisp.remove(literal1,
								literals1)),
				  (LList)applySubst((LList)s,
						    Lisp.remove(literal2,
								literals2))),
		       Lisp.merge((LList)applySubst((LList)s,
						    Lisp.remove(literal1,
								answer1)),
				  (LList)applySubst((LList)s,
						    Lisp.remove(literal2,
								answer2))));
	  newLiterals = new Pair(newLiteral, newLiterals);
	  if (newLiteral.isEmpty()) {
	    return newLiterals;
	  }
	}
      }
    }
    return newLiterals;
  }

  LList	unify(LList negLiteral, LList literal) {
    LList	subs = LList.Empty;
    for (LList literal1 = negLiteral, literal2 = literal;
	 !literal1.equals(literal2); ) {
      LList	spair = unify1(literal1, literal2);
      if (spair == null || Lisp.isNil(spair)) {
	return null;
      }
      /* ;;; deBug */
      System.err.println("unify() spair=" + spair);
      /**/
      if (spair.isEmpty()) {
	return null;
      }
      spair = new Pair(spair, LList.Empty);
      /* ;;; deBug */
      System.err.println("unify() spair=" + spair);
      /**/
      literal1 = (LList)applySubst(spair, literal1);
      literal2 = (LList)applySubst(spair, literal2);
      subs = composeSubst(subs, spair);
    }
    return subs;
  }
  LList	unify1(Object literal1, Object literal2) {
    if (isVariable(literal1)) {
      if (occurIn(literal1, literal2)) {
	return null;
      }
      return new Pair(literal1, literal2);
    }
    if (isVariable(literal2)) {
      if (occurIn(literal2, literal1)) {
	return null;
      }
      return new Pair(literal2, literal1);
    }
    if (Lisp.isAtom(literal1) || Lisp.isAtom(literal2)) {
      return null;
    }
    if (!(literal1 instanceof LList) || !(literal2 instanceof LList)) {
      return null;
    }
    if (!((LList)literal1).isEmpty() && !((LList)literal2).isEmpty()
	&& Lisp.car(literal1).equals(Lisp.car(literal2))) {
      Object	a1 = Lisp.cdr(literal1);
      Object	a2 = Lisp.cdr(literal2);
      while (a1 instanceof LList && !((LList)a1).isEmpty() 
	     && a2 instanceof LList && !((LList)a2).isEmpty()
	     && Lisp.car(a1).equals(Lisp.car(a2))) {
	a1 = Lisp.cdr(a1);
	a2 = Lisp.cdr(a2);
      }
      return unify1(Lisp.car(a1), Lisp.car(a2));
    }
    return null;
  }
  boolean	occurIn(Object obj1, Object obj2) {
    if (obj1.equals(obj2)) {
      return true;
    }
    if (Lisp.isAtom(obj2)) {
      return false;
    }
    if (obj2 instanceof Pair) {
      if (occurIn(obj1, Lisp.car(obj2))) {
	return true;
      }
      return occurIn(obj1, Lisp.cdr(obj2));
    }
    return false;
  }

  Object	applySubst(LList subst, Object literals) {
    if (subst.isEmpty()) {
      return literals;
    }
    LList	substPair = null;
    if (literals instanceof Symbol) {
      /* ;;; deBug */
      System.err.println("applySubst(sym): " + subst + "/" + literals);
      /**/
      if ((substPair = Lisp.assoc(literals, subst)) != null
	  && !Lisp.isNil(substPair) && substPair instanceof Pair) {
	return Lisp.cdr(substPair);
      }
      return literals;
    }
    if (!(literals instanceof Pair)) {
      return literals;
    }
    /* ;;; deBug */
    System.err.println("applySubst(obj): " + subst + "/" + literals);
    /**/
    if ((substPair = Lisp.assoc(literals, subst)) != null
	&& !Lisp.isNil(substPair)) {
      return (LList)Lisp.cdr(substPair);
    }
    /* ;;; deBug */
    System.err.println("applySubst(obj) expand: " + subst + "/" + literals);
    /**/
    return new Pair(applySubst(subst, Lisp.car(literals)),
		    applySubst(subst, Lisp.cdr(literals)));
  }
  LList	composeSubst(LList substList, LList spair) {
    LList	composedList = LList.Empty;
    for (int i = 0; i < substList.size(); i++) {
      composedList =
	new Pair(new Pair(Lisp.car(substList.get(i)),
			  applySubst(spair, Lisp.cdr(substList.get(i)))),
		 composedList);
    }
    return addnew(spair, composedList);
  }
  LList	addnew(LList spair, LList substList) {
    if (spair.isEmpty()) {
      return substList;
    }
    if (substList.isEmpty()) {
      return spair;
    }
    if (!Lisp.isNil(Lisp.assoc(Lisp.car(Lisp.car(spair)), substList))) {
      return addnew((LList)Lisp.cdr(spair), substList);
    }
    return new Pair(Lisp.car(substList),
		    addnew((LList)Lisp.cdr(spair), substList));
  }
  
  LList	clauses(LList wff) {
    /* ;;; deBug */
    System.err.println("clauses(" + wff + ")");
    if (isAnd(operator(wff))) {
      return
	Lisp.append(clauses((LList)Lisp.car(wff)),
		    clauses((LList)Lisp.car(Lisp.cdr(Lisp.cdr(wff)))));
    }
    if (isOr(operator(wff))) {
      return new Pair(clauseIt(wff), LList.Empty);
    }
    return new Pair(clauseIt(wff), LList.Empty);
  }
  LList	clauseIt(LList wff) {
    if (isOr(operator(wff))) {
      return
	Lisp.append(clauseIt((LList)Lisp.car(wff)),
		    clauseIt((LList)Lisp.car(Lisp.cdr(Lisp.cdr(wff)))));
    }
    return new Pair(wff, LList.Empty);
  }
  LList	condelim(LList wff) {
    /* ;;; deBug */
    System.err.println("condelim(" + wff + ")");
    /**/
    Object	op = operator(wff);
    if (op == null || Lisp.isNil(op)) {
      return wff;
    }
    if (isQuantifier(op) || isNeg(op)) {
      return new Pair(Lisp.car(wff),
		      new Pair(condelim((LList)Lisp.car(Lisp.cdr(wff))),
			       LList.Empty));
    }
    LList	left = condelim((LList)Lisp.car(wff));
    LList right = condelim((LList)Lisp.car(Lisp.cdr(Lisp.cdr(wff))));
    if (isCond(op)) {
      return new Pair(new Pair("~", new Pair(left, LList.Empty)),
		      new Pair("!", new Pair(right, LList.Empty)));
    }
    if (isBicond(op)) {
      LList
	car = new Pair(left,
		       new Pair("!",
				new Pair(new Pair("~",
						  new Pair(left,
							   LList.Empty)),
					 LList.Empty)));
      LList	cadr = new Pair(new Pair("~",
					 new Pair(left,
						  LList.Empty)),
				new Pair("!", new Pair(right, LList.Empty)));
      return new Pair(car, new Pair(cadr, LList.Empty));
    }
    return new Pair(left, new Pair(Lisp.car(Lisp.cdr(wff)),
				   new Pair(right, LList.Empty)));
  }
  LList	miniscope(LList wff) {
    /* ;;; deBug */
    System.err.println("miniscope(" + wff + ")");
    /**/
    Object	op = operator(wff);
    if (op == null || Lisp.isNil(op)) {
      return wff;
    }
    if (isQuantifier(op)) {
      return new Pair(Lisp.car(wff),
		      new Pair(miniscope((LList)Lisp.car(Lisp.cdr(wff))),
			       LList.Empty));
    }
    if (isNeg(op)) {
      return (LList)negate((LList)Lisp.car(Lisp.cdr(wff)));
    }
    LList
      caddr = miniscope((LList)Lisp.car(Lisp.cdr(Lisp.cdr(wff))));
    return new Pair(miniscope((LList)Lisp.car(wff)),
		    new Pair(Lisp.car(Lisp.cdr(wff)),
			     new Pair(caddr, LList.Empty)));
  }
  Object	negate(Object wff) {
    /* ;;; deBug */
    System.err.println("negate(" + wff + ")");
    /**/
    if (wff instanceof String) {
      if (isAnd(wff)) {
	return "!";
      }
      if (isOr(wff)) {
	return "&";
      }
      return wff;
    }
    if (!(wff instanceof LList)) {
      return wff;
    }
    Object	op = operator(wff);
    if (op == null || Lisp.isNil(op)) {
      return new Pair("~", new Pair(wff, LList.Empty));
    }
    if (isNeg(op)) {
      return miniscope((LList)Lisp.car(Lisp.cdr(wff)));
    }
    if (isQuantifier(op)) {
      /* ;;; deBug */
      System.err.println("negateQ(" + op + ","
			 + (Lisp.car(op).equals("A") ? "t" : "f") + ")");
      /**/
      return new Pair(new Pair((Lisp.car(op).equals("A") ? "E" : "A"),
			       Lisp.cdr(op)),
		      new Pair((LList)negate(Lisp.car(Lisp.cdr(wff))),
			       LList.Empty));
    }
    LList	retList = new LList();
    for (int i = 0; i < ((LList)wff).size(); i++) {
      retList = Lisp.append(retList, new Pair(negate(((LList)wff).get(i)),
					      LList.Empty));
    }
    return retList;
  }
  LList standardize(LList wff) {
    /* ;;; deBug */
    System.err.println("standardize(" + wff + ")");
    /**/
    Object	op = operator(wff);
    if (op == null || Lisp.isNil(op)) {
      return wff;
    }
    if (isQuantifier(op)) {
      Object	var = Lisp.car(Lisp.cdr(op));
      LList	retList = standardize((LList)Lisp.car(Lisp.cdr(wff)));
      return Lisp.subst(newVar(), var,
			new Pair(op, (new Pair(retList, LList.Empty))));
    }
    LList	retList = LList.Empty;
    for (int i = 0; i < wff.size(); i++) {
      if (wff.get(i) instanceof LList) {
	retList = Lisp.append(retList, new Pair(standardize((LList)wff.get(i)),
						LList.Empty));
      }
      else {
	retList = Lisp.append(retList, new Pair(wff.get(i), LList.Empty));
      }
    }
    return retList;
  }
  LList skolemize(LList wff, String type) {
    /* ;;; deBug */
    System.err.println("skolemize(" + wff + ")");
    /**/
    return skolemize(wff, type, LList.Empty);
  }
  LList skolemize(LList wff, String type, LList vars) {
    Object	op = operator(wff);
    if (wff.isEmpty()) {
      return wff;
    }
    if (isQuantifier(op)) {
      if (Lisp.car(op).equals("A")) {
	vars = Lisp.append(vars,
			   new Pair(Lisp.car(Lisp.cdr(op)), LList.Empty));
	return skolemize((LList)Lisp.car(Lisp.cdr(wff)), type, vars);
      }
      else if (vars.isEmpty()) {
	/* ;;; */
	if (type.equals("conclusion")) {
	  wff = Lisp.subst(newVar(), Lisp.car(Lisp.cdr(op)),
			   (LList)Lisp.car(Lisp.cdr(wff)));
	}
	else {
	  /**/
	  wff = Lisp.subst(newConst(), Lisp.car(Lisp.cdr(op)),
			   (LList)Lisp.car(Lisp.cdr(wff)));
	  /* ;;; */
	}
	/**/
	return skolemize((LList)wff, type, vars);
      }
      else {
	/* ;;; */
	if (type.equals("conclusion")) {
	  wff = Lisp.subst(newVar(), Lisp.car(Lisp.cdr(op)),
			   (LList)Lisp.car(Lisp.cdr(wff)));
	}
	else {
	  /**/
	  wff = Lisp.subst(new Pair(newFunc(), vars),
			   Lisp.car(Lisp.cdr(op)),
			   (LList)Lisp.car(Lisp.cdr(wff)));
	  /* ;;; */
	}
	/**/
	return skolemize((LList)wff, type, vars);
      }
    }
    LList	newList = LList.Empty;
    for (int i = 0; i < wff.size(); i++) {
      if (wff.get(i) instanceof LList) {
	newList = Lisp.append(newList,
			      new Pair(skolemize((LList)wff.get(i),
						 type, vars),
				       LList.Empty));
      }
      else {
	newList = Lisp.append(newList, new Pair(wff.get(i), LList.Empty));
      }
    }
    return newList;
  }
  LList	cnf(LList wff) {
    /* ;;; deBug */
    System.err.println("cnf(" + wff + ")");
    /**/
    if (Lisp.isAtom(wff)) {
      return wff;
    }
    LList	newList = LList.Empty;
    for (int i = 0; i < wff.size(); i++) {
      if (wff.get(i) instanceof Pair) {
	newList = Lisp.append(newList, new Pair(cnf((LList)wff.get(i)),
						LList.Empty));
      }
      else {
	newList = Lisp.append(newList, new Pair(wff.get(i), LList.Empty));
      }
    }
    wff = newList;
    if (isOr(operator(wff))) {
      return distribute((LList)Lisp.car(wff),
			(LList)Lisp.car(Lisp.cdr(Lisp.cdr(wff))));
    }
    return wff;
  }
  LList	distribute(LList wff1, LList wff2) {
    if (isAnd(operator(wff1))) {
      LList	caddr = (LList)Lisp.car(Lisp.cdr(Lisp.cdr(wff1)));
      return new Pair(distribute((LList)Lisp.car(wff1), wff2),
		      new Pair("&",
			       new Pair(distribute((LList)caddr, wff2),
					LList.Empty)));
    }
    if (isAnd(operator(wff2))) {
      LList	caddr = (LList)Lisp.car(Lisp.cdr(Lisp.cdr(wff2)));
      return new Pair(distribute(wff1, (LList)Lisp.car(wff2)),
		      new Pair("&",
			       new Pair(distribute(wff1, (LList)caddr),
					LList.Empty)));
    }
    return new Pair(wff1, new Pair("!", new Pair(wff2, LList.Empty)));
  }
  LList negateClause(LList literals) {
    if (literals.isEmpty()) {
      return literals;
    }
    if (literals.size() == 1) {
      return (LList)negate((LList)literals.get(0));
    }
    LList	retLiterals = LList.Empty;
    for (int i = 0; i < literals.size(); i++) {
      retLiterals = Lisp.append(retLiterals,
				new Pair("!",
					 new Pair(Lisp.car(literals),
						  LList.Empty)));
    }
    return cnf((LList)negate(retLiterals));
  }
  LList	makeClauses(LList literals, String type) {
    LList
      ret = clauses(cnf(skolemize(standardize(miniscope(condelim(literals))),
				  type)));
    return ret;
  }
}

class	ClauseNode extends GraphNode {
  static GraphSearch	graph;
  LList	parentClause;
  /* ;;; dummy */
  public boolean	isGoal() {
    return ((Clause)state).isNil();
  }
  public LinkedList	operators(int index) {
    return null;
  }
  public void	reportSolution() {
    for (int i = 0, n = graph.getClosed().size(); i < n; i++) {
      /* ;;; deBug */
      System.err.println("reportSolution(" + n + "/" + i +"/" + (n-i-1) + ")");
      System.err.println((graph.getClosed().get(n - i - 1)));
      /**/
      ClauseNode	node = (ClauseNode)graph.getClosed().get(n - i - 1);
      ((Clause)node.state).reportSolution();
    }
    ((Clause)state).reportSolution();
  }
  
  public boolean	isStateEqual(Object node) {
    return ((Clause)state).isClauseEqual((Clause)((ClauseNode)node).state);
  }
  public int	hhat() {
    return ((Clause)state).numLiterals();
  }
  
  public LinkedList	graphExpand() {
    LinkedList	nodes = null;
    LinkedList	applied = graph.getClosed();
    /* ;;; deBug */
    System.err.println("expand = " + state);
    /**/
    for (int i = 0; i < applied.size(); i++) {
      if (isStateEqual((ClauseNode)applied.get(i))) {
	continue;
      }
      /* ;;; deBug */
      System.err.println("applied(" + i + ")= "
			 + ((ClauseNode)applied.get(i)).state);
      /**/
      LList
	resolved =
	((Clause)state).resolve((Clause)((ClauseNode)applied.get(i)).state);
      boolean	isNil = false;
      for (int j = 0; j < resolved.size(); j++) {
	if (((Clause)resolved.get(j)).isNil()) {
	  isNil = true;
	}
	GraphNode
	  node = makeSuccessor(new Pair(resolved.get(j),
					new Pair(new Integer(0), LList.Empty)),
			       (ClauseNode)applied.get(i));
	if (node != null) {
	  if (nodes == null) {
	    nodes = new LinkedList();
	  }
	  nodes.add(node);
	}
      }
      if (isNil) {
	break;
      }
    }
    LinkedList	ret = new LinkedList();
    ret.addFirst(nodes);
    ret.addLast(this);
    return ret;
  }
  
  ClauseNode	makeSuccessor(LList stateAndCost, ClauseNode another) {
    ClauseNode	node = null;
    if (stateAndCost.isEmpty()) {
      return null;
    }
    try {
      node = (ClauseNode)getClass().newInstance();
    }
    catch (Exception e) {
      System.err.println("make instance failed");
    }
    node.setState(stateAndCost.get(0));
    node.setGhat(ghat + ((Integer)stateAndCost.get(1)).intValue());
    node.setFhat(node.ghat + hhat());
    node.setParentClause(new Pair(this, new Pair(another, LList.Empty)));
    node.graph = graph;
    return node;
  }
  public void	setParentClause(LList parentClause) {
    this.parentClause = parentClause;
  }

  public static void	main(String [] args) {
    StringReader	str = new StringReader(args[0]);
    LList	tree = null;
    try {
      tree = Lisp.read(str);
    }
    catch (Exception e) {
      System.err.println("problem read error");
      return;
    }

    /* ;;; deBug */
    System.err.println("input = " + tree);
    /**/

    LList	premis = (LList)Lisp.car(tree);
    LList	conclusion = (LList)Lisp.cdr(tree);
    LinkedList	premisNodes = new LinkedList();
    LinkedList	conclusionNodes = new LinkedList();

    graph = new GraphSearchA();
    
    for (int i = 0; i < premis.size(); i++) {
      LList	literals = (LList)premis.get(i);
      LList	cls = (new Clause()).makeClauses(literals, "premis");
      for (int j = 0; j < cls.size(); j++) {
	ClauseNode	node = new ClauseNode();
	node.setState((new Clause()).newClause((LList)cls.get(j),
					       "premis",
					       (LList)cls.get(j)));
	node.setGhat(0);
	node.setFhat(node.ghat + node.hhat());
	node.setParentClause(LList.Empty);
	node.graph = graph;
	premisNodes.addFirst(node);
	/* ;;; deBug */
	System.err.println("premis(" + i + ")= "
			   + ((Clause)node.state).literals);
	/**/
      }
    }
    if (!conclusion.isEmpty()) {
      LList	literals = new Pair("~", conclusion);
      /* ;;; deBug */
      System.err.println("conclusion pre = " + literals);
      /**/
      /*
	LList	literals = conclusion;
      */
      LList	cls = (new Clause()).makeClauses(literals, "conclusion");
      /**/
      /*
	cls = (new Clause()).negateClause(cls);
      */
      /* ;;; deBug */
      System.err.println("conclusion = " + cls);
      /**/
      for (int i = 0; i < cls.size(); i++) {
	ClauseNode	node = new ClauseNode();
	Clause	clause = new Clause();
	LList	answer =
	  Lisp.append((LList)cls.get(i),
		      new Pair(clause.negateClause((LList)cls.get(i)),
			       LList.Empty));
	node.setState(clause.newClause((LList)cls.get(i),
				       "conclusion", answer));
	node.setGhat(0);
	node.setFhat(node.ghat + node.hhat());
	node.setParentClause(LList.Empty);
	node.graph = graph;
	conclusionNodes.add(node);
	/* ;;; deBug */
	System.err.println("conclusion = " + ((Clause)node.state).literals);
	/**/
      }
      graph.setOpen(conclusionNodes);
      graph.setClosed(premisNodes);
    }
    else {
      graph.setOpen(premisNodes);
    }
    LinkedList	solutions = graph.search1();
    solution(solutions);
  }

  public static void	solution(LinkedList solutions) {
    if (solutions != null && !solutions.isEmpty()) {
      System.out.println("solution");
      ((GraphNode)solutions.getFirst()).reportSolution();
    }
    else {
      noSolution();
    }
  }

  /* ;;; deBug */
  public static void	noSolution() {
    for (int i = 0, n = graph.getClosed().size(); i < n; i++) {
      ClauseNode	node = (ClauseNode)graph.getClosed().get(n - i - 1);
      ((Clause)node.state).reportSolution();
    }
  }
}
