// ===========================================================================
//	CColorView.cp
// ===========================================================================

#ifdef PowerPlant_PCH
	#include PowerPlant_PCH
#endif

#include "CColorView.h"
#include "CColorViewImp.h"
#include "CClickCheckAttachment.h"
#include <UAppearance.h>

PP_Begin_Namespace_PowerPlant


// ---------------------------------------------------------------------------
//	 CColorView						Stream Constructor			  [public]
// ---------------------------------------------------------------------------

CColorView::CColorView(
	LStream*	inStream,
	ClassIDT	inImpID)

	: LControlView(inStream, inImpID),
	  mActionCallback(0)
{
}


// ---------------------------------------------------------------------------
//	 CColorView						Parameterized Constructor	  [public]
// ---------------------------------------------------------------------------

CColorView::CColorView(
	const SPaneInfo&	inPaneInfo,
	const SViewInfo&	inViewInfo,
	bool				inListView,
	ClassIDT			inImpID)

	: LControlView(inPaneInfo, inViewInfo, inImpID,
					inListView ? kControlWindowListViewHeaderProc
							   : kControlWindowHeaderProc)
{
}


// ---------------------------------------------------------------------------
//	 ~CColorView						Destructor					  [public]
// ---------------------------------------------------------------------------

CColorView::~CColorView()
{
}


// ---------------------------------------------------------------------------
//	 GetColor
// ---------------------------------------------------------------------------

bool
CColorView::GetColor(
	RGBColor*	outColor) const
{
	CColorViewImp* imp = dynamic_cast<CColorViewImp*>(mControlSubPane->GetControlImp());
	ThrowIfNil_(imp);
	return imp->GetColor(outColor);
}


// ---------------------------------------------------------------------------
//	 SetColor
// ---------------------------------------------------------------------------

void
CColorView::SetColor(
	RGBColor*	inColor) const
{
	CColorViewImp* imp = dynamic_cast<CColorViewImp*>(mControlSubPane->GetControlImp());
	ThrowIfNil_(imp);
	imp->SetColor(inColor);
}


// ---------------------------------------------------------------------------
//	 Click
// ---------------------------------------------------------------------------
//	Handle a click inside a View

void
CColorView::Click(
	SMouseDownEvent	&inMouseDown)
{
	LView::Click(inMouseDown);

	if ( mActionCallback && !CClickCheckAttachment::sClickHandled )
		mActionCallback(inMouseDown.macEvent.modifiers, mActionArg);
	CClickCheckAttachment::sClickHandled = 1;
}

PP_End_Namespace_PowerPlant
