/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


// ===========================================================================
//	VApplication.h
// ===========================================================================

#ifndef _H_VApplication
#define _H_VApplication
#pragma once

#include <LApplication.h>

class VApplication : public LDocApplication {

public:
						VApplication();
	virtual					~VApplication();

	virtual Boolean			ObeyCommand(
								CommandT			inCommand,
								void*				ioParam = nil);	

	virtual void			FindCommandStatus(
								CommandT			inCommand,
								Boolean&			outEnabled,
								Boolean&			outUsesMark,
								UInt16&				outMark,
								Str255				outName);

	virtual void			OpenDocument(
								FSSpec*				inMacFSSpec);
	virtual void			ChooseDocument();

protected:
	virtual void			StartUp();
	virtual	void			DoReopenApp();
	virtual void			DoPreferences();	
	void					RegisterClasses();

	virtual Boolean			AttemptQuitSelf( SInt32	 inSaveOption );
};

extern VApplication *theApp;
extern int appBusyLv;


#endif // _H_VApplication
