/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"machine/include.h"
#include	"task.h"
#include	"netutils.h"
#include	"resolve.h"

extern int resolve_tid;
extern int resolve_running;


static void
noop(int signo)
{
	return;
}

void
aboat_resolve_request_init()
{
	struct sigaction sa;
	sa.sa_handler = noop;
	sigemptyset(&sa.sa_mask);
	sigaction(SIGALRM, &sa, NULL);
}


void
aboat_resolve_request()
{
	if ( resolve_running ) {
		printf("ABOAT RESOLVE\n");
		pthread_kill((pthread_t)get_hard_tid(resolve_tid), SIGALRM);
	}
}
