/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<string.h>

#include	"memory_debug.h"
#include	"v/VButton.h"
#include	"v_pango.h"
#include	"machine/v_object.h"

void
VButton::destroy_do(VObject * nmp)
{
	nmp->remove_child_do(this);
	v_serialized_exec_sub(gtk_widget_destroy, info);
	v_serialized_exec_sub(g_object_unref, info);
}

VButton::~VButton()
{
}

VExError
VButton::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = v_get_status_standard(s, &flags, info);
	VExError err2 = VObject::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	V_OP_END
	return err;
};

VExError
VButton::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = v_set_status_standard(s, flags, info);
	err = VObject::set_status(s,flags);
	if ( err.code ) {
		V_OP_END
		return err;
	}
	
	if ( flags & (VSF_VERTD|VSF_WS|VSF_FSIZE|VSF_DESC) ) {
		set_styled_descriptor(
			sts.descriptor,
			sts.ws,
			sts.fsize,
			sts.vert_desc,
			info, true);
		err.subcode1 &= ~(VSF_VERTD|VSF_WS|VSF_FSIZE|VSF_DESC);
	}

	V_OP_END
	
	if ( flags & ( VSF_ALIGN | VSF_PADDING ) ) {
		sts.parent->child_status_changed(this, info);
		err.subcode1 &= ~( VSF_ALIGN | VSF_PADDING );
	}
	return err;
}

void
VButton::redraw(VRect* rect) const
{
}
