/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	<stdlib.h>
#include	"xlerror.h"
#include	"gbview.h"
#include	"win_flame.h"

XL_SEXP * xl_gv_indicated_status();
XL_SEXP * xl_gv_hide_status();
XL_SEXP * xl_gv_get_raw_image();

extern RESOURCE ** res_entry_hash_table;

void
init_gv_resource_option(XLISP_ENV * env)
{
XLISP_ENV * e;
	e = new_env(gblisp_top_env0);
	set_env(e,l_string(std_cm,"gv-status"),
		get_func_prim(xl_gv_indicated_status,FO_APPLICATIVE,0,1,1));

	set_env(gblisp_top_env0,l_string(std_cm,"indicated-coord"),
		get_env(e));
	set_gv_sp_resource(RID_INDICATED_COORD,e);

	e = new_env(gblisp_top_env0);
	set_env(e,l_string(std_cm,"gv-status"),
		get_func_prim(xl_gv_hide_status,FO_APPLICATIVE,0,1,1));
	set_gv_sp_resource(RID_HIDE_COORD,e);
	set_env(gblisp_top_env0,l_string(std_cm,"hide-coord"),
		get_env(e));

	e = new_env(gblisp_top_env0);
	set_env(e,l_string(std_cm,"gv-get-raw-image"),
		get_func_prim(xl_gv_get_raw_image,FO_APPLICATIVE,0,2,2));
	set_gv_sp_resource(RID_RAW_IMAGE,e);
	set_env(gblisp_top_env0,l_string(std_cm,"raw-image"),
		get_env(e));
}

void
gv_set_status_option(RESOURCE * r)
{
/*	if ( wfid ) {
		if ( wf_get_resource(wfid) == r && 
				(r->h.flags&RF_INDICATE) == RF_I_OFF &&
				wf_check_last(wfid) == 0 ) {
			free_win_flame(wfid);
		}
		else	win_flame_dirty(wfid,0,WFF_DIRTY,0);
	}
*/
	call_gv_event(r->h.no,l_string(std_cm,"set-status"));
}

XL_SEXP *
xl_gv_indicated_status(XLISP_ENV * e,XL_SEXP * s,
	XLISP_ENV * a,XL_SYM_FIELD * sf)
{
XL_SEXP * ret;
int no;
WF_ID id;
RESOURCE * r;
GBVIEW_FLAME * gf;
L_CHAR * gf_id;
	gf_id = get_sf_attribute(sf,l_string(std_cm,"flame-id"));
	if ( gf_id ) {
		gf = wf_get_gf_from_id(atoi(n_string(std_cm,gf_id)));
	}
	else 	gf = 0;
	if ( gf == 0 )
		gf = wf_next_gf(0,GVFM_LIVE);
	ret = 0;
	for ( no = 0 ; ; no ++ ) {
		id = wf_get(gf,no);
		if ( id == 0 )
			break;
		r = wf_get_resource(gf,id);
		if ( r == 0 )
			continue;
		ret = cons(
		       	cons(get_symbol(l_string(std_cm,"element")),
				get_resource_element(r)),
			ret);
	}
	return cons(get_symbol(l_string(std_cm,"indicated")),ret);
}

XL_SEXP *
xl_gv_hide_status(XLISP_ENV * e,XL_SEXP * s)
{
XL_SEXP * ret;
RESOURCE * r;
int i;
	ret = 0;
	for ( i = 0 ; i < RES_HASH_SIZE ; i ++ ) {
		r = res_entry_hash_table[i];
		for ( ; r ; r = r->h.entry_next ) {
			if ( r->h.type != RT_COORDINATE )
				continue;
			if ( wf_search(0,r) )
				continue;
			ret = cons(
				cons(get_symbol(l_string(std_cm,"element")),
					get_resource_element(r)),
				ret);
		}
	}

	return cons(get_symbol(l_string(std_cm,"hide")),ret);
}


XL_SEXP *
xl_gv_get_raw_image(XLISP_ENV * e,XL_SEXP * s)
{
XL_SEXP * url;
void * data;
int len;
	url = get_el(s,1);
	if ( get_type(url) != XLT_STRING )
		goto type_missmatch;
	data = search_ri_org(&len,url->string.data);
	if ( data == 0 )
		return 0;
	return get_raw(data,len);
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gv-get-raw-image"),
		n_get_string("type missmatch"));
}
