/**********************************************************************
 
	Copyright (C) 2004 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xl.h"
#include	"xlerror.h"
#include	"utils.h"
#include	"gb.h"


XL_SEXP *
gb_GetMeta(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);


void
init_gb_GetMeta(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"GetMeta"),
		get_func_prim(gb_GetMeta,FO_APPLICATIVE,0,2,2));
}


XL_SEXP *
gb_GetMeta(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * mode;
	mode = get_sf_attribute(sf,
			l_string(std_cm,"mode"));
	if ( mode == 0 )
		return get_el(s,1);
	if ( get_type(get_el(s,1)) != XLT_PAIR ) {
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_INV_PARAM,
			l_string(std_cm,"GetMeta"),
			List(
			n_get_string("invalid argument"),
			-1));
	}
	if ( l_strcmp(mode,l_string(std_cm,"meta")) == 0 ) {
		return List(
			get_el(s,0),
			get_meta(env,get_el(s,1)),-1);
	}
	return get_el(s,1);
}
