/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "xl.h"
#include "gbview.h"
#include "xlerror.h"
#include "win_flame.h"

void gc_gb_sexp(XL_SEXP * p);

XL_SEXP * xl_gv_flame_point_status();

XL_SEXP * gvstatus2list(GBVIEW_STATUS * gs);

void
init_gv_flame_point_status(XLISP_ENV * env)
{
	set_env(env, l_string(std_cm,"gv-flame-point-status"),
			get_func_prim(xl_gv_flame_point_status,FO_APPLICATIVE,0,3,3));
}


XL_SEXP *
xl_gv_flame_point_status(
		XLISP_ENV * e,
		XL_SEXP * s,
		XLISP_ENV * a,
		XL_SYM_FIELD * sf)
{
XL_SEXP * ret, * x, * y;
GBVIEW_STATUS gs;
GBVIEW_FLAME * gf;

	gf = get_gf_from_sf(sf);
	
	x = get_el(s,1);
	y = get_el(s,2);
	if ( get_type(x) != XLT_INTEGER || get_type(y) != XLT_INTEGER )
		goto type_missmatch;
	
	wf_indicate(gf,&gs,x->integer.data,y->integer.data,0);
	ret = gvstatus2list(&gs);
	wf_free_status(&gs);
	return ret;

type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gv-flame-point-status"),
		List(n_get_string("type missmatch"),
			-1));
}
