/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___MATRIX_H___
#define ___MATRIX_H___

#include	"queue.h"
#include	"pdb.h"

#define NCACHE_SIZE		100
#define NHASH_SIZE		(4*NCACHE_SIZE+3)
#define MIN_NCACHE_SIZE		NCACHE_SIZE


typedef struct matrix_sexp {
	struct matrix_sexp *	next;
	struct matrix_sexp *	prev;
	XL_SEXP *		data;
	unsigned		del:1;
} MATRIX_SEXP;

#define CH_PARENT		0x80000000
#define CH_CHILDREN		0xc0000000
#define CH_ATTRIBUTE		0x40000000
#define CH_TARGET		0x00000000

typedef struct matrix_data_type {
	int			type;
#define MDT_VECTOR		0x80000000
#define MDT_SCOLOR		0x00000000
#define MDT_BIT			0x00000001
#define MDT_INT8		0x00000002
#define MDT_INT16		0x00000003
#define MDT_INT32		0x00000004
#define MDT_INT64		0x00000005
#define MDT_UINT8		0x00000006
#define MDT_UINT16		0x00000007
#define MDT_UINT32		0x00000008
#define MDT_UINT64		0x00000009
#define MDT_FLOAT		0x0000000a
#define MDT_DOUBLE		0x0000000b
#define MDT_RGB8		0x0000000c
#define MDT_BLOCK		0x0000000d
#define MDT_STRING		0x0000000e
#define MDT_SEXP		0x0000000f
	int			(*get_size)(struct matrix_data_type*,void*);
	void *			(*sexp2md)(int * cpy,struct matrix_data_type*,XL_SEXP * s);
	XL_SEXP *		(*md2sexp)(struct matrix_data_type*,void*);
	int			(*cmp)(void*,void*);
	void			(*copy)(struct matrix_data_type*,void*,void*);
	void *			(*alloc_copy)(struct matrix_data_type*,void*);
	void *			(*alloc_data)();
	void			(*free_data)(struct matrix_data_type*,struct matrix_data *);
} MATRIX_DATA_TYPE;

typedef struct matrix_data_header {
	short			offset;
	short			type;
} MATRIX_DATA_HEADER;

#define MD_AREA(x,type)	(*(type*)(((char*)(x))+((MATRIX_DATA_HEADER*)(x)->offset)))

typedef struct matrix_list {
	struct matrix_list * 		next;
	struct matrix_node *		node;
} MATRIX_LIST;


#define MT_ACCESS_MAX		14

typedef struct matrix_token {
	Q_HEADER			h;
	struct matrix_token *		next;
	int				access[MT_ACCESS_MAX];
	struct matrix *			wait_matrix;
	struct matrix_node *		wait_node;
	struct matrix_node *		process_node;
	struct matrix_list *		locked_node_list;
	int				access_target;
	XL_SEXP *			cal_target;
	void				(*func)();
} MATRIX_TOKEN;


#define PR_UP		0
#define PR_DOWN		1
#define PR_STRT		2
#define PR_MAX		3

#define MI_DEF		0
#define MI_FETCH_1	1
#define MI_FETCH_2	2
#define MI_EDIT_1	3
#define MI_EDIT_2	4
#define MI_VISU_1	5
#define MI_VISU_2	6
#define MI_SAVE		7
#define MI_MAX		8


typedef struct matrix_channel_info {
	MATRIX_DATA_TYPE *		data_type;
	int				flags;
#define MF_SEND		0x00000001
#define MF_FILE		0x00000002
#define MF_VISU		0x00000004
} MATRIX_CHANNEL_INFO;



typedef struct matrix_channel {
	void *			data;
} MATRIX_CHANNEL;

typedef struct matrix_node_header {
	struct matrix_node *	next;
	struct matrix_node *	prev;
} MATRIX_NODE_HEADER;

typedef struct matrix_node {
	struct matrix_node_header h;
	struct matrix_node *	nh_next;
	U_INTEGER64		fofs;
	struct matrix *		matrix;

	INTEGER64 *		dim_code;

	int			status;
#define MS_NOBIND			0
#define MS_PROCESS			1
#define MS_OK				2
#define MS_LOADING_ERR_1		3
#define MS_PROCESS_ERR_1		4
	int			locked;
	unsigned 		ch_lock:1;
	unsigned		save_lock:1;
	unsigned 		dirty_file:1;

	int			access_no;

	MATRIX_CHANNEL *	channel;
	char *			nlist_dim_bit_field;
	INTEGER64 **		nlist_dim_addr;
	int			nlist_dim_bit_field_len;
	int			nlist_dim_addr_len;

	MATRIX_TOKEN *		wait_token;
	MATRIX_TOKEN *		process_token;
} MATRIX_NODE;

#define MATRIX_NULLNODE		((INTEGER64)-1)

typedef struct matrix_param {
	int			channel_nos;
	int			dim;
	int			pri_area[MI_MAX];
	void			(*open_method)(MATRIX_TOKEN*);
	void			(*read_file)(MATRIX_TOKEN*);
	void			(*write_file)(MATRIX_TOKEN*);
	void			(*read_net)(MATRIX_TOKEN*);
	void			(*close_file)(struct matrix *);
	void			(*close_net)(struct matrix *);
} MATRIX_PARAM;

typedef struct matrix {
	struct matrix *		next;
	
	int 			mode;
#define MM_CREATE		0
#define MM_STANBY		1
#define MM_ERR			2
#define MM_CLOSE		3

	MATRIX_CHANNEL_INFO *	channel_info;
	MATRIX_NODE *		node_hash[NCACHE_SIZE];
	
	MATRIX_PARAM		p;

	int			total_levels;
	unsigned char *		dim_divide;
	unsigned char *		block_size;
	INTEGER64 *		pixel_size;
	MATRIX_SEXP *		cal[MI_MAX];

	L_CHAR *		neturl;
	L_CHAR *		filename;
	L_CHAR *		key;

	int			access_no;

	MATRIX_TOKEN *		wait_token;
} MATRIX;

#define ME_ERROR		(-100)
#define ME_NO_NODE		(-101)
#define ME_PROC_NODE		(-102)
#define ME_INDEX_OVER		(-104)
#define ME_DIM			(-105)
#define ME_DIM_DIVIDE		(-106)
#define ME_CHANNEL_INFO		(-107)
#define ME_CHANNEL_NOS		(-108)
#define ME_BLOCK_SIZE		(-109)
#define ME_TOTAL_LEVELS		(-110)
#define ME_PRI_AREA		(-111)
#define ME_OPEN_METHOD		(-112)
#define ME_FETCH_METHOD		(-113)

#define ME_INVALID_INST		(-114)
#define ME_CAL_ERROR		(-115)

#define ME_MATRIX_ERR		(-116)

/* xlerror application code */

#define XL_AC_FILE		1
#define XL_AC_NODE		2
#define XL_AC_NETWORK		3


/*

DIM-CODE:
(dim-code me)
(dim-code [level] [code-1] [code-2] ....)
MATRIX


*/

void init_matrix();
MATRIX_NODE * get_matrix_node(int * errp,MATRIX * m,int * dim_code,int access,MATRIX_TOKEN*);
INTEGER64 * get_dim_code_from_sexp(XL_SEXP * );
XL_SEXP * get_channel_data(MATRIX_NODE * n,int ch,XL_SEXP * s);
XL_SEXP * matrix_error(char*,XL_SEXP *);
INTEGER64 * copy_dim_code(MATRIX * m,INTEGER64 * dim_code);
XL_SEXP * get_sexp_from_dim_code(MATRIX * m,INTEGER64*);
MATRIX * open_matrix(L_CHAR * neturl,L_CHAR * filename,L_CHAR * key,
			void (*open_method)(MATRIX_TOKEN*));
MATRIX * search_matrix(int *,L_CHAR * neturl,L_CHAR * filename,L_CHAR * key,MATRIX_TOKEN * t);
int set_channel_sexp(MATRIX_NODE*,int,XL_SEXP*);
void matrix_node_channel_unlock(MATRIX_NODE * n);
void matrix_node_channel_lock(MATRIX_NODE * n);
void set_matrix_mode(MATRIX * m,int mode);
void matrix_trigger_access(MATRIX_NODE * n,int access);

void init_mxCH(XLISP_ENV * env);
void init_mxSet(XLISP_ENV * env);
void init_mxTrigger(XLISP_ENV * env);

int set_matrix_channel_info(MATRIX * m,int ch,MATRIX_CHANNEL_INFO * inf);
int set_matrix_param(MATRIX * m,MATRIX_PARAM * p);
int set_matrix_dim_divide(MATRIX * m,int dim,int dim_divide);
int set_matrix_block_size(MATRIX * m,int dim,int block_size);
int set_matrix_pixel_size(MATRIX * m,int dim,int pixel_size);
int set_matrix_cal(MATRIX * m,int id,XL_SEXP * cal);


#endif

