/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_EDITABLE_H___
#define ___V_EDITABLE_H___

#include "v/VObject.h"
#include "v/VMenu.h"

class VEditable
{
  public:
	
			VEditable();
	
	// check if a command type(VMT_xxx) is currently acceptable
	virtual bool	command_status(int type) const = 0;
	
	// process a command(VMT_xxx) - return if command is processed
	virtual bool	obey_command(int type) = 0;
	
	// focus management
	virtual void	focus() = 0;
	virtual void	focus_event(bool in);	// called from OS etc.
	static VEditable *	get_focused_object() { return focused_object; }
	void	set_focused_event_handler(V_CALLBACK(handler), void *user_arg);
	
  protected:
	V_CALLBACK(focused_event_handler);
	void *	focused_eh_arg;
	
	static VEditable *	focused_object;
};

#endif
