/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include <stdio.h>
#include <stdlib.h>

#include "locator.h"
#include "utils.h"


LOCATOR_INFO *
init_locator(LOCATOR_INFO *info)
{
	info->h.last_time = 0;
	info->h.active = 1;
	return info;
}

int
kill_locator(LOCATOR_INFO *info)
{
LOCATOR_TABLE *tbl = info->h.tbl;
	info->h.tbl = 0;
	return (*tbl->kill_func)(info);
}

void
send_location_info(LOCATOR_INFO *li, LOCATION_INFO *info)
{
int cur_time;
	if ( li->h.active == 0 )
		return;
	cur_time = get_xltime();
	if ( cur_time > li->h.last_time + li->h.listen_interval ) {
		li->h.last_time = cur_time;
		(*li->h.listen_func)(li, info);
	}
}

void
activate_locator(LOCATOR_INFO *li)
{
	li->h.active = 1;
	if ( li->h.tbl->activate_func )
		(*li->h.tbl->activate_func)(li);
}

void
inactivate_locator(LOCATOR_INFO *li)
{
	li->h.active = 0;
	if ( li->h.tbl->inactivate_func )
		(*li->h.tbl->inactivate_func)(li);
}
