/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "vpf_std.h"
#include "vpf_file.h"
#include "gm_builtup_area_aft.h"

void gm_builtup_area_aft_delete(GM_BUILTUP_AREA_AFT_RECORD *record)
{
	if(record->nam)
		free(record->nam);
	free(record);
}

VPF_RECORD_READER_BEGIN(
	gm_builtup_area_aft_read, 
	GM_BUILTUP_AREA_AFT_RECORD)

	VPF_READ_FIELD(id)
	VPF_READ_FIELD(f_code)
	VPF_READ_VARIABLE_TEXT_FIELD(nam)
	VPF_READ_FIELD(soc)
	VPF_READ_FIELD(tile_id)
	VPF_READ_FIELD(fac_id);
VPF_RECORD_READER_END()

LONG gm_builtup_area_aft_get_tileid(const GM_BUILTUP_AREA_AFT_RECORD *record)
{
	return record->tile_id;
}

LONG gm_builtup_area_aft_get_fac_id(const GM_BUILTUP_AREA_AFT_RECORD *record)
{
	return record->fac_id;
}

void gm_builtup_area_aft_write_information_tag(
		FILE *fp, 
		GM_BUILTUP_AREA_AFT_RECORD *record)
{
	fprintf(fp, 
		"<BuiltupAreaAft>\n"
		"<Name>%s</Name>\n"
		"<FACCFeatureCode>%s</FACCFeatureCode>\n"
		"</BuiltupAreaAft>\n",
		record->nam, 
		record->f_code);
}

