/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "vpf_std.h"
#include "vpf_file.h"

#include "gm_road_lft.h"

void gm_road_lft_delete(GM_ROAD_LFT_RECORD *record){
	free(record);
}

VPF_RECORD_READER_BEGIN(
	gm_road_lft_read, 
	GM_ROAD_LFT_RECORD)

	VPF_READ_FIELD(id)
	VPF_READ_FIELD(f_code);
	VPF_READ_FIELD(acc);
	VPF_READ_FIELD(exs);
	VPF_READ_FIELD(med);
	VPF_READ_FIELD(rst);
	VPF_READ_FIELD(rsu);
	VPF_READ_FIELD(rtt);
	VPF_READ_FIELD(soc);
	VPF_READ_FIELD(tile_id);
	VPF_READ_FIELD(edg_id);
VPF_RECORD_READER_END()

LONG gm_road_lft_get_tileid(const GM_ROAD_LFT_RECORD *record)
{
	return record->tile_id;
}

LONG gm_road_lft_get_edge_id(const GM_ROAD_LFT_RECORD *record)
{
	return record->edg_id;
}

void gm_road_lft_write_information_tag(FILE *fp, const GM_ROAD_LFT_RECORD *record)
{
	fprintf(fp, 
		"<Road>\n"
		"<FACCFeatureCode>%s</FACCFeatureCode>\n"
		"<AccuracyCategory>%hi</AccuracyCategory>\n"
		"<ExistanceCategory>%hi</ExistanceCategory>\n"
		"<Surface>%hi</Surface>\n"
		"<MedianCategory>%hi</MedianCategory>\n"
		"<RouteIntendedUse>%hi</RouteIntendedUse>\n"
		"<SeasonalAvailability>%hi</SeasonalAvailability>\n"
		"</Road>\n",
		record->f_code, 
		record->acc,
		record->exs,
		record->rst,
		record->med,
		record->rtt,
		record->rsu);
}

